(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14115,        462]
NotebookOptionsPosition[     11185,        364]
NotebookOutlinePosition[     12537,        402]
CellTagsIndexPosition[     12452,        397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookToSymbolicNotebookML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/NotebookToSymbolicNotebookML"], 
          "ExpressionToSymbolicExpressionML" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/ExpressionToSymbolicExpressionML"], 
          "SymbolicNotebookMLToNotebook" :> 
          Documentation`HelpLookup[
           "paclet:XML/ref/SymbolicNotebookMLToNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookToSymbolicNotebookML\"\>", 
       2->"\<\"ExpressionToSymbolicExpressionML\"\>", 
       3->"\<\"SymbolicNotebookMLToNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicExpressionMLToExpression", "ObjectName",
 CellID->9079],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicExpressionMLToExpression", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes a SymbolicXML expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that represents an ExpressionML document and returns the corresponding \
expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->3766],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<WrapperFunction\>\"", 
    ButtonBox["Identity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Identity"], Cell[
    "function to be applied to the result", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->27587]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2393319],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->133610789],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->44649021],

Cell["Generate SymbolicXML from an expression:", "ExampleText",
 CellID->24147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpressionToSymbolicExpressionML", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"5", "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29156],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{"\<\"xmlns\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Log\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Function\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Symbol\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"Plus\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Number\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"5\"\>", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"Function\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"Sin\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"Symbol\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}], ",",
    
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{548, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30134]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["SymbolicExpressionMLToExpression"], "InlineFormula"],
 " to recover the expression:"
}], "ExampleText",
 CellID->3360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicExpressionMLToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->751],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"5", "+", 
   RowBox[{"Sin", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16208]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17518],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookToSymbolicNotebookML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/NotebookToSymbolicNotebookML",
    ButtonNote->"ObsLink: No successor for NotebookToSymbolicNotebookML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpressionToSymbolicExpressionML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ExpressionToSymbolicExpressionML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicNotebookMLToNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicNotebookMLToNotebook",
    ButtonNote->"ObsLink: No successor for SymbolicNotebookMLToNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5808],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->862952688],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->19993483]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicExpressionMLToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 34.6091016}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "SymbolicExpressionMLToExpression[expr] takes a SymbolicXML expression \
expr that represents an ExpressionML document and returns the corresponding \
expression. ", "synonyms" -> {}, "title" -> 
    "SymbolicExpressionMLToExpression", "type" -> "Symbol", "uri" -> 
    "XML/ref/SymbolicExpressionMLToExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4508, 142, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2393319]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12311, 390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2151, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2774, 81, 69, 1, 70, "ObjectName",
 CellID->9079],
Cell[2846, 84, 574, 16, 70, "Usage",
 CellID->32091]
}, Open  ]],
Cell[CellGroupData[{
Cell[3457, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3935, 122, 67, 1, 70, "Notes",
 CellID->3766],
Cell[4005, 125, 466, 12, 70, "3ColumnTableMod",
 CellID->27587]
}, Closed]],
Cell[CellGroupData[{
Cell[4508, 142, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2393319],
Cell[CellGroupData[{
Cell[4891, 156, 148, 5, 70, "ExampleSection",
 CellID->133610789],
Cell[5042, 163, 125, 3, 70, "Input",
 CellID->44649021],
Cell[5170, 168, 79, 1, 70, "ExampleText",
 CellID->24147],
Cell[CellGroupData[{
Cell[5274, 173, 210, 6, 28, "Input",
 CellID->29156],
Cell[5487, 181, 2750, 69, 173, "Output",
 CellID->30134]
}, Open  ]],
Cell[8252, 253, 158, 5, 70, "ExampleText",
 CellID->3360],
Cell[CellGroupData[{
Cell[8435, 262, 122, 3, 70, "Input",
 CellID->751],
Cell[8560, 267, 238, 8, 36, "Output",
 CellID->16208]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8859, 282, 311, 9, 70, "SeeAlsoSection",
 CellID->17518],
Cell[9173, 293, 983, 28, 70, "SeeAlso",
 CellID->3220]
}, Open  ]],
Cell[CellGroupData[{
Cell[10193, 326, 313, 9, 70, "TutorialsSection",
 CellID->5808],
Cell[10509, 337, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[10685, 345, 319, 9, 70, "MoreAboutSection",
 CellID->862952688],
Cell[11007, 356, 136, 3, 70, "MoreAbout",
 CellID->19993483]
}, Open  ]],
Cell[11158, 362, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

