(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15943,        535]
NotebookOptionsPosition[     12707,        426]
NotebookOutlinePosition[     14029,        463]
CellTagsIndexPosition[     13944,        458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"ToSymbolicXML\"\>", 3->"\<\"FromSymbolicXML\"\>", 
       4->"\<\"ToVerboseXML\"\>", 5->"\<\"ToCompactXML\"\>", 
       6->"\<\"RawXML\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicXMLErrors", "ObjectName",
 CellID->32471],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicXMLErrors", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a list of part specifications indicating where \
there are errors in the SymbolicXML expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and a message about the nature of each error."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["This function is intended as a utility for debugging only.", "Notes",
 CellID->27440]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184673370],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->250070484],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->152717586],

Cell["A SymbolicXML expression with one small error:", "ExampleText",
 CellID->24815],

Cell[BoxData[
 RowBox[{
  RowBox[{"symbolicXMLWithError", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<math\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<xmlns\>\"", "\[Rule]", 
       "\"\<http://www.w3.org/1998/Math/MathML\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\"\<semantics\>\"", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<msup\>\"", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\"\<mi\>\"", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\"\<x\>\"", "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\"\<mn\>\"", ",", 
                RowBox[{"{", "\"\<2\>\"", "}"}]}], "]"}]}], "}"}]}], "]"}], 
          ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\"\<annotation-xml\>\"", ",", 
            RowBox[{"{", 
             RowBox[{
             "\"\<encoding\>\"", "\[Rule]", "\"\<MathML-Content\>\""}], "}"}],
             ",", 
            RowBox[{"{", 
             RowBox[{"XMLElement", "[", 
              RowBox[{"\"\<apply\>\"", ",", 
               RowBox[{"{", "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\"\<power\>\"", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\"\<ci\>\"", ",", 
                   RowBox[{"{", "}"}], ",", 
                   RowBox[{"{", "\"\<x\>\"", "}"}]}], "]"}], ",", 
                 RowBox[{"XMLElement", "[", 
                  RowBox[{"\"\<cn\>\"", ",", 
                   RowBox[{"{", 
                    RowBox[{"\"\<type\>\"", "\[Rule]", "\"\<integer\>\""}], 
                    "}"}], ",", 
                   RowBox[{"{", "\"\<2\>\"", "}"}]}], "]"}]}], "}"}]}], "]"}],
              "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6064],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymbolicXMLQ",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/SymbolicXMLQ"]], "InlineFormula"],
 " indicates that there is an error:"
}], "ExampleText",
 CellID->16226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLQ", "[", 
  RowBox[{"symbolicXMLWithError", ",", " ", "True"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29472],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->284260247]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["SymbolicXMLErrors"], "InlineFormula"],
 " returns a part specification indicating where the error occurred, and a \
message indicating the nature of the problem:"
}], "ExampleText",
 CellID->19593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLErrors", "[", "symbolicXMLWithError", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32482],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLElement", "::", "\<\"argrx\"\>"}], ":", 
  " ", "\<\"\\!\\(XMLElement\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" called with \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(2\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
arguments; \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(3\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" arguments are \
expected.\\\\\\\"\\\", \\\"MSG\\\"]\\) \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/General/argrx\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->1558340401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"3", ",", "1", ",", "3", ",", "1", ",", "3", ",", "2"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->316560795]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " only has two arguments\[LongDash]the list for the attributes is missing:"
}], "ExampleText",
 CellID->15333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolicXMLWithError", "[", 
  RowBox[{"[", 
   RowBox[{"3", ",", "1", ",", "3", ",", "1", ",", "3", ",", "2"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->11105],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"mn\"\>", ",", 
   RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1120287946]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16125],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18456],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->297816849],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->668357460]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicXMLErrors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 35.7810066}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "SymbolicXMLErrors[expr] returns a list of part specifications indicating \
where there are errors in the SymbolicXML expression expr and a message about \
the nature of each error.", "synonyms" -> {}, "title" -> "SymbolicXMLErrors", 
    "type" -> "Symbol", "uri" -> "XML/ref/SymbolicXMLErrors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4239, 131, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->184673370]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13801, 451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 84, 55, 1, 70, "ObjectName",
 CellID->32471],
Cell[3003, 87, 593, 16, 70, "Usage",
 CellID->21778]
}, Open  ]],
Cell[CellGroupData[{
Cell[3633, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4111, 125, 91, 1, 70, "Notes",
 CellID->27440]
}, Closed]],
Cell[CellGroupData[{
Cell[4239, 131, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184673370],
Cell[CellGroupData[{
Cell[4624, 145, 148, 5, 70, "ExampleSection",
 CellID->250070484],
Cell[4775, 152, 126, 3, 70, "Input",
 CellID->152717586],
Cell[4904, 157, 85, 1, 70, "ExampleText",
 CellID->24815],
Cell[4992, 160, 2243, 57, 70, "Input",
 CellID->6064],
Cell[7238, 219, 219, 7, 70, "ExampleText",
 CellID->16226],
Cell[CellGroupData[{
Cell[7482, 230, 154, 4, 70, "Input",
 CellID->29472],
Cell[7639, 236, 162, 5, 36, "Output",
 CellID->284260247]
}, Open  ]],
Cell[7816, 244, 228, 5, 70, "ExampleText",
 CellID->19593],
Cell[CellGroupData[{
Cell[8069, 253, 128, 3, 70, "Input",
 CellID->32482],
Cell[8200, 258, 565, 12, 70, "Message",
 CellID->1558340401],
Cell[8768, 272, 271, 9, 36, "Output",
 CellID->316560795]
}, Open  ]],
Cell[9054, 284, 259, 8, 70, "ExampleText",
 CellID->15333],
Cell[CellGroupData[{
Cell[9338, 296, 202, 6, 70, "Input",
 CellID->11105],
Cell[9543, 304, 260, 8, 36, "Output",
 CellID->1120287946]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9864, 319, 311, 9, 70, "SeeAlsoSection",
 CellID->16125],
Cell[10178, 330, 1498, 53, 70, "SeeAlso",
 CellID->7210]
}, Open  ]],
Cell[CellGroupData[{
Cell[11713, 388, 314, 9, 70, "TutorialsSection",
 CellID->18456],
Cell[12030, 399, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[12206, 407, 319, 9, 70, "MoreAboutSection",
 CellID->297816849],
Cell[12528, 418, 137, 3, 70, "MoreAbout",
 CellID->668357460]
}, Open  ]],
Cell[12680, 424, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

