(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13697,        477]
NotebookOptionsPosition[     10732,        380]
NotebookOutlinePosition[     12180,        419]
CellTagsIndexPosition[     12095,        414]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ToSymbolicXML\"\>", 
       2->"\<\"FromSymbolicXML\"\>", 3->"\<\"ToVerboseXML\"\>", 
       4->"\<\"ToCompactXML\"\>", 5->"\<\"RawXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolicXMLQ", "ObjectName",
 CellID->3617],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicXMLQ", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " matches some basic patterns for a SymbolicXML expression and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicXMLQ", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["True",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/True"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]performs a complete test on ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to determine if it is a well-formed SymbolicXML expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymbolicXMLQ", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["False",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/False"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      RowBox[{"SymbolicXMLQ", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->29173]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
This is not a guarantee that the document is well formed, nor does it give \
hints about validation.\
\>", "Notes",
 CellID->30786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->586059857],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->530595986],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->77234329],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["attribute", "TI"], "->", 
    StyleBox["value", "TI"]}], "}"}]], "InlineFormula"],
 " portion of the SymbolicXML statement is malformed. ",
 Cell[BoxData["SymbolicXMLQ"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLQ", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<2001: A Space Odyssey\>\"", ",", 
     RowBox[{"{", "author", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", "True"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452]
}, Open  ]],

Cell[TextData[{
 "With a correctly formed option, ",
 Cell[BoxData["SymbolicXMLQ"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolicXMLQ", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<2001: A Space Odyssey\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<author\>\"", " ", "\[Rule]", " ", "\"\<Arthur C. Clarke\>\""}], 
      "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", "True"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29562],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1570]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17728],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10668],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->414656848],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->3992768]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolicXMLQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 35.9841368}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "SymbolicXMLQ[expr] returns True if the expression expr matches some \
basic patterns for a SymbolicXML expression and False otherwise. \
SymbolicXMLQ[expr, True] performs a complete test on expr to determine if it \
is a well-formed SymbolicXML expression. SymbolicXMLQ[expr, False] is \
equivalent to SymbolicXMLQ[expr].", "synonyms" -> {}, "title" -> 
    "SymbolicXMLQ", "type" -> "Symbol", "uri" -> "XML/ref/SymbolicXMLQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5418, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->586059857]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11952, 407}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 84, 49, 1, 70, "ObjectName",
 CellID->3617],
Cell[3013, 87, 1712, 52, 70, "Usage",
 CellID->29173]
}, Open  ]],
Cell[CellGroupData[{
Cell[4762, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5240, 161, 141, 4, 70, "Notes",
 CellID->30786]
}, Closed]],
Cell[CellGroupData[{
Cell[5418, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->586059857],
Cell[CellGroupData[{
Cell[5803, 184, 148, 5, 70, "ExampleSection",
 CellID->530595986],
Cell[5954, 191, 125, 3, 70, "Input",
 CellID->77234329],
Cell[6082, 196, 437, 16, 70, "ExampleText",
 CellID->19312],
Cell[CellGroupData[{
Cell[6544, 216, 281, 8, 28, "Input",
 CellID->734],
Cell[6828, 226, 156, 5, 36, "Output",
 CellID->452]
}, Open  ]],
Cell[6999, 234, 265, 10, 70, "ExampleText",
 CellID->5169],
Cell[CellGroupData[{
Cell[7289, 248, 371, 11, 70, "Input",
 CellID->29562],
Cell[7663, 261, 156, 5, 36, "Output",
 CellID->1570]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7880, 273, 311, 9, 70, "SeeAlsoSection",
 CellID->17728],
Cell[8194, 284, 1509, 53, 70, "SeeAlso",
 CellID->26260]
}, Open  ]],
Cell[CellGroupData[{
Cell[9740, 342, 314, 9, 70, "TutorialsSection",
 CellID->10668],
Cell[10057, 353, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[10233, 361, 319, 9, 70, "MoreAboutSection",
 CellID->414656848],
Cell[10555, 372, 135, 3, 70, "MoreAbout",
 CellID->3992768]
}, Open  ]],
Cell[10705, 378, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

