(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22003,        772]
NotebookOptionsPosition[     17897,        628]
NotebookOutlinePosition[     19256,        666]
CellTagsIndexPosition[     19171,        661]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "ToSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToSymbolicXML"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"ToSymbolicXML\"\>", 3->"\<\"FromSymbolicXML\"\>", 
       4->"\<\"ToVerboseXML\"\>", 5->"\<\"RawXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToCompactXML", "ObjectName",
 CellID->30336],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"ToCompactXML", "[", 
        StyleBox["expr", "TI"], "]"}], " "}]], "InlineFormula"],
     " \[LineSeparator]generates an equivalent SymbolicXML expression that \
suppresses all the redundant namespace information for elements and \
attributes in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToCompactXML", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["patt", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]suppresses only namespaces that match ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18829]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given: ", "Notes",
 CellID->5950],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AttributesDefaultNameSpace\>\"", 
    "\"\<NullNameSpace\>\"", Cell[
    "controls how attribute namespaces are abbreviated", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->21457]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66428113],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1052725494],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->261116846],

Cell["XML with explicit namespace information:", "ExampleText",
 CellID->29313],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xmlNull", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<foo\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xmlns\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\>\"", ",", "\"\<att\>\""}], "}"}], "\[Rule]", 
        "\"\<val\>\""}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xmlSame", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<foo\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xmlns\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<att\>\""}], "}"}], "\[Rule]", 
        "\"\<val\>\""}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xmlDifferent", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<foo\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xmlns\>\"", "\[Rule]", "\"\<A\>\""}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<B\>\"", ",", "\"\<att\>\""}], "}"}], "\[Rule]", 
        "\"\<val\>\""}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->15253],

Cell[TextData[{
 Cell[BoxData["ToCompactXML"], "InlineFormula"],
 " suppresses redundant namespace information for elements. Attributes in the \
null namespace always get compacted, regardless of the setting of ",
 Cell[BoxData["\"\<AttributesDefaultNameSpace\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlNull", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<NullNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4977],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{"\<\"att\"\>", "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlNull", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21505],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{"\<\"att\"\>", "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->153]
}, Open  ]],

Cell[TextData[{
 "Attributes in the same default namespace as the element only get compacted \
when ",
 Cell[BoxData["\"\<AttributesDefaultNameSpace\>\""], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<ElementNameSpace\>\""], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->24591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlSame", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<NullNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6562],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlSame", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->4854],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{"\<\"att\"\>", "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->20072]
}, Open  ]],

Cell["Attributes in other namespaces do not get compacted:", "ExampleText",
 CellID->11134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlDifferent", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<NullNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->23016],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"B\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->25050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{"xmlDifferent", ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->9193],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"foo\"\>", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"A\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"B\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->21945]
}, Open  ]],

Cell["\<\
If the namespace of a tag is explicit but different from the default, \
attributes will not be compacted:\
\>", "ExampleText",
 CellID->1852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<A\>\"", ",", "\"\<foo\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<xmlns\>\"", "\[Rule]", "\"\<B\>\""}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<att\>\""}], "}"}], "\[Rule]", 
        "\"\<val\>\""}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->20747],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"A\"\>", ",", "\<\"foo\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"B\"\>"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"att\"\>"}], "}"}], 
      "\[Rule]", "\<\"val\"\>"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->32521]
}, Open  ]],

Cell["The default namespace may be inherited from containing tags:", \
"ExampleText",
 CellID->8061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCompactXML", "[", 
  RowBox[{
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<root\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<xmlns\>\"", "\[Rule]", "\"\<B\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<A\>\"", ",", "\"\<foo\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\"\<B\>\"", ",", "\"\<att\>\""}], "}"}], "\[Rule]", 
          "\"\<val\>\""}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{
   "\"\<AttributesDefaultNameSpace\>\"", "\[Rule]", 
    "\"\<ElementNameSpace\>\""}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->6344],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"root\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xmlns\"\>", "\[Rule]", "\<\"B\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"XMLElement", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\<\"A\"\>", ",", "\<\"foo\"\>"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\<\"att\"\>", "\[Rule]", "\<\"val\"\>"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{470, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->20259]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19094],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32405],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->205233436],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->295522785]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToCompactXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 36.2341432}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ToCompactXML[expr] generates an equivalent SymbolicXML expression that \
suppresses all the redundant namespace information for elements and \
attributes in expr. ToCompactXML[expr, patt] suppresses only namespaces that \
match patt.", "synonyms" -> {}, "title" -> "ToCompactXML", "type" -> "Symbol",
     "uri" -> "XML/ref/ToCompactXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5016, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66428113]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19029, 654}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 84, 50, 1, 70, "ObjectName",
 CellID->30336],
Cell[3014, 87, 952, 29, 70, "Usage",
 CellID->18829]
}, Open  ]],
Cell[CellGroupData[{
Cell[4003, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4481, 138, 67, 1, 70, "Notes",
 CellID->5950],
Cell[4551, 141, 428, 10, 70, "3ColumnTableMod",
 CellID->21457]
}, Closed]],
Cell[CellGroupData[{
Cell[5016, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66428113],
Cell[CellGroupData[{
Cell[5400, 170, 149, 5, 70, "ExampleSection",
 CellID->1052725494],
Cell[5552, 177, 126, 3, 70, "Input",
 CellID->261116846],
Cell[5681, 182, 79, 1, 70, "ExampleText",
 CellID->29313],
Cell[5763, 185, 1438, 44, 70, "Input",
 CellID->15253],
Cell[7204, 231, 324, 7, 70, "ExampleText",
 CellID->16117],
Cell[CellGroupData[{
Cell[7553, 242, 224, 7, 70, "Input",
 CellID->4977],
Cell[7780, 251, 406, 12, 36, "Output",
 CellID->19160]
}, Open  ]],
Cell[CellGroupData[{
Cell[8223, 268, 228, 7, 70, "Input",
 CellID->21505],
Cell[8454, 277, 404, 12, 36, "Output",
 CellID->153]
}, Open  ]],
Cell[8873, 292, 283, 8, 70, "ExampleText",
 CellID->24591],
Cell[CellGroupData[{
Cell[9181, 304, 224, 7, 70, "Input",
 CellID->6562],
Cell[9408, 313, 475, 15, 36, "Output",
 CellID->3576]
}, Open  ]],
Cell[CellGroupData[{
Cell[9920, 333, 227, 7, 70, "Input",
 CellID->4854],
Cell[10150, 342, 406, 12, 36, "Output",
 CellID->20072]
}, Open  ]],
Cell[10571, 357, 91, 1, 70, "ExampleText",
 CellID->11134],
Cell[CellGroupData[{
Cell[10687, 362, 230, 7, 70, "Input",
 CellID->23016],
Cell[10920, 371, 476, 15, 36, "Output",
 CellID->25050]
}, Open  ]],
Cell[CellGroupData[{
Cell[11433, 391, 232, 7, 70, "Input",
 CellID->9193],
Cell[11668, 400, 476, 15, 36, "Output",
 CellID->21945]
}, Open  ]],
Cell[12159, 418, 151, 4, 70, "ExampleText",
 CellID->1852],
Cell[CellGroupData[{
Cell[12335, 426, 624, 19, 70, "Input",
 CellID->20747],
Cell[12962, 447, 533, 17, 36, "Output",
 CellID->32521]
}, Open  ]],
Cell[13510, 467, 100, 2, 70, "ExampleText",
 CellID->8061],
Cell[CellGroupData[{
Cell[13635, 473, 758, 22, 70, "Input",
 CellID->6344],
Cell[14396, 497, 586, 17, 36, "Output",
 CellID->20259]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15043, 521, 311, 9, 70, "SeeAlsoSection",
 CellID->19094],
Cell[15357, 532, 1509, 53, 70, "SeeAlso",
 CellID->28592]
}, Open  ]],
Cell[CellGroupData[{
Cell[16903, 590, 314, 9, 70, "TutorialsSection",
 CellID->32405],
Cell[17220, 601, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[17396, 609, 319, 9, 70, "MoreAboutSection",
 CellID->205233436],
Cell[17718, 620, 137, 3, 70, "MoreAbout",
 CellID->295522785]
}, Open  ]],
Cell[17870, 626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

