(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21502,        738]
NotebookOptionsPosition[     17638,        604]
NotebookOutlinePosition[     18884,        640]
CellTagsIndexPosition[     18799,        635]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Capabilities\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolicXMLQ" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLQ"], 
          "FromSymbolicXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/FromSymbolicXML"], 
          "ToVerboseXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToVerboseXML"], 
          "ToCompactXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/ToCompactXML"], "RawXML" :> 
          Documentation`HelpLookup["paclet:XML/ref/RawXML"], 
          "SymbolicXMLErrors" :> 
          Documentation`HelpLookup["paclet:XML/ref/SymbolicXMLErrors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SymbolicXMLQ\"\>", 
       2->"\<\"FromSymbolicXML\"\>", 3->"\<\"ToVerboseXML\"\>", 
       4->"\<\"ToCompactXML\"\>", 5->"\<\"RawXML\"\>", 
       6->"\<\"SymbolicXMLErrors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToSymbolicXML", "ObjectName",
 CellID->28428],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToSymbolicXML", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "converts an expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to an appropriate XML format and returns the result as SymbolicXML."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16678]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ToSymbolicXML"], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["FromSymbolicXML",
   BaseStyle->"Link",
   ButtonData->"paclet:XML/ref/FromSymbolicXML"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25960],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ToSymbolicXML"], "InlineFormula"],
 " to generate SymbolicXML with no output to a file. Once the SymbolicXML is \
generated, you can write it to a file with ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->101],

Cell["The following option can be given: ", "Notes",
 CellID->20949],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ExpandRawXML\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to convert ",
     Cell[BoxData[
      ButtonBox["RawXML",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/RawXML"]], "InlineFormula"],
     " string fragments"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64335407],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->320404002],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->346866147],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  SuperscriptBox["x", "2"]], "InlineFormula"],
 " returned in the corresponding SymbolicXML:"
}], "ExampleText",
 CellID->4493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", "[", 
  RowBox[{"x", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29768],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Expression\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Expression\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{"\<\"xmlns\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"Function\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Power\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Symbol\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"Number\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], 
      "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{494, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29935],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->55508658],

Cell["\<\
A notebook expression results in SymbolicXML representing ExpressionML:\
\>", "ExampleText",
 CellID->19109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", "[", 
  RowBox[{"Notebook", "[", 
   RowBox[{"{", 
    RowBox[{"Cell", "[", "\"\<Here is a notebook example\>\"", "]"}], "}"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30096],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], "]"}], ",", 
     RowBox[{
      RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
      RowBox[{"\<\"Notebook\"\>", ",", 
       RowBox[{"\<\"System\"\>", 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/notebookml1.dtd\"\>"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"Notebook\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\<\"CreatedBy\"\>", "\[Rule]", "\<\"Mathematica 6.0\"\>"}], 
       ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xhtml\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.w3.org/1999/xhtml\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"mathematica\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
          ",", "\<\"xmlns\"\>"}], "}"}], 
        "\[Rule]", "\<\"http://www.wolfram.com/XML/\"\>"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"List\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"XMLElement", "[", 
          RowBox[{"\<\"Cell\"\>", ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"XMLElement", "[", 
             RowBox[{"\<\"String\"\>", ",", 
              RowBox[{"{", "}"}], ",", 
              RowBox[{"{", "\<\"Here is a notebook example\"\>", "}"}]}], 
             "]"}], "}"}]}], "]"}], "}"}]}], "]"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{543, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->332618482],

Cell[TextData[{
 Cell[BoxData["\"\<ExpandRawXML\>\""], "InlineFormula"],
 " can control the conversion of raw XML string segments enclosed within the \
",
 Cell[BoxData["RawXML"], "InlineFormula"],
 " wrapper:"
}], "ExampleText",
 CellID->25739],

Cell[BoxData[
 RowBox[{
  RowBox[{"comboFragment", "=", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\"\<p\>\"", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<There's\>\"", ",", 
       RowBox[{"RawXML", "[", "\"\<<i>trouble</i>\>\"", "]"}], ",", 
       "\"\<my friend, right here in River City.\>\""}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", "[", 
  RowBox[{"comboFragment", ",", 
   RowBox[{"\"\<ExpandRawXML\>\"", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25923],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"p\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"There's\"\>", ",", 
     RowBox[{"RawXML", "[", "\<\"<i>trouble</i>\"\>", "]"}], 
     ",", "\<\"my friend, right here in River City.\"\>"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{510, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28499]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", "[", 
  RowBox[{"comboFragment", ",", 
   RowBox[{"\"\<ExpandRawXML\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16731],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"p\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"There's\"\>", ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"i\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"trouble\"\>", "}"}]}], "]"}], 
     ",", "\<\"my friend, right here in River City.\"\>"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{546, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11849]
}, Open  ]],

Cell[TextData[{
 "(The default setting for the option, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", is equivalent to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ".)"
}], "ExampleText",
 CellID->25442],

Cell[TextData[{
 "This provides an alternative to ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " for converting a segment of text XML to SymbolicXML:"
}], "ExampleText",
 CellID->8606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToSymbolicXML", "[", 
  RowBox[{
  "RawXML", "[", "\"\<<p>But what is it <i>good</i> for?</p>\>\"", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6850],

Cell[BoxData[
 RowBox[{"XMLElement", "[", 
  RowBox[{"\<\"p\"\>", ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"But what is it\"\>", ",", 
     RowBox[{"XMLElement", "[", 
      RowBox[{"\<\"i\"\>", ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\<\"good\"\>", "}"}]}], "]"}], ",", "\<\"for?\"\>"}], 
    "}"}]}], "]"}]], "Output",
 ImageSize->{464, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->28287]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4841],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLQ",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromSymbolicXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/FromSymbolicXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToVerboseXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToVerboseXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCompactXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ToCompactXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RawXML",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/RawXML"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolicXMLErrors",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/SymbolicXMLErrors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26385],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->162618140],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->138653413]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToSymbolicXML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 36.4997750}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "ToSymbolicXML[expr] converts an expression expr to an appropriate XML \
format and returns the result as SymbolicXML.", "synonyms" -> {}, "title" -> 
    "ToSymbolicXML", "type" -> "Symbol", "uri" -> "XML/ref/ToSymbolicXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5413, 175, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->64335407]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18657, 628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2335, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2958, 84, 51, 1, 70, "ObjectName",
 CellID->28428],
Cell[3012, 87, 539, 16, 70, "Usage",
 CellID->16678]
}, Open  ]],
Cell[CellGroupData[{
Cell[3588, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4066, 125, 261, 9, 70, "Notes",
 CellID->25960],
Cell[4330, 136, 346, 11, 70, "Notes",
 CellID->101],
Cell[4679, 149, 68, 1, 70, "Notes",
 CellID->20949],
Cell[4750, 152, 626, 18, 70, "3ColumnTableMod",
 CellID->2364]
}, Closed]],
Cell[CellGroupData[{
Cell[5413, 175, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64335407],
Cell[CellGroupData[{
Cell[5797, 189, 148, 5, 70, "ExampleSection",
 CellID->320404002],
Cell[5948, 196, 126, 3, 70, "Input",
 CellID->346866147],
Cell[6077, 201, 178, 6, 70, "ExampleText",
 CellID->4493],
Cell[CellGroupData[{
Cell[6280, 211, 128, 4, 28, "Input",
 CellID->29768],
Cell[6411, 217, 1886, 50, 139, "Output",
 CellID->27873]
}, Open  ]],
Cell[8312, 270, 121, 3, 70, "ExampleDelimiter",
 CellID->29935],
Cell[8436, 275, 125, 3, 70, "Input",
 CellID->55508658],
Cell[8564, 280, 118, 3, 70, "ExampleText",
 CellID->19109],
Cell[CellGroupData[{
Cell[8707, 287, 234, 7, 70, "Input",
 CellID->30096],
Cell[8944, 296, 2093, 55, 173, "Output",
 CellID->20381]
}, Open  ]],
Cell[11052, 354, 121, 3, 70, "ExampleDelimiter",
 CellID->21561],
Cell[11176, 359, 126, 3, 70, "Input",
 CellID->332618482],
Cell[11305, 364, 245, 7, 70, "ExampleText",
 CellID->25739],
Cell[11553, 373, 409, 12, 70, "Input",
 CellID->5584],
Cell[CellGroupData[{
Cell[11987, 389, 193, 5, 70, "Input",
 CellID->25923],
Cell[12183, 396, 433, 13, 54, "Output",
 CellID->28499]
}, Open  ]],
Cell[CellGroupData[{
Cell[12653, 414, 192, 5, 70, "Input",
 CellID->16731],
Cell[12848, 421, 526, 16, 54, "Output",
 CellID->11849]
}, Open  ]],
Cell[13389, 440, 354, 13, 70, "ExampleText",
 CellID->25442],
Cell[13746, 455, 270, 8, 70, "ExampleText",
 CellID->8606],
Cell[CellGroupData[{
Cell[14041, 467, 188, 6, 70, "Input",
 CellID->6850],
Cell[14232, 475, 494, 15, 36, "Output",
 CellID->28287]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14787, 497, 310, 9, 70, "SeeAlsoSection",
 CellID->4841],
Cell[15100, 508, 1507, 53, 70, "SeeAlso",
 CellID->18938]
}, Open  ]],
Cell[CellGroupData[{
Cell[16644, 566, 314, 9, 70, "TutorialsSection",
 CellID->26385],
Cell[16961, 577, 139, 3, 70, "Tutorials",
 CellID->31597]
}, Open  ]],
Cell[CellGroupData[{
Cell[17137, 585, 319, 9, 70, "MoreAboutSection",
 CellID->162618140],
Cell[17459, 596, 137, 3, 70, "MoreAbout",
 CellID->138653413]
}, Open  ]],
Cell[17611, 602, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

