(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18452,        610]
NotebookOptionsPosition[     15115,        497]
NotebookOutlinePosition[     16421,        534]
CellTagsIndexPosition[     16336,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Capabilities" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
          "Importing XML" :> 
          Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
       2->"\<\"Importing XML\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XMLGet" :> Documentation`HelpLookup["paclet:XML/ref/XMLGet"], 
          "InitializeXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/InitializeXMLParser"], 
          "ReleaseXMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/ReleaseXMLParser"], 
          "XMLParser" :> 
          Documentation`HelpLookup["paclet:XML/ref/XMLParser"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"XMLGet\"\>", 
       2->"\<\"InitializeXMLParser\"\>", 3->"\<\"ReleaseXMLParser\"\>", 
       4->"\<\"XMLParser\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"XML Package" :> 
          Documentation`HelpLookup["paclet:XML/guide/XMLPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"XML Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["XMLGetString", "ObjectName",
 CellID->5771],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLGetString", "[", "\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the XML expression tree corresponding to a \
string."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"XMLGetString", "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"data\", \"TI\"]\)\>\"", ",", 
        StyleBox["parser", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the pre-initialized ",
     Cell[BoxData[
      ButtonBox["XMLParser",
       BaseStyle->"Link",
       ButtonData->"paclet:XML/ref/XMLParser"]], "InlineFormula"],
     " object to parse the string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This function is similar to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"], "[", 
   RowBox[{
    StyleBox[
     RowBox[{"\"\<\>", "data", "\"\<\>"}], "TI"], ",", 
    ButtonBox["\"\<XML\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/XML"]}], "]"}]], "InlineFormula"],
 ". However, it can take a pre-initialized XML parser."
}], "Notes",
 CellID->11110],

Cell["The following options can be given: ", "Notes",
 CellID->32057],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<NormalizeWhitespace\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to remove leading, trailing, and multiple internal whitespace in \
elements\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeNamespaces\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to explicitly include namespaces", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ValidateAgainstDTD\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to validate the XML against the DTD content model", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeEmbeddedObjects\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether to retain comments and processing instructions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AllowRemoteDTDAccess\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to seek DTDs on the network", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadDTD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to read the DTD", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeDefaultedAttributes\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to explicitly include default attributes as defined in the DTD\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AllowUnrecognizedEntities\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether entities undefined by the DTD are considered errors", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PreserveCDATASections\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the distinction between CDATA sections and regular character data is \
maintained on import\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->10666]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26923647],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->230909820],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->88407172],

Cell[TextData[{
 Cell[BoxData["XMLGetString"], "InlineFormula"],
 " imports a string as SymbolicXML:"
}], "ExampleText",
 CellID->5536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XMLGetString", "[", 
  "\"\<<math><mi>x</mi><mo>+</mo><mn>5</mn></math>\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6763],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mi\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"x\"\>", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mo\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"+\"\>", "}"}]}], "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"mn\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", "\<\"5\"\>", "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{560, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21858],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<XML`\>\"", "]"}]], "Input", "Deemphasis",
 CellLabel->"In[1]:=",
 CellID->837418251],

Cell[TextData[{
 "To use ",
 Cell[BoxData["XMLGetString"], "InlineFormula"],
 " with a pre-initialized parser, pre-initialize the parser according to a \
DTD at the remote URL and name that pre-initialized parser ",
 Cell[BoxData["XHTMLParser"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XHTMLParser", "=", 
  RowBox[{"InitializeXMLParser", "[", 
   RowBox[{
   "\"\<html\>\"", ",", 
    "\"\<http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7301],

Cell[BoxData[
 RowBox[{"XMLParser", "[", 
  RowBox[{"\<\"html\"\>", 
   ",", "\<\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\>"}], 
  "]"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2061]
}, Open  ]],

Cell[TextData[{
 "Use the pre-initialized parser to validate the string on import. ",
 Cell[BoxData[
  RowBox[{"\"\<Valid\>\"", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " indicates the string was validated successfully:"
}], "ExampleText",
 CellID->32655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"XMLGetString", "[", 
  RowBox[{
  "\"\<<html><head><title>test</title></head><body><p>Here is some \
text.</p></body></html>\>\"", ",", "XHTMLParser", ",", 
   RowBox[{"\"\<ValidateAgainstDTD\>\"", "\[Rule]", "True"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3815],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Doctype\"\>", "]"}], "[", 
     RowBox[{"\<\"html\"\>", ",", 
      RowBox[{"\<\"System\"\>", 
       "\[Rule]", \
"\<\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"html\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"head\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"title\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"test\"\>", "}"}]}], "]"}], "}"}]}], "]"}], ",", 
       
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"body\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"p\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"Here is some text.\"\>", "}"}]}], "]"}], 
          "}"}]}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"\<\"Valid\"\>", "\[Rule]", "True"}]}], "]"}]], "Output",
 ImageSize->{571, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21174]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31148],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLGet",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLGet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializeXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/InitializeXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReleaseXMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/ReleaseXMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["XMLParser",
    BaseStyle->"Link",
    ButtonData->"paclet:XML/ref/XMLParser"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26250],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "Tutorials",
 CellID->31597],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "Tutorials",
 CellID->406323577]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->281066259],

Cell[TextData[ButtonBox["XML Package",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/guide/XMLPackage"]], "MoreAbout",
 CellID->531052125]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XMLGetString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 43.0468176}", "context" -> "XML`", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Symbol", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "XMLGetString[\"data\"] returns the XML expression tree corresponding to \
a string. XMLGetString[\"data\", parser] uses the pre-initialized XMLParser \
object to parse the string. ", "synonyms" -> {}, "title" -> "XMLGetString", 
    "type" -> "Symbol", "uri" -> "XML/ref/XMLGetString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7415, 218, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26923647]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16194, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2210, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2833, 81, 49, 1, 70, "ObjectName",
 CellID->5771],
Cell[2885, 84, 888, 26, 70, "Usage",
 CellID->21256]
}, Open  ]],
Cell[CellGroupData[{
Cell[3810, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4288, 132, 467, 15, 70, "Notes",
 CellID->11110],
Cell[4758, 149, 69, 1, 70, "Notes",
 CellID->32057],
Cell[4830, 152, 2548, 61, 70, "3ColumnTableMod",
 CellID->10666]
}, Closed]],
Cell[CellGroupData[{
Cell[7415, 218, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26923647],
Cell[CellGroupData[{
Cell[7799, 232, 148, 5, 70, "ExampleSection",
 CellID->230909820],
Cell[7950, 239, 125, 3, 70, "Input",
 CellID->88407172],
Cell[8078, 244, 135, 4, 70, "ExampleText",
 CellID->5536],
Cell[CellGroupData[{
Cell[8238, 252, 156, 4, 28, "Input",
 CellID->6763],
Cell[8397, 258, 931, 27, 54, "Output",
 CellID->20016]
}, Open  ]],
Cell[9343, 288, 121, 3, 70, "ExampleDelimiter",
 CellID->21858],
Cell[9467, 293, 126, 3, 70, "Input",
 CellID->837418251],
Cell[9596, 298, 303, 8, 70, "ExampleText",
 CellID->23934],
Cell[CellGroupData[{
Cell[9924, 310, 253, 8, 70, "Input",
 CellID->7301],
Cell[10180, 320, 292, 9, 36, "Output",
 CellID->2061]
}, Open  ]],
Cell[10487, 332, 323, 9, 70, "ExampleText",
 CellID->32655],
Cell[CellGroupData[{
Cell[10835, 345, 302, 8, 70, "Input",
 CellID->3815],
Cell[11140, 355, 1430, 41, 88, "Output",
 CellID->21174]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12631, 403, 311, 9, 70, "SeeAlsoSection",
 CellID->31148],
Cell[12945, 414, 992, 35, 70, "SeeAlso",
 CellID->5874]
}, Open  ]],
Cell[CellGroupData[{
Cell[13974, 454, 314, 9, 70, "TutorialsSection",
 CellID->26250],
Cell[14291, 465, 139, 3, 70, "Tutorials",
 CellID->31597],
Cell[14433, 470, 144, 3, 70, "Tutorials",
 CellID->406323577]
}, Open  ]],
Cell[CellGroupData[{
Cell[14614, 478, 319, 9, 70, "MoreAboutSection",
 CellID->281066259],
Cell[14936, 489, 137, 3, 70, "MoreAbout",
 CellID->531052125]
}, Open  ]],
Cell[15088, 495, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

