(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62641,       2182]
NotebookOptionsPosition[     50423,       1745]
NotebookOutlinePosition[     52581,       1793]
CellTagsIndexPosition[     52538,       1790]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["XML PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"XML Capabilities" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/Overview"], 
         "Importing XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ImportingXML"], 
         "Exporting XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/ExportingXML"], 
         "Transforming XML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/TransformingXML"], 
         "MathML" :> 
         Documentation`HelpLookup["paclet:XML/tutorial/MathML"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"XML Capabilities\"\>", 
      2->"\<\"Importing XML\"\>", 3->"\<\"Exporting XML\"\>", 
      4->"\<\"Transforming XML\"\>", 
      5->"\<\"MathML\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Representing XML in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Title",
 PageBreakAbove->True,
 CellID->8329],

Cell[CellGroupData[{

Cell[TextData[{
 "XML and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "Section",
 CellID->16290],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later includes comprehensive support for ",
 ButtonBox["XML",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/REC-xml"], None}],
 ", the meta-markup language developed by the ",
 ButtonBox["World Wide Web Consortium (W3C)",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3c.org"], None}],
 " for describing structured documents and data. Using the new XML features \
introduced in Version 4.2, you can do any of the following:"
}], "Text",
 CellID->22974],

Cell[TextData[{
 "Import any arbitrary XML document into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in the form of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression."
}], "BulletedText",
 CellID->23072],

Cell[TextData[{
 "Analyze the contents of the XML document or transform its structure using \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s sophisticated programming and symbolic manipulation \
capabilities."
}], "BulletedText",
 CellID->3591],

Cell["\<\
Export the resulting expression back as an XML document to share it with \
other users and applications.\
\>", "BulletedText",
 CellID->12189],

Cell[CellGroupData[{

Cell["\<\
Import, export, and evaluate equations in MathML, the standard for \
representing math on the web. \
\>", "BulletedText",
 CellID->15787],

Cell[TextData[{
 "These features make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " a powerful development environment for creating and processing XML \
documents. They ensure complete interoperability between ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and other XML applications, and between notebooks and other XML document \
formats. "
}], "Text",
 CellID->31490]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Native XML Formats", "Section",
 CellID->3239],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has built-in support for many",
 " ",
 "XML formats, including MathML, SVG, ExpressionML, JVX, X3D, VRML, and \
XHTML. If you import a document in any of these formats, it is automatically \
converted into a specific type of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. An ExpressionML file is imported as a cell expression. A \
MathML file is returned as a box expression."
}], "Text",
 CellID->14893],

Cell[CellGroupData[{

Cell["MathML", "Subsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3053],

Cell[TextData[{
 "MathML is an XML format developed by the W3C for describing the structure \
and meaning of mathematical formulas. It provides a standard way of \
displaying mathematical notation in web pages. Version 4.1 of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " included limited support for import and export of MathML. In Version 4.2 \
and later, the support has been greatly expanded with many new functions for \
generating and manipulating MathML and converting between MathML and the \
expressions used internally by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to represent mathematics. "
}], "Text",
 CellID->17063],

Cell[TextData[{
 "New MathML features make ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " an excellent environment for authoring and editing MathML content. You \
can, for example, use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s powerful typesetting system to create properly \
formatted equations and then copy and paste them in MathML format into an \
HTML document for display on the web. You can also import MathML equations \
from other applications and evaluate them using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->10681]
}, Open  ]],

Cell[CellGroupData[{

Cell["SVG", "Subsection",
 CellID->25903],

Cell[TextData[{
 "SVG (Scalable Vector Graphics) is an XML format developed by the W3C for \
describing two-dimensional graphics. SVG images can be rescaled without loss \
of resolution and are usually much smaller in size than comparable JPEG or \
GIF images. SVG files can also be manipulated with a scripting language to \
produce dynamic and interactive graphics. Using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 4.2 and later, you can directly export any graphics present in a notebook, \
in SVG format."
}], "Text",
 CellID->27005]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExpressionML", "Subsection",
 CellID->24176],

Cell[TextData[{
 "ExpressionML fragments can represent any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression in an XML format."
}], "Text",
 CellID->18479]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic XML", "Section",
 CellID->1695],

Cell[CellGroupData[{

Cell["What is Symbolic XML?", "Subsection",
 CellID->6139],

Cell[TextData[{
 "Symbolic XML is the format used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " for representing XML documents. The conversion from XML to symbolic XML \
translates the XML document into a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, while preserving its structure. Since both XML documents and \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions have a tree structure, there is a natural mapping from one to \
the other. You can then manipulate the symbolic XML expression using the \
standard techniques of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming. "
}], "Text",
 CellID->32468],

Cell[TextData[{
 "You can import XML data into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using the standard ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " function. You can also control various details of the import process, such \
as how to treat whitespace, whether to recognize entities, or whether to \
validate against a DTD, by specifying options."
}], "Text",
 CellID->13998],

Cell[TextData[{
 " The following command imports an XML data file into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->21083],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"], "[", 
  RowBox[{
   StyleBox["\"\<data.xml\>\"", "MR"], ",", 
   ButtonBox["\"\<XML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/XML"]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->23639],

Cell[TextData[{
 "The result is a symbolic XML expression, ",
 StyleBox["expr1", "TI"],
 ", which you can then manipulate using standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands. The end result of your transformations is another symbolic XML \
expression, ",
 StyleBox["expr2", "TI"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellID->29515]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  StyleBox["expr1", "TI"], " ", "->", " ", 
  StyleBox["expr2", "TI"]}]], "InlineFormula"]], "IndentedText",
 FontWeight->"Bold",
 CellID->27621],

Cell[TextData[{
 "Finally, you can export the result as an XML file using the standard ",
 StyleBox["Export", "Input",
  FontWeight->"Plain"],
 " function. "
}], "Text",
 CellID->29993]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"], "[", 
  RowBox[{
   StyleBox["\"\<newdata.xml\>\"", "MR"], ",", 
   StyleBox["expr2", "TI"], ",", 
   ButtonBox["\"\<XML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/XML"]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->15826],

Cell["\<\
You can use options to control various details of the export process, such as \
the format of the exported XML.\
\>", "Text",
 CellID->15722],

Cell[TextData[{
 "The combination of symbolic XML and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programming provides a useful alternative to other techniques for \
manipulating XML documents, such as XSLT transformations or the SAX or DOM \
APIs used with a low-level programming language such as Java. ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "allows you to achieve the same level of flexibility and control in \
processing XML documents. You can leverage ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s advanced support for symbolic manipulation and \
numerical computation to do some very complex and sophisticated \
transformations that would be difficult or impossible to do using other \
methods."
}], "Text",
 CellID->23838],

Cell[TextData[{
 "For example, you can use pattern-matching techniques to extract specific \
parts of an XML document, perform numerical computations on the data, and \
then convert the results into 3D graphics for easy visualization. You can \
also define transformations to convert one type of XML application to \
another. For example, you can import a ",
 StyleBox["DocBook", "MR"],
 " document as symbolic XML and then convert it into XHTML format by defining \
suitable transformation rules to replace one set of element names with \
another set. For some specific examples of useful applications of symbolic \
XML, see ",
 ButtonBox["Transforming XML",
  BaseStyle->"Link",
  ButtonData->"paclet:XML/tutorial/TransformingXML"],
 "."
}], "Text",
 CellID->24828],

Cell[TextData[{
 "Support for symbolic XML is well-integrated with ExpressionML and MathML. \
For example, when importing an XML document as symbolic XML, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " recognizes whether the document is in ExpressionML",
 " ",
 "or MathML format and automatically converts it into an expression in the \
case of ExpressionML or a typeset box expression in the case of MathML. You \
can also override the default behavior and choose to import any of these XML \
flavors as symbolic XML. There are a large number of kernel functions for \
quickly and easily converting between strings, boxes, or expressions on the \
one hand, and MathML or symbolic XML on the other."
}], "Text",
 CellID->12581],

Cell[TextData[{
 "If you prefer to manipulate XML documents using Java directly, you can \
still do so using the ",
 StyleBox["J/Link",
  FontSlant->"Italic"],
 " add-on package. This package integrates ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " fully with Java, enabling you to call Java commands from ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "or to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel functions from Java programs. You can thus have access to both the \
computational abilities of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as well as the low-level programming features and classes of Java, \
combining the two as needed."
}], "Text",
 CellID->24399]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Representing Elements", "Subsection",
 CellID->8978],

Cell[TextData[{
 "Each element in an XML document corresponds to an ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " object in symbolic XML. An XML expression of the form"
}], "Text",
 CellID->11891],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["<", "MR"],
 StyleBox["element", "TI"],
 StyleBox[" ", "MR"],
 StyleBox["attribute", "TI"],
 StyleBox["='", "MR"],
 StyleBox["value", "TI"],
 StyleBox["'>", "MR"],
 StyleBox["data", "TI"],
 StyleBox["</", "MR"],
 StyleBox["element", "TI"],
 StyleBox[">", "MR"]
}], "IndentedText",
 CellID->1023],

Cell["has the following representation in symbolic XML:", "Text",
 CellID->26943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"], "[", 
  RowBox[{
   StyleBox["element", "TI"], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["attribute", "TI"], "->", 
     StyleBox["value", "TI"]}], "}"}], ",", 
   RowBox[{"{", 
    StyleBox["data", "TI"], "}"}]}], "]"}]], "InlineFormula"]], "IndentedText",\

 CellID->24834],

Cell[TextData[{
 "Each ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", "]"}]], "InlineFormula"],
 " expression has three arguments:"
}], "Text",
 CellID->14243]
}, Open  ]],

Cell["The first argument specifies the name of the element.", "BulletedText",
 CellID->7349],

Cell[TextData[{
 "The second argument specifies the attributes of the element as a list of \
zero or more rules, with each rule specifying a single attribute in the form: \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["attribute", "TI"], " ", "->", " ", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". "
}], "BulletedText",
 CellID->2702],

Cell[CellGroupData[{

Cell[TextData[{
 "The third argument specifies the actual data contained in the element. This \
can be raw character data in the form of a string, child elements of the \
element being represented, or both. Each child element is represented by its \
own ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", "]"}]], "InlineFormula"],
 " expression. You can nest multiple ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", "]"}]], "InlineFormula"],
 " expressions to the level necessary to replicate the nested structure of \
the original XML expression. "
}], "BulletedText",
 CellID->8707],

Cell[TextData[{
 "The names of all elements and attributes as well as any character data in \
the XML document are represented as strings in symbolic XML. This is to \
prevent a large number of new symbols from being introduced into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session, which could lead to possible naming conflicts. "
}], "Text",
 CellID->20502],

Cell["Here is a simple XML fragment.", "Text",
 CellID->25141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<book type='novel'>Moby Dick</book>", "MR"]], \
"IndentedText",
 CellID->10687],

Cell["Here is the representation of this fragment in symbolic XML.", "Text",
 CellID->8346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"], "[", 
  RowBox[{
   StyleBox["\"\<book\>\"", "MR"], ",", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["\"\<type\>\"", "MR"], "->", 
     StyleBox["\"\<novel\>\"", "MR"]}], "}"}], ",", 
   RowBox[{"{", "\"\<Moby Dick\>\"", "}"}]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->15891],

Cell["\<\
Here is a more complicated XML expression, showing several levels of nesting.\
\
\>", "Text",
 CellID->24637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<book type='novel'>\n <title>Moby Dick</title>\n \
<author born='1819' died='1891'>\n  <name>\n   <first>Herman</first>\n   \
<last>Melville</last>\n  </name>\n </author>\n</book>", "MR"]], "IndentedText",\

 CellID->18413],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->11400]
}, Open  ]],

Cell[TextData[{
 "  ",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["XMLElement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/XMLElement"], "[", 
    RowBox[{
     StyleBox["\"\<book\>\"", "MR"], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\"\<type\>\"", "MR"], "->", 
       StyleBox["\"\<novel\>\"", "MR"]}], "}"}], ",", 
     RowBox[{"{", "\n", "    ", 
      RowBox[{
       RowBox[{
        ButtonBox["XMLElement",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/XMLElement"], "[", 
        RowBox[{
         StyleBox["\"\<title\>\"", "MR"], ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          StyleBox["\"\<Moby Dick\>\"", "MR"], "}"}]}], "]"}], ",", "\n", 
       "    ", 
       RowBox[{
        ButtonBox["XMLElement",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/XMLElement"], "[", 
        RowBox[{
         StyleBox["\"\<author\>\"", "MR"], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            StyleBox["\"\<born\>\"", "MR"], "->", 
            StyleBox["\"\<1819\>\"", "MR"]}], ",", 
           RowBox[{
            StyleBox["\"\<died\>\"", "MR"], "->", 
            StyleBox["\"\<1891\>\"", "MR"]}]}], "}"}], ",", 
         RowBox[{"{", "\n", "    ", 
          RowBox[{
           ButtonBox["XMLElement",
            BaseStyle->"Link",
            ButtonData->"paclet:ref/XMLElement"], "[", 
           RowBox[{
            StyleBox["\"\<name\>\"", "MR"], ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\n", "      ", 
             RowBox[{
              RowBox[{
               ButtonBox["XMLElement",
                BaseStyle->"Link",
                ButtonData->"paclet:ref/XMLElement"], "[", 
               RowBox[{
                StyleBox[
                 RowBox[{"\"\<\>", "first", "\"\<\>"}], "MR"], ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 StyleBox["\"\<Herman\>\"", "MR"], "}"}]}], "]"}], ",", "\n", 
              "      ", 
              RowBox[{
               ButtonBox["XMLElement",
                BaseStyle->"Link",
                ButtonData->"paclet:ref/XMLElement"], "[", 
               RowBox[{
                StyleBox[
                 RowBox[{"\"\<\>", "last", "\"\<\>"}], "MR"], ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 StyleBox["\"\<Melville\>\"", "MR"], "}"}]}], "]"}]}], 
             "}"}]}], "]"}], "}"}]}], "]"}]}], "}"}]}], "]"}]}]], 
  "InlineFormula"]
}], "IndentedText",
 CellID->22816]
}, Open  ]],

Cell[CellGroupData[{

Cell["Handling Namespaces", "Subsection",
 CellID->31690],

Cell["\<\
If a namespace is specified in an XML element, the syntax of the \
corresponding symbolic XML expression is slightly more complex. The exact \
syntax depends on whether the namespace is specified implicitly, as a default \
namespace, or explicitly, using a namespace prefix.\
\>", "Text",
 CellID->13162],

Cell[CellGroupData[{

Cell["Using a default namespace", "Subsubsection",
 CellID->8935],

Cell[TextData[{
 "For any element that lies within a default namespace, the ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " expression is the same as it would be if no namespace was specified. \
However, the element in which the default namespace is declared has its ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " expression modified."
}], "Text",
 CellID->29126],

Cell[TextData[{
 "Here is a simple XHTML document with a default namespace declared on the ",
 StyleBox["html", "MR"],
 " element. "
}], "Text",
 CellID->19410],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<html xmlns='http://www.w3.org/1999/xhtml'>\n     \
<head> </head>\n     <body>\n     <p>Here is some text.</p>\n</body>\n\
</html>", "MR"]], "IndentedText",
 CellID->19877],

Cell["Here is the corresponding symbolic XML expression. ", "Text",
 CellID->11382]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"], "[", 
  RowBox[{
   StyleBox["\"\<html\>\"", "MR"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox[
        RowBox[{
         RowBox[{"\"\<\>", 
          RowBox[{"http", ":"}]}], "//", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"www", ".", "w3", ".", "org"}], "/", "2000"}], "/", 
           "xmlns"}], "/", "\"\<\>"}]}], "MR"], ",", 
       StyleBox[
        RowBox[{"\"\<\>", "xmlns", "\"\<\>"}], "MR"]}], "}"}], " ", "->", " ",
      
     StyleBox["\"\<http://www.w3.org/1999/xhtml\>\"", "MR"]}], "}"}], ",", 
   RowBox[{"{", "\n", 
    RowBox[{
     RowBox[{
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"], "[", 
      RowBox[{
       StyleBox["\"\<head\>\"", "MR"], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "]"}], ",", "\n", 
     RowBox[{
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"], "[", 
      RowBox[{
       StyleBox["\"\<body\>\"", "MR"], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\n", 
        RowBox[{
         ButtonBox["XMLElement",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/XMLElement"], "[", 
         RowBox[{
          StyleBox["\"\<p\>\"", "MR"], ",", 
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           StyleBox["\"\<Here is some text.\>\"", "MR"], "}"}]}], "]"}], 
        "}"}]}], "]"}]}], "}"}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->26260],

Cell[TextData[{
 "Note the complex structure of the ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " expression representing the html element. Its second argument is:"
}], "Text",
 CellID->27189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["\"\<http://www.w3.org/2000/xmlns/\>\"", "MR"], ",", 
     StyleBox["\"\<xmlns\>\"", "MR"]}], "}"}], "->", 
   StyleBox["\"\<http://www.w3.org/1999/xhtml\>\"", "MR"]}], 
  "}"}]], "InlineFormula"]], "IndentedText",
 CellID->26705],

Cell["This statement:", "Text",
 CellID->13874]
}, Open  ]],

Cell[TextData[{
 "Identifies the ",
 StyleBox["xmlns", "MR"],
 " attribute with the namespace defined by the URI (Universal Resource \
Identifier)",
 " ",
 StyleBox["http://www.w3.org/2000/xmlns", "MR"],
 ", as required by the XML specification. "
}], "BulletedText",
 CellID->2663],

Cell[CellGroupData[{

Cell[TextData[{
 "Sets the value of the ",
 StyleBox["xmlns", "MR"],
 " attribute to the URI ",
 StyleBox["http://www.w3.org/1999/xhtml", "MR"],
 ", thus defining the default namespace."
}], "BulletedText",
 CellID->20722],

Cell[TextData[{
 "In general, when declaring a default namespace on an element, the syntax of \
the corresponding ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " structure is:"
}], "Text",
 CellID->32195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"], "[", 
  RowBox[{
   StyleBox["element", "TI"], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xmlns_uri", "TI"], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           StyleBox[
            RowBox[{"\"\<\>", "xmlns", "\"\<\>"}], "MR"], "}"}], "->", " ", 
          StyleBox["namespace_uri", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         StyleBox["data", "TI"], "}"}]}], 
       "]"}]}]}]}]}]}]], "InlineFormula"]], "IndentedText",
 CellID->22566],

Cell[TextData[{
 "Here ",
 StyleBox["xmlns_uri",
  FontSlant->"Italic"],
 " is the URI associated with the namespace of the ",
 StyleBox["xmlns", "MR"],
 " attribute and ",
 StyleBox["namespace_uri",
  FontSlant->"Italic"],
 " is the URI of the default namespace being declared."
}], "Text",
 CellID->16360]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Using an explicit namespace prefix", "Subsubsection",
 CellID->6038],

Cell["\<\
If the namespace is specified explicitly on an element using a namespace \
prefix, the syntax of the symbolic XML expression is modified, as shown in \
the following example. \
\>", "Text",
 CellID->18588],

Cell[TextData[{
 "Here is an XHTML document with some embedded MathML markup. The ",
 StyleBox["xmlns:m", "MR"],
 " attribute in the ",
 StyleBox["math", "MR"],
 " element binds the MathML namespace to the namespace prefix ",
 Cell[BoxData["m"], "InlineFormula"],
 ". All the MathML element names are then written with this namespace prefix \
attached. "
}], "Text",
 CellID->7811],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<html xmlns='http://www.w3.org/1999/xhtml'>\n     \
<head> <title>Test</title> </head>\n       <body>\n         <p>Here is some \
math.</p>\n         <p>\n           <m:math \
xmlns:m='http://www.w3.org/1998/Math/MathML'>\n             <m:mi>x</m:mi>\n  \
           <m:mo>+</m:mo>\n             <m:mn>1</m:mn>\n          </m:math>\n \
        </p>\n     </body>\n</html>", "MR"]], "IndentedText",
 CellID->28245],

Cell["Here is the corresponding symbolic XML expression. ", "Text",
 CellID->9467]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"], "[", 
  RowBox[{
   StyleBox["\"\<html\>\"", "MR"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["\"\<http://www.w3.org/2000/xmlns/\>\"", "MR"], ",", 
       StyleBox["\"\<xmlns\>\"", "MR"]}], "}"}], " ", "->", " ", 
     StyleBox["\"\<http://www.w3.org/1999/xhtml\>\"", "MR"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"], "[", 
      RowBox[{
       StyleBox["\"\<head\>\"", "MR"], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "]"}], ",", "\n", "     ", 
     RowBox[{
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"], "[", 
      RowBox[{
       StyleBox["\"\<body\>\"", "MR"], ",", 
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "\n", "         ", 
        RowBox[{
         RowBox[{
          ButtonBox["XMLElement",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/XMLElement"], "[", 
          RowBox[{
           StyleBox["\"\<p\>\"", "MR"], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", 
            StyleBox["\"\<Here is some math.\>\"", "MR"], "}"}]}], "]"}], ",",
          "\n", "         ", 
         RowBox[{
          ButtonBox["XMLElement",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/XMLElement"], "[", 
          RowBox[{
           StyleBox["\"\<p\>\"", "MR"], ",", 
           RowBox[{"{", "}"}], ",", 
           RowBox[{"{", "            \t", 
            RowBox[{
             ButtonBox["XMLElement",
              BaseStyle->"Link",
              ButtonData->"paclet:ref/XMLElement"], "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                StyleBox["\"\<http://www.w3.org/1998/Math/MathML\>\"", "MR"], 
                ",", 
                StyleBox["\"\<math\>\"", "MR"]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  StyleBox["\"\<http://www.w3.org/2000/xmlns/\>\"", "MR"], 
                  ",", 
                  StyleBox["\"\<m\>\"", "MR"]}], "}"}], "->", 
                
                StyleBox["\"\<http://www.w3.org/1998/Math/MathML\>\"", 
                 "MR"]}], "}"}], ",", 
              RowBox[{"{", "\n", 
               RowBox[{
                RowBox[{
                 ButtonBox["XMLElement",
                  BaseStyle->"Link",
                  ButtonData->"paclet:ref/XMLElement"], "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    
                    StyleBox["\"\<http://www.w3.org/1998/Math/MathML\>\"", 
                    "MR"], ",", 
                    StyleBox["\"\<mi\>\"", "MR"]}], "}"}], ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", 
                   StyleBox["\"\<x\>\"", "MR"], "}"}]}], "]"}], ",", "\n", 
                "                 ", 
                RowBox[{
                 ButtonBox["XMLElement",
                  BaseStyle->"Link",
                  ButtonData->"paclet:ref/XMLElement"], "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    
                    StyleBox["\"\<http://www.w3.org/1998/Math/MathML\>\"", 
                    "MR"], ",", 
                    StyleBox["\"\<mo\>\"", "MR"]}], "}"}], ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", 
                   StyleBox["\"\<+\>\"", "MR"], "}"}]}], "]"}], ",", "\n", 
                "                 ", 
                RowBox[{
                 ButtonBox["XMLElement",
                  BaseStyle->"Link",
                  ButtonData->"paclet:ref/XMLElement"], "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    StyleBox[
                    RowBox[{
                    RowBox[{"\"\<\>", 
                    RowBox[{"http", ":"}]}], "//", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"www", ".", "w3", ".", "org"}], "/", "1998"}], 
                    "/", "Math"}], "/", "MathML"}], "\"\<\>"}]}], "MR"], ",", 
                    
                    StyleBox[
                    RowBox[{"\"\<\>", "mn", "\"\<\>"}], "MR"]}], "}"}], ",", 
                  RowBox[{"{", "}"}], ",", 
                  RowBox[{"{", 
                   StyleBox[
                    RowBox[{"\"\<\>", "1", "\"\<\>"}], "MR"], "}"}]}], "\n", 
                 "                   ", "]"}]}], "}"}]}], "]"}], "}"}]}], 
          "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->32425],

Cell["There are two features to note here.", "Text",
 CellID->26867]
}, Open  ]],

Cell[TextData[{
 "The first attribute of the XMLElement structure for the top-level math \
element is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<http://www.w3.org/2000/xmlns/\>\"", ",", "\"\<m\>\""}], 
    "}"}], "->", "\"\<http://www.w3.org/1998/Math/MathML\>\""}]], 
  "InlineFormula"],
 ". This associates the MathML namespace with the prefix ",
 Cell[BoxData["m"], "InlineFormula"],
 "."
}], "BulletedText",
 CellID->13189],

Cell[TextData[{
 "The XMLElement expression for each MathML element is of the form: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLElement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLElement"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["uri", "TI"], ",", " ", 
      StyleBox["element", "TI"]}], "}"}], ",", 
    RowBox[{"{", "}"}], ",", 
    RowBox[{"{", 
     StyleBox["data", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 ", where ",
 StyleBox["uri", "TI"],
 " identifies the MathML namespace. This is the symbolic XML equivalent of \
writing an element name with the namespace prefix attached."
}], "BulletedText",
 CellID->10542]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Representing Other Objects", "Subsection",
 CellID->13063],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " expressions are used as containers for parts of an XML document other than \
elements, such as comments, processing instructions, and declarations. They \
are also used as containers for the entire document itself. This structure \
has the syntax ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["XMLObject",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/XMLObject"], "[", 
    StyleBox["object", "TI"], "]"}], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 ", where ",
 StyleBox["object", "TI"],
 " describes the type of object being represented and ",
 StyleBox["data", "TI"],
 " specifies the details of the object. There are six types of objects that \
can be specified as the first argument; each object type corresponds to a \
specific type of XML construct."
}], "Text",
 CellID->21547],

Cell[TextData[StyleBox["Declaration", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->30502],

Cell[TextData[StyleBox["Comment", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->29617],

Cell[TextData[StyleBox["Document", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->9099],

Cell[TextData[StyleBox["Doctype", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->25023],

Cell[TextData[StyleBox["ProcessingInstruction", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->17226],

Cell[TextData[StyleBox["CDATASection", "Input",
 FontWeight->"Plain"]], "BulletedText",
 CellID->31203],

Cell[CellGroupData[{

Cell["Declaration", "Subsubsection",
 CellID->30048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Declaration\>\"", "]"}]], 
  "InlineFormula"],
 " represents the XML declaration that typically appears at the start of an \
XML document. It has the syntax:"
}], "Text",
 CellID->21051],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Declaration\>\"", "]"}], 
  "[", 
  RowBox[{
   RowBox[{"\"\<Version\>\"", " ", "->", " ", "\"\<1.0\>\""}], ",", " ", 
   RowBox[{
    StyleBox["option", "TI"], " ", "->", " ", 
    StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->1570],

Cell["There are two options allowed.", "Text",
 CellID->8636]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<Standalone\>\""], "InlineFormula"],
 "\[LongDash]takes the value ",
 Cell[BoxData["\"\<yes\>\""], "InlineFormula"],
 " if the document references an external DTD and ",
 Cell[BoxData["\"\<no\>\""], "InlineFormula"],
 " otherwise."
}], "BulletedText",
 CellID->9458],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData["\"\<Encoding\>\""], "InlineFormula"],
 "\[LongDash]specifies the character encoding used in the document. Not all \
encodings will be honored on export. If an encoding that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot export is specified, an error message is produced and the encoding \
is changed in the document."
}], "BulletedText",
 CellID->25967],

Cell["Here is a typical XML declaration.", "Text",
 CellID->8456]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<?xml version=\"1.0\" encoding=\"ascii\" \
standalone=\"yes\"?>", "MR"]], "IndentedText",
 CellID->9405],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->11531]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Declaration\>\"", "]"}], 
  "[", 
  RowBox[{
   RowBox[{"\"\<Version\>\"", "->", "\"\<1.0\>\""}], ",", " ", 
   RowBox[{"\"\<Encoding\>\"", "->", 
    RowBox[{
     RowBox[{"\"\<\!\(\*
StyleBox[\"ascii\", \"MR\"]\)\>\"", " ", "\"\<Standalone\>\""}], "->", 
     "\"\<Yes\>\""}]}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->29962]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comment", "Subsubsection",
 CellID->26819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Comment\>\"", "]"}]], 
  "InlineFormula"],
 " represents XML comments. It has the syntax: "
}], "Text",
 CellID->7975],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Comment\>\"", "]"}], "[", 
  StyleBox["string", "TI"], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->10556],

Cell["Here is an example of an XML comment.", "Text",
 CellID->7531]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<!-- Created on 3/6/02. -->", "MR"]], "IndentedText",
 CellID->31495],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->8044]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Comment\>\"", "]"}], "[", 
  "\"\<Created on 3/6/02.\>\"", "]"}]], "InlineFormula"]], "IndentedText",
 CellID->30591]
}, Open  ]],

Cell[CellGroupData[{

Cell["Document", "Subsubsection",
 CellID->26803],

Cell[TextData[{
 "The most important ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Document\>\"", "]"}]], 
  "InlineFormula"],
 ". It is used as a container for the entire document and has ",
 "the syntax: "
}], "Text",
 CellID->3388],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Document\>\"", "]"}], "[", 
  
  RowBox[{
   RowBox[{"{", 
    StyleBox["prolog", "TI"], "}"}], ",", " ", 
   RowBox[{
    StyleBox["document", "TI"], " ", 
    StyleBox["tree", "TI"]}], ",", " ", 
   RowBox[{"{", 
    StyleBox["epilog", "TI"], "}"}]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->18915],

Cell[TextData[{
 "The prolog may contain an ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Declaration\>\"", "]"}]], 
  "InlineFormula"],
 ", followed by optional processing instructions and DTD declarations. The \
epilog contains either processing instructions or comments."
}], "Text",
 CellID->7450],

Cell["\<\
Here is an example of a simple document consisting of an XML declaration, a \
comment, and a single element. \
\>", "Text",
 CellID->12319]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<?xml version='1.0'?>\n<!--this is a sample file-->\n\
<root/>", "MR"]], "IndentedText",
 CellID->6272],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->25791]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Document\>\"", "]"}], "[", 
  
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       ButtonBox["XMLObject",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Declaration\>\"", 
       "]"}], "[", 
      RowBox[{"\"\<Version\>\"", "->", "\"\<1.0\>\""}], "]"}], ",", 
     RowBox[{
      RowBox[{
       ButtonBox["XMLObject",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Comment\>\"", "]"}], 
      "[", "\"\<\!\(\*
StyleBox[\"this\", \"MR\"]\)\!\(\*
StyleBox[\" \", \"MR\"]\)\!\(\*
StyleBox[\"is\", \"MR\"]\)\!\(\*
StyleBox[\" \", \"MR\"]\)\!\(\*
StyleBox[\"a\", \"MR\"]\)\!\(\*
StyleBox[\" \", \"MR\"]\)\!\(\*
StyleBox[\"sample\", \"MR\"]\)\!\(\*
StyleBox[\" \", \"MR\"]\)\!\(\*
StyleBox[\"file\", \"MR\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"MR\"]\)\>", "]"}]}], "}"}], ",", 
   RowBox[{
    ButtonBox["XMLElement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/XMLElement"], "[", 
    RowBox[{
     StyleBox["\"\<root\>\"", "MR"], ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->29383],

Cell[TextData[{
 "The only option for ",
 StyleBox["XMLObject[\"Document\"]",
  FontFamily->"Courier"],
 " is ",
 StyleBox["\"Valid\"",
  FontFamily->"Courier"],
 ". This option is set automatically by the parser. If the document was \
validated on import and validation succeeded, then ",
 StyleBox["\"Valid\"\[Rule]True",
  FontFamily->"Courier"],
 " will be included in the ",
 StyleBox["XMLObject",
  FontFamily->"Courier"],
 " expression. If validation was attempted but failed, then ",
 StyleBox["\"Valid\"\[Rule]False",
  FontFamily->"Courier"],
 " will be included. If validation was not attempted, the option ",
 StyleBox["\"Valid\"",
  FontFamily->"Courier"],
 " is omitted."
}], "Text",
 CellID->10133]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Doctype", "Subsubsection",
 CellID->1775],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Doctype\>\"", "]"}]], 
  "InlineFormula"],
 " expression represents XML document type declarations. It has ",
 "the syntax: "
}], "Text",
 CellID->24642],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Doctype\>\"", "]"}], "[", 
  RowBox[{
   StyleBox["name", "TI"], ",", " ", 
   RowBox[{
    StyleBox["option", "TI"], " ", "->", " ", 
    StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"]], "IndentedText",
 CellID->23569],

Cell["There are three options allowed.", "Text",
 CellID->18300]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["\"\<System\>\""], "InlineFormula"],
 "\[LongDash]specifies a DTD in the local file system, either as a relative \
pathname or a URI."
}], "BulletedText",
 CellID->17954],

Cell[TextData[{
 Cell[BoxData["\"\<Public\>\""], "InlineFormula"],
 "\[LongDash]specifies a standardized name that is used to publicly identify \
the DTD."
}], "BulletedText",
 CellID->12078],

Cell[CellGroupData[{

Cell[TextData[{
 Cell[BoxData["\"\<Internal\>\""], "InlineFormula"],
 "\[LongDash]specifies an internal DTD subset. Its value is a string that \
contains the data in the internal DTD subset."
}], "BulletedText",
 CellID->3585],

Cell["\<\
Here is a Doctype declaration that has both a formalized public identifier \
name and a specific location for the DTD along with an internal DTD subset.\
\>", "Text",
 CellID->2257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox["<!DOCTYPE catalog PUBLIC \"-//FOO//DTD catalog 1.1//EN\" \
\"www.foo.com/example/catalog.dtd\"\n   [", "MR"],
 StyleBox["internal DTD stuff", "TI"],
 StyleBox["]>", "MR"]
}], "IndentedText",
 CellID->25333],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<Doctype\>\"", "]"}], "[", 
  RowBox[{
   StyleBox["\"\<catalog\>\"", "MR"], ",", " ", 
   RowBox[{"\"\<Public\>\"", "->", "\"\<-//FOO//DTD catalog 1.1//EN\>\""}], 
   ",", " ", 
   RowBox[{"\"\<System\>\"", "->", 
    StyleBox["\"\<www.foo.com/example/catalog.dtd\>\"", "MR"]}], ",", " ", 
   RowBox[{"\"\<InternalSubset\>\"", "->", "\"\<\!\(\*
StyleBox[\"internal\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"DTD\", \"TI\"]\)\!\(\*
StyleBox[\" \", \"TI\"]\)\!\(\*
StyleBox[\"stuff\", \"TI\"]\)\>\""}]}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->10490],

Cell[TextData[{
 "For more details on XML ",
 "Doctype declarations, see the ",
 ButtonBox["W3C XML specification",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://www.w3.org/TR/REC-xml#NT-doctypedecl"], None}],
 ". "
}], "Text",
 CellID->10103]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProcessingInstruction", "Subsubsection",
 CellID->4750],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<ProcessingInstruction\>\"",
    "]"}]], "InlineFormula"],
 " represents XML processing instructions. It has ",
 "the syntax: "
}], "Text",
 CellID->17233],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    ButtonBox["XMLObject",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/XMLObject"], "[", 
    "\"\<ProcessingInstruction\>\"", "]"}], "[", 
   RowBox[{
    RowBox[{
     StyleBox["target", "TI"], " ", 
     StyleBox["string", "TI"]}], ",", " ", 
    RowBox[{
     StyleBox["optional", "TI"], " ", 
     StyleBox["data", "TI"], " ", 
     StyleBox["string", "TI"]}]}], "]"}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->10722],

Cell["\<\
It is common to use attribute-like syntax in processing instructions. These \
pseudo-attributes are not parsed but are returned as raw strings. Here is a \
processing instruction that specifies a stylesheet.\
\>", "Text",
 CellID->24271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<?xml-stylesheet href=\"mystyle.css\" type=\"text/css\
\"?>", "MR"]], "IndentedText",
 CellID->19611],

Cell["\<\
Here is the corresponding symbolic XML expression. The double quotes around \
the attribute values are escaped, to distinguish them from the double quotes \
around the argument as a whole. \
\>", "Text",
 CellID->18990]
}, Open  ]],

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<ProcessingInstruction\>\"",
    "]"}], "[", 
  RowBox[{
  "\"\<xml-stylesheet\>\"", ",", 
   "\"\<href=\\\"mystyle.css\\\" type=\\\"text/css\\\"\>\""}], 
  "]"}]], "InlineFormula"]], "IndentedText",
 CellID->30338]
}, Open  ]],

Cell[CellGroupData[{

Cell["CDATASection", "Subsubsection",
 CellID->21641],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<CDATASection\>\"", "]"}]], 
  "InlineFormula"],
 " represents CDATA sections. CDATA is a W3C abbreviation for \"character \
data\". CDATA sections are used in an XML document as a wrapper for raw \
character data to avoid having to escape special characters such as ",
 StyleBox["\"", "MR"],
 " and ",
 StyleBox["<", "MR"],
 ". (These characters would normally have to be indicated as ",
 StyleBox["&quote;", "MR"],
 " and ",
 StyleBox["&lt;", "MR"],
 ".) CDATA sections are used in XML to enclose character data that would \
require a lot of escaping, such as programs or math expressions. "
}], "Text",
 CellID->23258],

Cell["\<\
Here is a simple fragment from an XML document containing a CDATA section. \
\>", "Text",
 CellID->19047],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<![CDATA[ 5 < 7 << 2*10^123]]>", "MR"]], \
"IndentedText",
 CellID->2352],

Cell["Here is the corresponding symbolic XML expression.", "Text",
 CellID->9658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 RowBox[{
  RowBox[{
   ButtonBox["XMLObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/XMLObject"], "[", "\"\<CDATASection\>\"", "]"}], 
  "[", "\"\< 5 < 7 << 2*10^123\>\"", "]"}]], "InlineFormula"]], "IndentedText",\

 CellID->479],

Cell[TextData[{
 "By default, CDATASection object wrappers are not preserved on import; only \
the contents of the CDATA section are retained. To preserve the CDATASection \
wrappers, you must explicitly set the option ",
 Cell[BoxData[
  RowBox[{"\"\<PreserveCDATASections\>\"", " ", "->", " ", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->25302]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->485902228],

Cell[TextData[ButtonBox["XML Capabilities",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/Overview"]], "RelatedTutorials",
 CellID->1866278227],

Cell[TextData[ButtonBox["Importing XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ImportingXML"]], "RelatedTutorials",
 CellID->296442083],

Cell[TextData[ButtonBox["Exporting XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/ExportingXML"]], "RelatedTutorials",
 CellID->523248764],

Cell[TextData[ButtonBox["Transforming XML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/TransformingXML"]], "RelatedTutorials",
 CellID->616508677],

Cell[TextData[ButtonBox["MathML",
 BaseStyle->"Link",
 ButtonData->"paclet:XML/tutorial/MathML"]], "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Representing XML in Mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 14, 46.2656500}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "XML Package Tutorial", 
    "language" -> "en", "paclet" -> "XML Package", "status" -> "None", 
    "summary" -> 
    "Mathematica 4.2 and later includes comprehensive support for XML, the \
meta-markup language developed by the World Wide Web Consortium (W3C) for \
describing structured documents and data. Using the new XML features \
introduced in Version 4.2, you can do any of the following: These features \
make Mathematica a powerful development environment for creating and \
processing XML documents. They ensure complete interoperability between \
Mathematica and other XML applications, and between notebooks and other XML \
document formats. Mathematica has built-in support for many XML formats, \
including MathML, SVG, ExpressionML, JVX, X3D, VRML, and XHTML. If you import \
a document in any of these formats, it is automatically converted into a \
specific type of Mathematica expression. An ExpressionML file is imported as \
a cell expression. A MathML file is returned as a box expression.", 
    "synonyms" -> {}, "title" -> "Representing XML in Mathematica", "type" -> 
    "Tutorial", "uri" -> "XML/tutorial/RepresentingXML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1120, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1745, 52, 139, 6, 70, "Title",
 PageBreakAbove->True,
 CellID->8329],
Cell[CellGroupData[{
Cell[1909, 62, 107, 5, 70, "Section",
 CellID->16290],
Cell[2019, 69, 571, 16, 70, "Text",
 CellID->22974],
Cell[2593, 87, 232, 9, 70, "BulletedText",
 CellID->23072],
Cell[2828, 98, 271, 8, 70, "BulletedText",
 CellID->3591],
Cell[3102, 108, 152, 4, 70, "BulletedText",
 CellID->12189],
Cell[CellGroupData[{
Cell[3279, 116, 147, 4, 70, "BulletedText",
 CellID->15787],
Cell[3429, 122, 387, 11, 70, "Text",
 CellID->31490]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3865, 139, 52, 1, 70, "Section",
 CellID->3239],
Cell[3920, 142, 492, 13, 70, "Text",
 CellID->14893],
Cell[CellGroupData[{
Cell[4437, 159, 91, 2, 70, "Subsection",
 CellID->3053],
Cell[4531, 163, 651, 14, 70, "Text",
 CellID->17063],
Cell[5185, 179, 601, 16, 70, "Text",
 CellID->10681]
}, Open  ]],
Cell[CellGroupData[{
Cell[5823, 200, 41, 1, 70, "Subsection",
 CellID->25903],
Cell[5867, 203, 549, 11, 70, "Text",
 CellID->27005]
}, Open  ]],
Cell[CellGroupData[{
Cell[6453, 219, 50, 1, 70, "Subsection",
 CellID->24176],
Cell[6506, 222, 171, 6, 70, "Text",
 CellID->18479]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6726, 234, 46, 1, 70, "Section",
 CellID->1695],
Cell[CellGroupData[{
Cell[6797, 239, 58, 1, 70, "Subsection",
 CellID->6139],
Cell[6858, 242, 673, 19, 70, "Text",
 CellID->32468],
Cell[7534, 263, 605, 18, 70, "Text",
 CellID->13998],
Cell[8142, 283, 156, 6, 70, "Text",
 CellID->21083],
Cell[CellGroupData[{
Cell[8323, 293, 337, 11, 70, "IndentedText",
 CellID->23639],
Cell[8663, 306, 373, 12, 70, "Text",
 CellID->29515]
}, Open  ]],
Cell[CellGroupData[{
Cell[9073, 323, 183, 5, 70, "IndentedText",
 CellID->27621],
Cell[9259, 330, 185, 6, 70, "Text",
 CellID->29993]
}, Open  ]],
Cell[CellGroupData[{
Cell[9481, 341, 374, 12, 70, "IndentedText",
 CellID->15826],
Cell[9858, 355, 151, 4, 70, "Text",
 CellID->15722],
Cell[10012, 361, 783, 18, 70, "Text",
 CellID->23838],
Cell[10798, 381, 767, 16, 70, "Text",
 CellID->24828],
Cell[11568, 399, 736, 14, 70, "Text",
 CellID->12581],
Cell[12307, 415, 720, 21, 70, "Text",
 CellID->24399]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13076, 442, 58, 1, 70, "Subsection",
 CellID->8978],
Cell[13137, 445, 279, 8, 70, "Text",
 CellID->11891],
Cell[CellGroupData[{
Cell[13441, 457, 321, 13, 70, "IndentedText",
 CellID->1023],
Cell[13765, 472, 81, 1, 70, "Text",
 CellID->26943]
}, Open  ]],
Cell[CellGroupData[{
Cell[13883, 478, 410, 14, 70, "IndentedText",
 CellID->24834],
Cell[14296, 494, 238, 9, 70, "Text",
 CellID->14243]
}, Open  ]],
Cell[14549, 506, 92, 1, 70, "BulletedText",
 CellID->7349],
Cell[14644, 509, 340, 10, 70, "BulletedText",
 CellID->2702],
Cell[CellGroupData[{
Cell[15009, 523, 737, 19, 70, "BulletedText",
 CellID->8707],
Cell[15749, 544, 377, 8, 70, "Text",
 CellID->20502],
Cell[16129, 554, 62, 1, 70, "Text",
 CellID->25141]
}, Open  ]],
Cell[CellGroupData[{
Cell[16228, 560, 103, 2, 70, "IndentedText",
 CellID->10687],
Cell[16334, 564, 91, 1, 70, "Text",
 CellID->8346]
}, Open  ]],
Cell[CellGroupData[{
Cell[16462, 570, 419, 13, 70, "IndentedText",
 CellID->15891],
Cell[16884, 585, 119, 4, 70, "Text",
 CellID->24637]
}, Open  ]],
Cell[CellGroupData[{
Cell[17040, 594, 247, 4, 70, "IndentedText",
 CellID->18413],
Cell[17290, 600, 82, 1, 70, "Text",
 CellID->11400]
}, Open  ]],
Cell[17387, 604, 2583, 74, 70, "IndentedText",
 CellID->22816]
}, Open  ]],
Cell[CellGroupData[{
Cell[20007, 683, 57, 1, 70, "Subsection",
 CellID->31690],
Cell[20067, 686, 314, 6, 70, "Text",
 CellID->13162],
Cell[CellGroupData[{
Cell[20406, 696, 65, 1, 70, "Subsubsection",
 CellID->8935],
Cell[20474, 699, 526, 14, 70, "Text",
 CellID->29126],
Cell[21003, 715, 160, 5, 70, "Text",
 CellID->19410],
Cell[CellGroupData[{
Cell[21188, 724, 197, 3, 70, "IndentedText",
 CellID->19877],
Cell[21388, 729, 83, 1, 70, "Text",
 CellID->11382]
}, Open  ]],
Cell[CellGroupData[{
Cell[21508, 735, 1678, 52, 70, "IndentedText",
 CellID->26260],
Cell[23189, 789, 275, 8, 70, "Text",
 CellID->27189]
}, Open  ]],
Cell[CellGroupData[{
Cell[23501, 802, 323, 9, 70, "IndentedText",
 CellID->26705],
Cell[23827, 813, 47, 1, 70, "Text",
 CellID->13874]
}, Open  ]],
Cell[23889, 817, 282, 9, 70, "BulletedText",
 CellID->2663],
Cell[CellGroupData[{
Cell[24196, 830, 222, 7, 70, "BulletedText",
 CellID->20722],
Cell[24421, 839, 285, 9, 70, "Text",
 CellID->32195]
}, Open  ]],
Cell[CellGroupData[{
Cell[24743, 853, 656, 22, 70, "IndentedText",
 CellID->22566],
Cell[25402, 877, 307, 11, 70, "Text",
 CellID->16360]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25758, 894, 74, 1, 70, "Subsubsection",
 CellID->6038],
Cell[25835, 897, 215, 5, 70, "Text",
 CellID->18588],
Cell[26053, 904, 381, 10, 70, "Text",
 CellID->7811],
Cell[CellGroupData[{
Cell[26459, 918, 437, 6, 70, "IndentedText",
 CellID->28245],
Cell[26899, 926, 82, 1, 70, "Text",
 CellID->9467]
}, Open  ]],
Cell[CellGroupData[{
Cell[27018, 932, 4970, 130, 70, "IndentedText",
 CellID->32425],
Cell[31991, 1064, 68, 1, 70, "Text",
 CellID->26867]
}, Open  ]],
Cell[32074, 1068, 447, 13, 70, "BulletedText",
 CellID->13189],
Cell[32524, 1083, 665, 20, 70, "BulletedText",
 CellID->10542]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33238, 1109, 64, 1, 70, "Subsection",
 CellID->13063],
Cell[33305, 1112, 959, 25, 70, "Text",
 CellID->21547],
Cell[34267, 1139, 102, 2, 70, "BulletedText",
 CellID->30502],
Cell[34372, 1143, 98, 2, 70, "BulletedText",
 CellID->29617],
Cell[34473, 1147, 98, 2, 70, "BulletedText",
 CellID->9099],
Cell[34574, 1151, 98, 2, 70, "BulletedText",
 CellID->25023],
Cell[34675, 1155, 112, 2, 70, "BulletedText",
 CellID->17226],
Cell[34790, 1159, 103, 2, 70, "BulletedText",
 CellID->31203],
Cell[CellGroupData[{
Cell[34918, 1165, 52, 1, 70, "Subsubsection",
 CellID->30048],
Cell[34973, 1168, 328, 10, 70, "Text",
 CellID->21051],
Cell[CellGroupData[{
Cell[35326, 1182, 417, 12, 70, "IndentedText",
 CellID->1570],
Cell[35746, 1196, 61, 1, 70, "Text",
 CellID->8636]
}, Open  ]],
Cell[35822, 1200, 300, 8, 70, "BulletedText",
 CellID->9458],
Cell[CellGroupData[{
Cell[36147, 1212, 399, 9, 70, "BulletedText",
 CellID->25967],
Cell[36549, 1223, 65, 1, 70, "Text",
 CellID->8456]
}, Open  ]],
Cell[CellGroupData[{
Cell[36651, 1229, 128, 2, 70, "IndentedText",
 CellID->9405],
Cell[36782, 1233, 82, 1, 70, "Text",
 CellID->11531]
}, Open  ]],
Cell[36879, 1237, 490, 14, 70, "IndentedText",
 CellID->29962]
}, Open  ]],
Cell[CellGroupData[{
Cell[37406, 1256, 48, 1, 70, "Subsubsection",
 CellID->26819],
Cell[37457, 1259, 260, 9, 70, "Text",
 CellID->7975],
Cell[CellGroupData[{
Cell[37742, 1272, 262, 7, 70, "IndentedText",
 CellID->10556],
Cell[38007, 1281, 68, 1, 70, "Text",
 CellID->7531]
}, Open  ]],
Cell[CellGroupData[{
Cell[38112, 1287, 93, 1, 70, "IndentedText",
 CellID->31495],
Cell[38208, 1290, 81, 1, 70, "Text",
 CellID->8044]
}, Open  ]],
Cell[38304, 1294, 266, 7, 70, "IndentedText",
 CellID->30591]
}, Open  ]],
Cell[CellGroupData[{
Cell[38607, 1306, 49, 1, 70, "Subsubsection",
 CellID->26803],
Cell[38659, 1309, 447, 16, 70, "Text",
 CellID->3388],
Cell[CellGroupData[{
Cell[39131, 1329, 464, 16, 70, "IndentedText",
 CellID->18915],
Cell[39598, 1347, 384, 11, 70, "Text",
 CellID->7450],
Cell[39985, 1360, 149, 4, 70, "Text",
 CellID->12319]
}, Open  ]],
Cell[CellGroupData[{
Cell[40171, 1369, 127, 2, 70, "IndentedText",
 CellID->6272],
Cell[40301, 1373, 82, 1, 70, "Text",
 CellID->25791]
}, Open  ]],
Cell[CellGroupData[{
Cell[40420, 1379, 1338, 42, 70, "IndentedText",
 CellID->29383],
Cell[41761, 1423, 713, 22, 70, "Text",
 CellID->10133]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42523, 1451, 47, 1, 70, "Subsubsection",
 CellID->1775],
Cell[42573, 1454, 304, 11, 70, "Text",
 CellID->24642],
Cell[CellGroupData[{
Cell[42902, 1469, 375, 11, 70, "IndentedText",
 CellID->23569],
Cell[43280, 1482, 64, 1, 70, "Text",
 CellID->18300]
}, Open  ]],
Cell[43359, 1486, 200, 5, 70, "BulletedText",
 CellID->17954],
Cell[43562, 1493, 191, 5, 70, "BulletedText",
 CellID->12078],
Cell[CellGroupData[{
Cell[43778, 1502, 226, 5, 70, "BulletedText",
 CellID->3585],
Cell[44007, 1509, 191, 4, 70, "Text",
 CellID->2257]
}, Open  ]],
Cell[CellGroupData[{
Cell[44235, 1518, 233, 6, 70, "IndentedText",
 CellID->25333],
Cell[44471, 1526, 80, 1, 70, "Text",
 CellID->893]
}, Open  ]],
Cell[CellGroupData[{
Cell[44588, 1532, 732, 19, 70, "IndentedText",
 CellID->10490],
Cell[45323, 1553, 255, 9, 70, "Text",
 CellID->10103]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45627, 1568, 61, 1, 70, "Subsubsection",
 CellID->4750],
Cell[45691, 1571, 296, 10, 70, "Text",
 CellID->17233],
Cell[CellGroupData[{
Cell[46012, 1585, 506, 17, 70, "IndentedText",
 CellID->10722],
Cell[46521, 1604, 247, 5, 70, "Text",
 CellID->24271]
}, Open  ]],
Cell[CellGroupData[{
Cell[46805, 1614, 125, 2, 70, "IndentedText",
 CellID->19611],
Cell[46933, 1618, 229, 5, 70, "Text",
 CellID->18990]
}, Open  ]],
Cell[47177, 1626, 363, 11, 70, "IndentedText",
 CellID->30338]
}, Open  ]],
Cell[CellGroupData[{
Cell[47577, 1642, 53, 1, 70, "Subsubsection",
 CellID->21641],
Cell[47633, 1645, 762, 20, 70, "Text",
 CellID->23258],
Cell[48398, 1667, 115, 3, 70, "Text",
 CellID->19047],
Cell[CellGroupData[{
Cell[48538, 1674, 97, 2, 70, "IndentedText",
 CellID->2352],
Cell[48638, 1678, 81, 1, 70, "Text",
 CellID->9658]
}, Open  ]],
Cell[CellGroupData[{
Cell[48756, 1684, 271, 8, 70, "IndentedText",
 CellID->479],
Cell[49030, 1694, 431, 11, 70, "Text",
 CellID->25302]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49510, 1711, 72, 1, 70, "RelatedTutorialsSection",
 CellID->485902228],
Cell[49585, 1714, 151, 3, 70, "RelatedTutorials",
 CellID->1866278227],
Cell[49739, 1719, 151, 3, 70, "RelatedTutorials",
 CellID->296442083],
Cell[49893, 1724, 151, 3, 70, "RelatedTutorials",
 CellID->523248764],
Cell[50047, 1729, 157, 3, 70, "RelatedTutorials",
 CellID->616508677],
Cell[50207, 1734, 138, 3, 70, "RelatedTutorials",
 CellID->140027941]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[50396, 1743, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

