(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8113,        281]
NotebookOptionsPosition[      5058,        194]
NotebookOutlinePosition[      6566,        230]
CellTagsIndexPosition[      6523,        227]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Accessibility", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " not only fits into standard accessibility frameworks, but also provides \
its own highly flexible interface accessibility options."
}], "GuideAbstract",
 CellID->384768453],

Cell[TextData[{
 Cell[TextData[ButtonBox["Magnification",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Magnification"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "change overall notebook magnification"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->93731475],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScriptSizeMultipliers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "control size reduction for subscripts, etc."
}], "GuideText",
 CellID->295957456],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScriptMinSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ScriptMinSize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify minimum sizes for subscripts, etc."
}], "GuideText",
 CellID->19042901],

Cell["\t", "GuideDelimiter",
 CellID->137391183],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "control image sizes for graphics, etc."
}], "GuideText",
 CellID->221048139],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSizeAction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ImageSizeAction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "specify how images should automatically be resized"
}], "GuideText",
 CellID->723844879],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " change syntax coloring schemes"
}], "GuideText",
 CellID->321882812],

Cell[TextData[{
 Cell[TextData[ButtonBox["DelimiterFlashTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DelimiterFlashTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShowCursorTracker",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowCursorTracker"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19638620],

Cell["\t", "GuideDelimiterSubsection",
 CellID->266293403],

Cell[CellGroupData[{

Cell["Left-Handed Mouse Configuration", "GuideFunctionsSubsection",
 CellID->380234206],

Cell[TextData[{
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Delete", "KeyEvent"],
 ", ",
 StyleBox["Control", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Insert", "KeyEvent"],
 ", ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Insert", "KeyEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " cut, copy, paste"
}], "GuideText",
 CellID->309028365]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "GuideTutorial",
 CellID->200432721]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Stylesheets & Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Accessibility - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 29, 55.6687072}", "context" -> "", 
    "keywords" -> {
     "blob", "cursor tracker", "delimiter flash time", "elliptical blob", 
      "eye motion", "flashing", "flashing blob", "gaze", "graphics size", 
      "image size", "image size action", "jumping", "matching", 
      "picture size", "readability", "resize image", "script min size", 
      "script size multipliers", "\\scriptscriptstyle (TeX)", 
      "\\scriptstyle (TeX)", "show cursor tracker", "shrink image", 
      "tracker"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica not only fits into standard accessibility frameworks, but \
also provides its own highly flexible interface accessibility options.", 
    "synonyms" -> {}, "title" -> "Accessibility", "type" -> "Guide", "uri" -> 
    "guide/Accessibility"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[677, 28, 240, 6, 70, "GuideAbstract",
 CellID->384768453],
Cell[920, 36, 277, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1200, 47, 47, 1, 70, "GuideDelimiter",
 CellID->93731475],
Cell[1250, 50, 298, 9, 70, "GuideText",
 CellID->295957456],
Cell[1551, 61, 280, 9, 70, "GuideText",
 CellID->19042901],
Cell[1834, 72, 48, 1, 70, "GuideDelimiter",
 CellID->137391183],
Cell[1885, 75, 269, 9, 70, "GuideText",
 CellID->221048139],
Cell[2157, 86, 438, 12, 70, "GuideText",
 CellID->723844879],
Cell[2598, 100, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2649, 103, 253, 8, 70, "GuideText",
 CellID->321882812],
Cell[2905, 113, 433, 11, 70, "InlineGuideFunctionListing",
 CellID->19638620],
Cell[3341, 126, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->266293403],
Cell[CellGroupData[{
Cell[3424, 131, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->380234206],
Cell[3514, 134, 442, 16, 70, "GuideText",
 CellID->309028365]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4005, 156, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4070, 159, 159, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[4232, 164, 152, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[4387, 169, 195, 4, 70, "GuideTutorial",
 CellID->200432721]
}, Open  ]],
Cell[CellGroupData[{
Cell[4619, 178, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4684, 181, 156, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[4843, 186, 173, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[5031, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

