(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15793,        446]
NotebookOptionsPosition[     11258,        337]
NotebookOutlinePosition[     14041,        391]
CellTagsIndexPosition[     13998,        388]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Algebraic Number Theory", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "With its convenient symbolic representation of algebraic numbers, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s state-of-the-art algebraic number theory capabilities provide a concrete \
implementation of one of the historically richest areas of pure mathematics\
\[LongDash]all tightly integrated with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s powerful unified environment."
}], "GuideAbstract",
 CellID->497353655],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "algebraic number represented in a particular field"
}], "GuideText",
 CellID->58965563],

Cell[TextData[{
 Cell[TextData[ButtonBox["MinimalPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicNumberPolynomial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberPolynomial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->104618754],

Cell["\t", "GuideDelimiter",
 CellID->316235904],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicIntegerQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicIntegerQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicUnitQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicUnitQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RootOfUnityQ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RootOfUnityQ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->161599357],

Cell[TextData[{
 Cell[TextData[ButtonBox["AlgebraicNumberNorm",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberNorm"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicNumberTrace",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberTrace"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlgebraicNumberDenominator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlgebraicNumberDenominator"]], "InlineFunctionSans",
  
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->193149516],

Cell["\t", "GuideDelimiter",
 CellID->24430705],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToNumberField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ToNumberField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a common field, or express numbers in a given field"
}], "GuideText",
 CellID->200881714],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberFieldIntegralBasis",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldClassNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldClassNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldDiscriminant",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldRegulator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldRegulator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldSignature",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldSignature"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->136098769],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberFieldNormRepresentatives",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldNormRepresentatives"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldFundamentalUnits",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldFundamentalUnits"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberFieldRootsOfUnity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NumberFieldRootsOfUnity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->378076574],

Cell["\t", "GuideDelimiter",
 CellID->220292192],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extension",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extension"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "field extension for number theoretic and polynomial operations"
}], "GuideText",
 CellID->87316428],

Cell[TextData[{
 Cell[TextData[ButtonBox["RootReduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RootReduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce an algebraic number to minimal ",
 Cell[TextData[ButtonBox["Root",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Root"]], "InlineFunctionSans"],
 " form"
}], "GuideText",
 CellID->626661959],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToRadicals"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to explicit radicals"
}], "GuideText",
 CellID->704045765]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "GuideMoreAbout",
 CellID->464051363]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1468574705],

Cell[TextData[{
 ButtonBox["Demonstrations related to Algebraic Number Theory",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22algebraic+numbers%22+content%3AAlgebraicIntegerQ+OR+AlgebraicNumber+OR+\
AlgebraicNumberDenominator+OR+AlgebraicNumberNorm+OR+\
AlgebraicNumberPolynomial+OR+AlgebraicNumberTrace+OR+AlgebraicUnitQ+OR+\
Extension+OR+MinimalPolynomial+OR+NumberFieldClassNumber+OR+\
NumberFieldDiscriminant+OR+NumberFieldFundamentalUnits+OR+\
NumberFieldIntegralBasis+OR+NumberFieldNormRepresentatives+OR+\
NumberFieldRegulator+OR+NumberFieldRootsOfUnity+OR+NumberFieldSignature+OR+\
Root+OR+RootOfUnityQ+OR+RootReduce+OR+ToNumberField+OR+ToRadicals"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->226006021]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Number Theory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 29, 56.4968534}", "context" -> "", 
    "keywords" -> {
     "absolute value of algebraic number", "algebraic field", 
      "algebraic integer", "algebraic number", "AlgebraicNumber", 
      "algebraic number denominator", "algebraic number field", 
      "algebraic number invariant", "algebraic number norm", 
      "algebraic number polynomial", "algebraic number trace", 
      "algebraic number units", "algebraic rational", "algebraic unit", 
      "characteristic polynomial", "class number", "class field theory", 
      "Galois theory", "Collins-Krandick algorithm", "combining radicals", 
      "cyclotomic root", "Descartes rule of signs", "domain of coefficients", 
      "fundamental unit", "fundamental units", "generator", "integral basis", 
      "invariant", "minimal polynomial", "norm of algebraic number", 
      "norm representatives", "number field", "number field basis", 
      "number field class number", "number field discriminant", 
      "number field fundamental units", "number field integral basis", 
      "number field norm representatives", "number field regulator", 
      "number field roots of unity", "number field signature", 
      "number field unit", "polynomial", "primitive element", 
      "radical expression", "reducing radicals", "ring of integers", "root", 
      "RootOf", "root of polynomial", "root of unity", "root reduce", "roots",
       "roots of equations", "roots of unity", "signature of a number field", 
      "simplifying radicals", "smallest field", "to number field", 
      "to radicals", "trace", "unit"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "With its convenient symbolic representation of algebraic numbers, \
Mathematica's state-of-the-art algebraic number theory capabilities provide a \
concrete implementation of one of the historically richest areas of pure \
mathematics--all tightly integrated with Mathematica's powerful unified \
environment.", "synonyms" -> {}, "title" -> "Algebraic Number Theory", "type" -> 
    "Guide", "uri" -> "guide/AlgebraicNumberTheory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 460, 11, 70, "GuideAbstract",
 CellID->497353655],
Cell[1150, 41, 437, 12, 70, "GuideText",
 CellID->58965563],
Cell[1590, 55, 738, 17, 70, "InlineGuideFunctionListing",
 CellID->104618754],
Cell[2331, 74, 48, 1, 70, "GuideDelimiter",
 CellID->316235904],
Cell[2382, 77, 1077, 26, 70, "InlineGuideFunctionListing",
 CellID->161599357],
Cell[3462, 105, 1124, 27, 70, "InlineGuideFunctionListing",
 CellID->193149516],
Cell[4589, 134, 47, 1, 70, "GuideDelimiter",
 CellID->24430705],
Cell[4639, 137, 440, 12, 70, "GuideText",
 CellID->200881714],
Cell[5082, 151, 1883, 44, 70, "InlineGuideFunctionListing",
 CellID->136098769],
Cell[6968, 197, 1157, 28, 70, "InlineGuideFunctionListing",
 CellID->378076574],
Cell[8128, 227, 48, 1, 70, "GuideDelimiter",
 CellID->220292192],
Cell[8179, 230, 292, 9, 70, "GuideText",
 CellID->87316428],
Cell[8474, 241, 393, 13, 70, "GuideText",
 CellID->626661959],
Cell[8870, 256, 261, 9, 70, "GuideText",
 CellID->704045765]
}, Open  ]],
Cell[CellGroupData[{
Cell[9168, 270, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9233, 273, 152, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[9388, 278, 164, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[9589, 286, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9654, 289, 151, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9808, 294, 142, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9953, 299, 177, 3, 70, "GuideMoreAbout",
 CellID->464051363]
}, Open  ]],
Cell[CellGroupData[{
Cell[10167, 307, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1468574705],
Cell[10240, 310, 976, 22, 70, "GuideRelatedLinks",
 CellID->226006021]
}, Open  ]],
Cell[11231, 335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

