(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10493,        331]
NotebookOptionsPosition[      6449,        231]
NotebookOutlinePosition[      9142,        286]
CellTagsIndexPosition[      9099,        283]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Applying Functions to Lists", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Many computations are conveniently specified in terms of applying functions \
in parallel to many elements in a list. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a suite of elegant functional programming constructs for doing \
this. In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", mathematical functions are automatically taken to be \"listable\", so \
that they are always applied to every element in a list",
 ". "
}], "GuideAbstract",
 CellID->135780300],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " map a function over a list, at specified levels"
}], "GuideText",
 CellID->19172],

Cell[TextData[{
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["@@@",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 ") \[LongDash] apply a function to a list, at specified levels"
}], "GuideText",
 CellID->19864],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapIndexed",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapIndexed"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "map a function, including index information"
}], "GuideText",
 CellID->236506109],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "map a function at particular positions"
}], "GuideText",
 CellID->701727187],

Cell[TextData[{
 Cell[TextData[ButtonBox["Scan",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Scan"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "scan over every element of a list, applying a function"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FoldList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FoldList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "successively apply a function, \"folding in\" elements from a list"
}], "GuideText",
 CellID->473115285],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComposeList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComposeList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Outer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Outer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Inner",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Inner"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->474963498],

Cell[TextData[{
 Cell[TextData[ButtonBox["MapThread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapThread"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "map a function across corresponding elements in multiple lists"
}], "GuideText",
 CellID->21998484],

Cell["\t", "GuideDelimiter",
 CellID->40911053],

Cell[TextData[{
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "\"thread\" a function across lists that appear in its arguments"
}], "GuideText",
 CellID->454083869],

Cell[TextData[{
 Cell[TextData[ButtonBox["Listable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Listable"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " attribute for any function to automatically thread over lists"
}], "GuideText",
 CellID->125928067]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Applying Functions to Lists and Other Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"]], \
"GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "GuideTutorial",
 CellID->164773389],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Applying Functions to Lists - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 2.7001372}", "context" -> "", 
    "keywords" -> {
     "Accumulate (Version 1 function)", "applying functions", 
      "applying functions to elements of lists", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices", 
      "applying functions with multiple arguments", 
      "applying indexed functions", "automatic threading over lists", 
      "Cartesian products", "cascade", "compose list", 
      "composition of functions", "contraction of tensors", "cumulative sums",
       "direct products", "direct products of tensors", "divergence operator",
       "dyadic products", "exterior products", "fold list", 
      "functional composition", "generalized inner products", 
      "implementing listability", "inner product", 
      "Kronecker products of tensors", "levels", "map at", "map indexed", 
      "map thread", "matrices", "multivariate Map", 
      "numbered parts of expressions", "outer products", 
      "parallel form of Map", "prefix operation", "scalar product", 
      "simultaneous application", "tensor products", "tensors", "threadable", 
      "threading operations over equations", "threading over lists", 
      "tree walking", "walking through expressions", "wedge product", 
      "wrapping functions around elements of lists"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Many computations are conveniently specified in terms of applying \
functions in parallel to many elements in a list. Mathematica provides a \
suite of elegant functional programming constructs for doing this. In \
Mathematica, mathematical functions are automatically taken to be \
\"listable\", so that they are always applied to every element in a list. ", 
    "synonyms" -> {}, "title" -> "Applying Functions to Lists", "type" -> 
    "Guide", "uri" -> "guide/ApplyingFunctionsToLists"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 506, 13, 70, "GuideAbstract",
 CellID->135780300],
Cell[1200, 43, 379, 13, 70, "GuideText",
 CellID->19172],
Cell[1582, 58, 464, 14, 70, "GuideText",
 CellID->19864],
Cell[2049, 74, 276, 9, 70, "GuideText",
 CellID->236506109],
Cell[2328, 85, 261, 9, 70, "GuideText",
 CellID->701727187],
Cell[2592, 96, 276, 9, 70, "GuideText",
 CellID->1463276848],
Cell[2871, 107, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2922, 110, 295, 9, 70, "GuideText",
 CellID->473115285],
Cell[3220, 121, 1314, 35, 70, "InlineGuideFunctionListing",
 CellID->474963498],
Cell[4537, 158, 292, 9, 70, "GuideText",
 CellID->21998484],
Cell[4832, 169, 47, 1, 70, "GuideDelimiter",
 CellID->40911053],
Cell[4882, 172, 288, 9, 70, "GuideText",
 CellID->454083869],
Cell[5173, 183, 285, 8, 70, "GuideText",
 CellID->125928067]
}, Open  ]],
Cell[CellGroupData[{
Cell[5495, 196, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5560, 199, 216, 5, 70, "GuideTutorial",
 CellID->806871991],
Cell[5779, 206, 201, 4, 70, "GuideTutorial",
 CellID->164773389],
Cell[5983, 212, 161, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[6181, 220, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6246, 223, 161, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[6422, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

