(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10102,        344]
NotebookOptionsPosition[      6849,        253]
NotebookOutlinePosition[      8644,        293]
CellTagsIndexPosition[      8601,        290]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Arithmetic Functions", "GuideTitle",
 CellID->5447],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " immediately allows you to do arithmetic not only with individual numbers, \
but also with arbitrary lists or arrays\[LongDash]as well as symbolic and \
algebraic forms",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the latest platform-optimized algorithms to work with exact and \
approximate numbers up to billions of digits, as well as polynomials with \
millions of terms."
}], "GuideAbstract",
 CellID->6736786],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["+",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ") \[LongDash] addition of numbers, lists, arrays or symbolic expressions"
}], "GuideText",
 CellID->19912],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subtract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subtract"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["-",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subtract"]], "InlineFunctionSans"],
 ") \[LongDash] subtraction"
}], "GuideText",
 CellID->25667],

Cell[TextData[{
 Cell[TextData[ButtonBox["Times",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ") \[LongDash] multiplication, entered as a space, ",
 Cell[BoxData[
  FormBox["*", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox["\[Times]", TraditionalForm]], "InlineMath"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]*\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->26299],

Cell[TextData[{
 Cell[TextData[ButtonBox["Divide",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divide"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Divide"]], "InlineFunctionSans"],
 ") \[LongDash] division, also entered as ",
 Cell[BoxData[
  FormBox["\[Divide]", TraditionalForm]], "InlineMath"],
 " (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]div\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->17035],

Cell[TextData[{
 Cell[TextData[ButtonBox["Power",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["^",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Power"]], "InlineFunctionSans"],
 ") \[LongDash] power, entered as a superscript using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"]
}], "GuideText",
 CellID->9894],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sqrt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sqrt"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " square root, entered as ",
 Cell[BoxData[
  FormBox[
   SqrtBox["\[Placeholder]"], TraditionalForm]], "InlineMath"],
 " using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"]
}], "GuideText",
 CellID->28703],

Cell["\t", "GuideDelimiter",
 CellID->23811],

Cell[TextData[{
 Cell[TextData[ButtonBox["Total",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Total"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " total of elements in a list"
}], "GuideText",
 CellID->31322],

Cell[TextData[{
 Cell[TextData[ButtonBox["Mean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mean"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " mean of a list"
}], "GuideText",
 CellID->30333],

Cell[TextData[{
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " cumulative sums in a list"
}], "GuideText",
 CellID->17673],

Cell[TextData[{
 Cell[TextData[ButtonBox["Differences",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Differences"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " successive differences in a list"
}], "GuideText",
 CellID->4664]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->6868],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "GuideTutorial",
 CellID->25547],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "GuideTutorial",
 CellID->27644]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->32662],

Cell[TextData[ButtonBox["Polynomial Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "GuideMoreAboutSub",
 CellID->8723],

Cell[TextData[ButtonBox["Numerical Data and Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "GuideMoreAboutSub",
 CellID->9741],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "GuideMoreAboutSub",
 CellID->34129218]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1108619914],

Cell[TextData[{
 ButtonBox["Demonstrations related to Arithmetic Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Accumulate+OR+Differences+OR+Divide+OR+Mean+OR+Plus+OR+Power+OR+Sqrt+OR+\
Subtract+OR+Times+OR+Total)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->119305701]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arithmetic Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 3.2314008}", "context" -> "", 
    "keywords" -> {
     "addition", "asterisk", "average", "avg", "caret", "column sum", "cubed",
       "divide", "expectation", "expected value", "mean", "mixed fractions", 
      "multiply", "plus", "pow", "pow10", "pow2", "power", "power10", 
      "power2", "radic", "radical", "raise to a power", "reciprocal", "roots",
       "row sum", "sqrt", "sqt", "squared", "square root", "square roots", 
      "subtract", "sum of array elements", "sum of list", "surd", 
      "total of list", "uparrow", "tally"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica immediately allows you to do arithmetic not only with \
individual numbers, but also with arbitrary lists or arrays--as well as \
symbolic and algebraic forms. Mathematica uses the latest platform-optimized \
algorithms to work with exact and approximate numbers up to billions of \
digits, as well as polynomials with millions of terms.", "synonyms" -> {}, 
    "title" -> "Arithmetic Functions", "type" -> "Guide", "uri" -> 
    "guide/ArithmeticFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->5447],
Cell[679, 28, 502, 13, 70, "GuideAbstract",
 CellID->6736786],
Cell[1184, 43, 352, 10, 70, "GuideText",
 CellID->19912],
Cell[1539, 55, 317, 10, 70, "GuideText",
 CellID->25667],
Cell[1859, 67, 611, 20, 70, "GuideText",
 CellID->26299],
Cell[2473, 89, 527, 17, 70, "GuideText",
 CellID->17035],
Cell[3003, 108, 430, 13, 70, "GuideText",
 CellID->9894],
Cell[3436, 123, 434, 15, 70, "GuideText",
 CellID->28703],
Cell[3873, 140, 44, 1, 70, "GuideDelimiter",
 CellID->23811],
Cell[3920, 143, 241, 8, 70, "GuideText",
 CellID->31322],
Cell[4164, 153, 226, 8, 70, "GuideText",
 CellID->30333],
Cell[4393, 163, 394, 11, 70, "GuideText",
 CellID->17673],
Cell[4790, 176, 402, 11, 70, "GuideText",
 CellID->4664]
}, Open  ]],
Cell[CellGroupData[{
Cell[5229, 192, 57, 1, 70, "GuideTutorialsSection",
 CellID->6868],
Cell[5289, 195, 135, 3, 70, "GuideTutorial",
 CellID->25547],
Cell[5427, 200, 167, 3, 70, "GuideTutorial",
 CellID->27644]
}, Open  ]],
Cell[CellGroupData[{
Cell[5631, 208, 59, 1, 70, "GuideMoreAboutSection",
 CellID->32662],
Cell[5693, 211, 157, 3, 70, "GuideMoreAboutSub",
 CellID->8723],
Cell[5853, 216, 153, 3, 70, "GuideMoreAboutSub",
 CellID->9741],
Cell[6009, 221, 144, 3, 70, "GuideMoreAboutSub",
 CellID->34129218]
}, Open  ]],
Cell[CellGroupData[{
Cell[6190, 229, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1108619914],
Cell[6263, 232, 544, 16, 70, "GuideRelatedLinks",
 CellID->119305701]
}, Open  ]],
Cell[6822, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

