(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22392,        798]
NotebookOptionsPosition[     16799,        652]
NotebookOutlinePosition[     19372,        703]
CellTagsIndexPosition[     19329,        700]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Assignments", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture supports a highly generalized notion of \
assignment, in which you can specify a transformation for any class of \
expressions defined by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " pattern. Simple cases correspond to assignments for \"variables\", \
\"indexed variables\" or \"structure elements\"",
 ". ",
 "Other cases define functions or general transformations."
}], "GuideAbstract",
 CellID->774521997],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["v",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " assign a value (",
 Cell[TextData[ButtonBox["Set",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Set"]], "InlineFunctionSans"],
 ")"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox[",",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["y",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["u",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox[",",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["v",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " assign multiple values"
}], "GuideText",
 CellID->169534758],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox[",",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["y",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["{",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["y",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox[",",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["}",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " swap values"
}], "GuideText",
 CellID->189900579],

Cell["\t", "GuideDelimiter",
 CellID->98179567],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["a",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["i",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["v",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " assign a value to a list/array/expression element"
}], "GuideText",
 CellID->221535717],

Cell["\t", "GuideDelimiter",
 CellID->6111720],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["++",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Increment"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Increment",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Increment"]], "InlineFunctionSans"],
 ")",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["++",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreIncrement"], 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["PreIncrement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PreIncrement"]], "InlineFunctionSans"],
 ")",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["+=",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["AddTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AddTo"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->35118136],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["--",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decrement"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Decrement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Decrement"]], "InlineFunctionSans"],
 ")",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["--",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreDecrement"], 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["PreDecrement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PreDecrement"]], "InlineFunctionSans"],
 ")",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["-=",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubtractFrom"], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["SubtractFrom",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SubtractFrom"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->523989374],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["*=",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimesBy"], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["TimesBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimesBy"]], "InlineFunctionSans"],
 ")",
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox["/=",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DivideBy"], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["DivideBy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DivideBy"]], "InlineFunctionSans"],
 ")"
}], "InlineGuideFunctionListing",
 CellID->20495134],

Cell[TextData[{
 Cell[TextData[ButtonBox["AppendTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AppendTo"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["PrependTo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrependTo"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "add elements to a list"
}], "GuideText",
 CellID->114423427],

Cell["\t", "GuideDelimiterSubsection",
 CellID->422195275],

Cell[CellGroupData[{

Cell["Function Definitions", "GuideFunctionsSubsection",
 CellID->3633602],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["body",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " define a function"
}], "GuideText",
 CellID->53956708],

Cell["\t", "GuideDelimiterSubsection",
 CellID->144197917]
}, Open  ]],

Cell[CellGroupData[{

Cell["Forms of Assignment", "GuideFunctionsSubsection",
 CellID->46285456],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " immediate assignment, with ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " evaluated at the time of assignment"
}], "GuideText",
 CellID->74113233],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " delayed assignment, with ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " re-evaluated every time it is used "
}], "GuideText",
 CellID->19492365],

Cell["\t", "GuideDelimiter",
 CellID->54435332],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"], "TI"],
  ButtonBox["/:",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"],
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"], "TI"],
  ButtonBox["=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"], "TI"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["f",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"], "TI"],
  ButtonBox["/:",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"],
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"], "TI"],
  ButtonBox[":=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " associate assignments with the head ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->605083611],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSet"], "TI"],
  ButtonBox["^=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSet"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSet"], "TI"]
 }], "InlineFunctionSans"],
 ", ",
 Cell[TextData[{
  StyleBox[ButtonBox["lhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSetDelayed"], "TI"],
  ButtonBox["^:=",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSetDelayed"],
  StyleBox[ButtonBox["rhs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpSetDelayed"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " define \"upvalues\" associated with the leading head in ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->221251118],

Cell["\t", "GuideDelimiterSubsection",
 CellID->2126461]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clearing Assignments", "GuideFunctionsSubsection",
 CellID->165290154],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"], "TI"],
  ButtonBox["=.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " unset the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " (",
 Cell[TextData[ButtonBox["Unset",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unset"]], "InlineFunctionSans"],
 ")"
}], "GuideText",
 CellID->122294893],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clear"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "clear all values associated with a symbol"
}], "GuideText",
 CellID->255674648],

Cell[TextData[{
 Cell[TextData[ButtonBox["ClearAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClearAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Remove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Remove"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->603536910],

Cell["\t", "GuideDelimiterSubsection",
 CellID->109662237]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information about Assignments", "GuideFunctionsSubsection",
 CellID->84704688],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox["?",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"],
  StyleBox[ButtonBox["x",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"], "TI"]
 }], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["Information",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Information"]], "InlineFunctionSans"],
 ") \[LongDash] get information about all assignments for ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->43962812],

Cell[TextData[{
 Cell[TextData[ButtonBox["DownValues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DownValues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["UpValues",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UpValues"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Save",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Save"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->87233656]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Associating Definitions with Different Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]], \
"GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Making Definitions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingDefinitions"]], "GuideTutorial",
 CellID->270885965],

Cell[TextData[ButtonBox["Defining Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningVariables"]], "GuideTutorial",
 CellID->361153983],

Cell[TextData[ButtonBox["Defining Numerical Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningNumericalValues"]], "GuideTutorial",
 CellID->79356066],

Cell[TextData[ButtonBox["Defining Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningFunctions"]], "GuideTutorial",
 CellID->157945330],

Cell[TextData[ButtonBox["Making Definitions for Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MakingDefinitionsForFunctions"]], "GuideTutorial",
 CellID->120067565],

Cell[TextData[ButtonBox["Immediate and Delayed Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ImmediateAndDelayedDefinitions"]], "GuideTutorial",
 CellID->803642876]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Assignments - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 3.9657946}", "context" -> "", 
    "keywords" -> {
     "=", "++", "--", "add to", "append to", "assignments", "assign value", 
      "cleaning up", "clear all", "clearing symbols", "clearing values", 
      "clearing values of symbols", "concatenation of lists", "decrement", 
      "defining values", "definitions", "deleting functions", 
      "deleting symbols", "deleting values", "divide by", "DivideBy", 
      "down values", "equals sign", "erasing values", "exchange values", 
      "functions", "immediate assignment", "immediate definition", 
      "immediate value", "increase by", "increment", 
      "incremental multiplication", "inert functions", "interchange values", 
      "killing values", "list append", "permute values", "post-decrement", 
      "postdecrement", "post-increment", "pre-decrement", "predecrement", 
      "pre-increment", "preincrement", "prepend elements to lists", 
      "prepending to list", "prepend to", "removing assignments", 
      "removing functions", "removing symbols", "removing values", 
      "saving definitions of functions", "saving function definitions", 
      "saving of definitions", "set", "setting values", "subtract from", 
      "subtract one", "swap values", "times by", "undefining functions", 
      "undefining symbols", "unset", "unsetting symbols", "up values"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's symbolic architecture supports a highly generalized notion \
of assignment, in which you can specify a transformation for any class of \
expressions defined by a Mathematica pattern. Simple cases correspond to \
assignments for \"variables\", \"indexed variables\" or \"structure \
elements\". Other cases define functions or general transformations.", 
    "synonyms" -> {}, "title" -> "Assignments", "type" -> "Guide", "uri" -> 
    "guide/Assignments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 53, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[675, 28, 513, 13, 70, "GuideAbstract",
 CellID->774521997],
Cell[1191, 43, 531, 20, 70, "GuideText",
 CellID->203374175],
Cell[1725, 65, 1037, 40, 70, "GuideText",
 CellID->169534758],
Cell[2765, 107, 1026, 40, 70, "GuideText",
 CellID->189900579],
Cell[3794, 149, 47, 1, 70, "GuideDelimiter",
 CellID->98179567],
Cell[3844, 152, 829, 31, 70, "GuideText",
 CellID->221535717],
Cell[4676, 185, 46, 1, 70, "GuideDelimiter",
 CellID->6111720],
Cell[4725, 188, 1135, 42, 70, "InlineGuideFunctionListing",
 CellID->35118136],
Cell[5863, 232, 1157, 42, 70, "InlineGuideFunctionListing",
 CellID->523989374],
Cell[7023, 276, 776, 29, 70, "InlineGuideFunctionListing",
 CellID->20495134],
Cell[7802, 307, 380, 13, 70, "GuideText",
 CellID->114423427],
Cell[8185, 322, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->422195275],
Cell[CellGroupData[{
Cell[8268, 327, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->3633602],
Cell[8345, 330, 776, 28, 70, "GuideText",
 CellID->53956708],
Cell[9124, 360, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->144197917]
}, Open  ]],
Cell[CellGroupData[{
Cell[9219, 366, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->46285456],
Cell[9296, 369, 529, 19, 70, "GuideText",
 CellID->74113233],
Cell[9828, 390, 549, 19, 70, "GuideText",
 CellID->19492365],
Cell[10380, 411, 47, 1, 70, "GuideDelimiter",
 CellID->54435332],
Cell[10430, 414, 1194, 42, 70, "GuideText",
 CellID->605083611],
Cell[11627, 458, 860, 30, 70, "GuideText",
 CellID->221251118],
Cell[12490, 490, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->2126461]
}, Open  ]],
Cell[CellGroupData[{
Cell[12583, 496, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->165290154],
Cell[12662, 499, 518, 20, 70, "GuideText",
 CellID->122294893],
Cell[13183, 521, 264, 9, 70, "GuideText",
 CellID->255674648],
Cell[13450, 532, 392, 11, 70, "InlineGuideFunctionListing",
 CellID->603536910],
Cell[13845, 545, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->109662237]
}, Open  ]],
Cell[CellGroupData[{
Cell[13940, 551, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->84704688],
Cell[14027, 554, 523, 17, 70, "GuideText",
 CellID->43962812],
Cell[14553, 573, 599, 17, 70, "InlineGuideFunctionListing",
 CellID->87233656]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15201, 596, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[15266, 599, 213, 5, 70, "GuideTutorial",
 CellID->1885805579],
Cell[15482, 606, 154, 3, 70, "GuideTutorial",
 CellID->270885965],
Cell[15639, 611, 154, 3, 70, "GuideTutorial",
 CellID->361153983],
Cell[15796, 616, 166, 3, 70, "GuideTutorial",
 CellID->79356066],
Cell[15965, 621, 154, 3, 70, "GuideTutorial",
 CellID->157945330],
Cell[16122, 626, 183, 4, 70, "GuideTutorial",
 CellID->120067565],
Cell[16308, 632, 185, 4, 70, "GuideTutorial",
 CellID->803642876]
}, Open  ]],
Cell[CellGroupData[{
Cell[16530, 641, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[16595, 644, 162, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[16772, 650, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

