(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17338,        506]
NotebookOptionsPosition[     10036,        351]
NotebookOutlinePosition[     15272,        439]
CellTagsIndexPosition[     15229,        436]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Assumptions and Domains", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a flexible system for specifying arbitrary symbolic assumptions about \
variables",
 ". ",
 "It uses a wide range of sophisticated algorithms to infer the consequences \
of assumptions\[LongDash]often in the process automatically proving a \
sequence of necessary mathematical theorems."
}], "GuideAbstract",
 CellID->299162047],

Cell[TextData[{
 Cell[TextData[ButtonBox["Element",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Element]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify membership in a domain (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]elem\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->777146570],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotElement",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NotElement"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " (",
 Cell[TextData[ButtonBox["\[NotElement]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotElement"]], "InlineFunctionSans"],
 ") \[LongDash] specify exclusion from a domain (",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!elem\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->532103703],

Cell[TextData[{
 Cell[TextData[ButtonBox["Less",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["<",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Less"]], "InlineFunctionSans"],
 "), ",
 Cell[TextData[ButtonBox["Greater",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox[">",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Greater"]], "InlineFunctionSans"],
 "), ",
 Cell[BoxData["..."], "InlineGuideFunction"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " define inequalities, implicitly for real numbers"
}], "GuideText",
 CellID->781092269],

Cell[TextData[{
 Cell[TextData[ButtonBox["ForAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[ForAll]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ForAll"]], "InlineFunctionSans"],
 ") \[LongDash] universal quantifier (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]fa\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->309384201],

Cell[TextData[{
 Cell[TextData[ButtonBox["Exists",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["\[Exists]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Exists"]], "InlineFunctionSans"],
 ") \[LongDash] existential quantifier (entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ex\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ")"
}], "GuideText",
 CellID->353955745],

Cell[CellGroupData[{

Cell["Domains", "GuideFunctionsSubsection",
 CellID->92333869],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integers",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integers"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complexes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complexes"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Algebraics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Algebraics"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Primes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Primes"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rationals",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rationals"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Booleans",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Booleans"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->778407685],

Cell["\t", "GuideDelimiter",
 CellID->121708281],

Cell[TextData[{
 Cell[TextData[ButtonBox["Refine",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Refine"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "evaluate an expression using assumptions"
}], "GuideText",
 CellID->466787938],

Cell[TextData[{
 Cell[TextData[ButtonBox["Simplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Simplify"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FullSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " simplify using assumptions"
}], "GuideText",
 CellID->44769405],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "expand in terms of simpler functions, using assumptions"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Assuming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Assuming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set up assumptions to be used by functions inside"
}], "GuideText",
 CellID->295892253],

Cell[TextData[{
 Cell[TextData[ButtonBox["$Assumptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$Assumptions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "global default for ",
 Cell[TextData[ButtonBox["Assumptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Assumptions"]], "InlineFunctionSans"],
 " option"
}], "GuideText",
 CellID->244125],

Cell["\t", "GuideDelimiterSubsection",
 CellID->134360432]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions Allowing Domain Specifications ", "GuideFunctionsSubsection",
 CellID->59726456],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Resolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Resolve"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->79842485]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Quantifiers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Quantifiers"]], "GuideTutorial",
 CellID->5720002],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "GuideTutorial",
 CellID->113618864],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "GuideTutorial",
 CellID->30585418]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Assumptions and Domains - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 4.6220614}", "context" -> "", 
    "keywords" -> {
     "algebraic equations", "algebraic inequalities", "algebraic numbers", 
      "algebraic simplification", "algebraic solutions", 
      "algebraic variables", "always", "applicability", "assertions", 
      "assume", "assumptions", "Bessel function simplification", "Booleans", 
      "Boolean satisfiability", "cleaning up expressions", 
      "combinatorial explosion", "combinatorial simplification", "comparison",
       "complete simplification", "complex domain", "complex number", 
      "complex range", "complex solution", "complex space", 
      "complex variable", "complex variables", "conditions", 
      "constrained optimization", "constraints", "cost function", "criteria", 
      "cylindrical decomposition", "decision problem", "default assumptions", 
      "Diophantine equations", "domain assumptions", "domain exclusion", 
      "domain membership", "domain of algebraic numbers", "domains", 
      "domains for variables", "domain specification", "element", "equations",
       "evaluate using assumptions", "evaluation using assumptions", 
      "exact optimization", "existence", "existential quantifier", 
      "exist quantifier", "expanding", "expanding special constants", 
      "expanding special functions", "expanding special sequences", 
      "expressions", "extremization", "factorial simplification", "False", 
      "find instance", "first order logic", "for all", "for all quantifier", 
      "formulas", "fractions", "full simplify", "function expand", 
      "gamma function simplification", "general quantifier", 
      "geometric theorem proving", "global assumptions", 
      "global minimization", "goal functions", "greater", "Groebner basis", 
      "Hardy-Muskat-Williams methods", "identities", "inequalities", 
      "inequality", "infeasible constraints", "inferences", "integer domain", 
      "integer equations", "integer lattice", "integer linear programming", 
      "integer programming", "integer range", "integers", "integer solutions",
       "integer variables", "integral numbers", "less", "less than", 
      "linear equations", "linear fractional programming", 
      "linear inequalities", "linear programming", "logic quantifier", 
      "logic values", "LP (linear programming)", "minimization", 
      "modular equations", "not element", "numerical minimization", 
      "objective functions", "operations research", "optimization", "order", 
      "order relation", "parameters", "parametric optimization", 
      "pay-off functions", "Pell equations", "polynomial inequalities", 
      "polynomial programming", "predicates", "Prime domain", "Prime number", 
      "Primes", "quadratic programming", "quantifier elimination", 
      "radical simplification", "rational numbers", "rational solutions", 
      "rational space", "rational variables", "real axis", "real domain", 
      "real numbers", "real plane", "real range", "reals", "real solutions", 
      "real space", "real variables", "rearrange expression", 
      "reducing inequalities", "reduction formulas", "refine", 
      "refine using assumptions", "reflection formula", "reflection formulas",
       "regions", "relations", "remove quantifiers", "roots", "sample points",
       "satisfiability", "satisfiability problem", "SAT problem", "scope", 
      "semi-algebraic sets", "shortest form", "simplest forms", 
      "simplex algorithm", "simplification", "smallest form", "solutions", 
      "some", "special functions", "special function simplification", "speed",
       "square roots", "squash expression", "strict inequality", 
      "strictly less than", "strong inequality", "symbolic optimization", 
      "theorem proving", "Thue equations", "transcendental equations", 
      "transcendental inequalities", "transformations", 
      "trigonometric simplification", "True", "type assumptions", "types", 
      "type specification", "universal quantifier", "universal quantor", 
      "variables", "whole numbers", "witnesses", "conditions"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has a flexible system for specifying arbitrary symbolic \
assumptions about variables. It uses a wide range of sophisticated algorithms \
to infer the consequences of assumptions--often in the process automatically \
proving a sequence of necessary mathematical theorems.", "synonyms" -> {}, 
    "title" -> "Assumptions and Domains", "type" -> "Guide", "uri" -> 
    "guide/AssumptionsAndDomains"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 400, 10, 70, "GuideAbstract",
 CellID->299162047],
Cell[1090, 40, 522, 17, 70, "GuideText",
 CellID->777146570],
Cell[1615, 59, 630, 17, 70, "GuideText",
 CellID->532103703],
Cell[2248, 78, 679, 22, 70, "GuideText",
 CellID->781092269],
Cell[2930, 102, 466, 14, 70, "GuideText",
 CellID->309384201],
Cell[3399, 118, 468, 14, 70, "GuideText",
 CellID->353955745],
Cell[CellGroupData[{
Cell[3892, 136, 62, 1, 70, "GuideFunctionsSubsection",
 CellID->92333869],
Cell[3957, 139, 1434, 41, 70, "InlineGuideFunctionListing",
 CellID->778407685],
Cell[5394, 182, 48, 1, 70, "GuideDelimiter",
 CellID->121708281],
Cell[5445, 185, 265, 9, 70, "GuideText",
 CellID->466787938],
Cell[5713, 196, 384, 12, 70, "GuideText",
 CellID->44769405],
Cell[6100, 210, 297, 9, 70, "GuideText",
 CellID->1463276848],
Cell[6400, 221, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[6451, 224, 278, 9, 70, "GuideText",
 CellID->295892253],
Cell[6732, 235, 391, 13, 70, "GuideText",
 CellID->244125],
Cell[7126, 250, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->134360432]
}, Open  ]],
Cell[CellGroupData[{
Cell[7221, 256, 96, 1, 70, "GuideFunctionsSubsection",
 CellID->59726456],
Cell[7320, 259, 1151, 33, 70, "InlineGuideFunctionListing",
 CellID->79842485]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8520, 298, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8585, 301, 152, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[8740, 306, 174, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[8917, 311, 139, 3, 70, "GuideTutorial",
 CellID->5720002],
Cell[9059, 316, 196, 4, 70, "GuideTutorial",
 CellID->113618864],
Cell[9258, 322, 168, 3, 70, "GuideTutorial",
 CellID->30585418]
}, Open  ]],
Cell[CellGroupData[{
Cell[9463, 330, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9528, 333, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[9684, 338, 141, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9828, 343, 166, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[10009, 349, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

