(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12102,        396]
NotebookOptionsPosition[      8384,        296]
NotebookOutlinePosition[     10336,        339]
CellTagsIndexPosition[     10293,        336]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Atomic Elements of Expressions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "All expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are ultimately built from a small number of distinct types of atomic \
elements."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["AtomQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AtomQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test whether an expression is an atom"
}], "GuideText",
 CellID->269436861],

Cell[TextData[{
 Cell[TextData[ButtonBox["Head",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Head"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the head of any expression, including an atom"
}], "GuideText",
 CellID->149430832],

Cell["\t", "GuideDelimiterSubsection",
 CellID->525679796],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Symbols \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SymbolHandling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->230756595],

Cell[TextData[{
 Cell[TextData[ButtonBox["Symbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Symbol"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the head of a symbol; create a symbol from a name"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SymbolName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SymbolName"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Context",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Context"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Remove",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Remove"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Names",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Names"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NameQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolHandling"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->910511090],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Strings \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StringManipulation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->37671145],

Cell[TextData[{
 Cell[TextData[ButtonBox["String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the head of a string"
}], "GuideText",
 CellID->199581953],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Characters"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToCharacterCode",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StringLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringLength"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToExpression"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StringManipulation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiterSubsection",
 CellID->12948478]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Numbers \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RepresentationOfNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->265389930],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Real",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Real"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Rational",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rational"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complex",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complex"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22421],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test for a number of any type"
}], "GuideText",
 CellID->394780145],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RealDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RealDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Precision",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Precision"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MachineNumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MachineNumberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RepresentationOfNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->950923952]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS:", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "GuideTutorial",
 CellID->671748855],

Cell[TextData[ButtonBox["Basic Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicObjects"]], "GuideTutorial",
 CellID->159228503],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "GuideTutorial",
 CellID->14799702]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Atomic Elements of Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 5.8720934}", "context" -> "", 
    "keywords" -> {
     "approximate numbers", "atoi", "atom", "conversion", 
      "elementary expression", "explode", "expressions", 
      "floating-point numbers", "function name", "held expressions", 
      "inert functions", "input as string", "integers", 
      "interpretation of input", "known symbols", "length", "machine number", 
      "make list of symbols", "names", "names listing", "names of operators", 
      "numbers", "octal digits", "padding", "parsing of strings", 
      "radix conversion", "real digits", "real numbers", "recurring decimals",
       "relative error", "search for symbols", "string length", 
      "subexpressions", "symbol name", "symbols", "test if string", 
      "testing for numbers", "testing for numerical expressions", "ToASCII", 
      "to character code", "to expression", "unpack", 
      "using strings as input", "workspace"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "All expressions in Mathematica are ultimately built from a small number \
of distinct types of atomic elements.", "synonyms" -> {}, "title" -> 
    "Atomic Elements of Expressions", "type" -> "Guide", "uri" -> 
    "guide/AtomicElementsOfExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 72, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[694, 28, 215, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[912, 37, 260, 9, 70, "GuideText",
 CellID->269436861],
Cell[1175, 48, 271, 9, 70, "GuideText",
 CellID->149430832],
Cell[1449, 59, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->525679796],
Cell[CellGroupData[{
Cell[1532, 64, 209, 5, 70, "GuideFunctionsSubsection",
 CellID->230756595],
Cell[1744, 71, 274, 9, 70, "GuideText",
 CellID->203374175],
Cell[2021, 82, 1217, 35, 70, "InlineGuideFunctionListing",
 CellID->910511090],
Cell[3241, 119, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[3336, 125, 212, 5, 70, "GuideFunctionsSubsection",
 CellID->37671145],
Cell[3551, 132, 245, 9, 70, "GuideText",
 CellID->199581953],
Cell[3799, 143, 1266, 35, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[5068, 180, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->12948478]
}, Open  ]],
Cell[CellGroupData[{
Cell[5162, 186, 218, 5, 70, "GuideFunctionsSubsection",
 CellID->265389930],
Cell[5383, 193, 796, 23, 70, "InlineGuideFunctionListing",
 CellID->22421],
Cell[6182, 218, 256, 9, 70, "GuideText",
 CellID->394780145],
Cell[6441, 229, 1060, 29, 70, "InlineGuideFunctionListing",
 CellID->950923952]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7550, 264, 63, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7616, 267, 170, 3, 70, "GuideTutorial",
 CellID->671748855],
Cell[7789, 272, 144, 3, 70, "GuideTutorial",
 CellID->159228503],
Cell[7936, 277, 148, 3, 70, "GuideTutorial",
 CellID->14799702]
}, Open  ]],
Cell[CellGroupData[{
Cell[8121, 285, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8186, 288, 156, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[8357, 294, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

