(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14503,        509]
NotebookOptionsPosition[      9998,        384]
NotebookOutlinePosition[     12057,        428]
CellTagsIndexPosition[     12014,        425]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Attributes", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Any ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbol can have both a variety of types of values, and a variety of \
independently settable attributes that define overall aspects of its \
behavior."
}], "GuideAbstract",
 CellID->373550659],

Cell[TextData[{
 Cell[TextData[ButtonBox["Attributes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Attributes"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find the attributes of a symbol"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetAttributes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetAttributes"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ClearAttributes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ClearAttributes"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set, clear attributes"
}], "GuideText",
 CellID->180866233],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892],

Cell[CellGroupData[{

Cell["Function Properties", "GuideFunctionsSubsection",
 CellID->638657903],

Cell[TextData[{
 Cell[TextData[ButtonBox["Listable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Listable"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "automatically thread over lists appearing in arguments"
}], "GuideText",
 CellID->264272573],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flat",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flat"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["a", "TI"], "]"}], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ", etc. (associativity)"
}], "GuideText",
 CellID->63678795],

Cell[TextData[{
 Cell[TextData[ButtonBox["Orderless",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Orderless"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ", etc. (commutativity)"
}], "GuideText",
 CellID->642871469],

Cell[TextData[{
 Cell[TextData[ButtonBox["OneIdentity",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OneIdentity"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " treat ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " as equivalent to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", etc. (idempotence)"
}], "GuideText",
 CellID->152474980]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function Argument Evaluation", "GuideFunctionsSubsection",
 CellID->16302387],

Cell[TextData[{
 Cell[TextData[ButtonBox["HoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldFirst"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldRest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldRest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldAllComplete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SequenceHold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SequenceHold"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numeric-Related Properties", "GuideFunctionsSubsection",
 CellID->433567566],

Cell[TextData[{
 Cell[TextData[ButtonBox["NumericFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumericFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "treat as a numeric function"
}], "GuideText",
 CellID->17086036],

Cell[TextData[{
 Cell[TextData[ButtonBox["NHoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldFirst"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NHoldRest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldRest"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NHoldAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldAll"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->15815354],

Cell[TextData[{
 Cell[TextData[ButtonBox["Constant",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Constant"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "treat as a constant in differentiation, etc."
}], "GuideText",
 CellID->1707358]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol Space", "GuideFunctionsSubsection",
 CellID->274551837],

Cell[TextData[{
 Cell[TextData[ButtonBox["Stub",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Stub"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "stub created by ",
 Cell[TextData[ButtonBox["DeclarePackage",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeclarePackage"]], "InlineFunctionSans"],
 ", etc."
}], "GuideText",
 CellID->960469383],

Cell[TextData[{
 Cell[TextData[ButtonBox["Temporary",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Temporary"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "temporary local variable from ",
 Cell[TextData[ButtonBox["Module",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Module"]], "InlineFunctionSans"],
 ", etc."
}], "GuideText",
 CellID->27222937]
}, Open  ]],

Cell[CellGroupData[{

Cell["Protection", "GuideFunctionsSubsection",
 CellID->8978530],

Cell[TextData[{
 Cell[TextData[ButtonBox["Protected",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Protected"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "keep protected against redefinition"
}], "GuideText",
 CellID->63669131],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReadProtected",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReadProtected"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Protect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Protect"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unprotect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unprotect"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->84244528],

Cell[TextData[{
 Cell[TextData[ButtonBox["Locked",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Locked"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "keep all attributes locked (settable but not clearable)"
}], "GuideText",
 CellID->340369788],

Cell["\t", "GuideDelimiter",
 CellID->291222486],

Cell[TextData[{
 Cell[TextData[ButtonBox["Function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a pure function, potentially with attributes"
}], "GuideText",
 CellID->487645866]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS:", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "GuideTutorial",
 CellID->17492173],

Cell[TextData[ButtonBox["Flat and Orderless Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FlatAndOrderlessFunctions"]], "GuideTutorial",
 CellID->764336940],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsAndTransformationRules"]], "GuideTutorial",
 CellID->113586514],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "GuideTutorial",
 CellID->602925840]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[{
 ButtonBox["Expressions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Expressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Expressions"],
  FontSlant->"Italic"]
}], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Attributes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 6.4971094}", "context" -> "", 
    "keywords" -> {
     "anonymous functions", "autoload package", 
      "automatic threading over lists", "clear attributes", "declare package",
       "garbage collection", "hidden", "hold all", "hold all complete", 
      "hold first", "hold rest", "idempotence", "idempotent", "immutable", 
      "invisible", "lambda expression", "lexical scoping", 
      "localized variables", "local variables", "lock definition", 
      "numeric function", "one-identity", "one identity", 
      "overwrite protection", "prevent redefinition", "protected attribute", 
      "protection of definitions", "pure function", "read protected", 
      "redefine system function", "remove protected attribute", "scoping", 
      "security", "sequence hold", "set attributes", "static scoping", 
      "symbols", "temporary symbols", "threadable", "unchangeable", 
      "unmodifiable", "unnamed function", "unprotect definitions", 
      "unwritable", "write-protect", "write protected", "write protection"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Any Mathematica symbol can have both a variety of types of values, and a \
variety of independently settable attributes that define overall aspects of \
its behavior.", "synonyms" -> {}, "title" -> "Attributes", "type" -> "Guide", 
    "uri" -> "guide/Attributes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 52, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[674, 28, 269, 8, 70, "GuideAbstract",
 CellID->373550659],
Cell[946, 38, 264, 9, 70, "GuideText",
 CellID->203374175],
Cell[1213, 49, 396, 12, 70, "GuideText",
 CellID->180866233],
Cell[1612, 63, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892],
Cell[CellGroupData[{
Cell[1695, 68, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->638657903],
Cell[1773, 71, 283, 9, 70, "GuideText",
 CellID->264272573],
Cell[2059, 82, 624, 24, 70, "GuideText",
 CellID->63678795],
Cell[2686, 108, 582, 22, 70, "GuideText",
 CellID->642871469],
Cell[3271, 132, 447, 16, 70, "GuideText",
 CellID->152474980]
}, Open  ]],
Cell[CellGroupData[{
Cell[3755, 153, 83, 1, 70, "GuideFunctionsSubsection",
 CellID->16302387],
Cell[3841, 156, 1041, 29, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[4919, 190, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->433567566],
Cell[5004, 193, 269, 9, 70, "GuideText",
 CellID->17086036],
Cell[5276, 204, 609, 17, 70, "InlineGuideFunctionListing",
 CellID->15815354],
Cell[5888, 223, 271, 9, 70, "GuideText",
 CellID->1707358]
}, Open  ]],
Cell[CellGroupData[{
Cell[6196, 237, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->274551837],
Cell[6267, 240, 380, 13, 70, "GuideText",
 CellID->960469383],
Cell[6650, 255, 387, 13, 70, "GuideText",
 CellID->27222937]
}, Open  ]],
Cell[CellGroupData[{
Cell[7074, 273, 64, 1, 70, "GuideFunctionsSubsection",
 CellID->8978530],
Cell[7141, 276, 265, 9, 70, "GuideText",
 CellID->63669131],
Cell[7409, 287, 613, 17, 70, "InlineGuideFunctionListing",
 CellID->84244528],
Cell[8025, 306, 280, 9, 70, "GuideText",
 CellID->340369788],
Cell[8308, 317, 48, 1, 70, "GuideDelimiter",
 CellID->291222486],
Cell[8359, 320, 273, 9, 70, "GuideText",
 CellID->487645866]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8681, 335, 63, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8747, 338, 138, 3, 70, "GuideTutorial",
 CellID->17492173],
Cell[8888, 343, 172, 3, 70, "GuideTutorial",
 CellID->764336940],
Cell[9063, 348, 185, 4, 70, "GuideTutorial",
 CellID->113586514],
Cell[9251, 354, 171, 3, 70, "GuideTutorial",
 CellID->602925840]
}, Open  ]],
Cell[CellGroupData[{
Cell[9459, 362, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9524, 365, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[9679, 370, 277, 9, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[9971, 382, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

