(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11253,        365]
NotebookOptionsPosition[      6995,        255]
NotebookOutlinePosition[      9389,        304]
CellTagsIndexPosition[      9346,        301]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Automatic Text Styling Features", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", uses its knowledge of the symbolic structure of your input to display \
with semantics-directed syntax coloring and other forms of styling",
 ". ",
 "You can use options to control the details of this behavior, either \
programmatically or through the Preferences dialog."
}], "GuideAbstract",
 CellID->239332159],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Syntax Coloring", "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set details of syntax coloring"
}], "GuideText",
 CellID->642354523],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowAutoStyles",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowAutoStyles"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to display syntax coloring and other automatic styling"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->175365539],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Numbers", "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " formatting of numbers (digit blocks, default precision, etc.)"
}], "GuideText",
 CellID->147737133],

Cell[TextData[{
 Cell[TextData[ButtonBox["AutoMultiplicationSymbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoMultiplicationSymbol"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to display ",
 Cell[BoxData[
  StyleBox["\[Times]", "TR"]], "InlineFormula"],
 " for number multiplication"
}], "GuideText",
 CellID->128520750],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowStringCharacters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowStringCharacters"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to display quotes around strings"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowSpecialCharacters",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowSpecialCharacters"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to turn ",
 Cell[BoxData[
  RowBox[{"\\[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " sequences into special characters"
}], "GuideText",
 CellID->245645399],

Cell["\t", "GuideDelimiter",
 CellID->91390733],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputAliases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputAliases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "definitions for arbitrary ",
 StyleBox["Esc", "KeyEvent"],
 " aliases"
}], "GuideText",
 CellID->422992196],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputAutoReplacements",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "automatic character sequence replacements to do"
}], "GuideText",
 CellID->56823817],

Cell[TextData[{
 Cell[TextData[ButtonBox["AutoItalicWords",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoItalicWords"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " words to automatically make italic"
}], "GuideText",
 CellID->95991581],

Cell[TextData[{
 Cell[TextData[ButtonBox["SingleLetterItalics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SingleLetterItalics"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to make single-letter mathematical variables italic"
}], "GuideText",
 CellID->507045577],

Cell["\t", "GuideDelimiter",
 CellID->7414702],

Cell[TextData[{
 Cell[TextData[ButtonBox["AutoIndent",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AutoIndent"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to add an indent after a newline is entered"
}], "GuideText",
 CellID->697878183],

Cell[TextData[{
 Cell[TextData[ButtonBox["TabSpacings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TabSpacings"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TabFilling",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TabFilling"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->55131457],

Cell["\t", "GuideDelimiter",
 CellID->356187672],

Cell[TextData[{
 Cell[TextData[ButtonBox["DelimiterFlashTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DelimiterFlashTime"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " how long to flash matching delimiters"
}], "GuideText",
 CellID->401722616],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShowCursorTracker",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ShowCursorTracker"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether to display a real-time spot when if the cursor jumps"
}], "GuideText",
 CellID->108384497]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "GuideTutorial",
 CellID->307295932],

Cell[TextData[ButtonBox["Styles and the Inheritance of Option Settings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]], "GuideTutorial",\

 CellID->138461839],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "GuideTutorial",
 CellID->33580261]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "GuideMoreAbout",
 CellID->40268231]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Automatic Text Styling Features - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 7.2158778}", "context" -> "", 
    "keywords" -> {
     "aliases", "Annotation", "auto indent", "auto-italic words", 
      "auto italic words", "automatic italic", "automatic styles", 
      "auto multiplication symbol", "blob", "braces", "brackets", 
      "colorizing", "cursor tracker", "delimiter flash time", 
      "display special characters", "display string characters", 
      "double-quotes", "double quotes", "elliptical blob", "escape sequences",
       "eye motion", "flashing", "flashing blob", "gaze", "glossary", 
      "highlighting", "indentation", "indicator", "Input", "input aliases", 
      "input auto replacements", "italicization", "italics", 
      "keyboard shortcuts", "matching", "parentheses", "purple brackets", 
      "quotes", "shortcuts", "show auto styles", "show cursor tracker", 
      "show double-quotes", "show quotes", "show special characters", 
      "show string characters", "single-letter italics", 
      "single letter italics", "special characters", "special words", 
      "structure editing", "syntax coloring", "tab filling", "tab spacings", 
      "tracker", "unmatched brackets", "user-defined aliases", 
      "variable names"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica, uses its knowledge of the symbolic structure of your input \
to display with semantics-directed syntax coloring and other forms of \
styling. You can use options to control the details of this behavior, either \
programmatically or through the Preferences dialog.", "synonyms" -> {}, 
    "title" -> "Automatic Text Styling Features", "type" -> "Guide", "uri" -> 
    "guide/AutomaticTextStylingFeatures"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 73, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[695, 28, 382, 9, 70, "GuideAbstract",
 CellID->239332159],
Cell[1080, 39, 355, 10, 70, "GuideText",
 CellID->642354523],
Cell[1438, 51, 299, 8, 70, "GuideText",
 CellID->1463276848],
Cell[1740, 61, 48, 1, 70, "GuideDelimiter",
 CellID->175365539],
Cell[1791, 64, 378, 10, 70, "GuideText",
 CellID->147737133],
Cell[2172, 76, 370, 11, 70, "GuideText",
 CellID->128520750],
Cell[2545, 89, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2596, 92, 288, 8, 70, "GuideText",
 CellID->203374175],
Cell[2887, 102, 398, 12, 70, "GuideText",
 CellID->245645399],
Cell[3288, 116, 47, 1, 70, "GuideDelimiter",
 CellID->91390733],
Cell[3338, 119, 306, 11, 70, "GuideText",
 CellID->422992196],
Cell[3647, 132, 301, 9, 70, "GuideText",
 CellID->56823817],
Cell[3951, 143, 271, 8, 70, "GuideText",
 CellID->95991581],
Cell[4225, 153, 305, 8, 70, "GuideText",
 CellID->507045577],
Cell[4533, 163, 46, 1, 70, "GuideDelimiter",
 CellID->7414702],
Cell[4582, 166, 279, 8, 70, "GuideText",
 CellID->697878183],
Cell[4864, 176, 405, 11, 70, "InlineGuideFunctionListing",
 CellID->55131457],
Cell[5272, 189, 48, 1, 70, "GuideDelimiter",
 CellID->356187672],
Cell[5323, 192, 281, 8, 70, "GuideText",
 CellID->401722616],
Cell[5607, 202, 302, 8, 70, "GuideText",
 CellID->108384497]
}, Open  ]],
Cell[CellGroupData[{
Cell[5946, 215, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6011, 218, 195, 4, 70, "GuideTutorial",
 CellID->307295932],
Cell[6209, 224, 208, 5, 70, "GuideTutorial",
 CellID->138461839],
Cell[6420, 231, 149, 3, 70, "GuideTutorial",
 CellID->33580261]
}, Open  ]],
Cell[CellGroupData[{
Cell[6606, 239, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6671, 242, 141, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6815, 247, 138, 3, 70, "GuideMoreAbout",
 CellID->40268231]
}, Open  ]],
Cell[6968, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

