(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13041,        448]
NotebookOptionsPosition[      9474,        348]
NotebookOutlinePosition[     11161,        387]
CellTagsIndexPosition[     11118,        384]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["C/C++ Language Interface", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports several levels of interfacing to C and C++ programs. You can \
create \"installable\" C programs where C functions are directly connected to \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions",
 ". ",
 "You can use C to call ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " through ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " and get full access to its capabilities. And you can create C program \
fragments and modify C source code."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Calling C Programs from ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 " ",
 StyleBox[ButtonBox[" \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InstallableMathLinkPrograms"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->298730278],

Cell[TextData[{
 Cell[TextData[ButtonBox["Install",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Install"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " load an installable ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " program"
}], "GuideText",
 CellID->147941495],

Cell[TextData[{
 Cell[TextData[{
  ButtonBox[".",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"],
  ButtonBox["tm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/file/file.tm"]
 }], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " template file for connecting C and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions"
}], "GuideText",
 CellID->556748565],

Cell[TextData[{
 Cell[TextData[ButtonBox["mcc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mcc"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["mprep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/program/mprep"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " scripts for building ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " programs"
}], "GuideText",
 CellID->524000843],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLEvaluate()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLEvaluate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "call back into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " "
}], "GuideText",
 CellID->11379848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->440168247]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 StyleBox[ButtonBox["Calling ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"], 
  "GuideFunctionsSubsection"],
 StyleBox[ButtonBox["Mathematica ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"], 
  "GuideFunctionsSubsection",
  FontSlant->"Italic"],
 StyleBox[ButtonBox["from C Programs \[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"], 
  "GuideFunctionsSubsection"]
}], "GuideFunctionsSubsection",
 CellID->113147335],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLPutInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutInteger32"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLGetInteger32()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLGetInteger32"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLPutFunction()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLPutFunction"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->8597751],

Cell[TextData[{
 Cell[TextData[ButtonBox["MLOpenString()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLOpenString"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLNextPacket()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLNextPacket"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MLReady()",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/c/MLReady"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkCLanguageFunctions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->670705409],

Cell["\t", "GuideDelimiterSubsection",
 CellID->244322495]
}, Open  ]],

Cell[CellGroupData[{

Cell["C Program Construction", "GuideFunctionsSubsection",
 CellID->180196120],

Cell[TextData[{
 Cell[TextData[ButtonBox["CForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert an expression to C language form"
}], "GuideText",
 CellID->166047341],

Cell[TextData[{
 Cell[TextData[ButtonBox["Splice",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Splice"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "splice ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output into C source files"
}], "GuideText",
 CellID->526709970]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Generating C Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GeneratingCAndFortranExpressions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Mac OS X)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Macintosh"]
}], "GuideTutorial",
 CellID->403767969],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Unix and Linux)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Unix"]
}], "GuideTutorial",
 CellID->309869466],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"],
  FontSlant->"Italic"],
 ButtonBox[" C API Developer Guide (Windows)",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathLinkDeveloperGuide-Windows"]
}], "GuideTutorial",
 CellID->441486358]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Systems Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SystemsInterfacesAndDeploymentOverview"]], "GuideMoreAbout",
 CellID->431270840],

Cell[TextData[{
 ButtonBox["The ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"],
  FontSlant->"Italic"],
 ButtonBox[" API",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkAPI"]
}], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 ButtonBox["Listing of ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"],
  FontSlant->"Italic"],
 ButtonBox[" C Functions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AlphabeticalListingOfMathLinkCFunctions"]
}], "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"C/C++ Language Interface - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 19.3724390}", "context" -> "", 
    "keywords" -> {
     "add external function", "C language", "C programs", "code generation", 
      "extend functions", "external programs", 
      "insertion into external files", "install external program", 
      "language conversion", "MathLink", "output in external files", 
      "running external programs", "splicing C-code", "splicing into files", 
      "splicing Mathematica output"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica supports several levels of interfacing to C and C++ \
programs. You can create \"installable\" C programs where C functions are \
directly connected to Mathematica functions. You can use C to call \
Mathematica through MathLink and get full access to its capabilities. And you \
can create C program fragments and modify C source code.", "synonyms" -> {}, 
    "title" -> "C/C++ Language Interface", "type" -> "Guide", "uri" -> 
    "guide/CLanguageInterface"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 66, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[688, 28, 583, 19, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1296, 51, 556, 16, 70, "GuideFunctionsSubsection",
 CellID->298730278],
Cell[1855, 69, 301, 11, 70, "GuideText",
 CellID->147941495],
Cell[2159, 82, 412, 16, 70, "GuideText",
 CellID->556748565],
Cell[2574, 100, 432, 15, 70, "GuideText",
 CellID->524000843],
Cell[3009, 117, 306, 12, 70, "GuideText",
 CellID->11379848],
Cell[3318, 131, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->440168247]
}, Open  ]],
Cell[CellGroupData[{
Cell[3413, 137, 547, 15, 70, "GuideFunctionsSubsection",
 CellID->113147335],
Cell[3963, 154, 1092, 30, 70, "InlineGuideFunctionListing",
 CellID->8597751],
Cell[5058, 186, 856, 24, 70, "InlineGuideFunctionListing",
 CellID->670705409],
Cell[5917, 212, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->244322495]
}, Open  ]],
Cell[CellGroupData[{
Cell[6012, 218, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->180196120],
Cell[6093, 221, 263, 9, 70, "GuideText",
 CellID->166047341],
Cell[6359, 232, 313, 12, 70, "GuideText",
 CellID->526709970]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6721, 250, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6786, 253, 178, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[6967, 259, 376, 11, 70, "GuideTutorial",
 CellID->1885805579],
Cell[7346, 272, 335, 9, 70, "GuideTutorial",
 CellID->403767969],
Cell[7684, 283, 331, 9, 70, "GuideTutorial",
 CellID->309869466],
Cell[8018, 294, 330, 9, 70, "GuideTutorial",
 CellID->441486358]
}, Open  ]],
Cell[CellGroupData[{
Cell[8385, 308, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8450, 311, 189, 4, 70, "GuideMoreAbout",
 CellID->431270840],
Cell[8642, 317, 343, 12, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8988, 331, 444, 12, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[9447, 346, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

