(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10354,        350]
NotebookOptionsPosition[      6486,        249]
NotebookOutlinePosition[      8716,        295]
CellTagsIndexPosition[      8673,        292]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Combinatorial Functions", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " factorial function (total arrangements of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " objects)"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Subfactorial",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Subfactorial"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " number of derangements of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " objects, leaving none unchanged"
}], "GuideText",
 CellID->34555737],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial2"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[{
  ButtonBox["!",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"],
  ButtonBox["!",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factorial2"]
 }], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " double factorial"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "binomial coefficients"
}], "GuideText",
 CellID->41054628],

Cell[TextData[{
 Cell[TextData[ButtonBox["Multinomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Multinomial"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "multinomial coefficients"
}], "GuideText",
 CellID->139939398],

Cell[TextData[{
 Cell[TextData[ButtonBox["CatalanNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CatalanNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Catalan numbers"
}], "GuideText",
 CellID->11798450],

Cell["\t", "GuideDelimiter",
 CellID->37321961],

Cell[TextData[{
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["StirlingS2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS2"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Stirling numbers"
}], "GuideText",
 CellID->39762865],

Cell[TextData[{
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "number of partitions of an integer"
}], "GuideText",
 CellID->813357153],

Cell[TextData[{
 Cell[TextData[ButtonBox["BellB",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BellB"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Bell numbers"
}], "GuideText",
 CellID->606130920],

Cell["\t", "GuideDelimiter",
 CellID->106828551],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrobeniusNumber",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusNumber"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Frobenius number for a list"
}], "GuideText",
 CellID->208776518]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->827342985],

Cell[TextData[{
 ButtonBox["Demonstrations related to Combinatorial Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(BellB+\
OR+Binomial+OR+CatalanNumber+OR+Factorial+OR+Factorial2+OR+FrobeniusNumber+OR+\
Multinomial+OR+PartitionsP+OR+StirlingS1+OR+StirlingS2+OR+Subfactorial)"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->33886118]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Combinatorial Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 25.9507324}", "context" -> "", 
    "keywords" -> {
     "bang", "binom", "binomials", "Catalan number", "choose", "comb", 
      "combinations", "combinatorial function", "derangement", 
      "double factorial", "enumeration of permutations", "exclamation point", 
      "fact", "factorial", "Frobenius number", "multinomial", 
      "multinomial coefficients", "n-choose-k", "nchoosek", "nCk", "nPk", 
      "number of partitions", "partitions", "permutation", 
      "permutation cycle", "rencontres number", "restricted rooks problem", 
      "shriek", "stirling1", "stirling2", "Stirling number of the 1st kind", 
      "Stirling number of the 2nd kind", "Stirling number of the first kind", 
      "Stirling number of the second kind", "Stirling numbers", 
      "Stirling numbers S1", "Stirling numbers S2", "stirling s1", 
      "stirling s2"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Factorial (!) -- factorial function (total arrangements of n objects), \
Subfactorial -- number of derangements of n objects, leaving none unchanged, \
Factorial2 (!!) -- double factorial, Binomial -- binomial coefficients, \
Multinomial -- multinomial coefficients, CatalanNumber -- Catalan numbers, \
StirlingS1, StirlingS2 -- Stirling numbers, PartitionsP -- number of \
partitions of an integer, BellB -- Bell numbers, FrobeniusNumber -- Frobenius \
number for a list", "synonyms" -> {}, "title" -> "Combinatorial Functions", 
    "type" -> "Guide", "uri" -> "guide/CombinatorialFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 65, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[687, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[746, 31, 466, 16, 70, "GuideText",
 CellID->203374175],
Cell[1215, 49, 496, 14, 70, "GuideText",
 CellID->34555737],
Cell[1714, 65, 462, 18, 70, "GuideText",
 CellID->1463276848],
Cell[2179, 85, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2230, 88, 249, 9, 70, "GuideText",
 CellID->41054628],
Cell[2482, 99, 259, 9, 70, "GuideText",
 CellID->139939398],
Cell[2744, 110, 398, 12, 70, "GuideText",
 CellID->11798450],
Cell[3145, 124, 47, 1, 70, "GuideDelimiter",
 CellID->37321961],
Cell[3195, 127, 379, 13, 70, "GuideText",
 CellID->39762865],
Cell[3577, 142, 269, 9, 70, "GuideText",
 CellID->813357153],
Cell[3849, 153, 380, 12, 70, "GuideText",
 CellID->606130920],
Cell[4232, 167, 48, 1, 70, "GuideDelimiter",
 CellID->106828551],
Cell[4283, 170, 410, 11, 70, "GuideText",
 CellID->208776518]
}, Open  ]],
Cell[CellGroupData[{
Cell[4730, 186, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4795, 189, 164, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[4962, 194, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[5147, 202, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[5212, 205, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[5372, 210, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5525, 215, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[5765, 224, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->827342985],
Cell[5837, 227, 607, 17, 70, "GuideRelatedLinks",
 CellID->33886118]
}, Open  ]],
Cell[6459, 247, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

