(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10992,        347]
NotebookOptionsPosition[      7398,        248]
NotebookOutlinePosition[      9337,        290]
CellTagsIndexPosition[      9294,        287]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Combining Graphics", "GuideTitle",
 CellID->14688],

Cell[TextData[{
 "The symbolic character of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " graphics makes it straightforward to combine together different graphics \
constructs, both for presentation and interactive behavior\[LongDash]and \
efficiently maintain a variety of types of constraints."
}], "GuideAbstract",
 CellID->13401],

Cell[TextData[{
 Cell[TextData[ButtonBox["Show",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Show"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "graphics shown overlaid, or with options changed"
}], "GuideText",
 CellID->5002],

Cell["\t", "GuideDelimiter",
 CellID->10585],

Cell[TextData[{
 Cell[TextData[ButtonBox["Inset",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Inset"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " inset a graphic or expression inside a larger graphic"
}], "GuideText",
 CellID->24182],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsGroup",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " make graphics be selected as a group"
}], "GuideText",
 CellID->10285],

Cell[TextData[{
 StyleBox["Double\[Hyphen]Click", "PointerEvent"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " \"drill down\" inside an inset or group"
}], "GuideText",
 CellID->27088],

Cell["\t", "GuideDelimiter",
 CellID->31426],

Cell[TextData[{
 Cell[TextData[ButtonBox["Directive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Directive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "combine graphics directives"
}], "GuideText",
 CellID->28617],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " create a complex of graphics objects with shared coordinates"
}], "GuideText",
 CellID->23757],

Cell[CellGroupData[{

Cell["Tabular Layout", "GuideFunctionsSubsection",
 CellID->9832],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsRow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsRow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsColumn",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->30932]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alignment", "GuideFunctionsSubsection",
 CellID->4169],

Cell[TextData[{
 Cell[TextData[ButtonBox["BaselinePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BaselinePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AlignmentPoint",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Alignment",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Alignment"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->2154]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->25721],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "GuideTutorial",
 CellID->4003787],

Cell[TextData[ButtonBox["Grids, Rows, and Columns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GridsRowsAndColumns"]], "GuideTutorial",
 CellID->512868203],

Cell[TextData[ButtonBox["Insetting Objects in Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InsettingObjectsInGraphics"]], "GuideTutorial",
 CellID->96742094],

Cell[TextData[{
 ButtonBox["Editing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"],
  FontSlant->"Italic"],
 ButtonBox[" Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InteractiveGraphicsOverview"]
}], "GuideTutorial",
 CellID->60508230],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "GuideTutorial",
 CellID->912269080],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->28810171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31329],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "GuideMoreAbout",
 CellID->28692],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "GuideMoreAbout",
 CellID->2368]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Combining Graphics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 26.4038690}", "context" -> "", 
    "keywords" -> {
     "alignment point", "align objects", "baseline position", 
      "combining plots", "composite graphics directive", "graphics array", 
      "graphics column", "graphics complex", "graphics directive", 
      "graphics grid", "graphics group", "graphics row", "image array", 
      "inset 3D graphics into graphics", "inset graphic into graphics", 
      "inset text into graphics", "multiple directives", "overlaying plots", 
      "picture array", "polygon mesh", "positioning", "position offset", 
      "redisplay graphics", "redraw plot", "relative position", 
      "superimposing graphics", "surface data", "surface graphics", 
      "surface mesh", "surface polygons", "surface triangulation", 
      "tables of graphics", "transforming graphics"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "The symbolic character of Mathematica graphics makes it straightforward \
to combine together different graphics constructs, both for presentation and \
interactive behavior--and efficiently maintain a variety of types of \
constraints.", "synonyms" -> {}, "title" -> "Combining Graphics", "type" -> 
    "Guide", "uri" -> "guide/CombiningGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->14688],
Cell[678, 28, 342, 8, 70, "GuideAbstract",
 CellID->13401],
Cell[1023, 38, 264, 9, 70, "GuideText",
 CellID->5002],
Cell[1290, 49, 44, 1, 70, "GuideDelimiter",
 CellID->10585],
Cell[1337, 52, 412, 11, 70, "GuideText",
 CellID->24182],
Cell[1752, 65, 411, 11, 70, "GuideText",
 CellID->10285],
Cell[2166, 78, 190, 6, 70, "GuideText",
 CellID->27088],
Cell[2359, 86, 44, 1, 70, "GuideDelimiter",
 CellID->31426],
Cell[2406, 89, 399, 12, 70, "GuideText",
 CellID->28617],
Cell[2808, 103, 439, 11, 70, "GuideText",
 CellID->23757],
Cell[CellGroupData[{
Cell[3272, 118, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->9832],
Cell[3340, 121, 1061, 26, 70, "InlineGuideFunctionListing",
 CellID->30932]
}, Open  ]],
Cell[CellGroupData[{
Cell[4438, 152, 60, 1, 70, "GuideFunctionsSubsection",
 CellID->4169],
Cell[4501, 155, 1064, 26, 70, "InlineGuideFunctionListing",
 CellID->2154]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5614, 187, 58, 1, 70, "GuideTutorialsSection",
 CellID->25721],
Cell[5675, 190, 172, 3, 70, "GuideTutorial",
 CellID->4003787],
Cell[5850, 195, 162, 3, 70, "GuideTutorial",
 CellID->512868203],
Cell[6015, 200, 173, 3, 70, "GuideTutorial",
 CellID->96742094],
Cell[6191, 205, 409, 12, 70, "GuideTutorial",
 CellID->60508230],
Cell[6603, 219, 166, 3, 70, "GuideTutorial",
 CellID->912269080],
Cell[6772, 224, 160, 3, 70, "GuideTutorial",
 CellID->28810171]
}, Open  ]],
Cell[CellGroupData[{
Cell[6969, 232, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31329],
Cell[7031, 235, 163, 3, 70, "GuideMoreAbout",
 CellID->28692],
Cell[7197, 240, 159, 3, 70, "GuideMoreAbout",
 CellID->2368]
}, Open  ]],
Cell[7371, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

