(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8295,        308]
NotebookOptionsPosition[      5175,        212]
NotebookOutlinePosition[      6399,        243]
CellTagsIndexPosition[      6356,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Compression and Archive Formats", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically handles all standard compression and archive formats",
 ". "
}], "GuideAbstract",
 CellID->501714423],

Cell[CellGroupData[{

Cell["Common Formats", "GuideFunctionsSubsection",
 CellID->1201979730],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"ZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ZIP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Windows ZIP archive (.zip)"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"GZIP\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/GZIP"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix gzip compression (.gz)"
}], "GuideText",
 CellID->993919825],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"TAR\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/TAR"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix tar archive (.tar)"
}], "GuideText",
 CellID->799170720],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"BZIP2\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BZIP2"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "bzip2 compression format (.bz2)"
}], "GuideText",
 CellID->1841642524]
}, Open  ]],

Cell[CellGroupData[{

Cell["Encoding Formats", "GuideFunctionsSubsection",
 CellID->1494378212],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Base64\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Base64"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Base64 ASCII encoding"
}], "GuideText",
 CellID->1193357419],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"UUE\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/UUE"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Unix uuencode format (.uue, .enc)"
}], "GuideText",
 CellID->1408361800]
}, Open  ]],

Cell[CellGroupData[{

Cell["Serialization Formats", "GuideFunctionsSubsection",
 CellID->772015366],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"WDX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/WDX"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Wolfram optimized data exchange format (.wdx)"
}], "GuideText",
 CellID->252500494],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"MX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MX"]], "InlineFunctionSans"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " serialized package (.mx)"
}], "GuideText",
 CellID->785864125],

Cell["\t", "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],

Cell[CellGroupData[{

Cell["Common Elements", "GuideFunctionsSubsection",
 CellID->20474],

Cell["\<\
\"Files\" \[LongDash] names of available files\
\>", "GuideText",
 CellID->454366380],

Cell["\<\
\"Elements\" \[LongDash] all available elements\
\>", "GuideText",
 CellID->11500518],

Cell["\t", "GuideDelimiter",
 CellID->373333540],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileHash",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileHash"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "compute MD5 and other hash codes for files"
}], "GuideText",
 CellID->79035]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "GuideTutorial",
 CellID->60324697],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "GuideTutorial",
 CellID->207014367]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "GuideMoreAbout",
 CellID->479778287],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compression and Archive Formats - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 27.4663962}", "context" -> "", 
    "keywords" -> {
     "checksum", "CRC", "CRC32", "digest", "file hash", "hash", "hash code", 
      "hashcode", "hashing", "MD2", "MD5", "SHA", "ZIP", "GZIP", "TAR", 
      "tar.gz"}, "index" -> True, "label" -> "Mathematica Guide", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica automatically handles all standard compression and archive \
formats. ", "synonyms" -> {}, "title" -> "Compression and Archive Formats", 
    "type" -> "Guide", "uri" -> "guide/CompressionAndArchiveFormats"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 73, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[695, 28, 183, 6, 70, "GuideAbstract",
 CellID->501714423],
Cell[CellGroupData[{
Cell[903, 38, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->1201979730],
Cell[977, 41, 252, 8, 70, "GuideText",
 CellID->1463276848],
Cell[1232, 51, 254, 8, 70, "GuideText",
 CellID->993919825],
Cell[1489, 61, 248, 8, 70, "GuideText",
 CellID->799170720],
Cell[1740, 71, 266, 9, 70, "GuideText",
 CellID->1841642524]
}, Open  ]],
Cell[CellGroupData[{
Cell[2043, 85, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->1494378212],
Cell[2119, 88, 253, 8, 70, "GuideText",
 CellID->1193357419],
Cell[2375, 98, 259, 8, 70, "GuideText",
 CellID->1408361800]
}, Open  ]],
Cell[CellGroupData[{
Cell[2671, 111, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->772015366],
Cell[2751, 114, 270, 8, 70, "GuideText",
 CellID->252500494],
Cell[3024, 124, 255, 9, 70, "GuideText",
 CellID->785864125],
Cell[3282, 135, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->8546]
}, Open  ]],
Cell[CellGroupData[{
Cell[3372, 141, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->20474],
Cell[3442, 144, 95, 3, 70, "GuideText",
 CellID->454366380],
Cell[3540, 149, 95, 3, 70, "GuideText",
 CellID->11500518],
Cell[3638, 154, 48, 1, 70, "GuideDelimiter",
 CellID->373333540],
Cell[3689, 157, 412, 12, 70, "GuideText",
 CellID->79035]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4150, 175, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[4215, 178, 173, 3, 70, "GuideTutorial",
 CellID->60324697],
Cell[4391, 183, 172, 3, 70, "GuideTutorial",
 CellID->207014367]
}, Open  ]],
Cell[CellGroupData[{
Cell[4600, 191, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[4665, 194, 146, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[4814, 199, 158, 3, 70, "GuideMoreAbout",
 CellID->479778287],
Cell[4975, 204, 158, 3, 70, "GuideMoreAboutSub",
 CellID->19396]
}, Open  ]],
Cell[5148, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

