(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20182,        595]
NotebookOptionsPosition[     12931,        429]
NotebookOutlinePosition[     17579,        510]
CellTagsIndexPosition[     17536,        507]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Computational Geometry", "GuideTitle",
 CellID->4313],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s strengths in algebraic computation and graphics as well as numerics \
combine to bring unprecedented flexibility and power to geometric \
computation. Making extensive use of original algorithms developed at Wolfram \
Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s ability to represent and manipulate geometry symbolically allows it for \
the first time to fully integrate generation, analysis and rendering of \
geometrical structures."
}], "GuideAbstract",
 CellID->24355],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find nearest points in any number of dimensions with any metric"
}], "GuideText",
 CellID->10808],

Cell[TextData[{
 Cell[TextData[ButtonBox["NearestFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NearestFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a function created to repeatedly find nearest points"
}], "GuideText",
 CellID->1832],

Cell["\t", "GuideDelimiter",
 CellID->20945],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolically reduce real, complex and integer geometry descriptions"
}], "GuideText",
 CellID->27756],

Cell[TextData[{
 Cell[TextData[ButtonBox["CylindricalDecomposition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["GroebnerBasis",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real, complex decompositions"
}], "GuideText",
 CellID->28321],

Cell["\t", "GuideDelimiter",
 CellID->19558],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot regions defined by inequalities"
}], "GuideText",
 CellID->23646],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find areas and volumes of geometric regions"
}], "GuideText",
 CellID->27982],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NMinimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NMinimize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "globally minimize over geometric regions"
}], "GuideText",
 CellID->481],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearProgramming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearProgramming"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "minimize over finite or infinite polyhedral regions"
}], "GuideText",
 CellID->4144],

Cell["\t", "GuideDelimiter",
 CellID->23196],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["GraphPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "2D, 3D graph layout"
}], "GuideText",
 CellID->20222],

Cell["\t", "GuideDelimiter",
 CellID->82740012],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyhedronData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolyhedronData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "geometrical and structural data on regular polyhedra"
}], "GuideText",
 CellID->806729914],

Cell[TextData[{
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->19343916],

Cell["\t", "GuideDelimiterSubsection",
 CellID->151684169],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Geometric Transformations \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeometricTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->548827765],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TransformationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TransformationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->442155286],

Cell["\t", "GuideDelimiterSubsection",
 CellID->29714480]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Geometry Formats \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/3DGeometryAndModelingFormats"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->11173],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"DXF\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/DXF"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"PLY\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/PLY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"BYU\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/BYU"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"X3D\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/X3D"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"STL\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/STL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->10466]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->12044],

Cell[TextData[ButtonBox["Introduction to Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]], "GuideTutorial",
 CellID->60414979],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "GuideTutorial",
 CellID->737499578],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfSolutionSets"]], "GuideTutorial",
 CellID->21659]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->26439],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAbout",
 CellID->17253],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "GuideMoreAbout",
 CellID->20024],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "GuideMoreAbout",
 CellID->26154],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/guide/ComputationalGeometryPackage"]], \
"GuideMoreAboutSub",
 CellID->91496645],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Quaternions/guide/QuaternionsPackage"]], "GuideMoreAboutSub",
 CellID->146725770],

Cell[TextData[ButtonBox["Polyhedron Operations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PolyhedronOperations/guide/PolyhedronOperationsPackage"]], \
"GuideMoreAboutSub",
 CellID->964768108],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAboutSub",
 CellID->279765346]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->464265187],

Cell[TextData[{
 ButtonBox["Demonstrations related to Computational Geometry",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22computational+geometry%22+content%3AAffineTransform+OR+\
CylindricalDecomposition+OR+GraphData+OR+GraphPlot+OR+GraphPlot3D+OR+\
GroebnerBasis+OR+Integrate+OR+KnotData+OR+LatticeData+OR+LinearProgramming+OR+\
Minimize+OR+Nearest+OR+NearestFunction+OR+NIntegrate+OR+NMinimize+OR+\
PolyhedronData+OR+Reduce+OR+RegionPlot+OR+RegionPlot3D+OR+RotationTransform+\
OR+TransformationMatrix"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->155377236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Computational Geometry - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 27.7476534}", "context" -> "", 
    "keywords" -> {
     "3D graph drawing", "3D graph embedding", "3D graph layout", 
      "3D graph visualization", "3D network layout", 
      "3D network visualization", "affine transform", "affine transformation",
       "algebraic algorithms", "algebraic equations", "algebraic geometry", 
      "algebraic inequalities", "algebraic varieties", 
      "Archimedean polyhedra", "Archimidean polyhedra", "area", "CAD", 
      "Cartesian product cubature", "catastrophe theory", 
      "commutative algebra", "complex variables", "composite quadrature", 
      "constrained optimization", "cost function", "cubature", 
      "cylindrical algebraic decomposition", "cylindrical decomposition", 
      "cylindrical parts", "differential equations", "digraph layout", 
      "Diophantine equations", "domains", "double exponential integration", 
      "draw a graph", "Dwight's tables", "elimination basis", 
      "exact optimization", "extremization", "figure eight", 
      "Gaussian quadrature", "Gauss integration", "Gauss-Kronrod integration",
       "Genz-Malik algorithm", "Genz-Malik cubature", 
      "global adaptive integration", "global minimization", "goal functions", 
      "Gradshteyn-Ryzhik", "graph data", "graph drawing", "graph embedding", 
      "graph layout", "graph plot", "graph plot3", "graph plot 3D", 
      "graph visualization", "Grobner basis", "Groebner basis", 
      "Groebner Walk algorithm", "Hardy-Muskat-Williams methods", 
      "ideal basis", "ideal operations", "ideals", "inequalities", 
      "infeasible constraints", "integer equations", 
      "integer linear programming", "integer programming", "integration", 
      "integration over regions", "interior point methods", "lattice", 
      "Lie algebras", "Lie groups", "linear constraints", "linear equations", 
      "linear fractional programming", "linear inequalities", 
      "linear objective function", "linear optimization", 
      "linear programming", "LP", "measures", "mensuration", "minimization", 
      "modular equations", "Monte Carlo integration", 
      "multi-panel quadrature", "multiple integrals", "nearest function", 
      "network data", "network layout", "network visualization", 
      "Newton-Cotes integration", "normal form", "numerical integration", 
      "numerical minimization", "objective functions", "operations research", 
      "optimization", "parametric optimization", "pay-off functions", 
      "Pell equations", "Platonic solids", "plot a graph", "plot region", 
      "plot volume", "polyhedron data", "polynomial equations", 
      "polynomial inequalities", "polynomial programming", "polytopes", 
      "primary decomposition", "projection of algebraic set", 
      "quadratic programming", "reducing inequalities", "region integrals", 
      "region plot", "region plot3", "region plot 3D", "polygonal regions", 
      "regular polyhedra", "root lattices", "rotation transform", 
      "Schlaefli symbol", "semi-algebraic sets", "simplex algorithm", 
      "standard basis", "symbolic optimization", "transcendental equations", 
      "transcendental inequalities", "transformation matrix", 
      "trapezoidal integration", "varieties", "volume integrals", "volumes", 
      "Weninger model", "Wythoff symbol", "Zariski closure"}, "index" -> True,
     "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's strengths in algebraic computation and graphics as well as \
numerics combine to bring unprecedented flexibility and power to geometric \
computation. Making extensive use of original algorithms developed at Wolfram \
Research, Mathematica's ability to represent and manipulate geometry \
symbolically allows it for the first time to fully integrate generation, \
analysis and rendering of geometrical structures.", "synonyms" -> {}, "title" -> 
    "Computational Geometry", "type" -> "Guide", "uri" -> 
    "guide/ComputationalGeometry"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->4313],
Cell[681, 28, 564, 13, 70, "GuideAbstract",
 CellID->24355],
Cell[1248, 43, 431, 12, 70, "GuideText",
 CellID->10808],
Cell[1682, 57, 435, 12, 70, "GuideText",
 CellID->1832],
Cell[2120, 71, 44, 1, 70, "GuideDelimiter",
 CellID->20945],
Cell[2167, 74, 288, 9, 70, "GuideText",
 CellID->27756],
Cell[2458, 85, 422, 13, 70, "GuideText",
 CellID->28321],
Cell[2883, 100, 44, 1, 70, "GuideDelimiter",
 CellID->19558],
Cell[2930, 103, 690, 19, 70, "GuideText",
 CellID->23646],
Cell[3623, 124, 401, 13, 70, "GuideText",
 CellID->27982],
Cell[4027, 139, 392, 13, 70, "GuideText",
 CellID->481],
Cell[4422, 154, 293, 9, 70, "GuideText",
 CellID->4144],
Cell[4718, 165, 44, 1, 70, "GuideDelimiter",
 CellID->23196],
Cell[4765, 168, 669, 19, 70, "GuideText",
 CellID->20222],
Cell[5437, 189, 47, 1, 70, "GuideDelimiter",
 CellID->82740012],
Cell[5487, 192, 438, 12, 70, "GuideText",
 CellID->806729914],
Cell[5928, 206, 901, 23, 70, "InlineGuideFunctionListing",
 CellID->19343916],
Cell[6832, 231, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->151684169],
Cell[CellGroupData[{
Cell[6915, 236, 234, 6, 70, "GuideFunctionsSubsection",
 CellID->548827765],
Cell[7152, 244, 1311, 32, 70, "InlineGuideFunctionListing",
 CellID->442155286],
Cell[8466, 278, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->29714480]
}, Open  ]],
Cell[CellGroupData[{
Cell[8560, 284, 228, 5, 70, "GuideFunctionsSubsection",
 CellID->11173],
Cell[8791, 291, 1249, 36, 70, "InlineGuideFunctionListing",
 CellID->10466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10089, 333, 58, 1, 70, "GuideTutorialsSection",
 CellID->12044],
Cell[10150, 336, 171, 3, 70, "GuideTutorial",
 CellID->60414979],
Cell[10324, 341, 152, 3, 70, "GuideTutorial",
 CellID->737499578],
Cell[10479, 346, 184, 4, 70, "GuideTutorial",
 CellID->21659]
}, Open  ]],
Cell[CellGroupData[{
Cell[10700, 355, 59, 1, 70, "GuideMoreAboutSection",
 CellID->26439],
Cell[10762, 358, 137, 3, 70, "GuideMoreAbout",
 CellID->17253],
Cell[10902, 363, 137, 3, 70, "GuideMoreAbout",
 CellID->20024],
Cell[11042, 368, 163, 3, 70, "GuideMoreAbout",
 CellID->26154],
Cell[11208, 373, 204, 5, 70, "GuideMoreAboutSub",
 CellID->91496645],
Cell[11415, 380, 172, 4, 70, "GuideMoreAboutSub",
 CellID->146725770],
Cell[11590, 386, 202, 5, 70, "GuideMoreAboutSub",
 CellID->964768108],
Cell[11795, 393, 159, 3, 70, "GuideMoreAboutSub",
 CellID->279765346]
}, Open  ]],
Cell[CellGroupData[{
Cell[11991, 401, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->464265187],
Cell[12063, 404, 826, 20, 70, "GuideRelatedLinks",
 CellID->155377236]
}, Open  ]],
Cell[12904, 427, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

