(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17003,        539]
NotebookOptionsPosition[     10898,        390]
NotebookOutlinePosition[     14366,        454]
CellTagsIndexPosition[     14323,        451]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Conditionals", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic character allows a powerful unification of the notion of \
conditionals in programming and in mathematics."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Testing Expressions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TestingExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->446120002],

Cell[TextData[{
 Cell[TextData[ButtonBox["Equal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["==",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Equal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Unequal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!=",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unequal"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["===",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["And",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["&&",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/And"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TestingExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5629054],

Cell["\t", "GuideDelimiterSubsection",
 CellID->115070465]
}, Open  ]],

Cell[CellGroupData[{

Cell["Procedural Conditionals", "GuideFunctionsSubsection",
 CellID->129365695],

Cell[TextData[{
 Cell[TextData[ButtonBox["If",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/If"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test if a condition is true, false, or of unknown truth value"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Which",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Which"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test which of a sequence of conditions are true"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["Switch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Switch"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " switch based on a value, with patterns allowed"
}], "GuideText",
 CellID->76019498],

Cell["\t", "GuideDelimiterSubsection",
 CellID->389886880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Mathematical Function Conditionals \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->19809634],

Cell[TextData[{
 Cell[TextData[ButtonBox["Piecewise",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Piecewise"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " an arbitrary piecewise function"
}], "GuideText",
 CellID->39788925],

Cell[TextData[{
 Cell[TextData[ButtonBox["UnitStep",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/UnitStep"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sign",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sign"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Floor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Floor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Boole",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Boole"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/NumericalFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->664942068],

Cell["\t", "GuideDelimiterSubsection",
 CellID->71563015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Pattern-Based Conditionals \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RulesAndPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->684097168],

Cell[TextData[{
 Cell[TextData[ButtonBox["Replace",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Replace"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "replace an expression if a rule applies"
}], "GuideText",
 CellID->253753706],

Cell[TextData[{
 Cell[TextData[ButtonBox["Condition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["/;",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Condition"]], "InlineFunctionSans"],
 ") \[LongDash] specify an arbitrary condition for a pattern to match"
}], "GuideText",
 CellID->239319583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Functional Programming Conditionals \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionalIteration"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->168180679],

Cell[TextData[{
 Cell[TextData[ButtonBox["NestWhile",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestWhile"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TakeWhile",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TakeWhile"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/FunctionalIteration"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->228752066]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["List-Based Conditionals \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ElementsOfLists"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->534567645],

Cell[TextData[{
 Cell[TextData[ButtonBox["Select",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Select"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pick",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pick"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ElementsOfLists"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->27765663],

Cell["\t", "GuideDelimiterSubsection",
 CellID->361600376]
}, Open  ]],

Cell[CellGroupData[{

Cell["Program Execution Conditionals", "GuideFunctionsSubsection",
 CellID->284251023],

Cell[TextData[{
 Cell[TextData[ButtonBox["Check",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Check"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "GuideTutorial",\

 CellID->1885805579],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "GuideTutorial",
 CellID->437251728],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/RelationalAndLogicalOperators"]], "GuideTutorial",
 CellID->248188573]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Flow Control in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "GuideMoreAboutSub",
 CellID->57647321],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Conditionals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 29.3101934}", "context" -> "", 
    "keywords" -> {
     "aliquant", "ampersand", "and", "applicability of transformation rules", 
      "biconditional", "Boolean algebra", "Boolean tests", "branch", "Cases", 
      "characteristic function", "choose", "choose elements", 
      "combine conditions", "conditional", "conditional iteration", 
      "conditionals", "conditions", "congruence", "constrained memory", 
      "constraints", "control flow", "criteria", "data driven iteration", 
      "deleting elements", "delta function", "discontinuous functions", 
      "domain", "else", "equality testing", "equivalence", 
      "equivalent expressions", "errors", "evaluation with limited memory", 
      "evaluation with time constraints", "FEM", "filtering lists", 
      "finite memory", "first occurrence", "functional while operation", 
      "Heaviside step function", "hybrid systems", "identical", 
      "identical expressions", "indicator function", "inequality", 
      "inequation", "intersection", "interval-defined functions", "irem", 
      "Iverson's convention", "logical connective", "logical product", 
      "masking", "matching", "mathematical equivalence", "memory constrained",
       "memory constraints", "multiple conditional", "multiple cases", 
      "mu operator", "nearest integer function", "nest while", "not-equal", 
      "not equal", "number sign", "numerical overflow", "one-origin arrays", 
      "one-sided functions", "pattern condition", "patterns", "pick elements",
       "picking elements of lists", "piecewise continuous functions", 
      "piecewise functions", "predicates", "provided that", "ramp function", 
      "restricted pattern", "restriction", 
      "restrictions on transformation rules", "round down", "rounddown", 
      "same expressions", "satisfying criterion", "saturation function", 
      "sawtooth function", "sectionally defined functions", "sgn", "sign", 
      "signum", "slash-semi", "square wave", "step function", 
      "structural equivalence", "switching", "switching algebra", 
      "take while", "testing equality", "testing for equivalence", 
      "testing for integers", "testing for literal equality", "then", 
      "threshold function", "time constrained", "time constraints", 
      "transformation rules", "trapping errors", "unequal", "unit step", 
      "unit step function", "until", "whenever", "where", "while", 
      "wraparound", "zero-origin arrays", "branching"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's symbolic character allows a powerful unification of the \
notion of conditionals in programming and in mathematics.", "synonyms" -> {}, 
    "title" -> "Conditionals", "type" -> "Guide", "uri" -> 
    "guide/Conditionals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[676, 28, 228, 6, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[929, 38, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->446120002],
Cell[1157, 45, 1630, 55, 70, "InlineGuideFunctionListing",
 CellID->5629054],
Cell[2790, 102, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->115070465]
}, Open  ]],
Cell[CellGroupData[{
Cell[2885, 108, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->129365695],
Cell[2967, 111, 278, 9, 70, "GuideText",
 CellID->203374175],
Cell[3248, 122, 271, 9, 70, "GuideText",
 CellID->1463276848],
Cell[3522, 133, 265, 8, 70, "GuideText",
 CellID->76019498],
Cell[3790, 143, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->389886880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3885, 149, 241, 6, 70, "GuideFunctionsSubsection",
 CellID->19809634],
Cell[4129, 157, 256, 8, 70, "GuideText",
 CellID->39788925],
Cell[4388, 167, 1205, 35, 70, "InlineGuideFunctionListing",
 CellID->664942068],
Cell[5596, 204, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->71563015]
}, Open  ]],
Cell[CellGroupData[{
Cell[5690, 210, 232, 6, 70, "GuideFunctionsSubsection",
 CellID->684097168],
Cell[5925, 218, 266, 9, 70, "GuideText",
 CellID->253753706],
Cell[6194, 229, 367, 10, 70, "GuideText",
 CellID->239319583]
}, Open  ]],
Cell[CellGroupData[{
Cell[6598, 244, 244, 6, 70, "GuideFunctionsSubsection",
 CellID->168180679],
Cell[6845, 252, 761, 20, 70, "InlineGuideFunctionListing",
 CellID->228752066]
}, Open  ]],
Cell[CellGroupData[{
Cell[7643, 277, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->534567645],
Cell[7872, 284, 797, 23, 70, "InlineGuideFunctionListing",
 CellID->27765663],
Cell[8672, 309, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->361600376]
}, Open  ]],
Cell[CellGroupData[{
Cell[8767, 315, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->284251023],
Cell[8856, 318, 629, 17, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9534, 341, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9599, 344, 143, 3, 70, "GuideTutorial",
 CellID->806871991],
Cell[9745, 349, 181, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[9929, 355, 156, 3, 70, "GuideTutorial",
 CellID->437251728],
Cell[10088, 360, 183, 4, 70, "GuideTutorial",
 CellID->248188573]
}, Open  ]],
Cell[CellGroupData[{
Cell[10308, 369, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10373, 372, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10529, 377, 164, 3, 70, "GuideMoreAboutSub",
 CellID->57647321],
Cell[10696, 382, 160, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[10871, 388, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

