(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13305,        428]
NotebookOptionsPosition[      8871,        312]
NotebookOutlinePosition[     11296,        361]
CellTagsIndexPosition[     11253,        358]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Constructing Matrices", "GuideTitle",
 CellID->17773],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a range of methods for representing and constructing matrices. \
Especially powerful are symbolic representations, in terms of symbolic \
systems of equations, symbolic sparse or banded matrices, and symbolic \
geometric transformations",
 ". "
}], "GuideAbstract",
 CellID->32270],

Cell[TextData[{
 Cell[TextData[ButtonBox["Table",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Table"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a matrix from an expression"
}], "GuideText",
 CellID->13985],

Cell[TextData[{
 Cell[TextData[ButtonBox["Array",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Array"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a matrix from a function"
}], "GuideText",
 CellID->3102],

Cell[TextData[{
 Cell[TextData[ButtonBox["CoefficientArrays",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoefficientArrays"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a matrix from a system of equations"
}], "GuideText",
 CellID->8480],

Cell["\t", "GuideDelimiter",
 CellID->29213],

Cell[TextData[{
 Cell[TextData[ButtonBox["SparseArray",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SparseArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "construct a sparse matrix from positions and values"
}], "GuideText",
 CellID->7627],

Cell[TextData[{
 Cell[TextData[ButtonBox["Normal",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Normal"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert a sparse matrix to ordinary form"
}], "GuideText",
 CellID->4802],

Cell[TextData[{
 Cell[TextData[ButtonBox["Band",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Band"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "give values on any collection of bands, for tridiagonal etc. matrices"
}], "GuideText",
 CellID->33236430],

Cell["\t", "GuideDelimiter",
 CellID->4099],

Cell[TextData[{
 Cell[TextData[ButtonBox["IdentityMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiagonalMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ConstantArray",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ConstantArray"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->47528263],

Cell["\t", "GuideDelimiter",
 CellID->39581549],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayFlatten",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ArrayFlatten"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "flatten a matrix of matrices to make a block matrix "
}], "GuideText",
 CellID->1543],

Cell[TextData[{
 Cell[TextData[ButtonBox["Partition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Partition"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "partition a list to make a matrix"
}], "GuideText",
 CellID->1924],

Cell[TextData[{
 Cell[TextData[ButtonBox["Join",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Join"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " join several matrices to make a matrix"
}], "GuideText",
 CellID->450155438],

Cell[TextData[{
 Cell[TextData[ButtonBox["PadLeft",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadLeft"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["PadRight",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PadRight"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pad out a ragged array"
}], "GuideText",
 CellID->11023],

Cell["\t", "GuideDelimiter",
 CellID->171874833],

Cell[TextData[{
 Cell[TextData[ButtonBox["HilbertMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HilbertMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HankelMatrix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ToeplitzMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToeplitzMatrix"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->289569622],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Geometric Matrices \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeometricTransforms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->314892872],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScalingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ScalingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ShearingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GeometricTransforms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->251953115]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->29972],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingMatrices"]], "GuideTutorial",
 CellID->133685174],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "GuideTutorial",\

 CellID->18761341],

Cell[TextData[ButtonBox["Building Lists from Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BuildingListsFromFunctions"]], "GuideTutorial",
 CellID->188919415]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31003],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "GuideMoreAbout",
 CellID->27593],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAbout",
 CellID->27432],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "GuideMoreAbout",
 CellID->17505],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constructing Matrices - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 30.8571080}", "context" -> "", 
    "keywords" -> {
     "array flatten", "arrays", "band-diagonal matrices", "blocking lists", 
      "blocks", "catenating lists", "circular partitioning", 
      "coefficient arrays", "concatenating lists", "constant array", 
      "cyclic partitioning", "diagonal matrix", "flat list", "flatten matrix",
       "gathering elements in lists", "homogeneous forms", "identity", 
      "identity array", "identity matrix", "join block matrices", 
      "join lists", "linear equations", "lists", "matrices", 
      "matrix diagonal", "merging lists", "nary forms", "neighborhoods", 
      "normal window frame option", "one-dimensional list", "overhangs", 
      "pad left", "pad right", "padding", "partitioning lists", 
      "position-value pairs", "quadratic forms", "repeating expressions", 
      "replicating expressions", "reshape in APL", "rotation matrix", 
      "scaling matrix", "shearing matrix", "sparse array", "sparse matrix", 
      "sparse representation", "sparse vector", "special matrices", 
      "splicing", "splitting lists", "structured matrix", "sublists", 
      "tables", "tabulation of values", "tensors", "unflatten", "unit array", 
      "unit diagonal", "unit matrix", "wraparound partitioning"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica provides a range of methods for representing and \
constructing matrices. Especially powerful are symbolic representations, in \
terms of symbolic systems of equations, symbolic sparse or banded matrices, \
and symbolic geometric transformations. ", "synonyms" -> {}, "title" -> 
    "Constructing Matrices", "type" -> "Guide", "uri" -> 
    "guide/ConstructingMatrices"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 59, 1, 70, "GuideTitle",
 CellID->17773],
Cell[681, 28, 358, 9, 70, "GuideAbstract",
 CellID->32270],
Cell[1042, 39, 256, 9, 70, "GuideText",
 CellID->13985],
Cell[1301, 50, 252, 9, 70, "GuideText",
 CellID->3102],
Cell[1556, 61, 287, 9, 70, "GuideText",
 CellID->8480],
Cell[1846, 72, 44, 1, 70, "GuideDelimiter",
 CellID->29213],
Cell[1893, 75, 281, 9, 70, "GuideText",
 CellID->7627],
Cell[2177, 86, 260, 9, 70, "GuideText",
 CellID->4802],
Cell[2440, 97, 434, 12, 70, "GuideText",
 CellID->33236430],
Cell[2877, 111, 43, 1, 70, "GuideDelimiter",
 CellID->4099],
Cell[2923, 114, 782, 20, 70, "InlineGuideFunctionListing",
 CellID->47528263],
Cell[3708, 136, 47, 1, 70, "GuideDelimiter",
 CellID->39581549],
Cell[3758, 139, 429, 12, 70, "GuideText",
 CellID->1543],
Cell[4190, 153, 259, 9, 70, "GuideText",
 CellID->1924],
Cell[4452, 164, 254, 8, 70, "GuideText",
 CellID->450155438],
Cell[4709, 174, 372, 13, 70, "GuideText",
 CellID->11023],
Cell[5084, 189, 48, 1, 70, "GuideDelimiter",
 CellID->171874833],
Cell[5135, 192, 634, 17, 70, "InlineGuideFunctionListing",
 CellID->289569622],
Cell[CellGroupData[{
Cell[5794, 213, 225, 5, 70, "GuideFunctionsSubsection",
 CellID->314892872],
Cell[6022, 220, 1289, 32, 70, "InlineGuideFunctionListing",
 CellID->251953115]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7360, 258, 58, 1, 70, "GuideTutorialsSection",
 CellID->29972],
Cell[7421, 261, 160, 3, 70, "GuideTutorial",
 CellID->133685174],
Cell[7584, 266, 158, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[7745, 271, 176, 4, 70, "GuideTutorial",
 CellID->18761341],
Cell[7924, 277, 174, 3, 70, "GuideTutorial",
 CellID->188919415]
}, Open  ]],
Cell[CellGroupData[{
Cell[8135, 285, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31003],
Cell[8197, 288, 148, 3, 70, "GuideMoreAbout",
 CellID->27593],
Cell[8348, 293, 146, 3, 70, "GuideMoreAbout",
 CellID->27432],
Cell[8497, 298, 127, 3, 70, "GuideMoreAbout",
 CellID->17505],
Cell[8627, 303, 202, 4, 70, "GuideMoreAbout",
 CellID->95291904]
}, Open  ]],
Cell[8844, 310, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

