(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31157,        931]
NotebookOptionsPosition[     24890,        772]
NotebookOutlinePosition[     28146,        832]
CellTagsIndexPosition[     28103,        829]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Control Objects", "GuideTitle",
 CellID->142],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a full range of control objects, all specified in convenient \
symbolic form. ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " uses many of these objects automatically; you can also use them directly \
as part of generalized input, or in building your own dynamic interfaces."
}], "GuideAbstract",
 CellID->17222],

Cell[TextData[{
 Cell[TextData[ButtonBox["Slider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["VerticalSlider",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/VerticalSlider"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 "  ",
 Cell[BoxData[
  SliderBox[0.5,
   ImageSize->40]]],
 "       ",
 Cell[TextData[ButtonBox["Slider2D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Slider2D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 "  ",
 Cell[BoxData[
  Slider2DBox[{0.5, 0.5},
   ImageSize->18]]]
}], "GuideText",
 CellID->19187],

Cell[TextData[{
 Cell[TextData[ButtonBox["Checkbox",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Checkbox"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  CheckboxBox[True]]],
 "       ",
 Cell[TextData[ButtonBox["RadioButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RadioButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  RadioButtonBox[True, {True}]]],
 "      ",
 Cell[TextData[ButtonBox["Opener",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Opener"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 Cell[BoxData[
  OpenerBox[False]]]
}], "GuideText",
 CellID->8360],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorSlider",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ColorSlider"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interactively select a color"
}], "GuideText",
 CellID->714654581],

Cell[TextData[{
 Cell[TextData[ButtonBox["Setter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Setter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set a value when pressed: ",
 Cell[BoxData[
  SetterBox[1, {0}, "\[LongDash]"]]],
 " ",
 Cell[BoxData[
  SetterBox[1, {1}, "\[LongDash]"]]]
}], "GuideText",
 CellID->22413],

Cell[TextData[{
 Cell[TextData[ButtonBox["Toggler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Toggler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "toggle through values when clicked"
}], "GuideText",
 CellID->30974],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetterBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SetterBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RadioButtonBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["CheckboxBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CheckboxBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["TogglerBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TogglerBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "arrays of buttons"
}], "GuideText",
 CellID->767638699],

Cell[TextData[{
 Cell[TextData[ButtonBox["PopupMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "menu of choices"
}], "GuideText",
 CellID->14270],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InputField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "field for strings, numbers or any expression"
}], "GuideText",
 CellID->29170],

Cell[TextData[{
 Cell[TextData[ButtonBox["LocatorPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocatorPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " movable locators on graphics or other backgrounds"
}], "GuideText",
 CellID->105518980],

Cell[TextData[{
 Cell[TextData[ButtonBox["Animator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Animator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Manipulator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Locator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Locator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ProgressIndicator",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ProgressIndicator"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Trigger",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Trigger"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->30833],

Cell["\t", "GuideDelimiter",
 CellID->7285],

Cell[TextData[{
 Cell[TextData[ButtonBox["Button",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Button"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " button with any form and action"
}], "GuideText",
 CellID->12550],

Cell[TextData[{
 Cell[TextData[ButtonBox["PasteButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PasteButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "button to paste an expression"
}], "GuideText",
 CellID->140],

Cell[TextData[{
 Cell[TextData[ButtonBox["ActionMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ActionMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "menu of actions to choose"
}], "GuideText",
 CellID->13694],

Cell[TextData[{
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "low-level event handler"
}], "GuideText",
 CellID->2695],

Cell[TextData[{
 Cell[TextData[ButtonBox["MousePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MousePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControlActive",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControlActive"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->138191179],

Cell["\t", "GuideDelimiter",
 CellID->21624],

Cell[TextData[{
 Cell[TextData[ButtonBox["FileNameSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FileNameSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " system ",
 "file browser"
}], "GuideText",
 CellID->18896],

Cell[TextData[{
 Cell[TextData[ButtonBox["ColorSetter",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ColorSetter"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " system color picker"
}], "GuideText",
 CellID->25760],

Cell[TextData[{
 Cell[TextData[ButtonBox["SystemDialogInput",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemDialogInput"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "files, fonts, sounds, etc."
}], "GuideText",
 CellID->4667],

Cell["\t", "GuideDelimiter",
 CellID->183934086],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hyperlink",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Hyperlink"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general hyperlink to cells and URLs"
}], "GuideText",
 CellID->28019],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Annotations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ViewersAndAnnotation"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->2125],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PopupWindow",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PopupWindow"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Labeled",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ViewersAndAnnotation"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26576]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Programming with Controls \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicInteractivityLanguage"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->21694],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MousePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MousePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Setting",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Setting"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DynamicSetting",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicSetting"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->22658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Structuring and Layout \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/UserInterfaceStructuringAndLayout"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->26302],

Cell[TextData[{
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Row",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Panel",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pane",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->47402468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Controls Options \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ControlsOptions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->22466],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->{{"Link"}, "ExcludedObject"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Appearance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Appearance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deployed",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deployed"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Enabled",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Enabled"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AutoAction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AutoAction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ControlsOptions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4678]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Creating Separate Windows \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CustomInterfaceConstruction"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->53895345],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChoiceDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreatePalette",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreateDialog",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreateDocument",
  BaseStyle->{"Link"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CustomInterfaceConstruction"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->367338170]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->22593],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "GuideTutorial",
 CellID->367381208],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "GuideTutorial",
 CellID->590664718]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->1018],

Cell[TextData[ButtonBox["Viewers & Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "GuideMoreAbout",
 CellID->28464],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "GuideMoreAboutSub",
 CellID->23152],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAboutSub",\

 CellID->2800],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "GuideMoreAboutSub",
 CellID->174612369]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Control Objects - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 35.1072168}", "context" -> "", 
    "keywords" -> {
     "2D layout", "action menu", "animator", "applet window", "auto action", 
      "background panel", "balloon help", "calculation delay", "cell opener", 
      "section opener", "closed cell opener", "checkbox", "checkbox bar", 
      "choice dialog", "choose color", "click-interactive", "click pane", 
      "color chooser", "color control", "color dialog", "color palette", 
      "color picker", "color picking tool", "color selection dialog", 
      "color selector", "color setter", "color slider", "color swatch", 
      "color wheel", "control active", "controller state", "create dialog", 
      "create document", "create palette", "current value", "delay feedback", 
      "display panel", "dynamical setting", "dynamic variables", 
      "dynamic control", "dynamic module", "dynamic setting", "event handler",
       "event handling", "file browser", "file chooser", "file dialog", 
      "file name input", "file name setter", "file picker", 
      "file-selection dialog", "file setter", "flipping state", "grip", 
      "handle", "hyperlink button", "hyper-reference", "hypertext", 
      "image map", "imagemap", "input bar", "input box", "input field", 
      "knob", "link to page", "link to web", "locator pane", 
      "manipulate control", "manipulator", "menu bar", "mode switching", 
      "mouse over", "mouse position", "movable thumb", "multilocator", 
      "multiple selection control", "opener", "opener triangle", 
      "paste button", "playing a slider", "popup box", "popup menu", 
      "popup window", "progress display", "progress indicator", 
      "progress meter", "radio button", "radio button bar", "screen tip", 
      "ScreenTip", "scrollbar", "setter", "setter bar", "setter control", 
      "single selection control", "slider", "slider pane", "status area", 
      "status area window element", "system dialog input", "tab selector", 
      "tabular layout", "tabulation", "tab view", "tab view control", "thumb",
       "toggle", "toggler", "toggler bar", "vertical slider", 
      "GUI components", "widgets"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica provides a full range of control objects, all specified in \
convenient symbolic form. Manipulate uses many of these objects \
automatically; you can also use them directly as part of generalized input, \
or in building your own dynamic interfaces.", "synonyms" -> {}, "title" -> 
    "Control Objects", "type" -> "Guide", "uri" -> "guide/ControlObjects"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 51, 1, 70, "GuideTitle",
 CellID->142],
Cell[673, 28, 616, 14, 70, "GuideAbstract",
 CellID->17222],
Cell[1292, 44, 1092, 34, 70, "GuideText",
 CellID->19187],
Cell[2387, 80, 1149, 37, 70, "GuideText",
 CellID->8360],
Cell[3539, 119, 263, 9, 70, "GuideText",
 CellID->714654581],
Cell[3805, 130, 499, 16, 70, "GuideText",
 CellID->22413],
Cell[4307, 148, 402, 12, 70, "GuideText",
 CellID->30974],
Cell[4712, 162, 1231, 33, 70, "GuideText",
 CellID->767638699],
Cell[5946, 197, 387, 12, 70, "GuideText",
 CellID->14270],
Cell[6336, 211, 418, 12, 70, "GuideText",
 CellID->29170],
Cell[6757, 225, 424, 11, 70, "GuideText",
 CellID->105518980],
Cell[7184, 238, 1971, 50, 70, "InlineGuideFunctionListing",
 CellID->30833],
Cell[9158, 290, 43, 1, 70, "GuideDelimiter",
 CellID->7285],
Cell[9204, 293, 392, 11, 70, "GuideText",
 CellID->12550],
Cell[9599, 306, 403, 12, 70, "GuideText",
 CellID->140],
Cell[10005, 320, 399, 12, 70, "GuideText",
 CellID->13694],
Cell[10407, 334, 400, 12, 70, "GuideText",
 CellID->2695],
Cell[10810, 348, 1434, 35, 70, "InlineGuideFunctionListing",
 CellID->138191179],
Cell[12247, 385, 44, 1, 70, "GuideDelimiter",
 CellID->21624],
Cell[12294, 388, 401, 12, 70, "GuideText",
 CellID->18896],
Cell[12698, 402, 390, 11, 70, "GuideText",
 CellID->25760],
Cell[13091, 415, 413, 12, 70, "GuideText",
 CellID->4667],
Cell[13507, 429, 48, 1, 70, "GuideDelimiter",
 CellID->183934086],
Cell[13558, 432, 407, 12, 70, "GuideText",
 CellID->28019],
Cell[CellGroupData[{
Cell[13990, 448, 214, 5, 70, "GuideFunctionsSubsection",
 CellID->2125],
Cell[14207, 455, 1787, 46, 70, "InlineGuideFunctionListing",
 CellID->26576]
}, Open  ]],
Cell[CellGroupData[{
Cell[16031, 506, 239, 6, 70, "GuideFunctionsSubsection",
 CellID->21694],
Cell[16273, 514, 1997, 51, 70, "InlineGuideFunctionListing",
 CellID->22658]
}, Open  ]],
Cell[CellGroupData[{
Cell[18307, 570, 239, 5, 70, "GuideFunctionsSubsection",
 CellID->26302],
Cell[18549, 577, 1681, 45, 70, "InlineGuideFunctionListing",
 CellID->47402468]
}, Open  ]],
Cell[CellGroupData[{
Cell[20267, 627, 215, 5, 70, "GuideFunctionsSubsection",
 CellID->22466],
Cell[20485, 634, 1799, 46, 70, "InlineGuideFunctionListing",
 CellID->4678]
}, Open  ]],
Cell[CellGroupData[{
Cell[22321, 685, 241, 6, 70, "GuideFunctionsSubsection",
 CellID->53895345],
Cell[22565, 693, 1102, 30, 70, "InlineGuideFunctionListing",
 CellID->367338170]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23716, 729, 58, 1, 70, "GuideTutorialsSection",
 CellID->22593],
Cell[23777, 732, 163, 3, 70, "GuideTutorial",
 CellID->367381208],
Cell[23943, 737, 152, 3, 70, "GuideTutorial",
 CellID->590664718]
}, Open  ]],
Cell[CellGroupData[{
Cell[24132, 745, 58, 1, 70, "GuideMoreAboutSection",
 CellID->1018],
Cell[24193, 748, 153, 3, 70, "GuideMoreAbout",
 CellID->28464],
Cell[24349, 753, 167, 3, 70, "GuideMoreAboutSub",
 CellID->23152],
Cell[24519, 758, 173, 4, 70, "GuideMoreAboutSub",
 CellID->2800],
Cell[24695, 764, 153, 3, 70, "GuideMoreAboutSub",
 CellID->174612369]
}, Open  ]],
Cell[24863, 770, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

