(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12428,        388]
NotebookOptionsPosition[      7800,        274]
NotebookOutlinePosition[     10683,        331]
CellTagsIndexPosition[     10640,        328]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Converting between Expressions & Strings", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Expressions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can be represented as strings in a variety of ways, for display, export, \
or processing. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides powerful functions for formatting expressions as strings, and for \
parsing strings to determine the expressions they represent."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert any expression to a string"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert a string to an expression"
}], "GuideText",
 CellID->1463276848],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Format Types \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalTypesetting"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->447076277],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OutputForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OutputForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StandardForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StandardForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TraditionalForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TraditionalForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TeXForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TeXForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicalTypesetting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->703923094],

Cell[TextData[{
 Cell[TextData[ButtonBox["SyntaxQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SyntaxQ"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SyntaxLength",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SyntaxLength"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test syntactic correctness of input strings"
}], "GuideText",
 CellID->278731420],

Cell["\t", "GuideDelimiter",
 CellID->317956879],

Cell[TextData[{
 Cell[TextData[ButtonBox["ImportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImportString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "import many formats of strings to give expressions"
}], "GuideText",
 CellID->568712506],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExportString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExportString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "export expressions to give many formats of strings"
}], "GuideText",
 CellID->439520780],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->51922194],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Special Conversions", "GuideFunctionsSubsection",
 CellID->38151903],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert an integer to a string"
}], "GuideText",
 CellID->67699379],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["DateString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert between string and list forms of dates"
}], "GuideText",
 CellID->339556293],

Cell[TextData[{
 Cell[TextData[ButtonBox["Symbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Symbol"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["SymbolName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SymbolName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert between strings and symbols"
}], "GuideText",
 CellID->482445433]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Textual Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "GuideTutorial",
 CellID->332380744],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfTextualForms"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheInterpretationOfTextualForms"]], "GuideTutorial",
 CellID->297761464],

Cell[TextData[ButtonBox["Converting between Strings, Boxes and Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]], \
"GuideTutorial",
 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Box Representations of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Converting between Expressions & Strings - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 36.4197504}", "context" -> "", 
    "keywords" -> {
     "1D format", "ascii 2D output", "ascii input syntax", "ascii output", 
      "checking grammar in strings", "classical notation", 
      "construct string from expression", "conversion", "convert expression", 
      "convert number", "error syntax in string", "export string", 
      "expression conversion", "expressions", "expression to string", 
      "formula display", "formula markup", "formula typesetting", "grammar", 
      "import data from string", "import string", "input as string", 
      "input form", "integer string", "interpretation of input", 
      "invisible tags", "linear formatting", "linear input", 
      "mathematical markup", "mathematical notation", 
      "mathematical typesetting", "output form", "output formatting", 
      "output in TeX form", "parse date", "parsing of strings", 
      "publication format", "read data from string", "read formatted string", 
      "read string", "scientific typesetting", "standard form", 
      "standard representation", "string 2D output", "string format", 
      "string from expression", "StringImport", "StringInteger", 
      "symbol name", "syntax checking", "syntax checking in strings", 
      "syntax length", "technical typesetting", "tex form", "TeX output", 
      "textbook notation", "textual form of expression", "to expression", 
      "to string", "traditional form", "traditional notation", 
      "transform expression to string", "two-dimensional format", 
      "two-dimensional input", "two-dimensional output", 
      "unicode input syntax", "using strings as input", "year", 
      "serialization"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Expressions in Mathematica can be represented as strings in a variety of \
ways, for display, export, or processing. Mathematica provides powerful \
functions for formatting expressions as strings, and for parsing strings to \
determine the expressions they represent.", "synonyms" -> {}, "title" -> 
    "Converting between Expressions & Strings", "type" -> "Guide", "uri" -> 
    "guide/ConvertingBetweenExpressionsAndStrings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 82, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[704, 28, 413, 11, 70, "GuideAbstract",
 CellID->2001916300],
Cell[1120, 41, 263, 9, 70, "GuideText",
 CellID->203374175],
Cell[1386, 52, 271, 9, 70, "GuideText",
 CellID->1463276848],
Cell[CellGroupData[{
Cell[1682, 65, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->447076277],
Cell[1908, 72, 1266, 35, 70, "InlineGuideFunctionListing",
 CellID->703923094],
Cell[3177, 109, 405, 13, 70, "GuideText",
 CellID->278731420],
Cell[3585, 124, 48, 1, 70, "GuideDelimiter",
 CellID->317956879],
Cell[3636, 127, 287, 9, 70, "GuideText",
 CellID->568712506],
Cell[3926, 138, 287, 9, 70, "GuideText",
 CellID->439520780],
Cell[4216, 149, 540, 14, 70, "InlineGuideFunctionListing",
 CellID->51922194],
Cell[4759, 165, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[4854, 171, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->38151903],
Cell[4931, 174, 413, 12, 70, "GuideText",
 CellID->67699379],
Cell[5347, 188, 696, 19, 70, "GuideText",
 CellID->339556293],
Cell[6046, 209, 391, 13, 70, "GuideText",
 CellID->482445433]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6486, 228, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6551, 231, 164, 3, 70, "GuideTutorial",
 CellID->332380744],
Cell[6718, 236, 189, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[6910, 242, 188, 4, 70, "GuideTutorial",
 CellID->297761464],
Cell[7101, 248, 216, 5, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[7354, 258, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7419, 261, 156, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[7578, 266, 180, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554]
}, Open  ]],
Cell[7773, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

