(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28082,        829]
NotebookOptionsPosition[     22021,        671]
NotebookOutlinePosition[     24650,        722]
CellTagsIndexPosition[     24607,        719]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Custom Interface Construction", "GuideTitle",
 CellID->12896],

Cell[TextData[{
 "For many applications, high-level constructs like ",
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " and ",
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " will immediately give you the dynamic interactivity you need. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " also allows you to create your own sophisticated custom interfaces, using \
its uniquely straightforward symbolic interface-building technology. "
}], "GuideAbstract",
 CellID->13022],

Cell[TextData[{
 Cell[TextData[ButtonBox["Manipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Manipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create an interface to manipulate any expression or graphic"
}], "GuideText",
 CellID->24737512],

Cell[TextData[{
 Cell[TextData[ButtonBox["ControllerManipulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create an interface using external controllers"
}], "GuideText",
 CellID->132074270],

Cell["\t", "GuideDelimiter",
 CellID->138083589],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display as the dynamically updated current value"
}], "GuideText",
 CellID->18696],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicModule",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicModule"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "interface localization construct"
}], "GuideText",
 CellID->11585],

Cell["\t", "GuideDelimiterSubsection",
 CellID->757901389],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Palettes \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Palettes"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->57037504],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreatePalette",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreatePalette"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "create a new palette from a symbolic expression"
}], "GuideText",
 CellID->786173691],

Cell[TextData[{
 Cell[TextData[ButtonBox["Button",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Button"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PasteButton",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PasteButton"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Column",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Column"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WindowTitle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WindowTitle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Palettes"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->17048302],

Cell["\t", "GuideDelimiterSubsection",
 CellID->192485876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Toolbars \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/Toolbars"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->368967589],

Cell[TextData[{
 Cell[TextData[ButtonBox["DockedCells",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DockedCells"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "arbitrary cells to be docked at the top of a notebook"
}], "GuideText",
 CellID->156929472],

Cell["\t", "GuideDelimiterSubsection",
 CellID->309313113]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Dialog Boxes \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DialogBoxes"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->552265928],

Cell[TextData[{
 Cell[TextData[ButtonBox["Input",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Input"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InputString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputString"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "put up a dialog to get input"
}], "GuideText",
 CellID->552478604],

Cell[TextData[{
 Cell[TextData[ButtonBox["MessageDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MessageDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " put up a dialog box to display a message"
}], "GuideText",
 CellID->13615517],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChoiceDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " put up a dialog box with buttons to make choices"
}], "GuideText",
 CellID->78296311],

Cell[TextData[{
 Cell[TextData[ButtonBox["DialogInput",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DialogInput"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CreateDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CreateDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DialogReturn",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DialogReturn"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SystemDialogInput",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SystemDialogInput"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->389515900],

Cell[TextData[{
 Cell[TextData[ButtonBox["Button",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Button"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Checkbox",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Checkbox"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InputField",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/InputField"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Panel",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Panel"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TabView",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TabView"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Grid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Grid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DialogBoxes"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->229781873],

Cell["\t", "GuideDelimiterSubsection",
 CellID->216134136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Inspectors \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CreatingInspectors"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->7923208],

Cell[TextData[{
 Cell[TextData[ButtonBox["CurrentValue",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CurrentValue"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "test or set hundreds of interface values"
}], "GuideText",
 CellID->16972],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Options",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Options"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SetOptions",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetOptions"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PaletteNotebook",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CreatingInspectors"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->359786071],

Cell["\t", "GuideDelimiterSubsection",
 CellID->235934817]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Click-Interactive Panels \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ClickInteractivePanels"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->198101056],

Cell[TextData[{
 Cell[TextData[ButtonBox["LocatorPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LocatorPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ClickPane",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ClickPane"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mouseover",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Mouseover"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deploy"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ClickInteractivePanels"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->263391284],

Cell["\t", "GuideDelimiterSubsection",
 CellID->187993253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Stand-Alone Interfaces \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StandAloneInterfaces"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->34738038],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrontEndEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrontEndEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FrontEndExecute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ActionMenu",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ActionMenu"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Deploy",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Deploy"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandAloneInterfaces"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->63410084],

Cell["\t", "GuideDelimiterSubsection",
 CellID->510500813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Low-Level Interface Control \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/LowLevelInterfaceControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->72858751],

Cell[TextData[{
 Cell[TextData[ButtonBox["MousePosition",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MousePosition"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EventHandler",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EventHandler"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CellEventActions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CellEventActions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ControllerState",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ControllerState"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelInterfaceControl"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->157245392]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->2963],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "GuideMoreAbout",
 CellID->2607],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "GuideMoreAboutSub",
 CellID->202113698],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "GuideMoreAbout",
 CellID->911],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "GuideMoreAbout",
 CellID->11635],

Cell[TextData[ButtonBox["Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NotebookAndInterfaceCustomization"]], "GuideMoreAbout",
 CellID->617977633],

Cell[TextData[ButtonBox["Characters for User Interfaces & Documentation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CharactersForUserInterfacesAndDocumentation"]], \
"GuideMoreAboutSub",
 CellID->67807653],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "GuideMoreAboutSub",
 CellID->16525797],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "GuideMoreAboutSub",\

 CellID->561619196],

Cell[TextData[StyleBox[ButtonBox["GUIKit",
 BaseStyle->"Link",
 ButtonData->"paclet:GUIKit/guide/GUIKitPackage"],
 FontSlant->"Italic"]], "GuideMoreAboutSub",
 CellID->4675],

Cell[TextData[StyleBox[ButtonBox["J/Link",
 BaseStyle->"Link",
 ButtonData->"paclet:JLink/guide/JavaUserInterfaces"],
 FontSlant->"Italic"]], "GuideMoreAboutSub",
 CellID->12938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Custom Interface Construction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 42.8886660}", "context" -> "", 
    "keywords" -> {
     "2D layout", "action menu", "applets", "applet window", 
      "background panel", "cell event actions", "checkbox", "choice dialog", 
      "click-interactive", "click-interactive panels", "click pane", 
      "controller manipulate", "controller state", "controls", 
      "create dialog", "create palette", "current value", "dialog input", 
      "dialog return", "direct manipulation", "display panel", "docked cells",
       "dynamic module", "event handler", "event handling", 
      "finding options for output", "finding options for streams", 
      "front end event actions", "front end execute", "gamepad", 
      "graphical user interface", "GUI", "GUI programming", "hit testing", 
      "image map", "imagemap", "input bar", "input box", "input field", 
      "input string", "interactive", "interactive panels", "interface", 
      "interface builder", "joystick", "label", "locator pane", "menu bar", 
      "message dialog", "mouse interactive", "mouse over", "mouse position", 
      "multilocator", "palette notebook", "paste button", "reading files", 
      "requesting input", "reset medium", "resetting PageWidth", "slider", 
      "slider pane", "system dialog input", "tab selector", "tabular layout", 
      "tabulation", "tab view", "tab view control", "thumbs", "title", 
      "toggle", "user interface", "window title"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "For many applications, high-level constructs like Manipulate and TabView \
will immediately give you the dynamic interactivity you need. Mathematica \
also allows you to create your own sophisticated custom interfaces, using its \
uniquely straightforward symbolic interface-building technology. ", 
    "synonyms" -> {}, "title" -> "Custom Interface Construction", "type" -> 
    "Guide", "uri" -> "guide/CustomInterfaceConstruction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 67, 1, 70, "GuideTitle",
 CellID->12896],
Cell[689, 28, 916, 21, 70, "GuideAbstract",
 CellID->13022],
Cell[1608, 51, 436, 12, 70, "GuideText",
 CellID->24737512],
Cell[2047, 65, 444, 12, 70, "GuideText",
 CellID->132074270],
Cell[2494, 79, 48, 1, 70, "GuideDelimiter",
 CellID->138083589],
Cell[2545, 82, 416, 12, 70, "GuideText",
 CellID->18696],
Cell[2964, 96, 412, 12, 70, "GuideText",
 CellID->11585],
Cell[3379, 110, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->757901389],
Cell[CellGroupData[{
Cell[3462, 115, 203, 5, 70, "GuideFunctionsSubsection",
 CellID->57037504],
Cell[3668, 122, 431, 12, 70, "GuideText",
 CellID->786173691],
Cell[4102, 136, 1800, 47, 70, "InlineGuideFunctionListing",
 CellID->17048302],
Cell[5905, 185, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->192485876]
}, Open  ]],
Cell[CellGroupData[{
Cell[6000, 191, 204, 5, 70, "GuideFunctionsSubsection",
 CellID->368967589],
Cell[6207, 198, 433, 12, 70, "GuideText",
 CellID->156929472],
Cell[6643, 212, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->309313113]
}, Open  ]],
Cell[CellGroupData[{
Cell[6738, 218, 211, 5, 70, "GuideFunctionsSubsection",
 CellID->552265928],
Cell[6952, 225, 384, 13, 70, "GuideText",
 CellID->552478604],
Cell[7339, 240, 418, 11, 70, "GuideText",
 CellID->13615517],
Cell[7760, 253, 424, 11, 70, "GuideText",
 CellID->78296311],
Cell[8187, 266, 1432, 35, 70, "InlineGuideFunctionListing",
 CellID->389515900],
Cell[9622, 303, 2290, 59, 70, "InlineGuideFunctionListing",
 CellID->229781873],
Cell[11915, 364, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->216134136]
}, Open  ]],
Cell[CellGroupData[{
Cell[12010, 370, 214, 5, 70, "GuideFunctionsSubsection",
 CellID->7923208],
Cell[12227, 377, 418, 12, 70, "GuideText",
 CellID->16972],
Cell[12648, 391, 1331, 35, 70, "InlineGuideFunctionListing",
 CellID->359786071],
Cell[13982, 428, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->235934817]
}, Open  ]],
Cell[CellGroupData[{
Cell[14077, 434, 236, 6, 70, "GuideFunctionsSubsection",
 CellID->198101056],
Cell[14316, 442, 1978, 50, 70, "InlineGuideFunctionListing",
 CellID->263391284],
Cell[16297, 494, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->187993253]
}, Open  ]],
Cell[CellGroupData[{
Cell[16392, 500, 229, 5, 70, "GuideFunctionsSubsection",
 CellID->34738038],
Cell[16624, 507, 1501, 38, 70, "InlineGuideFunctionListing",
 CellID->63410084],
Cell[18128, 547, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->510500813]
}, Open  ]],
Cell[CellGroupData[{
Cell[18223, 553, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->72858751],
Cell[18466, 561, 1664, 42, 70, "InlineGuideFunctionListing",
 CellID->157245392]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20179, 609, 58, 1, 70, "GuideMoreAboutSection",
 CellID->2963],
Cell[20240, 612, 141, 3, 70, "GuideMoreAbout",
 CellID->2607],
Cell[20384, 617, 153, 3, 70, "GuideMoreAboutSub",
 CellID->202113698],
Cell[20540, 622, 148, 3, 70, "GuideMoreAbout",
 CellID->911],
Cell[20691, 627, 170, 3, 70, "GuideMoreAbout",
 CellID->11635],
Cell[20864, 632, 187, 4, 70, "GuideMoreAbout",
 CellID->617977633],
Cell[21054, 638, 213, 5, 70, "GuideMoreAboutSub",
 CellID->67807653],
Cell[21270, 645, 170, 3, 70, "GuideMoreAboutSub",
 CellID->16525797],
Cell[21443, 650, 179, 4, 70, "GuideMoreAboutSub",
 CellID->561619196],
Cell[21625, 656, 173, 4, 70, "GuideMoreAboutSub",
 CellID->4675],
Cell[21801, 662, 178, 4, 70, "GuideMoreAboutSub",
 CellID->12938]
}, Open  ]],
Cell[21994, 669, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

