(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12597,        390]
NotebookOptionsPosition[      7764,        272]
NotebookOutlinePosition[     10655,        327]
CellTagsIndexPosition[     10612,        324]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Data Transforms and Smoothing", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Directly integrated into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s uniform architecture for handling lists of data is an array of highly \
optimized algorithms for transforming and smoothing datasets that can \
routinely involve millions of elements."
}], "GuideAbstract",
 CellID->210391540],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rescale",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Rescale"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Clip",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Clip"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Normalize",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Normalize"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Accumulate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Accumulate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell["\t", "GuideDelimiter",
 CellID->75982476],

Cell[TextData[{
 Cell[TextData[ButtonBox["MovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the simple moving average with any span"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExponentialMovingAverage",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ExponentialMovingAverage"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the exponential moving average with damping"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["MovingMedian",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MovingMedian"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the moving median with any span"
}], "GuideText",
 CellID->86789298],

Cell["\t", "GuideDelimiter",
 CellID->1000658441],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interpolation"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find an interpolation of any order in any number of dimensions"
}], "GuideText",
 CellID->150919988],

Cell["\t", "GuideDelimiter",
 CellID->73313958],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "linear least-squares fit"
}], "GuideText",
 CellID->147097774],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindFit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindFit"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find a constrained nonlinear fit to data"
}], "GuideText",
 CellID->780191249],

Cell["\t", "GuideDelimiter",
 CellID->22669051],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListCorrelate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListCorrelate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " correlate data with any kernel"
}], "GuideText",
 CellID->283091111],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply a cellular automaton rule in any number of dimensions"
}], "GuideText",
 CellID->458090460],

Cell[TextData[{
 Cell[TextData[ButtonBox["Fourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fourier"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["InverseFourier",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFourier"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "discrete Fourier transform and inverse"
}], "GuideText",
 CellID->38080943]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Curve Fitting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CurveFitting"]], "GuideTutorial",
 CellID->478798714],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "GuideTutorial",\

 CellID->806871991]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Fitting Data",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "GuideMoreAboutSub",
 CellID->102112033],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->3287673],

Cell[TextData[{
 ButtonBox["Demonstrations related to Data Transforms and Smoothing",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
Accumulate+OR+CellularAutomaton+OR+Clip+OR+ExponentialMovingAverage+OR+\
FindFit+OR+Fit+OR+Fourier+OR+Interpolation+OR+InverseFourier+OR+ListCorrelate+\
OR+MovingAverage+OR+MovingMedian+OR+Normalize+OR+Rescale)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->240984280]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Data Transforms and Smoothing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 45.9824952}", "context" -> "", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "bezier curve", 
      "bilinear interpolation", "block maps", "b-spline", "b spline", 
      "chi squared", "continuous mappings of the shift", 
      "Cooley-Tukey transform", "correlations", "coupled map lattices", 
      "crop", "cubic spline", "curve fitting", "curves", "data", 
      "data filter", "data filtering", "data smoother", "data smoothing", 
      "discrete Fourier transform", "discrete models", "EMA", "EWMA", 
      "exponential moving average", "exponential smoother", 
      "exponential smoothing", "exponential weighted moving average", 
      "extrapolation", "FFT", "filter", "filter taps", "find fit", 
      "finite impulse response filter", "FIR filter", "fits", 
      "fitting curves", "fitting differential equations", "fitting of data", 
      "fitting surfaces", "Fourier transforms", "frequency spectrum", 
      "image transform", "interp", "interpolate data", "interpolate equation",
       "interpolate formula", "interpolate numbers", "interpolate table", 
      "inverse Fourier", "iterative arrays", "least-squares fits", 
      "length of vector", "limiting function", "linear fits", 
      "linear interpolation", "linear moving average", "list correlate", "MA",
       "models", "moving average", "moving mean", "moving median", 
      "nonlinear fitting", "normalize vector", "polyautomata", 
      "polynomial fit", "power spectrum", "ramp", "renormalize", "residuals", 
      "rule 30", "rule numbers", "simple moving average", "SMA", "spectrum", 
      "splines", "tesselation automata", "testing models", "transform", 
      "trend line", "trim", "weighted moving average", "WMA"}, "index" -> 
    True, "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Directly integrated into Mathematica's uniform architecture for handling \
lists of data is an array of highly optimized algorithms for transforming and \
smoothing datasets that can routinely involve millions of elements.", 
    "synonyms" -> {}, "title" -> "Data Transforms and Smoothing", "type" -> 
    "Guide", "uri" -> "guide/DataTransformsAndSmoothing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 71, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[693, 28, 325, 8, 70, "GuideAbstract",
 CellID->210391540],
Cell[1021, 38, 1097, 29, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[2121, 69, 47, 1, 70, "GuideDelimiter",
 CellID->75982476],
Cell[2171, 72, 423, 11, 70, "GuideText",
 CellID->203374175],
Cell[2597, 85, 450, 11, 70, "GuideText",
 CellID->1463276848],
Cell[3050, 98, 412, 11, 70, "GuideText",
 CellID->86789298],
Cell[3465, 111, 49, 1, 70, "GuideDelimiter",
 CellID->1000658441],
Cell[3517, 114, 301, 9, 70, "GuideText",
 CellID->150919988],
Cell[3821, 125, 47, 1, 70, "GuideDelimiter",
 CellID->73313958],
Cell[3871, 128, 243, 9, 70, "GuideText",
 CellID->147097774],
Cell[4117, 139, 267, 9, 70, "GuideText",
 CellID->780191249],
Cell[4387, 150, 47, 1, 70, "GuideDelimiter",
 CellID->22669051],
Cell[4437, 153, 264, 8, 70, "GuideText",
 CellID->283091111],
Cell[4704, 163, 306, 9, 70, "GuideText",
 CellID->458090460],
Cell[5013, 174, 403, 13, 70, "GuideText",
 CellID->38080943]
}, Open  ]],
Cell[CellGroupData[{
Cell[5453, 192, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5518, 195, 144, 3, 70, "GuideTutorial",
 CellID->478798714],
Cell[5665, 200, 198, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[5866, 206, 177, 4, 70, "GuideTutorial",
 CellID->806871991]
}, Open  ]],
Cell[CellGroupData[{
Cell[6080, 215, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6145, 218, 168, 4, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6316, 224, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[6469, 229, 141, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[6613, 234, 157, 3, 70, "GuideMoreAboutSub",
 CellID->102112033],
Cell[6773, 239, 180, 3, 70, "GuideMoreAbout",
 CellID->140580976]
}, Open  ]],
Cell[CellGroupData[{
Cell[6990, 247, 67, 1, 70, "GuideRelatedLinksSection",
 CellID->3287673],
Cell[7060, 250, 662, 17, 70, "GuideRelatedLinks",
 CellID->240984280]
}, Open  ]],
Cell[7737, 270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

