(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20732,        641]
NotebookOptionsPosition[     14813,        487]
NotebookOutlinePosition[     17672,        542]
CellTagsIndexPosition[     17629,        539]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Data Visualization", "GuideTitle",
 CellID->2223],

Cell[TextData[{
 "Using a host of original algorithms developed at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides powerful functions that automate the process of creating \
cognitively and aesthetically compelling representations of structured and \
unstructured data\[LongDash]not only for points, lines and surfaces, but also \
for graphs and networks."
}], "GuideAbstract",
 CellID->100397130],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot lists of points"
}], "GuideText",
 CellID->20175],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListLinePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLinePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot lines through lists of points"
}], "GuideText",
 CellID->21459],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListLogLinearPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListLogLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ListPolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->34683661],

Cell["\t", "GuideDelimiter",
 CellID->17825],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListPlot3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D plot from lists of 3D height data"
}], "GuideText",
 CellID->3221],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListPointPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "3D point scatter plot"
}], "GuideText",
 CellID->69839121],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListSurfacePlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListSurfacePlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " surface reconstruction from 3D points"
}], "GuideText",
 CellID->1626],

Cell["\t", "GuideDelimiter",
 CellID->546111885],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListContourPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ListDensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " contour and density plots from height values "
}], "GuideText",
 CellID->17870],

Cell[TextData[{
 Cell[TextData[ButtonBox["ListContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ListContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D contour surfaces from 3D field values"
}], "GuideText",
 CellID->31934],

Cell["\t", "GuideDelimiter",
 CellID->15205],

Cell[TextData[{
 Cell[TextData[ButtonBox["ArrayPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArrayPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot an array of values or colors"
}], "GuideText",
 CellID->31783],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReliefPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReliefPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot an array with simulated relief"
}], "GuideText",
 CellID->45425955],

Cell[TextData[{
 Cell[TextData[ButtonBox["MatrixPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatrixPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot values in a matrix"
}], "GuideText",
 CellID->179439170],

Cell["\t", "GuideDelimiter",
 CellID->23850],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateListPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateListPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " date and time plots"
}], "GuideText",
 CellID->644776629],

Cell["\t", "GuideDelimiter",
 CellID->89069268],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "lay out a general graph"
}], "GuideText",
 CellID->22701],

Cell[TextData[{
 Cell[TextData[ButtonBox["LayeredGraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " draw a graph in a layered or hierarchical way"
}], "GuideText",
 CellID->704343987],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " draw a tree structure"
}], "GuideText",
 CellID->12193],

Cell["\t", "GuideDelimiterSubsection",
 CellID->3503],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Styling Options \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsOptionsAndStyling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14867],

Cell[TextData[{
 Cell[TextData[ButtonBox["Frame",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Frame"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotStyle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mesh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mesh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Annotation & Combination \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AnnotatingAndCombiningGraphics"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->41],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1881]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->12734],

Cell[TextData[ButtonBox["Introduction to Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]], "GuideTutorial",
 CellID->26534]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->5556],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->544867867],

Cell[TextData[ButtonBox["Plot Legends Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:PlotLegends/guide/PlotLegendsPackage"]], "GuideMoreAboutSub",
 CellID->1817544484],

Cell[TextData[ButtonBox["Bar Charts Package",
 BaseStyle->"Link",
 ButtonData->"paclet:BarCharts/guide/BarChartsPackage"]], "GuideMoreAboutSub",\

 CellID->195289224],

Cell[TextData[ButtonBox["Pie Charts Package",
 BaseStyle->"Link",
 ButtonData->"paclet:PieCharts/guide/PieChartsPackage"]], "GuideMoreAboutSub",\

 CellID->668655531],

Cell[TextData[ButtonBox["Histograms Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Histograms/guide/HistogramsPackage"]], "GuideMoreAboutSub",
 CellID->306249270],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/guide/StatisticalPlotsPackage"]], \
"GuideMoreAboutSub",
 CellID->595223209],

Cell[TextData[ButtonBox["Plotting with Error Bars",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ErrorBarPlots/guide/ErrorBarPlottingPackage"]], "GuideMoreAboutSub",\

 CellID->10471],

Cell[TextData[ButtonBox["Vector Field Plotting Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorFieldPlots/guide/VectorFieldPlottingPackage"]], \
"GuideMoreAboutSub",
 CellID->481063370],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAboutSub",
 CellID->20278],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "GuideMoreAbout",
 CellID->26738736],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60VisualizationAndGraphics"]], "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1568828936],

Cell[TextData[{
 ButtonBox["Demonstrations related to Data Visualization",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ArrayPlot+OR+DateListPlot+OR+Filling+OR+Frame+OR+GraphicsGrid+OR+GraphPlot+OR+\
ImageSize+OR+LayeredGraphPlot+OR+ListContourPlot+OR+ListContourPlot3D+OR+\
ListDensityPlot+OR+ListLinePlot+OR+ListLogLinearPlot+OR+ListLogLogPlot+OR+\
ListLogPlot+OR+ListPlot+OR+ListPlot3D+OR+ListPointPlot3D+OR+ListPolarPlot+OR+\
ListSurfacePlot3D+OR+MatrixPlot+OR+Mesh+OR+PlotStyle+OR+ReliefPlot+OR+\
StatusArea+OR+Tooltip+OR+TreePlot)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->3436366]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Data Visualization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 46.6231366}", "context" -> "", 
    "keywords" -> {
     "array plot", "balloon help", "bas-relief", "cartography", "color lines",
       "color of curves", "color of lines", "contour plots from lists", 
      "dashed lines", "dashing", "date list plot", "date plotting", 
      "density plots", "digraph layout", "draw a graph", "elements plot", 
      "embossing", "fill area", "financial plots", "flowchart layout", 
      "framed", "graph drawing", "graph embedding", "graphics", 
      "graphics array", "graphics grid", "graphics size", "graph layout", 
      "graph plot", "graph visualization", "hierarchical graph layout", 
      "image array", "image size", "interpolation surface ", 
      "layered graph plot", "line color", "list contour plot", 
      "list contour plot3", "list density plot", "list line plot", 
      "list log linear plot", "list log log plot", "list log plot", 
      "list plot3", "list point plot3", "list polar plot", 
      "list surface plot3", "mapping", "matrix plot", "matrix structure plot",
       "network layout", "network visualization", "picture array", 
      "picture size", "plot a graph", "plot style", "plotting in time", 
      "point plot", "popup box", "recursive drawing", "relief plot", 
      "relief shading", "rulings on surfaces", "scatter plot", "screen tip", 
      "ScreenTip", "shaded surface", "shading", "status area", 
      "status area window element", "style of curves", "style of lines", 
      "styles of multiple curves", "surface patch", "surface plot", 
      "tables of graphics", "terrain", "three-dimensional plots", 
      "time series plots", "tree plot", "width"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Using a host of original algorithms developed at Wolfram Research, \
Mathematica provides powerful functions that automate the process of creating \
cognitively and aesthetically compelling representations of structured and \
unstructured data--not only for points, lines and surfaces, but also for \
graphs and networks.", "synonyms" -> {}, "title" -> "Data Visualization", 
    "type" -> "Guide", "uri" -> "guide/DataVisualization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 55, 1, 70, "GuideTitle",
 CellID->2223],
Cell[677, 28, 431, 9, 70, "GuideAbstract",
 CellID->100397130],
Cell[1111, 39, 240, 8, 70, "GuideText",
 CellID->20175],
Cell[1354, 49, 407, 11, 70, "GuideText",
 CellID->21459],
Cell[1764, 62, 1437, 35, 70, "InlineGuideFunctionListing",
 CellID->34683661],
Cell[3204, 99, 44, 1, 70, "GuideDelimiter",
 CellID->17825],
Cell[3251, 102, 259, 8, 70, "GuideText",
 CellID->3221],
Cell[3513, 112, 408, 12, 70, "GuideText",
 CellID->69839121],
Cell[3924, 126, 419, 11, 70, "GuideText",
 CellID->1626],
Cell[4346, 139, 48, 1, 70, "GuideDelimiter",
 CellID->546111885],
Cell[4397, 142, 420, 12, 70, "GuideText",
 CellID->17870],
Cell[4820, 156, 423, 11, 70, "GuideText",
 CellID->31934],
Cell[5246, 169, 44, 1, 70, "GuideDelimiter",
 CellID->15205],
Cell[5293, 172, 255, 8, 70, "GuideText",
 CellID->31783],
Cell[5551, 182, 412, 12, 70, "GuideText",
 CellID->45425955],
Cell[5966, 196, 396, 11, 70, "GuideText",
 CellID->179439170],
Cell[6365, 209, 44, 1, 70, "GuideDelimiter",
 CellID->23850],
Cell[6412, 212, 396, 11, 70, "GuideText",
 CellID->644776629],
Cell[6811, 225, 47, 1, 70, "GuideDelimiter",
 CellID->89069268],
Cell[6861, 228, 395, 12, 70, "GuideText",
 CellID->22701],
Cell[7259, 242, 430, 11, 70, "GuideText",
 CellID->704343987],
Cell[7692, 255, 386, 11, 70, "GuideText",
 CellID->12193],
Cell[8081, 268, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->3503],
Cell[CellGroupData[{
Cell[8159, 273, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->14867],
Cell[8386, 280, 1374, 39, 70, "InlineGuideFunctionListing",
 CellID->24865]
}, Open  ]],
Cell[CellGroupData[{
Cell[9797, 324, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->41],
Cell[10037, 332, 1274, 33, 70, "InlineGuideFunctionListing",
 CellID->1881]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11360, 371, 58, 1, 70, "GuideTutorialsSection",
 CellID->12734],
Cell[11421, 374, 168, 3, 70, "GuideTutorial",
 CellID->26534]
}, Open  ]],
Cell[CellGroupData[{
Cell[11626, 382, 58, 1, 70, "GuideMoreAboutSection",
 CellID->5556],
Cell[11687, 385, 168, 3, 70, "GuideMoreAbout",
 CellID->544867867],
Cell[11858, 390, 174, 4, 70, "GuideMoreAboutSub",
 CellID->1817544484],
Cell[12035, 396, 166, 4, 70, "GuideMoreAboutSub",
 CellID->195289224],
Cell[12204, 402, 166, 4, 70, "GuideMoreAboutSub",
 CellID->668655531],
Cell[12373, 408, 169, 4, 70, "GuideMoreAboutSub",
 CellID->306249270],
Cell[12545, 414, 190, 5, 70, "GuideMoreAboutSub",
 CellID->595223209],
Cell[12738, 421, 182, 5, 70, "GuideMoreAboutSub",
 CellID->10471],
Cell[12923, 428, 197, 5, 70, "GuideMoreAboutSub",
 CellID->481063370],
Cell[13123, 435, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[13285, 440, 158, 3, 70, "GuideMoreAboutSub",
 CellID->20278],
Cell[13446, 445, 170, 3, 70, "GuideMoreAbout",
 CellID->26738736],
Cell[13619, 450, 187, 4, 70, "GuideMoreAbout",
 CellID->164100761]
}, Open  ]],
Cell[CellGroupData[{
Cell[13843, 459, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1568828936],
Cell[13916, 462, 855, 20, 70, "GuideRelatedLinks",
 CellID->3436366]
}, Open  ]],
Cell[14786, 485, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

