(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15736,        519]
NotebookOptionsPosition[     11292,        394]
NotebookOutlinePosition[     13224,        436]
CellTagsIndexPosition[     13181,        433]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Date & Time", "GuideTitle",
 CellID->21108],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a highly flexible system for handling dates and times in almost any \
format, automatically converting between formats, and when necessary parsing \
strings representing dates",
 ". "
}], "GuideAbstract",
 CellID->17207],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateString",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateString"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "current or specified date as a string in many possible formats"
}], "GuideText",
 CellID->24075],

Cell[TextData[{
 Cell[BoxData["\"\<DateTime\>\""], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["\"\<MonthName\>\""], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["\"\<Hour24\>\""], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->284967572],

Cell[TextData[{
 Cell[TextData[ButtonBox["$DateStringFormat",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "default date string format"
}], "GuideText",
 CellID->20124],

Cell[TextData[{
 Cell[TextData[ButtonBox["$TimeZone",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$TimeZone"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " resettable current time zone"
}], "GuideText",
 CellID->27607],

Cell["\t", "GuideDelimiter",
 CellID->17774],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateList",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateList"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " date elements as numbers in ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 " format"
}], "GuideText",
 CellID->2884],

Cell[TextData[{
 Cell[TextData[ButtonBox["AbsoluteTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "absolute time in seconds "
}], "GuideText",
 CellID->20128],

Cell[TextData[{
 Cell[TextData[ButtonBox["Clock",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Clock"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "real-time dynamic clock variable"
}], "GuideText",
 CellID->24546],

Cell["\t", "GuideDelimiterSubsection",
 CellID->20481],

Cell[CellGroupData[{

Cell["Date Operations", "GuideFunctionsSubsection",
 CellID->11714],

Cell[TextData[{
 Cell[TextData[ButtonBox["DatePlus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DatePlus"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " add or subtract days, weeks, etc. to a date list or string"
}], "GuideText",
 CellID->155887444],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateDifference",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DateDifference"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find the difference in days, weeks, etc. between two dates"
}], "GuideText",
 CellID->376015456],

Cell["\t", "GuideDelimiterSubsection",
 CellID->74057093]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization", "GuideFunctionsSubsection",
 CellID->24168],

Cell[TextData[{
 Cell[TextData[ButtonBox["DateListPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DateListPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot data associated with dates specified in any format"
}], "GuideText",
 CellID->405777220],

Cell["\t", "GuideDelimiterSubsection",
 CellID->204833331]
}, Open  ]],

Cell[CellGroupData[{

Cell["Date Import/Export", "GuideFunctionsSubsection",
 CellID->20307],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"Table\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Table"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MDB\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MDB"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MBOX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->418343597],

Cell[TextData[{
 Cell[TextData[ButtonBox["DatePattern",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DatePattern"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "date pattern for string manipulation"
}], "GuideText",
 CellID->301908451],

Cell[TextData[{
 Cell[TextData[ButtonBox["\"XLS\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/XLS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"ApacheLog\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\"MBOX\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/MBOX"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26793],

Cell["\t", "GuideDelimiterSubsection",
 CellID->23504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["CPU Timing \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TimeMeasurementAndOptimization"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->1105],

Cell[TextData[{
 Cell[TextData[ButtonBox["Timing",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Timing"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbsoluteTiming",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SessionTime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SessionTime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1697]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18217],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "GuideTutorial",
 CellID->191890443]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->2343],

Cell[TextData[ButtonBox["CPU Time & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "GuideMoreAbout",\

 CellID->26133],

Cell[TextData[ButtonBox["Integrated Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataCollections"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Calendar Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Calendar/guide/CalendarPackage"]], "GuideMoreAbout",
 CellID->85278997],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60DataHandlingAndDataSources"]], "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->503709486],

Cell[TextData[{
 ButtonBox["Demonstrations related to Date & Time",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AbsoluteTime+OR+AbsoluteTiming+OR+Clock+OR+DateDifference+OR+DateList+OR+\
DateListPlot+OR+DatePattern+OR+DatePlus+OR+DateString+OR+SessionTime+OR+\
TimeConstrained+OR+Timing+OR+$DateStringFormat+OR+$TimeZone)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->13951326]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Date & Time - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 47.2794034}", "context" -> "", 
    "keywords" -> {
     "absolute time", "absolute timing", "benchmark", "calendar", "clock", 
      "computer time", "CPU time", "date", "date as string", 
      "date difference", "date list", "date list plot", "date pattern", 
      "date plotting", "date plus", "date string", "date string format", 
      "date structure", "DateTime", "day", "elapsed time", 
      "evaluation with time constraints", "execution time", "hour", 
      "measurement of efficiency", "measure of speed", "minute", "month", 
      "NTP", "parse date", "performance analysis", "plotting in time", 
      "process time", "profiling", "real-time clock", "second", 
      "session time", "standard time", "system time", "time", 
      "time constrained", "time constraints", "time series plots", 
      "timestamp", "time zone", "wall clock time", "year"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica has a highly flexible system for handling dates and times in \
almost any format, automatically converting between formats, and when \
necessary parsing strings representing dates. ", "synonyms" -> {}, "title" -> 
    "Date & Time", "type" -> "Guide", "uri" -> "guide/DateAndTime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 49, 1, 70, "GuideTitle",
 CellID->21108],
Cell[671, 28, 292, 8, 70, "GuideAbstract",
 CellID->17207],
Cell[966, 38, 436, 12, 70, "GuideText",
 CellID->24075],
Cell[1405, 52, 670, 19, 70, "InlineGuideFunctionListing",
 CellID->284967572],
Cell[2078, 73, 414, 12, 70, "GuideText",
 CellID->20124],
Cell[2495, 87, 395, 11, 70, "GuideText",
 CellID->27607],
Cell[2893, 100, 44, 1, 70, "GuideDelimiter",
 CellID->17774],
Cell[2940, 103, 655, 21, 70, "GuideText",
 CellID->2884],
Cell[3598, 126, 258, 9, 70, "GuideText",
 CellID->20128],
Cell[3859, 137, 396, 12, 70, "GuideText",
 CellID->24546],
Cell[4258, 151, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->20481],
Cell[CellGroupData[{
Cell[4337, 156, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->11714],
Cell[4407, 159, 282, 8, 70, "GuideText",
 CellID->155887444],
Cell[4692, 169, 294, 8, 70, "GuideText",
 CellID->376015456],
Cell[4989, 179, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->74057093]
}, Open  ]],
Cell[CellGroupData[{
Cell[5083, 185, 65, 1, 70, "GuideFunctionsSubsection",
 CellID->24168],
Cell[5151, 188, 437, 12, 70, "GuideText",
 CellID->405777220],
Cell[5591, 202, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->204833331]
}, Open  ]],
Cell[CellGroupData[{
Cell[5686, 208, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->20307],
Cell[5759, 211, 1261, 35, 70, "InlineGuideFunctionListing",
 CellID->418343597],
Cell[7023, 248, 416, 12, 70, "GuideText",
 CellID->301908451],
Cell[7442, 262, 617, 17, 70, "InlineGuideFunctionListing",
 CellID->26793],
Cell[8062, 281, 54, 1, 70, "GuideDelimiterSubsection",
 CellID->23504]
}, Open  ]],
Cell[CellGroupData[{
Cell[8153, 287, 223, 5, 70, "GuideFunctionsSubsection",
 CellID->1105],
Cell[8379, 294, 1065, 30, 70, "InlineGuideFunctionListing",
 CellID->1697]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9493, 330, 58, 1, 70, "GuideTutorialsSection",
 CellID->18217],
Cell[9554, 333, 162, 3, 70, "GuideTutorial",
 CellID->191890443]
}, Open  ]],
Cell[CellGroupData[{
Cell[9753, 341, 58, 1, 70, "GuideMoreAboutSection",
 CellID->2343],
Cell[9814, 344, 168, 4, 70, "GuideMoreAbout",
 CellID->26133],
Cell[9985, 350, 159, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[10147, 355, 156, 3, 70, "GuideMoreAbout",
 CellID->85278997],
Cell[10306, 360, 193, 4, 70, "GuideMoreAbout",
 CellID->929199252]
}, Open  ]],
Cell[CellGroupData[{
Cell[10536, 369, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->503709486],
Cell[10608, 372, 642, 17, 70, "GuideRelatedLinks",
 CellID->13951326]
}, Open  ]],
Cell[11265, 392, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

