(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10845,        360]
NotebookOptionsPosition[      7383,        261]
NotebookOutlinePosition[      9000,        299]
CellTagsIndexPosition[      8957,        296]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Defining Custom Notation", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s unified symbolic architecture allows arbitrary extensibility in the \
output and input of notation."
}], "GuideAbstract",
 CellID->44605237],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Local Interpretations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GeneralizedInput"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->46061565],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interpretation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Interpretation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " specify any interpretation for any expression"
}], "GuideText",
 CellID->25389777],

Cell[TextData[{
 Cell[TextData[ButtonBox["DynamicSetting",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DynamicSetting"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display as a control returns its setting when evaluated "
}], "GuideText",
 CellID->127753443],

Cell["\t", "GuideDelimiterSubsection",
 CellID->148634723]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keyboard Macros", "GuideFunctionsSubsection",
 CellID->121933884],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputAutoReplacements",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "automatic replacements for sequences of input characters"
}], "GuideText",
 CellID->52594310],

Cell[TextData[{
 Cell[TextData[ButtonBox["InputAliases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InputAliases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " aliases for arbitrary expressions, input with ",
 StyleBox["Esc", "KeyEvent"]
}], "GuideText",
 CellID->26104208],

Cell["\t", "GuideDelimiterSubsection",
 CellID->231258250]
}, Open  ]],

Cell[CellGroupData[{

Cell["Low-Level Definitions", "GuideFunctionsSubsection",
 CellID->531616407],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeBoxes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MakeBoxes"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "settable low-level translator from expression to display boxes"
}], "GuideText",
 CellID->106769705],

Cell[TextData[{
 Cell[TextData[ButtonBox["MakeExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MakeExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "settable low-level translator from boxes to evaluatable expressions"
}], "GuideText",
 CellID->572165821],

Cell[TextData[{
 Cell[TextData[ButtonBox["TagBox",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TagBox"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InterpretationBox",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InterpretationBox"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/LowLevelNotebookStructure"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->162150911],

Cell["\t", "GuideDelimiterSubsection",
 CellID->256361919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Built-in Symbolic Notational Forms \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/SymbolicNotationalForms"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->670294893],

Cell[TextData[{
 Cell[TextData[ButtonBox["CirclePlus",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CirclePlus"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "(",
 Cell[TextData[ButtonBox["\[CirclePlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CirclePlus"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Subscript",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subscript"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Overscript",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Overscript"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OverBar",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/OverBar"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Infix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Infix"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/SymbolicNotationalForms"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->552959646]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Basic Editing Techniques",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/BasicEditingTechniquesOverview"]], "GuideTutorial",
 CellID->507152383],

Cell[TextData[ButtonBox["Entering Two-Dimensional Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EnteringTwoDimensionalExpressionsOverview"]], \
"GuideTutorial",
 CellID->191546471],

Cell[TextData[ButtonBox["Entering Two-Dimensional Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringTwoDimensionalInput"]], "GuideTutorial",\

 CellID->86189687]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Notation Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Notation/guide/NotationPackage"]], "GuideMoreAboutSub",
 CellID->12170],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "GuideMoreAboutSub",\

 CellID->323869103]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defining Custom Notation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 50.1232262}", "context" -> "", 
    "keywords" -> {
     "aliases", "convert boxes to expression", "dynamic setting", 
      "escape sequences", "format expression", "glossary", "hidden box data", 
      "input aliases", "input auto replacements", "interpretation box", 
      "keyboard shortcuts", "macros", "make boxes", "make expression", 
      "output format", "over bar", "print expression with boxes", "shortcuts",
       "strip off boxes", "sub in HTML", "subscript index", "tag box", 
      "user-defined aliases", "input macros", "macro definitions", 
      "syntax modification"}, "index" -> True, "label" -> "Mathematica Guide",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica's unified symbolic architecture allows arbitrary \
extensibility in the output and input of notation.", "synonyms" -> {}, 
    "title" -> "Defining Custom Notation", "type" -> "Guide", "uri" -> 
    "guide/DefiningCustomNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 66, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[688, 28, 210, 6, 70, "GuideAbstract",
 CellID->44605237],
Cell[CellGroupData[{
Cell[923, 38, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->46061565],
Cell[1150, 45, 425, 11, 70, "GuideText",
 CellID->25389777],
Cell[1578, 58, 437, 11, 70, "GuideText",
 CellID->127753443],
Cell[2018, 71, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->148634723]
}, Open  ]],
Cell[CellGroupData[{
Cell[2113, 77, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->121933884],
Cell[2187, 80, 310, 9, 70, "GuideText",
 CellID->52594310],
Cell[2500, 91, 307, 9, 70, "GuideText",
 CellID->26104208],
Cell[2810, 102, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->231258250]
}, Open  ]],
Cell[CellGroupData[{
Cell[2905, 108, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->531616407],
Cell[2985, 111, 293, 9, 70, "GuideText",
 CellID->106769705],
Cell[3281, 122, 308, 9, 70, "GuideText",
 CellID->572165821],
Cell[3592, 133, 635, 18, 70, "InlineGuideFunctionListing",
 CellID->162150911],
Cell[4230, 153, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->256361919]
}, Open  ]],
Cell[CellGroupData[{
Cell[4325, 159, 247, 6, 70, "GuideFunctionsSubsection",
 CellID->670294893],
Cell[4575, 167, 1653, 46, 70, "InlineGuideFunctionListing",
 CellID->552959646]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6277, 219, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6342, 222, 176, 4, 70, "GuideTutorial",
 CellID->507152383],
Cell[6521, 228, 201, 5, 70, "GuideTutorial",
 CellID->191546471],
Cell[6725, 235, 177, 4, 70, "GuideTutorial",
 CellID->86189687]
}, Open  ]],
Cell[CellGroupData[{
Cell[6939, 244, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7004, 247, 156, 3, 70, "GuideMoreAboutSub",
 CellID->12170],
Cell[7163, 252, 178, 4, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[7356, 259, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

