(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10308,        321]
NotebookOptionsPosition[      6435,        223]
NotebookOutlinePosition[      8841,        272]
CellTagsIndexPosition[      8798,        269]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Diophantine Equations", "GuideTitle",
 CellID->9313],

Cell[TextData[{
 "Although Diophantine equations provide classic examples of undecidability, \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in practice succeeds in solving a remarkably wide range of such equations\
\[LongDash]automatically applying dozens of often original methods, many \
based on latest advances in number theory."
}], "GuideAbstract",
 CellID->875],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find particular solutions to Diophantine equations"
}], "GuideText",
 CellID->1017],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general reduction of Diophantine equations and inequalities"
}], "GuideText",
 CellID->14932],

Cell["\t", "GuideDelimiter",
 CellID->24886082],

Cell[TextData[{
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "partitions of an integer"
}], "GuideText",
 CellID->90219337],

Cell[TextData[{
 Cell[TextData[ButtonBox["FrobeniusSolve",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve Frobenius equations"
}], "GuideText",
 CellID->123583921],

Cell[TextData[{
 Cell[TextData[ButtonBox["SquaresR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquaresR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowersRepresentations",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PowersRepresentations"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->162629284],

Cell["\t", "GuideDelimiter",
 CellID->30695],

Cell[TextData[{
 Cell[TextData[ButtonBox["ChineseRemainder",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChineseRemainder"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve simultaneous linear congruences"
}], "GuideText",
 CellID->414781101],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultiplicativeOrder",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PowerMod",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PowerMod"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->22666495],

Cell["\t", "GuideDelimiter",
 CellID->428915508],

Cell[TextData[{
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Maximize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Maximize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "integer optimization"
}], "GuideText",
 CellID->713974987]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->2589],

Cell[TextData[ButtonBox["Diophantine Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiophantineReduce"]], "GuideTutorial",
 CellID->25990],

Cell[TextData[ButtonBox["Solving Frobenius Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Frobenius"]], "GuideTutorial",
 CellID->15145],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->562279604]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->19353],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->19314],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->18651],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "GuideMoreAboutSub",
 CellID->22044],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Diophantine Equations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 52.3264076}", "context" -> "", 
    "keywords" -> {
     "Boolean satisfiability", "chinese remainder", 
      "chinese remainder theorem", "counter-example", "Diophantine equations",
       "discrete log", "discrete logarithm", "Euler's pentagonal formula", 
      "find instance", "finite fields", "Frobenius equation", 
      "Frobenius solve", "group order", "index function", 
      "infeasible constraints", "integer equations", "integer partitions", 
      "integer programming", "integer representation", 
      "inverses in finite fields", "modular equations", "modular inverses", 
      "modular powers", "modular root", "multiplicative order", 
      "parametric optimization", "partitions", "pay-off functions", 
      "Pell equations", "polynomial equations", "polynomial inequalities", 
      "polynomial programming", "power mod", "powers in finite fields", 
      "powers representations", "primitive root", "quadratic programming", 
      "reducing inequalities", "satisfiability", "SAT problem", 
      "semi-algebraic sets", "simplex algorithm", "sum of powers", 
      "sum of squares", "symbolic optimization", "Thue equations", 
      "transcendental equations", "transcendental inequalities", "witnesses"},
     "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Although Diophantine equations provide classic examples of \
undecidability, Mathematica in practice succeeds in solving a remarkably wide \
range of such equations--automatically applying dozens of often original \
methods, many based on latest advances in number theory.", "synonyms" -> {}, 
    "title" -> "Diophantine Equations", "type" -> "Guide", "uri" -> 
    "guide/DiophantineEquations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->9313],
Cell[680, 28, 378, 9, 70, "GuideAbstract",
 CellID->875],
Cell[1061, 39, 277, 8, 70, "GuideText",
 CellID->1017],
Cell[1341, 49, 275, 8, 70, "GuideText",
 CellID->14932],
Cell[1619, 59, 47, 1, 70, "GuideDelimiter",
 CellID->24886082],
Cell[1669, 62, 415, 12, 70, "GuideText",
 CellID->90219337],
Cell[2087, 76, 411, 12, 70, "GuideText",
 CellID->123583921],
Cell[2501, 90, 1054, 27, 70, "InlineGuideFunctionListing",
 CellID->162629284],
Cell[3558, 119, 44, 1, 70, "GuideDelimiter",
 CellID->30695],
Cell[3605, 122, 427, 12, 70, "GuideText",
 CellID->414781101],
Cell[4035, 136, 545, 15, 70, "InlineGuideFunctionListing",
 CellID->22666495],
Cell[4583, 153, 48, 1, 70, "GuideDelimiter",
 CellID->428915508],
Cell[4634, 156, 376, 13, 70, "GuideText",
 CellID->713974987]
}, Open  ]],
Cell[CellGroupData[{
Cell[5047, 174, 57, 1, 70, "GuideTutorialsSection",
 CellID->2589],
Cell[5107, 177, 162, 3, 70, "GuideTutorial",
 CellID->25990],
Cell[5272, 182, 151, 3, 70, "GuideTutorial",
 CellID->15145],
Cell[5426, 187, 198, 4, 70, "GuideTutorial",
 CellID->562279604]
}, Open  ]],
Cell[CellGroupData[{
Cell[5661, 196, 59, 1, 70, "GuideMoreAboutSection",
 CellID->19353],
Cell[5723, 199, 138, 3, 70, "GuideMoreAbout",
 CellID->19314],
Cell[5864, 204, 152, 3, 70, "GuideMoreAbout",
 CellID->18651],
Cell[6019, 209, 168, 3, 70, "GuideMoreAboutSub",
 CellID->22044],
Cell[6190, 214, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[6408, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

