(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14150,        467]
NotebookOptionsPosition[      8753,        332]
NotebookOutlinePosition[     11769,        388]
CellTagsIndexPosition[     11726,        385]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Directories & Directory Operations", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Directory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Directory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "current kernel directory"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SetDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "set the current kernel directory"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookDirectory",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NotebookDirectory"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "current notebook directory"
}], "GuideText",
 CellID->381080874],

Cell[TextData[{
 Cell[TextData[ButtonBox["ResetDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ResetDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DirectoryStack",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DirectoryStack"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->173574300],

Cell[CellGroupData[{

Cell["Directory Names", "GuideFunctionsSubsection",
 CellID->448381265],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParentDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParentDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the parent of a directory"
}], "GuideText",
 CellID->1380321],

Cell[TextData[{
 Cell[TextData[ButtonBox["DirectoryName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DirectoryName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pick out the directory part from a full file name"
}], "GuideText",
 CellID->496030744],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToFileName",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToFileName"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "assemble a file name from a list of parts"
}], "GuideText",
 CellID->744413448],

Cell["\t", "GuideDelimiterSubsection",
 CellID->309627073]
}, Open  ]],

Cell[CellGroupData[{

Cell["Directory Operations", "GuideFunctionsSubsection",
 CellID->47357414],

Cell[TextData[{
 Cell[TextData[ButtonBox["CreateDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CreateDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RenameDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RenameDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CopyDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CopyDirectory"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DeleteDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DeleteDirectory"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->201330314],

Cell["\t", "GuideDelimiterSubsection",
 CellID->6790883]
}, Open  ]],

Cell[CellGroupData[{

Cell["User File Directories", "GuideFunctionsSubsection",
 CellID->859187135],

Cell[TextData[{
 Cell[TextData[ButtonBox["$UserDocumentsDirectory",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/$UserDocumentsDirectory"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "default directory to store kernel files"
}], "GuideText",
 CellID->209691329],

Cell[TextData[{
 Cell[TextData[ButtonBox["$HomeDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " user's home directory"
}], "GuideText",
 CellID->123018702],

Cell[TextData[{
 Cell[TextData[ButtonBox["$UserBaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "default base directory for user-specific add-on files"
}], "GuideText",
 CellID->100007581],

Cell[TextData[{
 Cell[TextData[ButtonBox["$Path",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$Path"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "list of directories to search for files"
}], "GuideText",
 CellID->224089086]
}, Open  ]],

Cell[CellGroupData[{

Cell["System File Directories", "GuideFunctionsSubsection",
 CellID->202265192],

Cell[TextData[{
 Cell[TextData[ButtonBox["$InitialDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InitialDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "initial directory when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " was started"
}], "GuideText",
 CellID->118939979],

Cell[TextData[{
 Cell[TextData[ButtonBox["$BaseDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " default base directory for systemwide add-on files"
}], "GuideText",
 CellID->450349194],

Cell[TextData[{
 Cell[TextData[ButtonBox["$InstallationDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$InstallationDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "root of directories for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " installation files"
}], "GuideText",
 CellID->27066885],

Cell[TextData[{
 Cell[TextData[ButtonBox["$RootDirectory",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$RootDirectory"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "file system root directory"
}], "GuideText",
 CellID->142993622],

Cell[TextData[{
 Cell[TextData[ButtonBox["$TemporaryPrefix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$TemporaryPrefix"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " prefix to use for temporary files"
}], "GuideText",
 CellID->68042057]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingFilesAndDirectories"]], "GuideTutorial",
 CellID->806871991],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "GuideTutorial",\

 CellID->1885805579],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "GuideTutorial",
 CellID->284427263],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "GuideTutorial",
 CellID->7808054]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"],
  FontSlant->"Italic"],
 ButtonBox[" System Setup",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSystemSetup"]
}], "GuideMoreAbout",
 CellID->140463763]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Directories & Directory Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 52.7639188}", "context" -> "", 
    "keywords" -> {
     "application directory", "base directory", "bin directory", "cd", 
      "change directory", "convert to file name", "copy directory", 
      "create directory", "create folder", "delete directory", "directories", 
      "directories of files", "directory name", 
      "directory of the current notebook", "directory stack", "file name", 
      "file name parts", "file path", "files", "history", "home directory", 
      "initial directory", "installation directory", "library directory", 
      "main directory", "move directory", "My Documents", "new directory", 
      "new folder", "notebook directory", "parent directory", 
      "path for files", "preferences directory", "previous directory", 
      "purging directories", "pwd", "rename directory", "reset directory", 
      "return to directory", "rmdir command", "root directory", "search path",
       "search path for files", "search path of directories", "set directory",
       "share directory", "startup directory", "temporary directory", 
      "temporary prefix", "to file name", "user base directory", 
      "user documents directory", "user's directory"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Directory -- current kernel directory, SetDirectory -- set the current \
kernel directory, NotebookDirectory -- current notebook directory, \
ParentDirectory -- the parent of a directory, DirectoryName -- pick out the \
directory part from a full file name, ToFileName -- assemble a file name from \
a list of parts, $UserDocumentsDirectory -- default directory to store kernel \
files, $HomeDirectory -- user's home directory, $UserBaseDirectory -- default \
base directory for user-specific add-on files, $Path -- list of directories \
to search for files, $InitialDirectory -- initial directory when Mathematica \
was started, $BaseDirectory -- default base directory for systemwide add-on \
files, $InstallationDirectory -- root of directories for Mathematica \
installation files, $RootDirectory -- file system root directory, \
$TemporaryPrefix -- prefix to use for temporary files", "synonyms" -> {}, 
    "title" -> "Directories & Directory Operations", "type" -> "Guide", "uri" -> 
    "guide/DirectoriesAndDirectoryOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 76, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[698, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[757, 31, 255, 9, 70, "GuideText",
 CellID->203374175],
Cell[1015, 42, 270, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1288, 53, 418, 12, 70, "GuideText",
 CellID->381080874],
Cell[1709, 67, 420, 11, 70, "InlineGuideFunctionListing",
 CellID->173574300],
Cell[CellGroupData[{
Cell[2154, 82, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->448381265],
Cell[2228, 85, 266, 9, 70, "GuideText",
 CellID->1380321],
Cell[2497, 96, 288, 9, 70, "GuideText",
 CellID->496030744],
Cell[2788, 107, 274, 9, 70, "GuideText",
 CellID->744413448],
Cell[3065, 118, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->309627073]
}, Open  ]],
Cell[CellGroupData[{
Cell[3160, 124, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->47357414],
Cell[3238, 127, 864, 23, 70, "InlineGuideFunctionListing",
 CellID->201330314],
Cell[4105, 152, 56, 1, 70, "GuideDelimiterSubsection",
 CellID->6790883]
}, Open  ]],
Cell[CellGroupData[{
Cell[4198, 158, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->859187135],
Cell[4278, 161, 443, 12, 70, "GuideText",
 CellID->209691329],
Cell[4724, 175, 257, 8, 70, "GuideText",
 CellID->123018702],
Cell[4984, 185, 302, 9, 70, "GuideText",
 CellID->100007581],
Cell[5289, 196, 262, 9, 70, "GuideText",
 CellID->224089086]
}, Open  ]],
Cell[CellGroupData[{
Cell[5588, 210, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->202265192],
Cell[5670, 213, 336, 12, 70, "GuideText",
 CellID->118939979],
Cell[6009, 227, 286, 8, 70, "GuideText",
 CellID->450349194],
Cell[6298, 237, 353, 12, 70, "GuideText",
 CellID->27066885],
Cell[6654, 251, 267, 9, 70, "GuideText",
 CellID->142993622],
Cell[6924, 262, 272, 8, 70, "GuideText",
 CellID->68042057]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7245, 276, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7310, 279, 187, 4, 70, "GuideTutorial",
 CellID->806871991],
Cell[7500, 285, 179, 4, 70, "GuideTutorial",
 CellID->1885805579],
Cell[7682, 291, 164, 3, 70, "GuideTutorial",
 CellID->284427263],
Cell[7849, 296, 311, 9, 70, "GuideTutorial",
 CellID->7808054]
}, Open  ]],
Cell[CellGroupData[{
Cell[8197, 310, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8262, 313, 153, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[8418, 318, 293, 9, 70, "GuideMoreAbout",
 CellID->140463763]
}, Open  ]],
Cell[8726, 330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

