(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26664,        769]
NotebookOptionsPosition[     16740,        545]
NotebookOutlinePosition[     23116,        652]
CellTagsIndexPosition[     23073,        649]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Discrete Mathematics", "GuideTitle",
 CellID->335],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has been used to make many important discoveries in discrete mathematics \
over the past two decades",
 ". ",
 "Its integration of highly efficient and often original algorithms together \
with its high-level symbolic language has made it a unique environment for \
the exploration, development and application of discrete mathematics."
}], "GuideAbstract",
 CellID->8759],

Cell[CellGroupData[{

Cell["List and Set Operations", "GuideFunctionsSubsection",
 CellID->12181],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tuples",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Tuples"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Subsets",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Subsets"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Union",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Union"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Intersection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Intersection"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Complement",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Complement"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28503]
}, Open  ]],

Cell[CellGroupData[{

Cell["Permutations", "GuideFunctionsSubsection",
 CellID->407027106],

Cell[TextData[{
 Cell[TextData[ButtonBox["Permutations",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Permutations"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Ordering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Ordering"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Signature",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Signature"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomSample",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomSample"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->580475346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Enumeration-Related Functions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CombinatorialFunctions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->23775],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Fibonacci",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Fibonacci"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StirlingS1",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StirlingS1"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PartitionsP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PartitionsP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerPartitions",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CombinatorialFunctions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->20608]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recurrences & Generating Functions", "GuideFunctionsSubsection",
 CellID->5997],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "solve recurrence equations"
}], "GuideText",
 CellID->17549],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ZTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseZTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseZTransform"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Sum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Sum"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SeriesCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SeriesCoefficient"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiscreteDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiscreteDelta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->29556],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate a list of forms matching a pattern"
}], "GuideText",
 CellID->306991040]
}, Open  ]],

Cell[CellGroupData[{

Cell["Strings and Digits", "GuideFunctionsSubsection",
 CellID->25561],

Cell[TextData[{
 Cell[TextData[ButtonBox["StringReplaceList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StringReplaceList"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IntegerDigits",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IntegerDigits"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitXor",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitXor"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BitAnd",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BitAnd"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->31627]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphs and Trees", "GuideFunctionsSubsection",
 CellID->6467],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["GraphPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["LayeredGraphPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " lay out and draw graphs"
}], "GuideText",
 CellID->29541],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreePlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TreePlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " display trees"
}], "GuideText",
 CellID->73720779],

Cell[TextData[{
 Cell[TextData[ButtonBox["GraphData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " database of named and enumerated graphs and their properties"
}], "GuideText",
 CellID->36094129]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combinatorial Optimization", "GuideFunctionsSubsection",
 CellID->524966721],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindMinimum",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindMinimum"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Minimize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Minimize"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve integer programming problems"
}], "GuideText",
 CellID->326904177],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindShortestTour",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindShortestTour"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve traveling salesman problems"
}], "GuideText",
 CellID->763209139]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Algebraic Systems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalData"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->75481355],

Cell[TextData[{
 Cell[TextData[ButtonBox["LatticeData",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LatticeData"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KnotData",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/KnotData"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->354876163]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Computational Systems \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ComputationalSystemsAndDiscovery"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->31240],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellularAutomaton",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TuringMachine",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TuringMachine"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->27813]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->29174],

Cell[TextData[ButtonBox["List as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "GuideTutorial",
 CellID->20601],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "GuideTutorial",
 CellID->6077],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->970978540],

Cell[TextData[ButtonBox["Solving Recurrence Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingRecurrenceEquations"]], "GuideTutorial",
 CellID->221380007],

Cell[TextData[ButtonBox["Operations on Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnStrings"]], "GuideTutorial",
 CellID->31434966],

Cell[TextData[ButtonBox["Introduction to Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]], "GuideTutorial",
 CellID->181219930],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "GuideTutorial",
 CellID->85226944],

Cell[TextData[ButtonBox["Cellular Automata",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CellularAutomata"]], "GuideTutorial",
 CellID->186108311]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->20215],

Cell[TextData[{
 StyleBox[ButtonBox["Combinatorica",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CombinatoricaPackage"],
  FontSlant->"Italic"],
 ButtonBox[" Package",
  BaseStyle->"Link",
  ButtonData->"paclet:Combinatorica/guide/CombinatoricaPackage"]
}], "GuideMoreAbout",
 CellID->30569792],

Cell[TextData[ButtonBox["Graph Utilities Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:GraphUtilities/guide/GraphUtilitiesPackage"]], "GuideMoreAbout",
 CellID->1448486493],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAbout",
 CellID->8683],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "GuideMoreAbout",
 CellID->8213],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAbout",
 CellID->313724992],

Cell[TextData[ButtonBox["Analyzing Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "GuideMoreAbout",
 CellID->517831915],

Cell[TextData[ButtonBox["Finite Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FiniteFields/guide/FiniteFieldsPackage"]], "GuideMoreAboutSub",
 CellID->25824],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "GuideMoreAboutSub",
 CellID->5601],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1282641449],

Cell[TextData[{
 ButtonBox["Demonstrations related to Discrete Mathematics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22discrete+mathematics%22+content%3ABinomial+OR+BitAnd+OR+BitXor+OR+\
CellularAutomaton+OR+Complement+OR+DiscreteDelta+OR+Factorial+OR+Fibonacci+OR+\
FindMinimum+OR+FindShortestTour+OR+FiniteGroupData+OR+GraphData+OR+GraphPlot+\
OR+GraphPlot3D+OR+IntegerDigits+OR+IntegerPartitions+OR+Intersection+OR+\
InverseZTransform+OR+KnotData+OR+LatticeData+OR+LayeredGraphPlot+OR+Minimize+\
OR+Ordering+OR+PartitionsP+OR+Permutations+OR+RandomSample+OR+ReplaceList+OR+\
RSolve+OR+SeriesCoefficient+OR+Signature+OR+Sort+OR+StirlingS1+OR+\
StringReplaceList+OR+Subsets+OR+Sum+OR+TreePlot+OR+Tuples+OR+TuringMachine+OR+\
Union+OR+ZTransform"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->66966904]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Discrete Mathematics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 53.9827000}", "context" -> "", 
    "keywords" -> {
     "3D graph drawing", "3D graph embedding", "3D graph layout", 
      "3D graph visualization", "3D network layout", 
      "3D network visualization", "Abramov algorithm", "absent from list", 
      "Adamchik techniques", "add", "additive cellular automata", 
      "antisymmetry", "arithmetic difference equations", "arrange", 
      "array automata", "ascending order", "automata", "bang", "bases", 
      "binary digits", "binom", "binomials", "bit and", "bit xor", 
      "block maps", "Bronstein algorithm", "CA", "canonical order", "carry", 
      "cell-automaton", "cell automaton", "cellular automaton", 
      "chirp Z transform", "choose", "comb", "combinations", 
      "combining lists", "continuous mappings of the shift", "conversion", 
      "cost function", "coupled map lattices", "d'Alembert test", 
      "decimal digits", "decode", "decreasing order", "delta function", 
      "delta sequence", "descending order", "difference-algebraic equations", 
      "difference equations", "difference of sets", "digits", 
      "digraph layout", "Dirichlet series", "discrete delta", 
      "discrete Dirac delta", "discrete equations", 
      "discrete Laplace transform", "discrete models", "disjointness", 
      "distinct elements in lists", "divide-and-conquer equations", 
      "draw a graph", "elementary cellular automata", "element positions", 
      "enumerating sublists", "enumeration of permutations", "epsilon symbol",
       "Euler's pentagonal formula", "exact optimization", 
      "exclamation point", "expressions ordering", "extremization", "fact", 
      "factorial", "fib", "Fibonacci equations", "Fibonacci sequence", 
      "figure eight", "finite difference equations", "finite group data", 
      "flowchart layout", "formal power series", "generating function", 
      "generating functions", "generating tuples", 
      "geometric difference equations", "global minimization", 
      "goal functions", "Goktas methods", "grade", "grade in APL", 
      "graph data", "graph drawing", "graph embedding", "graph layout", 
      "graph plot", "graph plot3", "graph plot 3D", "graph visualization", 
      "half adder", "Hardy-Ramanujan-Rademacher algorithm", 
      "hexadecimal digits", "hierarchical graph layout", 
      "hypergeometric sums", "impulse response", "increasing order", 
      "inequalities", "infeasible constraints", "integer digits", 
      "integer linear programming", "integer partitions", 
      "integer programming", "integer sequence equations", 
      "interior point algorithm", "inverse transform", "inverse Z-transform", 
      "inverse Z transform", "inverse ztransform", "iterative arrays", "knot",
       "knot data", "knot invariants", "k-subsets", "Laplace transform", 
      "largest", "lattice", "layered graph plot", "Lie algebras", 
      "Lie groups", "list complement", "lists", "lists ordering", 
      "LP (linear programming)", "mask", "merging lists", "models", 
      "multiple matches for patterns", "multiple string replacements", 
      "multiway systems", "n-choose-k", "nchoosek", "nCk", "network data", 
      "network layout", "network visualization", "Nim addition", 
      "octal digits", "optimization", "ordered pairs", "order in lists", 
      "order statistics", "overlap between lists", "padding", "pairs", 
      "parametric optimization", "parser construction", 
      "partial difference equations", "partial recurrence equations", 
      "partitions", "pay-off functions", "perm", "permutations of lists", 
      "permute", "plot a graph", "polyautomata", "polynomial programming", 
      "power series", "power series expansion", "powerset", 
      "production rules", "pseudotensors", "quadratic programming", 
      "Raabe test", "radix conversion", "ramp response", "random permutation",
       "random sample", "random subset", "ranking", "rearrangements", 
      "recurrence equations", "recursion equations", "recursive drawing", 
      "remove duplicates", "reordering of lists", "reorderings", 
      "replace list", "replace part of string", "replace substring", 
      "rewrite rules", "root lattices", "rule 30", "rule numbers", 
      "sampling without replacement", "searching", 
      "selecting objects with ordering", "selecting sublists", 
      "sequence equations", "sequences", "set exponential", "sets", "shriek", 
      "signal processing", "signature", "simplex algorithm", 
      "smallest element", "sorting", "sorting of lists", "step response", 
      "Stirling1", "Stirling number of the 1st kind", 
      "Stirling number of the first kind", "Stirling numbers", 
      "Stirling numbers S1", "Stirling s1", "sublists", "subset permutations",
       "subtraction of sets", "sums", "symmetry reduction", "ternary digits", 
      "tesselation automata", "totalistic cellular automata", 
      "transfer function", "traveling salesman problem", "tree plot", 
      "trefoil", "triples", "TSP", "turing machine", "union of sets", "uniq", 
      "unique elements in lists", "unknot", "unpack", "urn problem", 
      "van Hoeij algorithms", "ztransform"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Mathematica has been used to make many important discoveries in discrete \
mathematics over the past two decades. Its integration of highly efficient \
and often original algorithms together with its high-level symbolic language \
has made it a unique environment for the exploration, development and \
application of discrete mathematics.", "synonyms" -> {}, "title" -> 
    "Discrete Mathematics", "type" -> "Guide", "uri" -> 
    "guide/DiscreteMathematics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->335],
Cell[678, 28, 440, 10, 70, "GuideAbstract",
 CellID->8759],
Cell[CellGroupData[{
Cell[1143, 42, 75, 1, 70, "GuideFunctionsSubsection",
 CellID->12181],
Cell[1221, 45, 1016, 29, 70, "InlineGuideFunctionListing",
 CellID->28503]
}, Open  ]],
Cell[CellGroupData[{
Cell[2274, 79, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->407027106],
Cell[2345, 82, 1175, 32, 70, "InlineGuideFunctionListing",
 CellID->580475346]
}, Open  ]],
Cell[CellGroupData[{
Cell[3557, 119, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->23775],
Cell[3797, 127, 1620, 44, 70, "InlineGuideFunctionListing",
 CellID->20608]
}, Open  ]],
Cell[CellGroupData[{
Cell[5454, 176, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->5997],
Cell[5542, 179, 247, 9, 70, "GuideText",
 CellID->17549],
Cell[5792, 190, 1056, 29, 70, "InlineGuideFunctionListing",
 CellID->29556],
Cell[6851, 221, 278, 9, 70, "GuideText",
 CellID->306991040]
}, Open  ]],
Cell[CellGroupData[{
Cell[7166, 235, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->25561],
Cell[7239, 238, 828, 23, 70, "InlineGuideFunctionListing",
 CellID->31627]
}, Open  ]],
Cell[CellGroupData[{
Cell[8104, 266, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->6467],
Cell[8174, 269, 956, 25, 70, "GuideText",
 CellID->29541],
Cell[9133, 296, 381, 11, 70, "GuideText",
 CellID->73720779],
Cell[9517, 309, 430, 11, 70, "GuideText",
 CellID->36094129]
}, Open  ]],
Cell[CellGroupData[{
Cell[9984, 325, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->524966721],
Cell[10069, 328, 391, 12, 70, "GuideText",
 CellID->326904177],
Cell[10463, 342, 273, 8, 70, "GuideText",
 CellID->763209139]
}, Open  ]],
Cell[CellGroupData[{
Cell[10773, 355, 220, 5, 70, "GuideFunctionsSubsection",
 CellID->75481355],
Cell[10996, 362, 547, 14, 70, "InlineGuideFunctionListing",
 CellID->354876163]
}, Open  ]],
Cell[CellGroupData[{
Cell[11580, 381, 237, 5, 70, "GuideFunctionsSubsection",
 CellID->31240],
Cell[11820, 388, 565, 14, 70, "InlineGuideFunctionListing",
 CellID->27813]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12434, 408, 58, 1, 70, "GuideTutorialsSection",
 CellID->29174],
Cell[12495, 411, 138, 3, 70, "GuideTutorial",
 CellID->20601],
Cell[12636, 416, 146, 3, 70, "GuideTutorial",
 CellID->6077],
Cell[12785, 421, 164, 3, 70, "GuideTutorial",
 CellID->970978540],
Cell[12952, 426, 173, 3, 70, "GuideTutorial",
 CellID->221380007],
Cell[13128, 431, 158, 3, 70, "GuideTutorial",
 CellID->31434966],
Cell[13289, 436, 172, 3, 70, "GuideTutorial",
 CellID->181219930],
Cell[13464, 441, 151, 3, 70, "GuideTutorial",
 CellID->85226944],
Cell[13618, 446, 152, 3, 70, "GuideTutorial",
 CellID->186108311]
}, Open  ]],
Cell[CellGroupData[{
Cell[13807, 454, 59, 1, 70, "GuideMoreAboutSection",
 CellID->20215],
Cell[13869, 457, 313, 9, 70, "GuideMoreAbout",
 CellID->30569792],
Cell[14185, 468, 180, 4, 70, "GuideMoreAbout",
 CellID->1448486493],
Cell[14368, 474, 149, 3, 70, "GuideMoreAbout",
 CellID->8683],
Cell[14520, 479, 137, 3, 70, "GuideMoreAbout",
 CellID->8213],
Cell[14660, 484, 160, 3, 70, "GuideMoreAbout",
 CellID->313724992],
Cell[14823, 489, 172, 3, 70, "GuideMoreAbout",
 CellID->517831915],
Cell[14998, 494, 164, 4, 70, "GuideMoreAboutSub",
 CellID->25824],
Cell[15165, 500, 148, 3, 70, "GuideMoreAboutSub",
 CellID->5601],
Cell[15316, 505, 203, 4, 70, "GuideMoreAbout",
 CellID->117105735]
}, Open  ]],
Cell[CellGroupData[{
Cell[15556, 514, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1282641449],
Cell[15629, 517, 1069, 23, 70, "GuideRelatedLinks",
 CellID->66966904]
}, Open  ]],
Cell[16713, 543, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

