(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11918,        357]
NotebookOptionsPosition[      7630,        244]
NotebookOutlinePosition[     10014,        294]
CellTagsIndexPosition[      9971,        291]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Discrete Statistical Distributions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a general symbolic representation of statistical distributions that \
makes it possible to perform not only numerical but also symbolic operations \
on distributions",
 ". "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Binomial Distributions", "GuideFunctionsSubsection",
 CellID->722752080],

Cell[TextData[{
 Cell[TextData[ButtonBox["BernoulliDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BernoulliDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BinomialDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HypergeometricDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HypergeometricDistribution"]], "InlineFunctionSans",
  
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->337112]
}, Open  ]],

Cell[CellGroupData[{

Cell["Negative Binomial Distributions", "GuideFunctionsSubsection",
 CellID->135565508],

Cell[TextData[{
 Cell[TextData[ButtonBox["NegativeBinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/NegativeBinomialDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeometricDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GeometricDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->10151782]
}, Open  ]],

Cell[CellGroupData[{

Cell["Beta Mixture Distributions", "GuideFunctionsSubsection",
 CellID->344800539],

Cell[TextData[{
 Cell[TextData[ButtonBox["BetaBinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BetaBinomialDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BetaNegativeBinomialDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BetaNegativeBinomialDistribution"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->951892895]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poisson Distribution", "GuideFunctionsSubsection",
 CellID->530747323],

Cell[TextData[Cell[TextData[ButtonBox["PoissonDistribution",
 BaseStyle->"NewInVersionLink",
 ButtonData->"paclet:ref/PoissonDistribution"]], "InlineFunctionSans",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]]]], "InlineGuideFunctionListing",
 CellID->520079526]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uniform Distribution", "GuideFunctionsSubsection",
 CellID->591393600],

Cell[TextData[Cell[TextData[ButtonBox["DiscreteUniformDistribution",
 BaseStyle->"NewInVersionLink",
 ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFunctionSans",
 
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]]]], "InlineGuideFunctionListing",
 CellID->621727379]
}, Open  ]],

Cell[CellGroupData[{

Cell["Power Law Distributions", "GuideFunctionsSubsection",
 CellID->82995620],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZipfDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZipfDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogSeriesDistribution",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogSeriesDistribution"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->31567011]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "GuideTutorial",
 CellID->1885805579]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Using Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"]], \
"GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->913984757],

Cell[TextData[{
 ButtonBox["Demonstrations related to Discrete Statistical Distributions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BernoulliDistribution+OR+BetaBinomialDistribution+OR+\
BetaNegativeBinomialDistribution+OR+BinomialDistribution+OR+\
DiscreteUniformDistribution+OR+GeometricDistribution+OR+\
HypergeometricDistribution+OR+LogSeriesDistribution+OR+\
NegativeBinomialDistribution+OR+PoissonDistribution+OR+ZipfDistribution)"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->123861302]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Discrete Statistical Distributions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 55.5296146}", "context" -> "", 
    "keywords" -> {
     "Bernoulli distribution", "Bernoulli trial", "Bernoulli trials", 
      "beta-binomial distribution", "beta binomial distribution", 
      "beta-negative-binomial distribution", 
      "beta negative binomial distribution", "binomial distribution", 
      "binomial trials", "coin tossing", "discrete memoryless", 
      "discrete rectangular distribution", "discrete uniform distribution", 
      "geometric distribution", "hypergeometric distribution", 
      "infrequent events", "logarithmic distribution", 
      "logarithmic series distribution", "log distribution", 
      "log-series distribution", "log series distribution", 
      "mixture distribution", "negative binomial distribution", 
      "non-frequent events", "number of trials before success", 
      "Pascal distribution", "Poisson distribution", "Poisson process", 
      "Polya distribution", "Po'lya distribution", "power law", 
      "power-law distribution", "power law distribution", "rare events", 
      "rectangular distribution", "Saint Petersburg paradox", 
      "sampling without replacement", "urn problem", "zeta distribution", 
      "zipf distribution", "Zipf-Estoup law", "Zipf Estoup law", 
      "Zipf's law"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica has a general symbolic representation of statistical \
distributions that makes it possible to perform not only numerical but also \
symbolic operations on distributions. ", "synonyms" -> {}, "title" -> 
    "Discrete Statistical Distributions", "type" -> "Guide", "uri" -> 
    "guide/DiscreteStatisticalDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 76, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[698, 28, 287, 8, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1010, 40, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->722752080],
Cell[1091, 43, 1125, 27, 70, "InlineGuideFunctionListing",
 CellID->337112]
}, Open  ]],
Cell[CellGroupData[{
Cell[2253, 75, 87, 1, 70, "GuideFunctionsSubsection",
 CellID->135565508],
Cell[2343, 78, 754, 18, 70, "InlineGuideFunctionListing",
 CellID->10151782]
}, Open  ]],
Cell[CellGroupData[{
Cell[3134, 101, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->344800539],
Cell[3219, 104, 769, 18, 70, "InlineGuideFunctionListing",
 CellID->951892895]
}, Open  ]],
Cell[CellGroupData[{
Cell[4025, 127, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->530747323],
Cell[4104, 130, 345, 6, 70, "InlineGuideFunctionListing",
 CellID->520079526]
}, Open  ]],
Cell[CellGroupData[{
Cell[4486, 141, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->591393600],
Cell[4565, 144, 363, 7, 70, "InlineGuideFunctionListing",
 CellID->621727379]
}, Open  ]],
Cell[CellGroupData[{
Cell[4965, 156, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->82995620],
Cell[5046, 159, 727, 17, 70, "InlineGuideFunctionListing",
 CellID->31567011]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5822, 182, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5887, 185, 163, 3, 70, "GuideTutorial",
 CellID->1885805579]
}, Open  ]],
Cell[CellGroupData[{
Cell[6087, 193, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6152, 196, 173, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6328, 201, 174, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[6505, 206, 208, 5, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[6750, 216, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->913984757],
Cell[6822, 219, 766, 20, 70, "GuideRelatedLinks",
 CellID->123861302]
}, Open  ]],
Cell[7603, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

