(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15626,        441]
NotebookOptionsPosition[     11663,        339]
NotebookOutlinePosition[     13999,        388]
CellTagsIndexPosition[     13956,        385]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Distance and Dissimilarity Measures", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "Different measures of distance or dissimilarity are convenient for \
different types of analysis",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides built-in functions for many standard distance measures, as well \
as the capability to give a symbolic definition for an arbitrary measure. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell["Numerical Data", "GuideFunctionsSubsection",
 CellID->745895945],

Cell[TextData[{
 Cell[TextData[ButtonBox["EuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SquaredEuclideanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SquaredEuclideanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ManhattanDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChebyshevDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChebyshevDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BrayCurtisDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BrayCurtisDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CanberraDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CanberraDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CosineDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CosineDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CorrelationDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/CorrelationDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],

Cell[CellGroupData[{

Cell["Boolean Data", "GuideFunctionsSubsection",
 CellID->764671871],

Cell[TextData[{
 Cell[TextData[ButtonBox["HammingDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HammingDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JaccardDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MatchingDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DiceDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RogersTanimotoDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], 
  "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RussellRaoDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SokalSneathDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["YuleDissimilarity",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/YuleDissimilarity"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->203478879]
}, Open  ]],

Cell[CellGroupData[{

Cell["String Data", "GuideFunctionsSubsection",
 CellID->224550708],

Cell[TextData[{
 Cell[TextData[ButtonBox["EditDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/EditDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HammingDistance",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HammingDistance"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->126099946],

Cell["\t", "GuideDelimiter",
 CellID->243662298],

Cell[TextData[{
 Cell[TextData[ButtonBox["DistanceFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DistanceFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " option for specifying distance functions"
}], "GuideText",
 CellID->464196136],

Cell[TextData[{
 Cell[TextData[ButtonBox["Nearest",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Nearest"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindClusters",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/FindClusters"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FindShortestTour",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindShortestTour"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData["..."], "InlineFormula"]
}], "InlineGuideFunctionListing",
 CellID->322766673]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "GuideTutorial",\

 CellID->104508514]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Data Classification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "GuideMoreAbout",
 CellID->299372452],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Hierarchical Clustering Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:HierarchicalClustering/guide/HierarchicalClusteringPackage"]], \
"GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->713714642],

Cell[TextData[{
 ButtonBox["Demonstrations related to Distance and Dissimilarity Measures",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BrayCurtisDistance+OR+CanberraDistance+OR+ChebyshevDistance+OR+\
CorrelationDistance+OR+CosineDistance+OR+DiceDissimilarity+OR+EditDistance+OR+\
EuclideanDistance+OR+HammingDistance+OR+JaccardDissimilarity+OR+\
ManhattanDistance+OR+MatchingDissimilarity+OR+RogersTanimotoDissimilarity+OR+\
RussellRaoDissimilarity+OR+SokalSneathDissimilarity+OR+\
SquaredEuclideanDistance+OR+YuleDissimilarity)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->8978169]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Distance and Dissimilarity Measures - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 30, 58.1546818}", "context" -> "System`", 
    "keywords" -> {
     "angular cosine distance", "Bray Curtis distance", 
      "Bray\\[Hyphen]Curtis distance", "Canberra distance", 
      "Chebyshev distance", "city block distance", 
      "correlation dissimilarity", "correlation distance", 
      "cosine angle dissimilarity", "cosine angle distance", 
      "cosine dissimilarity", "cosine distance", "dice dissimilarity", 
      "edit distance", "Euclidean distance", "Euclidean norm", 
      "grid distance", "Jaccard dissimilarity", "Levenshtein distance", 
      "Manhattan distance", "Manhattan metric", "matching dissimilarity", 
      "max distance", "Rogers Tanimoto dissimilarity", 
      "Russell Rao dissimilarity", "Russell\\[Hyphen]Rao dissimilarity", 
      "simple matching", "Sokal Sneath dissimilarity", 
      "Sokal\\[Hyphen]Sneath dissimilarity", "squared Euclidean distance", 
      "squared Euclidean norm", "string distance", "string metric", 
      "sup distance", "taxi cab distance", "taxicab distance", 
      "taxicab metric", "Yule dissimilarity", "bit vectors", "norms", 
      "similarity measures"}, "index" -> True, "label" -> "Mathematica Guide",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Different measures of distance or dissimilarity are convenient for \
different types of analysis. Mathematica provides built-in functions for many \
standard distance measures, as well as the capability to give a symbolic \
definition for an arbitrary measure. ", "synonyms" -> {}, "title" -> 
    "Distance and Dissimilarity Measures", "type" -> "Guide", "uri" -> 
    "guide/DistanceAndDissimilarityMeasures"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 77, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[699, 28, 368, 9, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1092, 41, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->745895945],
Cell[1165, 44, 2959, 71, 70, "InlineGuideFunctionListing",
 CellID->58033752]
}, Open  ]],
Cell[CellGroupData[{
Cell[4161, 120, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->764671871],
Cell[4232, 123, 3007, 72, 70, "InlineGuideFunctionListing",
 CellID->203478879]
}, Open  ]],
Cell[CellGroupData[{
Cell[7276, 200, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->224550708],
Cell[7346, 203, 708, 17, 70, "InlineGuideFunctionListing",
 CellID->126099946],
Cell[8057, 222, 48, 1, 70, "GuideDelimiter",
 CellID->243662298],
Cell[8108, 225, 425, 11, 70, "GuideText",
 CellID->464196136],
Cell[8536, 238, 1044, 27, 70, "InlineGuideFunctionListing",
 CellID->322766673]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9629, 271, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9694, 274, 180, 4, 70, "GuideTutorial",
 CellID->104508514]
}, Open  ]],
Cell[CellGroupData[{
Cell[9911, 283, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9976, 286, 155, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[10134, 291, 154, 3, 70, "GuideMoreAbout",
 CellID->299372452],
Cell[10291, 296, 161, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[10455, 301, 208, 5, 70, "GuideMoreAboutSub",
 CellID->323869103]
}, Open  ]],
Cell[CellGroupData[{
Cell[10700, 311, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->713714642],
Cell[10772, 314, 849, 20, 70, "GuideRelatedLinks",
 CellID->8978169]
}, Open  ]],
Cell[11636, 337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

