(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9608,        339]
NotebookOptionsPosition[      5958,        241]
NotebookOutlinePosition[      7925,        282]
CellTagsIndexPosition[      7882,        279]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Edit Menu", "GuideTitle",
 CellID->18762],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 StyleBox[ButtonBox["Undo",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Undo"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reverse the most recent action"
}], "GuideText",
 CellID->161533042],

Cell["\t", "GuideDelimiter",
 CellID->20537],

Cell[TextData[{
 StyleBox[ButtonBox["Cut",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Cut"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " delete the selection and copy it to the clipboard"
}], "GuideText",
 CellID->579816007],

Cell[TextData[{
 StyleBox[ButtonBox["Copy",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Copy"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " copy the selection to the clipboard without deleting it"
}], "GuideText",
 CellID->30725319],

Cell[TextData[{
 StyleBox[ButtonBox["Paste",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Paste"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " insert the contents of the clipboard"
}], "GuideText",
 CellID->262982310],

Cell[TextData[{
 StyleBox[ButtonBox["Clear",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Clear"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " delete the selection without copying it to the clipboard"
}], "GuideText",
 CellID->272663151],

Cell[TextData[{
 StyleBox[ButtonBox["Copy As",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CopyAs"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " copy the selection in many possible formats"
}], "GuideText",
 CellID->236587240],

Cell["\t", "GuideDelimiter",
 CellID->27348],

Cell[TextData[{
 StyleBox[ButtonBox["Extend Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ExtendSelection"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " highlight the smallest subexpression containing the selection"
}], "GuideText",
 CellID->108714888],

Cell[TextData[{
 StyleBox[ButtonBox["Select All",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/SelectAll"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " select all cells in a notebook"
}], "GuideText",
 CellID->296960788],

Cell[TextData[{
 StyleBox[ButtonBox["Check Balance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckBalance"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand the selection to the nearest balanced bracketing characters"
}], "GuideText",
 CellID->76191736],

Cell["\t", "GuideDelimiter",
 CellID->3788],

Cell[TextData[{
 StyleBox[ButtonBox["Complete Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CompleteSelection"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete a partially typed function name"
}], "GuideText",
 CellID->830784634],

Cell[TextData[{
 StyleBox[ButtonBox["Make Template",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeTemplate"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "insert a function template for the selected function"
}], "GuideText",
 CellID->332844657],

Cell[TextData[{
 StyleBox[ButtonBox["Check Spelling...",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CheckSpelling"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "search for and fix misspelled words"
}], "GuideText",
 CellID->327118875],

Cell["\t", "GuideDelimiter",
 CellID->17807],

Cell[TextData[{
 StyleBox[ButtonBox["Find...",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Find"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find text in the current notebook"
}], "GuideText",
 CellID->27563339],

Cell[TextData[{
 StyleBox[ButtonBox["Enter Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EnterSelection"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "enter the selection as the search text"
}], "GuideText",
 CellID->89108116],

Cell[TextData[{
 StyleBox[ButtonBox["Find Next",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/FindNext"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find next instance of search text"
}], "GuideText",
 CellID->432505975],

Cell[TextData[{
 StyleBox[ButtonBox["Find Previous",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/FindPrevious"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find previous instance of search text"
}], "GuideText",
 CellID->191105802],

Cell["\t", "GuideDelimiter",
 CellID->5249],

Cell[TextData[{
 StyleBox[ButtonBox["Preferences...",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Preferences"], "MenuName"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 "  ",
 "set preferences for syntax coloring, system settings, etc."
}], "GuideText",
 CellID->68785311]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12290],

Cell[TextData[ButtonBox["Menu Items",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MenuItems"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Notebook Basics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookBasics"]], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Edit Menu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 0.7953744}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Undo -- reverse the most recent action, Cut -- delete the selection and \
copy it to the clipboard, Copy -- copy the selection to the clipboard without \
deleting it, Paste -- insert the contents of the clipboard, Clear -- delete \
the selection without copying it to the clipboard, Copy As -- copy the \
selection in many possible formats, Extend Selection -- highlight the \
smallest subexpression containing the selection, Select All -- select all \
cells in a notebook, Check Balance -- expand the selection to the nearest \
balanced bracketing characters, Complete Selection -- complete a partially \
typed function name, Make Template -- insert a function template for the \
selected function, Check Spelling... -- search for and fix misspelled words, \
Find... -- find text in the current notebook, Enter Selection -- enter the \
selection as the search text, Find Next -- find next instance of search text, \
Find Previous -- find previous instance of search text, Preferences... -- set \
preferences for syntax coloring, system settings, etc.", "synonyms" -> {}, 
    "title" -> "Edit Menu", "type" -> "Guide", "uri" -> "guide/EditMenu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 47, 1, 70, "GuideTitle",
 CellID->18762],
Cell[669, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[728, 31, 239, 8, 70, "GuideText",
 CellID->161533042],
Cell[970, 41, 44, 1, 70, "GuideDelimiter",
 CellID->20537],
Cell[1017, 44, 256, 8, 70, "GuideText",
 CellID->579816007],
Cell[1276, 54, 263, 8, 70, "GuideText",
 CellID->30725319],
Cell[1542, 64, 247, 8, 70, "GuideText",
 CellID->262982310],
Cell[1792, 74, 267, 8, 70, "GuideText",
 CellID->272663151],
Cell[2062, 84, 257, 8, 70, "GuideText",
 CellID->236587240],
Cell[2322, 94, 44, 1, 70, "GuideDelimiter",
 CellID->27348],
Cell[2369, 97, 293, 8, 70, "GuideText",
 CellID->108714888],
Cell[2665, 107, 250, 8, 70, "GuideText",
 CellID->296960788],
Cell[2918, 117, 291, 8, 70, "GuideText",
 CellID->76191736],
Cell[3212, 127, 43, 1, 70, "GuideDelimiter",
 CellID->3788],
Cell[3258, 130, 276, 8, 70, "GuideText",
 CellID->830784634],
Cell[3537, 140, 283, 9, 70, "GuideText",
 CellID->332844657],
Cell[3823, 151, 271, 9, 70, "GuideText",
 CellID->327118875],
Cell[4097, 162, 44, 1, 70, "GuideDelimiter",
 CellID->17807],
Cell[4144, 165, 244, 8, 70, "GuideText",
 CellID->27563339],
Cell[4391, 175, 272, 9, 70, "GuideText",
 CellID->89108116],
Cell[4666, 186, 256, 9, 70, "GuideText",
 CellID->432505975],
Cell[4925, 197, 268, 9, 70, "GuideText",
 CellID->191105802],
Cell[5196, 208, 43, 1, 70, "GuideDelimiter",
 CellID->5249],
Cell[5242, 211, 289, 9, 70, "GuideText",
 CellID->68785311]
}, Open  ]],
Cell[CellGroupData[{
Cell[5568, 225, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12290],
Cell[5630, 228, 136, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[5769, 233, 147, 3, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[5931, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

