(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20662,        613]
NotebookOptionsPosition[     14267,        458]
NotebookOutlinePosition[     18390,        536]
CellTagsIndexPosition[     18347,        533]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Elliptic Functions", "GuideTitle",
 CellID->19008],

Cell[TextData[{
 "With careful standardization of argument conventions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides full coverage of all standard types of elliptic functions, with \
arbitrary-precision numerical evaluation for complex values of all \
parameters, as well as extensive symbolic transformations and \
simplifications."
}], "GuideAbstract",
 CellID->846208095],

Cell[CellGroupData[{

Cell["Jacobi Elliptic Functions", "GuideFunctionsSubsection",
 CellID->9781],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiCN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiCN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiDN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiDN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiCS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiCS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiDC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiDC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiDS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiDS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiNC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiNC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiND",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiND"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiNS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiNS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["JacobiSD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiSD"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->26504]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Jacobi Elliptic Functions", "GuideFunctionsSubsection",
 CellID->12392],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseJacobiSN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiCN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiDN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiDN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiCD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiCD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiCS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiCS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiDC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiDS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiNC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiNC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiND",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiND"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiNS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiNS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiSC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseJacobiSD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->32685]
}, Open  ]],

Cell[CellGroupData[{

Cell["Weierstrass Elliptic Functions", "GuideFunctionsSubsection",
 CellID->25313],

Cell[TextData[{
 Cell[TextData[ButtonBox["WeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassP"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeierstrassPPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassPPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeierstrassSigma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WeierstrassZeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6698]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Weierstrass Elliptic Functions", "GuideFunctionsSubsection",
 CellID->5589],

Cell[TextData[Cell[TextData[ButtonBox["InverseWeierstrassP",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/InverseWeierstrassP"]], "InlineFunctionSans"]], \
"InlineGuideFunctionListing",
 CellID->12722]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theta Functions", "GuideFunctionsSubsection",
 CellID->5938],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticTheta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticTheta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticThetaPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticThetaPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SiegelTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SiegelTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->19037],

Cell[TextData[{
 Cell[TextData[ButtonBox["NevilleThetaC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NevilleThetaC"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NevilleThetaD",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NevilleThetaD"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NevilleThetaN",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NevilleThetaN"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NevilleThetaS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NevilleThetaS"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->28090683]
}, Open  ]],

Cell[CellGroupData[{

Cell["Elliptic Exponential Functions", "GuideFunctionsSubsection",
 CellID->487914987],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticExp",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticExp"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticExpPrime",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticExpPrime"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticLog"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->795423471],

Cell["\t", "GuideDelimiter",
 CellID->6410],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobiAmplitude",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from argument ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and parameter ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " to amplitude ",
 Cell[BoxData[
  FormBox["\[Phi]", TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->31461],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from parameter ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " to nome ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->6234],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseEllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from nome ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " to parameter ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " "
}], "GuideText",
 CellID->12508],

Cell["\t", "GuideDelimiter",
 CellID->9961],

Cell[TextData[{
 Cell[TextData[ButtonBox["WeierstrassInvariants",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from half-periods to invariants"
}], "GuideText",
 CellID->3959],

Cell[TextData[{
 Cell[TextData[ButtonBox["WeierstrassHalfPeriods",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from invariants to half-periods"
}], "GuideText",
 CellID->6493]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->1515],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "GuideTutorial",
 CellID->25269]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->28869],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "GuideMoreAbout",
 CellID->58],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->14700]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->84651640],

Cell[TextData[{
 ButtonBox["Demonstrations related to Elliptic Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
EllipticExp+OR+EllipticExpPrime+OR+EllipticLog+OR+EllipticNomeQ+OR+\
EllipticTheta+OR+EllipticThetaPrime+OR+InverseEllipticNomeQ+OR+\
InverseJacobiCD+OR+InverseJacobiCN+OR+InverseJacobiCS+OR+InverseJacobiDC+OR+\
InverseJacobiDN+OR+InverseJacobiDS+OR+InverseJacobiNC+OR+InverseJacobiND+OR+\
InverseJacobiNS+OR+InverseJacobiSC+OR+InverseJacobiSD+OR+InverseJacobiSN+OR+\
InverseWeierstrassP+OR+JacobiAmplitude+OR+JacobiCD+OR+JacobiCN+OR+JacobiCS+OR+\
JacobiDC+OR+JacobiDN+OR+JacobiDS+OR+JacobiNC+OR+JacobiND+OR+JacobiNS+OR+\
JacobiSC+OR+JacobiSD+OR+JacobiSN+OR+NevilleThetaC+OR+NevilleThetaD+OR+\
NevilleThetaN+OR+NevilleThetaS+OR+SiegelTheta+OR+WeierstrassHalfPeriods+OR+\
WeierstrassInvariants+OR+WeierstrassP+OR+WeierstrassPPrime+OR+\
WeierstrassSigma+OR+WeierstrassZeta)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->347347350]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elliptic Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 8.0143092}", "context" -> "", 
    "keywords" -> {
     "amplitude", "cd", "cn", "cnoid", "cs", "dc", 
      "derivative of Weierstrass elliptic P function", "dn", "dnoid", 
      "double-periodic function", "doubly periodic function", "ds", "eexp", 
      "elliptic curve", "elliptic exp", "elliptic exponential", 
      "elliptic exp prime", "elliptic function", "elliptic functions", 
      "elliptic Jacobi function", "elliptic log", "elliptic logarithm", 
      "elliptic modulus", "elliptic Neville theta function C", 
      "elliptic nome", "ellipticnome", "elliptic theta", 
      "elliptic theta prime", "elog", "half-periods", "halfperiods", 
      "half\\[Hyphen]period values", "inverse elliptic nome", 
      "inverse Jacobi", "inverse Jacobi CD", "inverse Jacobi CN", 
      "inverse Jacobi CS", "inverse Jacobi DC", "inverse Jacobi DN", 
      "inverse Jacobi DS", "inverse Jacobi elliptic function cd", 
      "inverse Jacobi elliptic function cn", 
      "inverse Jacobi elliptic function cs", 
      "inverse Jacobi elliptic function dc", 
      "inverse Jacobi elliptic function dn", 
      "inverse Jacobi elliptic function ds", 
      "inverse Jacobi elliptic function nc", 
      "inverse Jacobi elliptic function nd", 
      "inverse Jacobi elliptic function ns", 
      "inverse Jacobi elliptic function sc", 
      "inverse Jacobi elliptic function sd", 
      "inverse Jacobi elliptic function sn", "inverse Jacobi NC", 
      "inverse Jacobi ND", 
      "inverse Jacobi NS inverse Jacobi elliptic function NS", 
      "inverse Jacobi SC", "inverse Jacobi SD", "inverse Jacobi SN", 
      "inverse Weierstrass", "inverse Weierstrass elliptic function", 
      "jacobi am", "jacobiam", "Jacobi amplitude", "Jacobi CD", 
      "Jacobi elliptic function", "Jacobi elliptic function cd", 
      "Jacobi elliptic function cn", "Jacobi elliptic function cs", 
      "Jacobi elliptic function dc", "Jacobi elliptic function dn", 
      "Jacobi elliptic function ds", "Jacobi elliptic function nc", 
      "Jacobi elliptic function nd", "Jacobi elliptic function ns", 
      "Jacobi elliptic functions", "Jacobi elliptic function sc", 
      "Jacobi elliptic function sd", "Jacobi elliptic function sn", 
      "Jacobi theta 1", "Jacobi theta 2", "Jacobi theta 3", "Jacobi theta 4", 
      "modular angle", "nc", "nd", "Neville theta", "Neville theta function", 
      "nome", "ns", "pendulum", "pendulum problem", "Riemann-Siegel theta", 
      "Riemann theta function", "sc", "sd", "Siegel theta", 
      "Siegel theta function", "sn", "snoid", "theta1", "theta2", "theta3", 
      "theta4", "theta function", "Weierstrass elliptic function", 
      "Weierstrass elliptic functions", "Weierstrass half periods", 
      "Weierstrass invariants", "Weierstrass P", "Weierstrass P prime", 
      "Weierstrass prime", "Weierstrass sigma", "Weierstrass sigma function", 
      "Weierstrass zeta", "Weierstrass zeta function"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "With careful standardization of argument conventions, Mathematica \
provides full coverage of all standard types of elliptic functions, with \
arbitrary-precision numerical evaluation for complex values of all \
parameters, as well as extensive symbolic transformations and \
simplifications.", "synonyms" -> {}, "title" -> "Elliptic Functions", "type" -> 
    "Guide", "uri" -> "guide/EllipticFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->19008],
Cell[678, 28, 393, 9, 70, "GuideAbstract",
 CellID->846208095],
Cell[CellGroupData[{
Cell[1096, 41, 76, 1, 70, "GuideFunctionsSubsection",
 CellID->9781],
Cell[1175, 44, 2472, 71, 70, "InlineGuideFunctionListing",
 CellID->26504]
}, Open  ]],
Cell[CellGroupData[{
Cell[3684, 120, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->12392],
Cell[3772, 123, 2640, 71, 70, "InlineGuideFunctionListing",
 CellID->32685]
}, Open  ]],
Cell[CellGroupData[{
Cell[6449, 199, 82, 1, 70, "GuideFunctionsSubsection",
 CellID->25313],
Cell[6534, 202, 863, 23, 70, "InlineGuideFunctionListing",
 CellID->6698]
}, Open  ]],
Cell[CellGroupData[{
Cell[7434, 230, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->5589],
Cell[7526, 233, 204, 5, 70, "InlineGuideFunctionListing",
 CellID->12722]
}, Open  ]],
Cell[CellGroupData[{
Cell[7767, 243, 66, 1, 70, "GuideFunctionsSubsection",
 CellID->5938],
Cell[7836, 246, 781, 20, 70, "InlineGuideFunctionListing",
 CellID->19037],
Cell[8620, 268, 851, 23, 70, "InlineGuideFunctionListing",
 CellID->28090683]
}, Open  ]],
Cell[CellGroupData[{
Cell[9508, 296, 86, 1, 70, "GuideFunctionsSubsection",
 CellID->487914987],
Cell[9597, 299, 632, 17, 70, "InlineGuideFunctionListing",
 CellID->795423471],
Cell[10232, 318, 43, 1, 70, "GuideDelimiter",
 CellID->6410],
Cell[10278, 321, 492, 16, 70, "GuideText",
 CellID->31461],
Cell[10773, 339, 394, 13, 70, "GuideText",
 CellID->6234],
Cell[11170, 354, 415, 14, 70, "GuideText",
 CellID->12508],
Cell[11588, 370, 43, 1, 70, "GuideDelimiter",
 CellID->9961],
Cell[11634, 373, 284, 8, 70, "GuideText",
 CellID->3959],
Cell[11921, 383, 286, 8, 70, "GuideText",
 CellID->6493]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12256, 397, 57, 1, 70, "GuideTutorialsSection",
 CellID->1515],
Cell[12316, 400, 196, 4, 70, "GuideTutorial",
 CellID->25269]
}, Open  ]],
Cell[CellGroupData[{
Cell[12549, 409, 59, 1, 70, "GuideMoreAboutSection",
 CellID->28869],
Cell[12611, 412, 145, 3, 70, "GuideMoreAbout",
 CellID->58],
Cell[12759, 417, 146, 3, 70, "GuideMoreAbout",
 CellID->14700]
}, Open  ]],
Cell[CellGroupData[{
Cell[12942, 425, 68, 1, 70, "GuideRelatedLinksSection",
 CellID->84651640],
Cell[13013, 428, 1212, 25, 70, "GuideRelatedLinks",
 CellID->347347350]
}, Open  ]],
Cell[14240, 456, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

