(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9032,        299]
NotebookOptionsPosition[      5817,        212]
NotebookOutlinePosition[      7812,        256]
CellTagsIndexPosition[      7769,        253]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Elliptic Integrals", "GuideTitle",
 CellID->16215],

Cell[TextData[{
 "With careful standardization of argument conventions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides full coverage of elliptic integrals, with arbitrary-precision \
numerical evaluation for complex values of all parameters, as well as \
extensive symbolic transformations and simplifications."
}], "GuideAbstract",
 CellID->846208095],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticK",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticK"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete elliptic integral of the first kind"
}], "GuideText",
 CellID->30212],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticF",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " in",
 "complete elliptic integral of the first kind"
}], "GuideText",
 CellID->29288],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticE"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete and incomplete elliptic integral of the second kind"
}], "GuideText",
 CellID->28082],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticPi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticPi"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete and incomplete elliptic integral of the third kind"
}], "GuideText",
 CellID->1954],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobiZeta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiZeta"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["EllipticLog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticLog"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ArithmeticGeometricMean",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ArithmeticGeometricMean"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseWeierstrassP",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseWeierstrassP"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->16085],

Cell["\t", "GuideDelimiter",
 CellID->20710],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from parameter ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " to nome ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"]
}], "GuideText",
 CellID->24484],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseEllipticNomeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from nome ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " to parameter ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " "
}], "GuideText",
 CellID->24774],

Cell[TextData[{
 Cell[TextData[ButtonBox["JacobiAmplitude",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from argument ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and parameter ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " to amplitude ",
 Cell[BoxData[
  StyleBox["\[Phi]", "TR"]], "InlineFormula"]
}], "GuideText",
 CellID->8380]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->29815],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "GuideTutorial",
 CellID->25269]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18115],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "GuideMoreAbout",
 CellID->1679],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->17110]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1105939166],

Cell[TextData[{
 ButtonBox["Demonstrations related to Elliptic Integrals",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ArithmeticGeometricMean+OR+EllipticE+OR+EllipticF+OR+EllipticK+OR+EllipticLog+\
OR+EllipticNomeQ+OR+EllipticPi+OR+InverseEllipticNomeQ+OR+InverseWeierstrassP+\
OR+JacobiAmplitude+OR+JacobiZeta)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->12854278]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Elliptic Integrals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 8.8268300}", "context" -> "", 
    "keywords" -> {
     "amplitude", "complete elliptic integral", "ellipticce", "ellipticck", 
      "ellipticcpi", "elliptic curve", "elliptic function", 
      "elliptic functions", "elliptic integral", 
      "elliptic integral of first kind", "elliptic integral of second kind", 
      "elliptic integral of the third kind", "elliptic log", 
      "elliptic logarithm", "elliptic modulus", "elliptic nome", 
      "ellipticnome", "elliptic pi", "elog", "Gauss AGM", 
      "incomplete elliptic integral", "inverse elliptic nome", 
      "inverse Weierstrass", "inverse Weierstrass elliptic function", 
      "jacobi am", "jacobiam", "Jacobi amplitude", "Jacobi zeta", 
      "Jacobi zeta function", "modular angle", "nome", "pendulum", 
      "Weierstrass elliptic functions", "zeta function"}, "index" -> True, 
    "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "With careful standardization of argument conventions, Mathematica \
provides full coverage of elliptic integrals, with arbitrary-precision \
numerical evaluation for complex values of all parameters, as well as \
extensive symbolic transformations and simplifications.", "synonyms" -> {}, 
    "title" -> "Elliptic Integrals", "type" -> "Guide", "uri" -> 
    "guide/EllipticIntegrals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->16215],
Cell[678, 28, 369, 8, 70, "GuideAbstract",
 CellID->846208095],
Cell[1050, 38, 266, 8, 70, "GuideText",
 CellID->30212],
Cell[1319, 48, 273, 9, 70, "GuideText",
 CellID->29288],
Cell[1595, 59, 282, 8, 70, "GuideText",
 CellID->28082],
Cell[1880, 69, 282, 8, 70, "GuideText",
 CellID->1954],
Cell[2165, 79, 870, 23, 70, "InlineGuideFunctionListing",
 CellID->16085],
Cell[3038, 104, 44, 1, 70, "GuideDelimiter",
 CellID->20710],
Cell[3085, 107, 381, 13, 70, "GuideText",
 CellID->24484],
Cell[3469, 122, 401, 14, 70, "GuideText",
 CellID->24774],
Cell[3873, 138, 470, 16, 70, "GuideText",
 CellID->8380]
}, Open  ]],
Cell[CellGroupData[{
Cell[4380, 159, 58, 1, 70, "GuideTutorialsSection",
 CellID->29815],
Cell[4441, 162, 196, 4, 70, "GuideTutorial",
 CellID->25269]
}, Open  ]],
Cell[CellGroupData[{
Cell[4674, 171, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18115],
Cell[4736, 174, 147, 3, 70, "GuideMoreAbout",
 CellID->1679],
Cell[4886, 179, 146, 3, 70, "GuideMoreAbout",
 CellID->17110]
}, Open  ]],
Cell[CellGroupData[{
Cell[5069, 187, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1105939166],
Cell[5142, 190, 633, 17, 70, "GuideRelatedLinks",
 CellID->12854278]
}, Open  ]],
Cell[5790, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

