(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17810,        534]
NotebookOptionsPosition[      9905,        349]
NotebookOutlinePosition[     14821,        435]
CellTagsIndexPosition[     14778,        432]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Equation Solving", "GuideTitle",
 CellID->23977],

Cell[TextData[{
 "Built into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the world's largest collection of both numerical and symbolic equation \
solving capabilities\[LongDash]with many original algorithms, all \
automatically accessed through a small number of exceptionally powerful \
functions",
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture allows both equations and their solutions to be \
conveniently given in symbolic form, and immediately integrated into \
computations and visualizations."
}], "GuideAbstract",
 CellID->110406540],

Cell[TextData[{
 Cell[TextData[ButtonBox["Solve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Solve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " exact solutions to equations and systems"
}], "GuideText",
 CellID->12941],

Cell[TextData[{
 Cell[TextData[ButtonBox["NSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " general numerical solutions to equations and systems"
}], "GuideText",
 CellID->15790],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindRoot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerically find local roots of equations"
}], "GuideText",
 CellID->1723],

Cell["\t", "GuideDelimiter",
 CellID->21363],

Cell[TextData[{
 Cell[TextData[ButtonBox["DSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " exact solutions to differential equations"
}], "GuideText",
 CellID->28],

Cell[TextData[{
 Cell[TextData[ButtonBox["NDSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NDSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical solutions to differential equations"
}], "GuideText",
 CellID->25184],

Cell["\t", "GuideDelimiter",
 CellID->24778],

Cell[TextData[{
 Cell[TextData[ButtonBox["RSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/RSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " exact solutions to recurrence equations"
}], "GuideText",
 CellID->7200],

Cell["\t", "GuideDelimiter",
 CellID->5071],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindInstance",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FindInstance"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " find particular solutions to equations and inequalities"
}], "GuideText",
 CellID->1885],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " reduce equations and inequalities"
}], "GuideText",
 CellID->21974],

Cell["\t", "GuideDelimiter",
 CellID->1071],

Cell[TextData[{
 Cell[TextData[ButtonBox["LinearSolve",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LinearSolve"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve linear systems in matrix form"
}], "GuideText",
 CellID->11333],

Cell["\t", "GuideDelimiter",
 CellID->22867],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot solution curves and surfaces"
}], "GuideText",
 CellID->26153],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 ", ",
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " plot regions satisfied by inequalities"
}], "GuideText",
 CellID->14295]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->32168],

Cell[TextData[ButtonBox["Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Equations"]], "GuideTutorial",
 CellID->150036532],

Cell[TextData[ButtonBox["Equations in One Variable",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EquationsInOneVariable"]], "GuideTutorial",
 CellID->474170359],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "GuideTutorial",
 CellID->85540191],

Cell[TextData[ButtonBox["Numerical Root Finding",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalRootFinding"]], "GuideTutorial",
 CellID->57687666],

Cell[TextData[ButtonBox["Eliminating Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EliminatingVariables"]], "GuideTutorial",
 CellID->550913970],

Cell[TextData[ButtonBox["Numerical Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalEquationSolving"]], "GuideTutorial",
 CellID->181447341],

Cell[TextData[ButtonBox["Simultaneous Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimultaneousEquations"]], "GuideTutorial",
 CellID->240522383],

Cell[TextData[ButtonBox["Solving Recurrence Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingRecurrenceEquations"]], "GuideTutorial",
 CellID->810481074],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "GuideTutorial",
 CellID->142739167],

Cell[TextData[ButtonBox["Numerical Differential Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalDifferentialEquations"]], "GuideTutorial",
 CellID->131051164],

Cell[TextData[ButtonBox["Numerical Solution of Differential Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalSolutionOfDifferentialEquations"]], \
"GuideTutorial",
 CellID->44859305],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "GuideTutorial",
 CellID->30585418]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->2598],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "GuideMoreAboutSub",
 CellID->3309],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "GuideMoreAbout",
 CellID->4693],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "GuideMoreAbout",
 CellID->108407693],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "GuideMoreAbout",
 CellID->30080],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "GuideMoreAbout",
 CellID->10116],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "GuideMoreAbout",
 CellID->12249],

Cell[TextData[ButtonBox["Recurrence Equation Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "GuideMoreAbout",
 CellID->26667],

Cell[TextData[ButtonBox["Matrices & Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "GuideMoreAboutSub",
 CellID->1528],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "GuideMoreAboutSub",
 CellID->26679],

Cell[TextData[ButtonBox["Polynomial Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAboutSub",
 CellID->7864],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "GuideMoreAboutSub",
 CellID->29421],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "GuideMoreAboutSub",
 CellID->8826]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1048598177],

Cell[TextData[{
 ButtonBox["Demonstrations related to Equation Solving",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
DSolve+OR+FindInstance+OR+FindRoot+OR+LinearSolve+OR+NDSolve+OR+NSolve+OR+\
Reduce+OR+RSolve+OR+Solve)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->60905643]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Equation Solving - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 9.1862142}", "context" -> "", 
    "keywords" -> {
     "Abel equation", "Abramov algorithm", "Adams methods", 
      "adaptive procedure", "Airy's differential equation", 
      "algebraically constructive sets", "algebraic equations", 
      "algebraic inequalities", "algebraic inequations", 
      "analytical solution", "arithmetic difference equations", "BDF methods",
       "Bernoulli equation", "Bocharov techniques", "Boolean satisfiability", 
      "boundary conditions", "Brent method", "Bronstein algorithm", "BVP", 
      "chasing method", "chinese remainder theorem", "closed-form solution", 
      "common roots of equations", "complex variables", "contour levels", 
      "contour lines", "contour plot", "contour plot 3D", "contour surface", 
      "counter-example", "cylindrical decomposition", "DAE", "diff", "diffeq",
       "difference-algebraic equations", "difference equations", 
      "differential-algebraic equations", "differential equations", 
      "Diophantine equations", "direct equation solving method", 
      "direct method for root finding", "direct solver methods", 
      "discrete equations", "divide-and-conquer equations", 
      "division of matrices", "domains", "equations", "Fibonacci equations", 
      "find instance", "find root", "finite difference equations", 
      "Gaussian elimination", "gear method", "Gel'fand-Lokutsiyevskii method",
       "Gelfand-Lokutsiyevskii method", "geometric difference equations", 
      "Germundsson methods", "Goktas methods", "Groebner basis", 
      "Hamilton-Jacobi equations", "Hardy-Muskat-Williams methods", 
      "homogeneous differential equations", "inequalities", "inequations", 
      "inhomogeneous differential equations", "initial conditions", 
      "integer equations", "integer sequence equations", 
      "iterative root finding", "Jenkins-Traub algorithm", "Kamke", 
      "Kovacic algorithm", "Krylov methods", "linear differential equations", 
      "linear equations", "linear inequalities", "LINPACK", "LSODA", 
      "matrix equations", "Mellin transform methods", "method of lines", 
      "modular equations", "multifrontal methods", 
      "multivariate differential equations", "Newton-Raphson method", 
      "Newton's method", "nonlinear differential equations", 
      "numerical root finding", "numerical solving", 
      "numerical solution of differential equations", 
      "numerical solution of polynomial equations", "ODE", 
      "ordinary differential equations", "partial difference equations", 
      "partial differential equations", "partial recurrence equations", "PDE",
       "Pell equations", "phase plots", "piecewise differential equations", 
      "plot region", "plot volume", "polynomial equations", 
      "polynomial inequalities", "polynomial root finding", 
      "quasi algebraic sets", "recurrence equations", "recursion equations", 
      "reducing inequalities", "region plot", "region plot3", 
      "region plot 3D", "Riccati equations", "roots of equations", 
      "roots of polynomials", "Runge-Kutta methods", "sample points", 
      "satisfiability", "SAT problem", "secant method", "semi-algebraic sets",
       "sequence equations", "singularities", "solution of equations", 
      "solution of linear systems", "solution of polynomial equations", 
      "solutions", "solve algebraic equations", 
      "solving differential equations", "solving equations", 
      "solving systems of equations", "symmetry reduction", "Thue equations", 
      "transcendental equations", "transcendental inequalities", 
      "transcendental roots"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Built into Mathematica is the world's largest collection of both \
numerical and symbolic equation solving capabilities--with many original \
algorithms, all automatically accessed through a small number of \
exceptionally powerful functions. Mathematica's symbolic architecture allows \
both equations and their solutions to be conveniently given in symbolic form, \
and immediately integrated into computations and visualizations.", 
    "synonyms" -> {}, "title" -> "Equation Solving", "type" -> "Guide", "uri" -> 
    "guide/EquationSolving"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 54, 1, 70, "GuideTitle",
 CellID->23977],
Cell[676, 28, 592, 15, 70, "GuideAbstract",
 CellID->110406540],
Cell[1271, 45, 254, 8, 70, "GuideText",
 CellID->12941],
Cell[1528, 55, 268, 8, 70, "GuideText",
 CellID->15790],
Cell[1799, 65, 260, 8, 70, "GuideText",
 CellID->1723],
Cell[2062, 75, 44, 1, 70, "GuideDelimiter",
 CellID->21363],
Cell[2109, 78, 254, 8, 70, "GuideText",
 CellID->28],
Cell[2366, 88, 263, 8, 70, "GuideText",
 CellID->25184],
Cell[2632, 98, 44, 1, 70, "GuideDelimiter",
 CellID->24778],
Cell[2679, 101, 254, 8, 70, "GuideText",
 CellID->7200],
Cell[2936, 111, 43, 1, 70, "GuideDelimiter",
 CellID->5071],
Cell[2982, 114, 282, 8, 70, "GuideText",
 CellID->1885],
Cell[3267, 124, 249, 8, 70, "GuideText",
 CellID->21974],
Cell[3519, 134, 43, 1, 70, "GuideDelimiter",
 CellID->1071],
Cell[3565, 137, 261, 8, 70, "GuideText",
 CellID->11333],
Cell[3829, 147, 44, 1, 70, "GuideDelimiter",
 CellID->22867],
Cell[3876, 150, 541, 15, 70, "GuideText",
 CellID->26153],
Cell[4420, 167, 687, 18, 70, "GuideText",
 CellID->14295]
}, Open  ]],
Cell[CellGroupData[{
Cell[5144, 190, 58, 1, 70, "GuideTutorialsSection",
 CellID->32168],
Cell[5205, 193, 137, 3, 70, "GuideTutorial",
 CellID->150036532],
Cell[5345, 198, 166, 3, 70, "GuideTutorial",
 CellID->474170359],
Cell[5514, 203, 151, 3, 70, "GuideTutorial",
 CellID->85540191],
Cell[5668, 208, 160, 3, 70, "GuideTutorial",
 CellID->57687666],
Cell[5831, 213, 160, 3, 70, "GuideTutorial",
 CellID->550913970],
Cell[5994, 218, 169, 3, 70, "GuideTutorial",
 CellID->181447341],
Cell[6166, 223, 162, 3, 70, "GuideTutorial",
 CellID->240522383],
Cell[6331, 228, 173, 3, 70, "GuideTutorial",
 CellID->810481074],
Cell[6507, 233, 174, 3, 70, "GuideTutorial",
 CellID->142739167],
Cell[6684, 238, 184, 4, 70, "GuideTutorial",
 CellID->131051164],
Cell[6871, 244, 207, 5, 70, "GuideTutorial",
 CellID->44859305],
Cell[7081, 251, 168, 3, 70, "GuideTutorial",
 CellID->30585418]
}, Open  ]],
Cell[CellGroupData[{
Cell[7286, 259, 58, 1, 70, "GuideMoreAboutSection",
 CellID->2598],
Cell[7347, 262, 158, 3, 70, "GuideMoreAboutSub",
 CellID->3309],
Cell[7508, 267, 139, 3, 70, "GuideMoreAbout",
 CellID->4693],
Cell[7650, 272, 156, 3, 70, "GuideMoreAbout",
 CellID->108407693],
Cell[7809, 277, 137, 3, 70, "GuideMoreAbout",
 CellID->30080],
Cell[7949, 282, 156, 3, 70, "GuideMoreAbout",
 CellID->10116],
Cell[8108, 287, 154, 3, 70, "GuideMoreAbout",
 CellID->12249],
Cell[8265, 292, 167, 3, 70, "GuideMoreAbout",
 CellID->26667],
Cell[8435, 297, 164, 3, 70, "GuideMoreAboutSub",
 CellID->1528],
Cell[8602, 302, 149, 3, 70, "GuideMoreAboutSub",
 CellID->26679],
Cell[8754, 307, 155, 3, 70, "GuideMoreAboutSub",
 CellID->7864],
Cell[8912, 312, 140, 3, 70, "GuideMoreAboutSub",
 CellID->29421],
Cell[9055, 317, 158, 3, 70, "GuideMoreAboutSub",
 CellID->8826]
}, Open  ]],
Cell[CellGroupData[{
Cell[9250, 325, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1048598177],
Cell[9323, 328, 540, 16, 70, "GuideRelatedLinks",
 CellID->60905643]
}, Open  ]],
Cell[9878, 347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

