(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9918,        317]
NotebookOptionsPosition[      6232,        218]
NotebookOutlinePosition[      8397,        264]
CellTagsIndexPosition[      8354,        261]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Error and Exponential Integral Functions", "GuideTitle",
 CellID->6816],

Cell[TextData[{
 "Using original algorithms developed at Wolfram Research, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates error and exponential integral functions anywhere in the complex \
plane, to arbitrary precision\[LongDash]as well as supporting series \
expansions with careful attention to branch cuts, and an extensive web of \
symbolic transformations."
}], "GuideAbstract",
 CellID->7516],

Cell[CellGroupData[{

Cell["Error Functions", "GuideFunctionsSubsection",
 CellID->27681],

Cell[TextData[{
 Cell[TextData[ButtonBox["Erf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Erfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erfc"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Erfi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Erfi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseErf",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErf"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseErfc",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseErfc"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19964]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exponential Integrals", "GuideFunctionsSubsection",
 CellID->1340],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExpIntegralE",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpIntegralE"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpIntegralEi",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogIntegral"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->5686]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fresnel Functions", "GuideFunctionsSubsection",
 CellID->6021],

Cell[TextData[{
 Cell[TextData[ButtonBox["FresnelS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FresnelS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FresnelC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FresnelC"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->11662]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometric & Hyperbolic Integrals", "GuideFunctionsSubsection",
 CellID->14721],

Cell[TextData[{
 Cell[TextData[ButtonBox["SinIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SinIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CosIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CosIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SinhIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SinhIntegral"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CoshIntegral",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CoshIntegral"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6064]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->29309],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->29873],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAbout",
 CellID->14700],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "GuideMoreAbout",
 CellID->2670],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAbout",
 CellID->16141],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "GuideMoreAboutSub",
 CellID->21766]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1538753557],

Cell[TextData[{
 ButtonBox["Demonstrations related to Error and Exponential Integral \
Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
CoshIntegral+OR+CosIntegral+OR+Erf+OR+Erfc+OR+Erfi+OR+ExpIntegralE+OR+\
ExpIntegralEi+OR+FresnelC+OR+FresnelS+OR+InverseErf+OR+InverseErfc+OR+\
LogIntegral+OR+SinhIntegral+OR+SinIntegral)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->379266673]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Error and Exponential Integral Functions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 10.1237382}", "context" -> "", 
    "keywords" -> {
     "chi", "ci", "complementary error function", "confidence intervals", 
      "Cornu spiral", "cosh integral", "cosine integral", "cos integral", 
      "Dawson function", "Dawson integral", "ei", "en-function", 
      "error function", "expint", "exp integral", "exp integral ei", 
      "exponential integral", "Fresnel diffraction", "Fresnel functions", 
      "Fresnel integral", "Fresnel integral C", "Fresnel integral S", 
      "Gaussian distribution", "Gaussian random numbers", 
      "hyperbolic cosine integral", "hyperbolic sine integral", 
      "hyperbolic sinus integral", "imaginary error function", "inverse erf", 
      "inverse erfc", "law of big numbers", "li", "logarithmic integral", 
      "log integral", "shi", "si", "sine integral", "sinh integral", 
      "sin integral", "sinus integral", "Ssi", "statistics"}, "index" -> True,
     "label" -> "Mathematica Guide", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Using original algorithms developed at Wolfram Research, Mathematica \
evaluates error and exponential integral functions anywhere in the complex \
plane, to arbitrary precision--as well as supporting series expansions with \
careful attention to branch cuts, and an extensive web of symbolic \
transformations.", "synonyms" -> {}, "title" -> 
    "Error and Exponential Integral Functions", "type" -> "Guide", "uri" -> 
    "guide/ErrorAndExponentialIntegralFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 77, 1, 70, "GuideTitle",
 CellID->6816],
Cell[699, 28, 416, 9, 70, "GuideAbstract",
 CellID->7516],
Cell[CellGroupData[{
Cell[1140, 41, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->27681],
Cell[1210, 44, 1000, 29, 70, "InlineGuideFunctionListing",
 CellID->19964]
}, Open  ]],
Cell[CellGroupData[{
Cell[2247, 78, 72, 1, 70, "GuideFunctionsSubsection",
 CellID->1340],
Cell[2322, 81, 623, 17, 70, "InlineGuideFunctionListing",
 CellID->5686]
}, Open  ]],
Cell[CellGroupData[{
Cell[2982, 103, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->6021],
Cell[3053, 106, 392, 11, 70, "InlineGuideFunctionListing",
 CellID->11662]
}, Open  ]],
Cell[CellGroupData[{
Cell[3482, 122, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->14721],
Cell[3573, 125, 835, 23, 70, "InlineGuideFunctionListing",
 CellID->6064]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4457, 154, 58, 1, 70, "GuideTutorialsSection",
 CellID->29309],
Cell[4518, 157, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[4703, 165, 59, 1, 70, "GuideMoreAboutSection",
 CellID->29873],
Cell[4765, 168, 146, 3, 70, "GuideMoreAbout",
 CellID->14700],
Cell[4914, 173, 165, 3, 70, "GuideMoreAbout",
 CellID->2670],
Cell[5082, 178, 182, 4, 70, "GuideMoreAbout",
 CellID->16141],
Cell[5267, 184, 161, 3, 70, "GuideMoreAboutSub",
 CellID->21766]
}, Open  ]],
Cell[CellGroupData[{
Cell[5465, 192, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1538753557],
Cell[5538, 195, 652, 18, 70, "GuideRelatedLinks",
 CellID->379266673]
}, Open  ]],
Cell[6205, 216, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

