(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15804,        523]
NotebookOptionsPosition[     10728,        387]
NotebookOutlinePosition[     13237,        438]
CellTagsIndexPosition[     13194,        435]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Evaluation Control", "GuideTitle",
 CellID->27531],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " normally takes any expression it is given, and evaluates it as far as \
possible. But built into the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language is a collection of flexible primitives that allow finer control \
over the process of evaluation in cases where it is needed."
}], "GuideAbstract",
 CellID->28178982],

Cell[CellGroupData[{

Cell["Evaluation Control for Complete Expressions", "GuideFunctionsSubsection",
 CellID->244650667],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hold"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "hold an expression unevaluated"
}], "GuideText",
 CellID->26630],

Cell[TextData[{
 Cell[TextData[ButtonBox["HoldForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display an expression in unevaluated form"
}], "GuideText",
 CellID->24114],

Cell[TextData[{
 Cell[TextData[ButtonBox["Defer",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Defer"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "display unevaluated, but evaluate if given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input"
}], "GuideText",
 CellID->88649987]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation Control for Function Arguments", "GuideFunctionsSubsection",
 CellID->401300698],

Cell[TextData[{
 Cell[TextData[ButtonBox["HoldAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldAll"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["HoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldFirst"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["HoldRest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldRest"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " attributes for specifying held function arguments"
}], "GuideText",
 CellID->45310612],

Cell[TextData[{
 Cell[TextData[ButtonBox["Evaluate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Evaluate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "immediately evaluate a function argument"
}], "GuideText",
 CellID->82368107],

Cell[TextData[{
 Cell[TextData[ButtonBox["Unevaluated",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Unevaluated"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pass a function argument unevaluated"
}], "GuideText",
 CellID->888636630]
}, Open  ]],

Cell[CellGroupData[{

Cell["More Detailed Control", "GuideFunctionsSubsection",
 CellID->770860924],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReleaseHold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReleaseHold"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "release hold constructs"
}], "GuideText",
 CellID->623278914],

Cell[TextData[{
 Cell[TextData[ButtonBox["HoldComplete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldComplete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldPattern",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldPattern"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldAllComplete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SequenceHold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SequenceHold"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Update",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Update"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->659555886],

Cell[TextData[{
 Cell[TextData[ButtonBox["NHoldAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldAll"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NHoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldFirst"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["NHoldRest",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NHoldRest"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " prevent numerical evaluation of arguments"
}], "GuideText",
 CellID->86278872],

Cell["\t", "GuideDelimiterSubsection",
 CellID->72108007]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manipulating Unevaluated Expressions", "GuideFunctionsSubsection",
 CellID->163356105],

Cell[TextData[{
 Cell[TextData[ButtonBox["With",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/With"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "insert variable values without evaluation"
}], "GuideText",
 CellID->559528915],

Cell[TextData[{
 Cell[TextData[ButtonBox["Extract",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Extract"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extract numbered parts without evaluation"
}], "GuideText",
 CellID->4618805],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["/.",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplaceAll"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Delete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Delete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->90395394],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToString",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToString"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["ToExpression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ToExpression"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "convert to and from string form"
}], "GuideText",
 CellID->365496317],

Cell["\t", "GuideDelimiterSubsection",
 CellID->523604932]
}, Open  ]],

Cell[CellGroupData[{

Cell["Global Evaluation Control", "GuideFunctionsSubsection",
 CellID->537126330],

Cell[TextData[{
 Cell[TextData[ButtonBox["$IterationLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$IterationLimit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["$RecursionLimit",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->3615308],

Cell["\t", "GuideDelimiterSubsection",
 CellID->188059714]
}, Open  ]],

Cell[CellGroupData[{

Cell["Evaluation in Notebooks", "GuideFunctionsSubsection",
 CellID->382595533],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dynamic",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Dynamic"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Refresh",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Refresh"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Evaluator",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Evaluator"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->182280963]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->26809],

Cell[TextData[ButtonBox["The Standard Evaluation Procedure",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheStandardEvaluationProcedure"]], "GuideTutorial",
 CellID->4084],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "GuideTutorial",
 CellID->125888630],

Cell[TextData[ButtonBox["Non-Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "GuideTutorial",
 CellID->113737799],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "GuideTutorial",
 CellID->23556],

Cell[TextData[ButtonBox["Controlling Numerical Evaluation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ControllingNumericalEvaluation"]], "GuideTutorial",
 CellID->811247356]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->12290],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "GuideMoreAbout",
 CellID->21293]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluation Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 10.5299986}", "context" -> "", 
    "keywords" -> {
     "constrained memory", "controlled transformations", "defer evaluation", 
      "evaluate button action", "evaluation", "evaluation at a point", 
      "evaluation chain", "evaluation with limited memory", 
      "evaluation with time constraints", "finite memory", "fixed variables", 
      "forcing evaluation", "held expressions", "hold all", 
      "hold all complete", "hold complete", "hold first", "hold form", 
      "hold pattern", "hold rest", "inert forms", "iteration limit", 
      "local constants", "lookahead", "memory constrained", 
      "memory constraints", "observer", "output of unevaluated expressions", 
      "overriding hold", "preventing evaluation in printing", 
      "preventing evaluation of arguments", "printing without evaluation", 
      "quote in Lisp", "recursion limit", "release hold", 
      "releasing held arguments", "stopping iteration", "stopping recursion", 
      "substitution", "temporary binding", "time constrained", 
      "time constraints", "to expression", "to string", 
      "transform expression to string", "unevaluated expressions", 
      "unevaluated patterns", "update dynamically", "update value", 
      "upvalues", "watch changes", "write-once variables", 
      "controlled evaluation", "eval", "infinite evaluation", "quoting"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica normally takes any expression it is given, and evaluates it \
as far as possible. But built into the Mathematica language is a collection \
of flexible primitives that allow finer control over the process of \
evaluation in cases where it is needed.", "synonyms" -> {}, "title" -> 
    "Evaluation Control", "type" -> "Guide", "uri" -> 
    "guide/EvaluationControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 56, 1, 70, "GuideTitle",
 CellID->27531],
Cell[678, 28, 399, 10, 70, "GuideAbstract",
 CellID->28178982],
Cell[CellGroupData[{
Cell[1102, 42, 99, 1, 70, "GuideFunctionsSubsection",
 CellID->244650667],
Cell[1204, 45, 247, 9, 70, "GuideText",
 CellID->26630],
Cell[1454, 56, 266, 9, 70, "GuideText",
 CellID->24114],
Cell[1723, 67, 473, 15, 70, "GuideText",
 CellID->88649987]
}, Open  ]],
Cell[CellGroupData[{
Cell[2233, 87, 97, 1, 70, "GuideFunctionsSubsection",
 CellID->401300698],
Cell[2333, 90, 526, 16, 70, "GuideText",
 CellID->45310612],
Cell[2862, 108, 268, 9, 70, "GuideText",
 CellID->82368107],
Cell[3133, 119, 271, 9, 70, "GuideText",
 CellID->888636630]
}, Open  ]],
Cell[CellGroupData[{
Cell[3441, 133, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->770860924],
Cell[3521, 136, 258, 9, 70, "GuideText",
 CellID->623278914],
Cell[3782, 147, 1052, 29, 70, "InlineGuideFunctionListing",
 CellID->659555886],
Cell[4837, 178, 524, 16, 70, "GuideText",
 CellID->86278872],
Cell[5364, 196, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->72108007]
}, Open  ]],
Cell[CellGroupData[{
Cell[5458, 202, 92, 1, 70, "GuideFunctionsSubsection",
 CellID->163356105],
Cell[5553, 205, 262, 9, 70, "GuideText",
 CellID->559528915],
Cell[5818, 216, 261, 8, 70, "GuideText",
 CellID->4618805],
Cell[6082, 226, 927, 28, 70, "InlineGuideFunctionListing",
 CellID->90395394],
Cell[7012, 256, 395, 13, 70, "GuideText",
 CellID->365496317],
Cell[7410, 271, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->523604932]
}, Open  ]],
Cell[CellGroupData[{
Cell[7505, 277, 81, 1, 70, "GuideFunctionsSubsection",
 CellID->537126330],
Cell[7589, 280, 870, 23, 70, "InlineGuideFunctionListing",
 CellID->3615308],
Cell[8462, 305, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->188059714]
}, Open  ]],
Cell[CellGroupData[{
Cell[8557, 311, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->382595533],
Cell[8639, 314, 892, 23, 70, "InlineGuideFunctionListing",
 CellID->182280963]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9580, 343, 58, 1, 70, "GuideTutorialsSection",
 CellID->26809],
Cell[9641, 346, 180, 4, 70, "GuideTutorial",
 CellID->4084],
Cell[9824, 352, 139, 3, 70, "GuideTutorial",
 CellID->125888630],
Cell[9966, 357, 163, 3, 70, "GuideTutorial",
 CellID->113737799],
Cell[10132, 362, 135, 3, 70, "GuideTutorial",
 CellID->23556],
Cell[10270, 367, 184, 4, 70, "GuideTutorial",
 CellID->811247356]
}, Open  ]],
Cell[CellGroupData[{
Cell[10491, 376, 59, 1, 70, "GuideMoreAboutSection",
 CellID->12290],
Cell[10553, 379, 133, 3, 70, "GuideMoreAbout",
 CellID->21293]
}, Open  ]],
Cell[10701, 385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

