(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10750,        371]
NotebookOptionsPosition[      7080,        272]
NotebookOutlinePosition[      9002,        314]
CellTagsIndexPosition[      8959,        311]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Expression Structure", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "A foundational idea in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that all expressions\[LongDash]whatever they may \
represent\[LongDash]ultimately have a uniform tree-like structure."
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the full functional form of an expression, without shortened syntax"
}], "GuideText",
 CellID->32108190],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TreeForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "a representation of the tree structure of small expressions"
}], "GuideText",
 CellID->145988226],

Cell["\t", "GuideDelimiter",
 CellID->371269339],

Cell[TextData[{
 Cell[TextData[ButtonBox["Head",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Head"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " the head of an expression: the ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"]
}], "GuideText",
 CellID->233161401],

Cell[TextData[{
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the number of elements in an expression"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->307240991],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[{
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numbered part of an expression"
}], "GuideText",
 CellID->526474126],

Cell[TextData[{
 Cell[TextData[ButtonBox["Level",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Level"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "parts specified by a given number of indices"
}], "GuideText",
 CellID->709320145],

Cell[TextData[{
 Cell[TextData[ButtonBox["Depth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Depth"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the maximum number of indices to specify any part"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiterSubsection",
 CellID->639217823],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Atomic Components of Expressions \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AtomicElementsOfExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->194271677],

Cell[TextData[{
 Cell[TextData[ButtonBox["Symbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Symbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Integer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Real",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Real"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["String",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/String"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->202346344],

Cell["\t", "GuideDelimiterSubsection",
 CellID->284178079]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expression Sizes & Signatures", "GuideFunctionsSubsection",
 CellID->41162128],

Cell[TextData[{
 Cell[TextData[ButtonBox["LeafCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LeafCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ByteCount",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ByteCount"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Hash",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hash"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->114172467]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "GuideTutorial",
 CellID->798979554],

Cell[TextData[ButtonBox["Expressions as Trees",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsAsTrees"]], "GuideTutorial",
 CellID->585774333],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "GuideTutorial",
 CellID->30897650],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "GuideTutorial",
 CellID->159600587]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[{
 ButtonBox["Expressions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Expressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Expressions"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/Expressions"]
}], "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expression Structure - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 14.6551042}", "context" -> "", 
    "keywords" -> {
     "args", "atoms", "communicating expressions", "communicating language", 
      "elements", "expressions", "expression serialization", 
      "expression trees", "full form", "functional notation", "function name",
       "head", "internal form", "language representation", "leaf count", 
      "length of list", "level of expression", "m-expr", "number of elements",
       "number of terms", "object serialization", "output of internal form", 
      "output of internal representation", "part of expression", "parts", 
      "parts at level", "pattern matching", "pointer structure", 
      "prefix form", "sequence of elements", "serialization", "size", 
      "s-expr", "transmitting expressions", "tree form", 
      "tree formatted expression", "tree formatting", "tree representation", 
      "trees", "tree structure"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "A foundational idea in Mathematica is that all expressions--whatever \
they may represent--ultimately have a uniform tree-like structure.", 
    "synonyms" -> {}, "title" -> "Expression Structure", "type" -> "Guide", 
    "uri" -> "guide/ExpressionStructure"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[684, 28, 259, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[946, 37, 295, 9, 70, "GuideText",
 CellID->32108190],
Cell[1244, 48, 288, 9, 70, "GuideText",
 CellID->145988226],
Cell[1535, 59, 48, 1, 70, "GuideDelimiter",
 CellID->371269339],
Cell[1586, 62, 465, 17, 70, "GuideText",
 CellID->233161401],
Cell[2054, 81, 264, 9, 70, "GuideText",
 CellID->203374175],
Cell[2321, 92, 48, 1, 70, "GuideDelimiter",
 CellID->307240991],
Cell[2372, 95, 749, 30, 70, "GuideText",
 CellID->526474126],
Cell[3124, 127, 267, 9, 70, "GuideText",
 CellID->709320145],
Cell[3394, 138, 273, 9, 70, "GuideText",
 CellID->1463276848],
Cell[3670, 149, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->639217823],
Cell[CellGroupData[{
Cell[3753, 154, 249, 6, 70, "GuideFunctionsSubsection",
 CellID->194271677],
Cell[4005, 162, 1021, 30, 70, "InlineGuideFunctionListing",
 CellID->202346344],
Cell[5029, 194, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->284178079]
}, Open  ]],
Cell[CellGroupData[{
Cell[5124, 200, 84, 1, 70, "GuideFunctionsSubsection",
 CellID->41162128],
Cell[5211, 203, 600, 17, 70, "InlineGuideFunctionListing",
 CellID->114172467]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5860, 226, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5925, 229, 170, 3, 70, "GuideTutorial",
 CellID->798979554],
Cell[6098, 234, 157, 3, 70, "GuideTutorial",
 CellID->585774333],
Cell[6258, 239, 156, 3, 70, "GuideTutorial",
 CellID->30897650],
Cell[6417, 244, 165, 3, 70, "GuideTutorial",
 CellID->159600587]
}, Open  ]],
Cell[CellGroupData[{
Cell[6619, 252, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6684, 255, 354, 12, 70, "GuideMoreAbout",
 CellID->1567025153]
}, Open  ]],
Cell[7053, 270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

