(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18319,        598]
NotebookOptionsPosition[     13206,        461]
NotebookOutlinePosition[     15597,        511]
CellTagsIndexPosition[     15554,        508]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Expressions", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "At the core of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is the foundational idea that everything\[LongDash]data, programs, \
formulas, graphics, documents\[LongDash]can be represented as symbolic \
expressions",
 ". ",
 "And it is this unifying concept that underlies ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic programming paradigm, and makes possible much of the unique \
power of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " language and system."
}], "GuideAbstract",
 CellID->2001916300],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Expression Structure \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ExpressionStructure"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->77104024],

Cell[TextData[{
 Cell[TextData[ButtonBox["FullForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FullForm"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the full form of an expression, without shortened syntax"
}], "GuideText",
 CellID->314508187],

Cell[TextData[{
 Cell[TextData[ButtonBox["TreeForm",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TreeForm"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Head",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Head"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Length",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Length"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Depth",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Depth"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Symbol",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Symbol"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ExpressionStructure"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->374145924],

Cell["\t", "GuideDelimiterSubsection",
 CellID->749193529]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Transforming Expressions \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/RulesAndPatterns"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->7529415],

Cell[TextData[{
 Cell[TextData[{
  StyleBox[ButtonBox["expr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"],
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"],
  StyleBox[ButtonBox["rules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"], "TI"]
 }], "InlineFunctionSans"],
 " ",
 " make replacements for any occurrence of a pattern in an expression"
}], "GuideText",
 CellID->242041397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Applying Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionalProgramming"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->818082892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Map",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Map"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Apply",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Apply"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "map, apply a function at any level in any expression"
}], "GuideText",
 CellID->144371944],

Cell["\t", "GuideDelimiterSubsection",
 CellID->802988170]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Expression Testing \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/TestingExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->141831054],

Cell[TextData[{
 Cell[TextData[ButtonBox["SameQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[ButtonBox["===",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SameQ"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FreeQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FreeQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MemberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NumberQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NumberQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["OrderedQ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/OrderedQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/TestingExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->523893311],

Cell["\t", "GuideDelimiterSubsection",
 CellID->26413345]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Parts of Expressions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/PartsOfExpressions"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->215093603],

Cell[TextData[{
 Cell[TextData[ButtonBox["Part",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Part"]], "InlineFunctionSans"],
 " (",
 Cell[TextData[{
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["[",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["..",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"],
  ButtonBox["]",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]
 }], "InlineFunctionSans"],
 ") \[LongDash] numbered parts of an expression, reset using ",
 Cell[BoxData["="], "InlineFormula"]
}], "GuideText",
 CellID->93454917],

Cell[TextData[{
 Cell[TextData[ButtonBox["Position",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Position"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReplacePart",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ReplacePart"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MapAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MapAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Delete",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Delete"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PartsOfExpressions"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->724815369],

Cell[TextData[{
 Cell[TextData[ButtonBox["Cases",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Cases"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "find occurrences of a pattern in an expression"
}], "GuideText",
 CellID->1006573]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Structural Operations \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/StructuralOperationsOnExpressions"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->358525893],

Cell[TextData[{
 Cell[TextData[ButtonBox["Flatten",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Flatten"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Thread",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Thread"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Distribute",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Distribute"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FlattenAt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FlattenAt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Append",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Append"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->127398134],

Cell["\t", "GuideDelimiterSubsection",
 CellID->447121371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Controlling Expression Evaluation \
\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/EvaluationControl"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->129520060],

Cell[TextData[{
 Cell[TextData[ButtonBox["Hold",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Hold"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Evaluate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Evaluate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldFirst",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldFirst"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HoldAll",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/HoldAll"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationControl"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2281003]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "GuideTutorial",
 CellID->126989848],

Cell[TextData[ButtonBox["The Meaning of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMeaningOfExpressions"]], "GuideTutorial",
 CellID->12760],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "GuideTutorial",
 CellID->63368208],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsAndTransformationRules"]], "GuideTutorial",
 CellID->168719276],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "GuideTutorial",
 CellID->161288318]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "GuideMoreAboutSub",
 CellID->244377098],

Cell[TextData[{
 ButtonBox["Expressions in ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathLinkMathematicaFunctions"],
  FontSlant->"Italic"]
}], "GuideMoreAboutSub",
 CellID->94244670]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Expressions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 14.1550914}", "context" -> "", 
    "keywords" -> {
     "absent from expression", "applying functions", 
      "applying functions to elements of lists", 
      "applying functions to lists of expressions", 
      "applying functions to parts of expression", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices", "communicating expressions",
       "equality testing", "equivalent expressions", "expressions", 
      "expression serialization", "expression trees", "full form", 
      "functional notation", "identical expressions", "inert forms", 
      "internal form", "language representation", "length of list", "levels", 
      "list member", "lists", "multiple parts", "m-expr", "nesting level", 
      "object serialization", "parts", "pattern matching", "patterns", 
      "s-expr", "structural equivalence", "subexpressions", 
      "testing for equivalence", "testing for literal equality", 
      "testing for numbers", "testing for numerical expressions", 
      "transmitting expressions", "tree form", "tree formatted expression", 
      "tree representation", "tree structure", "unevaluated expressions"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "At the core of Mathematica is the foundational idea that \
everything--data, programs, formulas, graphics, documents--can be represented \
as symbolic expressions. And it is this unifying concept that underlies \
Mathematica's symbolic programming paradigm, and makes possible much of the \
unique power of the Mathematica language and system.", "synonyms" -> {}, 
    "title" -> "Expressions", "type" -> "Guide", "uri" -> 
    "guide/Expressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 53, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[675, 28, 559, 17, 70, "GuideAbstract",
 CellID->2001916300],
Cell[CellGroupData[{
Cell[1259, 49, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->77104024],
Cell[1488, 56, 285, 9, 70, "GuideText",
 CellID->314508187],
Cell[1776, 67, 1214, 35, 70, "InlineGuideFunctionListing",
 CellID->374145924],
Cell[2993, 104, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->749193529]
}, Open  ]],
Cell[CellGroupData[{
Cell[3088, 110, 228, 6, 70, "GuideFunctionsSubsection",
 CellID->7529415],
Cell[3319, 118, 453, 15, 70, "GuideText",
 CellID->242041397]
}, Open  ]],
Cell[CellGroupData[{
Cell[3809, 138, 227, 5, 70, "GuideFunctionsSubsection",
 CellID->818082892],
Cell[4039, 145, 392, 13, 70, "GuideText",
 CellID->144371944],
Cell[4434, 160, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->802988170]
}, Open  ]],
Cell[CellGroupData[{
Cell[4529, 166, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->141831054],
Cell[4756, 173, 1326, 40, 70, "InlineGuideFunctionListing",
 CellID->523893311],
Cell[6085, 215, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->26413345]
}, Open  ]],
Cell[CellGroupData[{
Cell[6179, 221, 226, 5, 70, "GuideFunctionsSubsection",
 CellID->215093603],
Cell[6408, 228, 761, 28, 70, "GuideText",
 CellID->93454917],
Cell[7172, 258, 1023, 29, 70, "InlineGuideFunctionListing",
 CellID->724815369],
Cell[8198, 289, 267, 9, 70, "GuideText",
 CellID->1006573]
}, Open  ]],
Cell[CellGroupData[{
Cell[8502, 303, 242, 5, 70, "GuideFunctionsSubsection",
 CellID->358525893],
Cell[8747, 310, 1249, 36, 70, "InlineGuideFunctionListing",
 CellID->127398134],
Cell[9999, 348, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->447121371]
}, Open  ]],
Cell[CellGroupData[{
Cell[10094, 354, 240, 6, 70, "GuideFunctionsSubsection",
 CellID->129520060],
Cell[10337, 362, 1016, 29, 70, "InlineGuideFunctionListing",
 CellID->2281003]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11402, 397, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[11467, 400, 170, 3, 70, "GuideTutorial",
 CellID->126989848],
Cell[11640, 405, 164, 3, 70, "GuideTutorial",
 CellID->12760],
Cell[11807, 410, 158, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[11968, 415, 158, 3, 70, "GuideTutorial",
 CellID->63368208],
Cell[12129, 420, 185, 4, 70, "GuideTutorial",
 CellID->168719276],
Cell[12317, 426, 139, 3, 70, "GuideTutorial",
 CellID->161288318]
}, Open  ]],
Cell[CellGroupData[{
Cell[12493, 434, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[12558, 437, 154, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[12715, 442, 140, 3, 70, "GuideMoreAboutSub",
 CellID->244377098],
Cell[12858, 447, 306, 9, 70, "GuideMoreAboutSub",
 CellID->94244670]
}, Open  ]],
Cell[13179, 459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

