(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10849,        357]
NotebookOptionsPosition[      7083,        259]
NotebookOutlinePosition[      9247,        304]
CellTagsIndexPosition[      9204,        301]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Flow Control", "GuideTitle",
 CellID->19557],

Cell[TextData[{
 "Traditional procedural programming languages typically require programmers \
to define an explicit \"flow of control\" at every stage in their programs. \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides standard flow control primitives, with various symbolic \
extensions\[LongDash]though its higher-level programming paradigm usually \
frees programmers from having to specify the details of flow control."
}], "GuideAbstract",
 CellID->28962],

Cell[TextData[{
 Cell[TextData[ButtonBox["Return",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Return"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "return from any function"
}], "GuideText",
 CellID->718042],

Cell[TextData[{
 Cell[TextData[ButtonBox["Break",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Break"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Continue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Continue"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "break, continue in procedural looping constructs"
}], "GuideText",
 CellID->140442422],

Cell[TextData[{
 Cell[TextData[ButtonBox["Goto",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Goto"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Label",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Label"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "largely obsolete explicit procedural flow control"
}], "GuideText",
 CellID->221591534],

Cell["\t", "GuideDelimiter",
 CellID->266546595],

Cell[TextData[{
 Cell[TextData[ButtonBox["Throw",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Throw"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "\"throw\" any expression to be \"caught\" by an enclosing ",
 Cell[TextData[ButtonBox["Catch",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Catch"]], "InlineFunctionSans"]
}], "GuideText",
 CellID->129786126],

Cell[TextData[{
 Cell[TextData[ButtonBox["Check",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Check"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "check for messages"
}], "GuideText",
 CellID->29603786],

Cell["\t", "GuideDelimiter",
 CellID->6285925],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abort"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "generate an abort"
}], "GuideText",
 CellID->360247587],

Cell[TextData[{
 Cell[TextData[ButtonBox["Interrupt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Interrupt"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["CheckAbort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/CheckAbort"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AbortProtect",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/AbortProtect"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->396169976],

Cell[TextData[{
 Cell[TextData[ButtonBox["TimeConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/TimeConstrained"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["MemoryConstrained",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/MemoryConstrained"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "run with constraints"
}], "GuideText",
 CellID->30589433],

Cell["\t", "GuideDelimiter",
 CellID->78931189],

Cell[TextData[{
 Cell[TextData[ButtonBox["Pause",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pause"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "pause for a specified time"
}], "GuideText",
 CellID->74340367],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["Dialog",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Dialog"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "initiate a subsession dialog"
}], "GuideText",
 CellID->12552756],

Cell[TextData[{
 Cell[TextData[ButtonBox["Input",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Input"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DialogInput",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DialogInput"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ChoiceDialog",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ChoiceDialog"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["DialogReturn",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/DialogReturn"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->24004774]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->18337],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "GuideTutorial",
 CellID->188830515],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "GuideTutorial",
 CellID->268388182],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "GuideTutorial",
 CellID->60826662]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->7636],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "GuideMoreAbout",
 CellID->30714],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "GuideMoreAbout",
 CellID->28164]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Flow Control - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 17.6395556}", "context" -> "", 
    "keywords" -> {
     "abort", "abort protect", "alarm", "block aborts", "catching of aborts", 
      "check abort", "choice dialog", "computed goto", "constrained memory", 
      "flow control", "critical section", "dialog input", "dialog return", 
      "divert", "errors", "evaluation sequence", "evaluation flow", 
      "limited memory", "exception handling", "finite memory", "front end", 
      "handling", "handling of errors", "intercept aborts", "jump", "longjmp",
       "loops", "memory constrained", "memory constraints", 
      "non-local returns", "procedures", "returns", "routines", "scope", 
      "sleep", "stop", "stopping calculations", "subroutines", "subsession", 
      "suspend", "terminate", "terminating computations", "time constrained", 
      "time constraints", "trapping errors", "uninterruptible code", "wait", 
      "exceptions", "program flow"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Traditional procedural programming languages typically require \
programmers to define an explicit \"flow of control\" at every stage in their \
programs. Mathematica provides standard flow control primitives, with various \
symbolic extensions--though its higher-level programming paradigm usually \
frees programmers from having to specify the details of flow control.", 
    "synonyms" -> {}, "title" -> "Flow Control", "type" -> "Guide", "uri" -> 
    "guide/FlowControl"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 50, 1, 70, "GuideTitle",
 CellID->19557],
Cell[672, 28, 478, 10, 70, "GuideAbstract",
 CellID->28962],
Cell[1153, 40, 246, 9, 70, "GuideText",
 CellID->718042],
Cell[1402, 51, 398, 13, 70, "GuideText",
 CellID->140442422],
Cell[1803, 66, 391, 13, 70, "GuideText",
 CellID->221591534],
Cell[2197, 81, 48, 1, 70, "GuideDelimiter",
 CellID->266546595],
Cell[2248, 84, 395, 12, 70, "GuideText",
 CellID->129786126],
Cell[2646, 98, 240, 9, 70, "GuideText",
 CellID->29603786],
Cell[2889, 109, 46, 1, 70, "GuideDelimiter",
 CellID->6285925],
Cell[2938, 112, 240, 9, 70, "GuideText",
 CellID->360247587],
Cell[3181, 123, 618, 17, 70, "InlineGuideFunctionListing",
 CellID->396169976],
Cell[3802, 142, 407, 13, 70, "GuideText",
 CellID->30589433],
Cell[4212, 157, 47, 1, 70, "GuideDelimiter",
 CellID->78931189],
Cell[4262, 160, 248, 9, 70, "GuideText",
 CellID->74340367],
Cell[4513, 171, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[4564, 174, 252, 9, 70, "GuideText",
 CellID->12552756],
Cell[4819, 185, 1262, 32, 70, "InlineGuideFunctionListing",
 CellID->24004774]
}, Open  ]],
Cell[CellGroupData[{
Cell[6118, 222, 58, 1, 70, "GuideTutorialsSection",
 CellID->18337],
Cell[6179, 225, 139, 3, 70, "GuideTutorial",
 CellID->188830515],
Cell[6321, 230, 172, 3, 70, "GuideTutorial",
 CellID->268388182],
Cell[6496, 235, 158, 3, 70, "GuideTutorial",
 CellID->60826662]
}, Open  ]],
Cell[CellGroupData[{
Cell[6691, 243, 58, 1, 70, "GuideMoreAboutSection",
 CellID->7636],
Cell[6752, 246, 137, 3, 70, "GuideMoreAbout",
 CellID->30714],
Cell[6892, 251, 149, 3, 70, "GuideMoreAbout",
 CellID->28164]
}, Open  ]],
Cell[7056, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

