(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18927,        583]
NotebookOptionsPosition[     13066,        436]
NotebookOutlinePosition[     16341,        498]
CellTagsIndexPosition[     16298,        495]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Function Visualization", "GuideTitle",
 CellID->11058],

Cell[TextData[{
 "Long the standard for high-quality function and surface visualization, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " incorporates a host of original numeric, symbolic and geometric algorithms \
that automate the immediate creation of highly aesthetic and technically \
correct 2D and 3D visualizations. "
}], "GuideAbstract",
 CellID->212855561],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " curves of one or more functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->5651],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogLinearPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LogLogPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LogLogPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->34683661],

Cell["\t", "GuideDelimiter",
 CellID->253400953],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plot3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D surfaces of one or more functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->2258],

Cell["\t", "GuideDelimiter",
 CellID->7213],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " contour plot for a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"],
 " or curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y"}], ")"}], "=", "c"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->9860],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D contour plot for a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y", ",", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " or surface ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", 
     RowBox[{"x", ",", "y", ",", "z"}], ")"}], "=", "c"}], TraditionalForm]], 
  "InlineMath"]
}], "GuideText",
 CellID->25783],

Cell["\t", "GuideDelimiter",
 CellID->21286],

Cell[TextData[{
 Cell[TextData[ButtonBox["DensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DensityPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " density plot for a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", 
    RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "InlineMath"]
}], "GuideText",
 CellID->2742],

Cell["\t", "GuideDelimiter",
 CellID->8610],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParametricPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 2D parametric curves or regions"
}], "GuideText",
 CellID->4472],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParametricPlot3D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D parametric curves or surfaces"
}], "GuideText",
 CellID->7128],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolarPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/PolarPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RevolutionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->13710843],

Cell["\t", "GuideDelimiter",
 CellID->18434],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 2D regions defined by inequalities"
}], "GuideText",
 CellID->5841],

Cell[TextData[{
 Cell[TextData[ButtonBox["RegionPlot3D",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " 3D regions defined by inequalities"
}], "GuideText",
 CellID->20718],

Cell["\t", "GuideDelimiterSubsection",
 CellID->3503],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Styling Options \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GraphicsOptionsAndStyling"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->14867],

Cell[TextData[{
 Cell[TextData[ButtonBox["Frame",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Frame"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PlotStyle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PlotStyle"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Filling",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Filling"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Mesh",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Mesh"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ImageSize",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ImageSize"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->24865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Annotation & Combination \[RightGuillemet]",
 
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/AnnotatingAndCombiningGraphics"], \
"GuideFunctionsSubsection"]], "GuideFunctionsSubsection",
 CellID->41],

Cell[TextData[{
 Cell[TextData[ButtonBox["Tooltip",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Tooltip"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StatusArea",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/StatusArea"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GraphicsGrid",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1881]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->9257],

Cell[TextData[ButtonBox["Basic Plotting",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicPlotting"]], "GuideTutorial",
 CellID->83342323],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "GuideTutorial",
 CellID->446023428],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "GuideTutorial",
 CellID->202887872],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "GuideTutorial",
 CellID->343306703]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->18598],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "GuideMoreAbout",
 CellID->544867867],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "GuideMoreAbout",
 CellID->26063],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "GuideMoreAbout",
 CellID->32756],

Cell[TextData[ButtonBox["Vector Field Plotting Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:VectorFieldPlots/guide/VectorFieldPlottingPackage"]], \
"GuideMoreAboutSub",
 CellID->481063370],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "GuideMoreAboutSub",\

 CellID->19489],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "GuideMoreAboutSub",
 CellID->20278]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->2137285542],

Cell[TextData[{
 ButtonBox["Demonstrations related to Function Visualization",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
ContourPlot+OR+ContourPlot3D+OR+DensityPlot+OR+Filling+OR+Frame+OR+ImageSize+\
OR+LogLinearPlot+OR+LogLogPlot+OR+LogPlot+OR+Mesh+OR+ParametricPlot+OR+\
ParametricPlot3D+OR+Plot+OR+Plot3D+OR+PlotStyle+OR+PolarPlot+OR+RegionPlot+OR+\
RegionPlot3D+OR+RevolutionPlot3D+OR+SphericalPlot3D)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->50888202]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function Visualization - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 30.1398756}", "context" -> "", 
    "keywords" -> {
     "Argand diagrams", "balloon help", "color lines", "color of curves", 
      "Color of curves", "color of lines", "complex plots", "contour levels", 
      "contour lines", "contour plot", "contour plot 3D", "contour surface", 
      "curve graphing", "curves", "dashed lines", "dashing", "density plot", 
      "double-logarithmic plot", "double logarithmic plot", 
      "false color plots", "fill area", "framed", "function graphing", 
      "function plotting", "functions", "function visualization", "graph", 
      "graphics", "graphics array", "graphics grid", "graphics size", 
      "graphing", "grid", "height fields", "image array", "image size", 
      "implicit curves", "implicit graphs", "implicit plots", 
      "implicit surfaces", "information drill down", "intensity plot", 
      "line color", "Lissajous figures", "loglinear", "log-linear plot", 
      "log linear plot", "loglog", "log log plot", "log-log scale plot", 
      "log-normal plot", "log-plot", "log plot", "log plots", 
      "parametric curves", "parametric plot", "parametric plot3", 
      "parametric plot 3D", "parametric regions", "parametric surfaces", 
      "picture array", "picture size", "plane curves", "plot region", 
      "plots of surfaces", "plot style", "plotting", 
      "plotting parametric surfaces", "plot volume", "polar plot", 
      "polar plots", "popup box", "region plot", "region plot3", 
      "region plot 3D", "revolution plot", "revolution plot3", 
      "revolved surface", "rulings on surfaces", "screen tip", "ScreenTip", 
      "semi-logarithmic", "semi-log plot", "semilog plot", "semilog plots", 
      "shading", "size", "space curves", "spherical plot3", 
      "spherical plot 3D", "status area", "status area window element", 
      "style of curves", "style of lines", "styles of multiple curves", 
      "surface of revolution", "surface plots", "surfaces", 
      "tables of graphics", "three-dimensional graphics", 
      "three-dimensional plots", "visualization", "width", "graphing", 
      "plotting"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Long the standard for high-quality function and surface visualization, \
Mathematica incorporates a host of original numeric, symbolic and geometric \
algorithms that automate the immediate creation of highly aesthetic and \
technically correct 2D and 3D visualizations. ", "synonyms" -> {}, "title" -> 
    "Function Visualization", "type" -> "Guide", "uri" -> 
    "guide/FunctionVisualization"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 60, 1, 70, "GuideTitle",
 CellID->11058],
Cell[682, 28, 372, 8, 70, "GuideAbstract",
 CellID->212855561],
Cell[1057, 38, 336, 11, 70, "GuideText",
 CellID->5651],
Cell[1396, 51, 1050, 26, 70, "InlineGuideFunctionListing",
 CellID->34683661],
Cell[2449, 79, 48, 1, 70, "GuideDelimiter",
 CellID->253400953],
Cell[2500, 82, 370, 12, 70, "GuideText",
 CellID->2258],
Cell[2873, 96, 43, 1, 70, "GuideDelimiter",
 CellID->7213],
Cell[2919, 99, 533, 19, 70, "GuideText",
 CellID->9860],
Cell[3455, 120, 711, 23, 70, "GuideText",
 CellID->25783],
Cell[4169, 145, 44, 1, 70, "GuideDelimiter",
 CellID->21286],
Cell[4216, 148, 371, 12, 70, "GuideText",
 CellID->2742],
Cell[4590, 162, 43, 1, 70, "GuideDelimiter",
 CellID->8610],
Cell[4636, 165, 262, 8, 70, "GuideText",
 CellID->4472],
Cell[4901, 175, 267, 8, 70, "GuideText",
 CellID->7128],
Cell[5171, 185, 1070, 26, 70, "InlineGuideFunctionListing",
 CellID->13710843],
Cell[6244, 213, 44, 1, 70, "GuideDelimiter",
 CellID->18434],
Cell[6291, 216, 402, 11, 70, "GuideText",
 CellID->5841],
Cell[6696, 229, 407, 11, 70, "GuideText",
 CellID->20718],
Cell[7106, 242, 53, 1, 70, "GuideDelimiterSubsection",
 CellID->3503],
Cell[CellGroupData[{
Cell[7184, 247, 224, 5, 70, "GuideFunctionsSubsection",
 CellID->14867],
Cell[7411, 254, 1374, 39, 70, "InlineGuideFunctionListing",
 CellID->24865]
}, Open  ]],
Cell[CellGroupData[{
Cell[8822, 298, 237, 6, 70, "GuideFunctionsSubsection",
 CellID->41],
Cell[9062, 306, 1274, 33, 70, "InlineGuideFunctionListing",
 CellID->1881]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10385, 345, 57, 1, 70, "GuideTutorialsSection",
 CellID->9257],
Cell[10445, 348, 145, 3, 70, "GuideTutorial",
 CellID->83342323],
Cell[10593, 353, 166, 3, 70, "GuideTutorial",
 CellID->446023428],
Cell[10762, 358, 146, 3, 70, "GuideTutorial",
 CellID->202887872],
Cell[10911, 363, 161, 3, 70, "GuideTutorial",
 CellID->343306703]
}, Open  ]],
Cell[CellGroupData[{
Cell[11109, 371, 59, 1, 70, "GuideMoreAboutSection",
 CellID->18598],
Cell[11171, 374, 168, 3, 70, "GuideMoreAbout",
 CellID->544867867],
Cell[11342, 379, 154, 3, 70, "GuideMoreAbout",
 CellID->26063],
Cell[11499, 384, 148, 3, 70, "GuideMoreAbout",
 CellID->32756],
Cell[11650, 389, 197, 5, 70, "GuideMoreAboutSub",
 CellID->481063370],
Cell[11850, 396, 175, 4, 70, "GuideMoreAboutSub",
 CellID->19489],
Cell[12028, 402, 158, 3, 70, "GuideMoreAboutSub",
 CellID->20278]
}, Open  ]],
Cell[CellGroupData[{
Cell[12223, 410, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->2137285542],
Cell[12296, 413, 728, 18, 70, "GuideRelatedLinks",
 CellID->50888202]
}, Open  ]],
Cell[13039, 434, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

