(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10445,        348]
NotebookOptionsPosition[      6677,        247]
NotebookOutlinePosition[      8778,        291]
CellTagsIndexPosition[      8735,        288]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functions of Complex Variables", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " transparently works with complex variables throughout, not only \
numerically, but also symbolically\[LongDash]often relying on original \
results to handle intricate branch cut and other issues. "
}], "GuideAbstract",
 CellID->439258888],

Cell[CellGroupData[{

Cell["Visualization", "GuideFunctionsSubsection",
 CellID->61613013],

Cell[TextData[{
 Cell[TextData[ButtonBox["ContourPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ContourPlot"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["DensityPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DensityPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot over the complex plane, potentially coloring by phase"
}], "GuideText",
 CellID->95035490],

Cell[TextData[{
 Cell[TextData[ButtonBox["ParametricPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ParametricPlot"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot conformal mappings"
}], "GuideText",
 CellID->190183472]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integration", "GuideFunctionsSubsection",
 CellID->841761988],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic integrals taking account of complex variables"
}], "GuideText",
 CellID->17920605],

Cell[TextData[{
 Cell[TextData[ButtonBox["PrincipalValue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PrincipalValue"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "option for specifying whether to take principal values"
}], "GuideText",
 CellID->296597927],

Cell[TextData[{
 Cell[TextData[ButtonBox["NIntegrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NIntegrate"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " numerical integration around contours in the complex plane"
}], "GuideText",
 CellID->191945593],

Cell[TextData[{
 Cell[TextData[ButtonBox["Residue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Residue"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "residue at a pole"
}], "GuideText",
 CellID->203374175]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Manipulation", "GuideFunctionsSubsection",
 CellID->357977178],

Cell[TextData[{
 Cell[TextData[ButtonBox["ComplexExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ComplexExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolically expand into real and imaginary parts"
}], "GuideText",
 CellID->70596497],

Cell[TextData[{
 Cell[TextData[ButtonBox["Reduce",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Reduce"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "reduce polynomial systems over complex variables"
}], "GuideText",
 CellID->161410554],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[ButtonBox["Basic Functions \[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ComplexNumbers"], "GuideFunctionsSubsection"]], \
"GuideFunctionsSubsection",
 CellID->160602925],

Cell[TextData[{
 Cell[TextData[ButtonBox["Abs",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Abs"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Arg",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Arg"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Conjugate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Conjugate"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Re",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Re"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Im",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Im"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RandomComplex",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RandomComplex"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ExpToTrig",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/ExpToTrig"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ComplexNumbers"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->96250567]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "GuideTutorial",
 CellID->194483788],

Cell[TextData[ButtonBox["Expressions Involving Complex Variables",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsInvolvingComplexVariables"]], "GuideTutorial",
 CellID->176171]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions of Complex Variables - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 24.7334872}", "context" -> "", 
    "keywords" -> {
     "absolute value", "angle", "arg", "argument", 
      "argument of complex number", "Cauchy principal value", 
      "complex analysis", "complex analysis", "complex conjugate", 
      "complex expand", "complex exponentials", "complex number", 
      "complex part", "complex plots", "complex powers", "complex variables", 
      "expanding into polar form", "expanding into real and imaginary parts", 
      "exponentials", "exp to trig", "Im", "imag", "imaginary part", 
      "\\Im (TeX)", "magnitude of complex number", "Mellin transform methods",
       "phase", "phase-angle", "phase shift", "plane curves", "polar angles", 
      "polar plots", "random complex", "random complex number", "Re", "real", 
      "real part", "reducing inequalities", "reduction", "region integrals", 
      "regions", "Res", "residue", "\\Re (TeX)", 
      "singularity of meromorphic function", "symbolic complex expressions"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica transparently works with complex variables throughout, not \
only numerically, but also symbolically--often relying on original results to \
handle intricate branch cut and other issues. ", "synonyms" -> {}, "title" -> 
    "Functions of Complex Variables", "type" -> "Guide", "uri" -> 
    "guide/FunctionsOfComplexVariables"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 72, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[694, 28, 306, 7, 70, "GuideAbstract",
 CellID->439258888],
Cell[CellGroupData[{
Cell[1025, 39, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->61613013],
Cell[1096, 42, 425, 13, 70, "GuideText",
 CellID->95035490],
Cell[1524, 57, 264, 9, 70, "GuideText",
 CellID->190183472]
}, Open  ]],
Cell[CellGroupData[{
Cell[1825, 71, 67, 1, 70, "GuideFunctionsSubsection",
 CellID->841761988],
Cell[1895, 74, 284, 9, 70, "GuideText",
 CellID->17920605],
Cell[2182, 85, 295, 9, 70, "GuideText",
 CellID->296597927],
Cell[2480, 96, 286, 8, 70, "GuideText",
 CellID->191945593],
Cell[2769, 106, 244, 9, 70, "GuideText",
 CellID->203374175]
}, Open  ]],
Cell[CellGroupData[{
Cell[3050, 120, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->357977178],
Cell[3130, 123, 287, 9, 70, "GuideText",
 CellID->70596497],
Cell[3420, 134, 273, 9, 70, "GuideText",
 CellID->161410554],
Cell[3696, 145, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[3791, 151, 217, 5, 70, "GuideFunctionsSubsection",
 CellID->160602925],
Cell[4011, 158, 1761, 50, 70, "InlineGuideFunctionListing",
 CellID->96250567]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5821, 214, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[5886, 217, 148, 3, 70, "GuideTutorial",
 CellID->194483788],
Cell[6037, 222, 194, 4, 70, "GuideTutorial",
 CellID->176171]
}, Open  ]],
Cell[CellGroupData[{
Cell[6268, 231, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6333, 234, 147, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6483, 239, 152, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[6650, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

