(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10138,        320]
NotebookOptionsPosition[      6867,        228]
NotebookOutlinePosition[      8674,        269]
CellTagsIndexPosition[      8631,        266]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Functions Used in Optics", "GuideTitle",
 CellID->22018],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Rectangular Geometries", "GuideFunctionsSubsection",
 CellID->23856],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinc",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FresnelS",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FresnelS"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FresnelC",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FresnelC"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19490]
}, Open  ]],

Cell[CellGroupData[{

Cell["Circular Geometries", "GuideFunctionsSubsection",
 CellID->8925],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselJ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BesselJ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StruveH",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StruveH"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["StruveL",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/StruveL"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["HankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ZernikeR",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ZernikeR"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BesselJZero",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/BesselJZero"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->4324]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spherical Geometries", "GuideFunctionsSubsection",
 CellID->6486],

Cell[TextData[{
 Cell[TextData[ButtonBox["SphericalHarmonicY",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SphericalHarmonicY"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalBesselJ",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalBesselJ"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SphericalHankelH2",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SphericalHankelH2"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->19677]
}, Open  ]],

Cell[CellGroupData[{

Cell["Band\[Hyphen]Limited Functions", "GuideFunctionsSubsection",
 CellID->87207899],

Cell[TextData[{
 Cell[TextData[ButtonBox["Sinc",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Sinc"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SpheroidalPS",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/SpheroidalPS"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->302497184]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->15969],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->15677],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsUsedInQuantumMechanics"]], "GuideMoreAbout",
 CellID->16141],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->7783],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->877385068],

Cell[TextData[{
 ButtonBox["Demonstrations related to Functions Used in Optics",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
BesselJ+OR+BesselJZero+OR+FresnelC+OR+FresnelS+OR+HankelH2+OR+Sinc+OR+\
SphericalBesselJ+OR+SphericalHankelH2+OR+SphericalHarmonicY+OR+SpheroidalPS+\
OR+StruveH+OR+StruveL+OR+ZernikeR)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->313928685]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Functions Used in Optics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 25.1241222}", "context" -> "", 
    "keywords" -> {
     "band\\[Hyphen]limited functions", "Bessel equation", "Bessel functions",
       "Bessel J", "Bessel zero", "circle polynomials", "Cornu spiral", 
      "cylindrical functions", "differential equations", 
      "Fresnel diffraction", "Fresnel functions", "Fresnel integral", 
      "Fresnel integral C", "Fresnel integral S", 
      "Hankel function of the second kind", "Hankel functions", "Hankel H2", 
      "optical aberrations", "radial polynomials", "spherical bessel", 
      "spherical Bessel function", "spherical Bessel J", 
      "spherical Hankel function", "spherical Hankel H2", 
      "spherical harmonic", "spherical harmonics", "spherical harmonic Y", 
      "spheroidal functions", "spheroidal harmonics", "square wave", 
      "Struve function", "Struve function H", "Struve function L", 
      "zeros of Bessel functions"}, "index" -> True, "label" -> 
    "Mathematica Guide", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> "", "synonyms" -> {}, "title" -> 
    "Functions Used in Optics", "type" -> "Guide", "uri" -> 
    "guide/FunctionsUsedInOptics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->22018],
Cell[684, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[765, 33, 74, 1, 70, "GuideFunctionsSubsection",
 CellID->23856],
Cell[842, 36, 737, 20, 70, "InlineGuideFunctionListing",
 CellID->19490]
}, Open  ]],
Cell[CellGroupData[{
Cell[1616, 61, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->8925],
Cell[1689, 64, 1658, 44, 70, "InlineGuideFunctionListing",
 CellID->4324]
}, Open  ]],
Cell[CellGroupData[{
Cell[3384, 113, 71, 1, 70, "GuideFunctionsSubsection",
 CellID->6486],
Cell[3458, 116, 944, 23, 70, "InlineGuideFunctionListing",
 CellID->19677]
}, Open  ]],
Cell[CellGroupData[{
Cell[4439, 144, 85, 1, 70, "GuideFunctionsSubsection",
 CellID->87207899],
Cell[4527, 147, 686, 17, 70, "InlineGuideFunctionListing",
 CellID->302497184]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5262, 170, 58, 1, 70, "GuideTutorialsSection",
 CellID->15969],
Cell[5323, 173, 148, 3, 70, "GuideTutorial",
 CellID->16541]
}, Open  ]],
Cell[CellGroupData[{
Cell[5508, 181, 59, 1, 70, "GuideMoreAboutSection",
 CellID->15677],
Cell[5570, 184, 182, 4, 70, "GuideMoreAbout",
 CellID->16141],
Cell[5755, 190, 148, 3, 70, "GuideMoreAboutSub",
 CellID->7783],
Cell[5906, 195, 179, 3, 70, "GuideMoreAbout",
 CellID->373399802]
}, Open  ]],
Cell[CellGroupData[{
Cell[6122, 203, 69, 1, 70, "GuideRelatedLinksSection",
 CellID->877385068],
Cell[6194, 206, 631, 17, 70, "GuideRelatedLinks",
 CellID->313928685]
}, Open  ]],
Cell[6840, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

