(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9880,        328]
NotebookOptionsPosition[      6175,        227]
NotebookOutlinePosition[      8247,        271]
CellTagsIndexPosition[      8204,        268]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Gamma Functions and Related Functions", "GuideTitle",
 CellID->19435],

Cell[TextData[{
 "As the basis for many other special functions, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " supports efficient arbitrary-precision evaluation of gamma functions, as \
well as an extensive web of relations and transformations\[LongDash]many \
original to Wolfram Research."
}], "GuideAbstract",
 CellID->6365],

Cell[TextData[{
 Cell[TextData[ButtonBox["Gamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Gamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete and incomplete gamma function"
}], "GuideText",
 CellID->7833],

Cell[TextData[{
 Cell[TextData[ButtonBox["Beta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Beta"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " complete and incomplete beta function"
}], "GuideText",
 CellID->8360],

Cell["\t", "GuideDelimiter",
 CellID->13330],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/PolyGamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " polygamma function"
}], "GuideText",
 CellID->26048],

Cell[TextData[{
 Cell[TextData[ButtonBox["LogGamma",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LogGamma"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " logarithm of gamma function"
}], "GuideText",
 CellID->8928],

Cell[CellGroupData[{

Cell["Integer-Oriented Functions", "GuideFunctionsSubsection",
 CellID->29492],

Cell[TextData[{
 Cell[TextData[ButtonBox["Factorial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Factorial2",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial2"]], "InlineFunctionSans"],
 "(",
 Cell[TextData[ButtonBox["!!",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Factorial2"]], "InlineFunctionSans"],
 ")",
 " ",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Pochhammer",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Pochhammer"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Binomial",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Binomial"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->12433]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regularized Functions", "GuideFunctionsSubsection",
 CellID->23840],

Cell[TextData[{
 Cell[TextData[ButtonBox["GammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/GammaRegularized"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["BetaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/BetaRegularized"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->6766]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse Functions", "GuideFunctionsSubsection",
 CellID->1735],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseGammaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["InverseBetaRegularized",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->19810]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->11599],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "GuideTutorial",
 CellID->16541],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "GuideTutorial",
 CellID->642958886],

Cell[TextData[ButtonBox["Integer and Number-Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "GuideTutorial",
 CellID->21892]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->31982],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "GuideMoreAboutSub",
 CellID->3967],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "GuideMoreAbout",
 CellID->29352]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1771777594],

Cell[TextData[{
 ButtonBox["Demonstrations related to Gamma Functions and Related Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=topics%3A%\
22gamma+beta+and+error+functions%22+content%3ABeta+OR+BetaRegularized+OR+\
Binomial+OR+Factorial+OR+Factorial2+OR+Gamma+OR+GammaRegularized+OR+\
InverseBetaRegularized+OR+InverseGammaRegularized+OR+LogGamma+OR+Pochhammer+\
OR+PolyGamma"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->247057623]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gamma Functions and Related Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 31.3742822}", "context" -> "", 
    "keywords" -> {
     "bang", "beta function", "beta regularized", "binom", "binomials", 
      "choose", "comb", "combinations", "digamma function", 
      "double factorial", "Euler beta function", "Euler gamma function", 
      "exclamation point", "fact", "factorial", "factorial function", 
      "gamma function", "gamma regularized", "generalized factorial", 
      "incomplete beta function", "incomplete gamma function", 
      "inverse beta regularized", "inverse gamma regularized", 
      "inverse regularized beta function", "inverse regularized gamma", 
      "ln gamma", "lngamma", "lnGAMMA", "logarithmic gamma", 
      "logarithm of gamma function", "log-gamma", "log gamma", "n-choose-k", 
      "nchoosek", "nCk", "Pochhammer", "Pochhammer symbol", "poly-gamma", 
      "poly gamma", "psi", "psi function", "rising factorial", "shriek"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "As the basis for many other special functions, Mathematica supports \
efficient arbitrary-precision evaluation of gamma functions, as well as an \
extensive web of relations and transformations--many original to Wolfram \
Research.", "synonyms" -> {}, "title" -> 
    "Gamma Functions and Related Functions", "type" -> "Guide", "uri" -> 
    "guide/GammaFunctionsAndRelatedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 75, 1, 70, "GuideTitle",
 CellID->19435],
Cell[697, 28, 336, 8, 70, "GuideAbstract",
 CellID->6365],
Cell[1036, 38, 251, 8, 70, "GuideText",
 CellID->7833],
Cell[1290, 48, 248, 8, 70, "GuideText",
 CellID->8360],
Cell[1541, 58, 44, 1, 70, "GuideDelimiter",
 CellID->13330],
Cell[1588, 61, 240, 8, 70, "GuideText",
 CellID->26048],
Cell[1831, 71, 246, 8, 70, "GuideText",
 CellID->8928],
Cell[CellGroupData[{
Cell[2102, 83, 78, 1, 70, "GuideFunctionsSubsection",
 CellID->29492],
Cell[2183, 86, 1036, 33, 70, "InlineGuideFunctionListing",
 CellID->12433]
}, Open  ]],
Cell[CellGroupData[{
Cell[3256, 124, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->23840],
Cell[3332, 127, 421, 11, 70, "InlineGuideFunctionListing",
 CellID->6766]
}, Open  ]],
Cell[CellGroupData[{
Cell[3790, 143, 68, 1, 70, "GuideFunctionsSubsection",
 CellID->1735],
Cell[3861, 146, 450, 11, 70, "InlineGuideFunctionListing",
 CellID->19810]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4360, 163, 58, 1, 70, "GuideTutorialsSection",
 CellID->11599],
Cell[4421, 166, 148, 3, 70, "GuideTutorial",
 CellID->16541],
Cell[4572, 171, 164, 3, 70, "GuideTutorial",
 CellID->642958886],
Cell[4739, 176, 194, 4, 70, "GuideTutorial",
 CellID->21892]
}, Open  ]],
Cell[CellGroupData[{
Cell[4970, 185, 59, 1, 70, "GuideMoreAboutSection",
 CellID->31982],
Cell[5032, 188, 148, 3, 70, "GuideMoreAboutSub",
 CellID->3967],
Cell[5183, 193, 146, 3, 70, "GuideMoreAbout",
 CellID->29352]
}, Open  ]],
Cell[CellGroupData[{
Cell[5366, 201, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1771777594],
Cell[5439, 204, 694, 18, 70, "GuideRelatedLinks",
 CellID->247057623]
}, Open  ]],
Cell[6148, 225, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

