(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7522,        257]
NotebookOptionsPosition[      4747,        179]
NotebookOutlinePosition[      6426,        218]
CellTagsIndexPosition[      6383,        215]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Generalized Functions", "GuideTitle",
 CellID->6608],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic character allows it to handle generalized functions or \
\"distributions\" as a direct extension of classical mathematical functions, \
and to represent integrals and integral transforms that cannot be expressed \
in terms of continuous functions. "
}], "GuideAbstract",
 CellID->243266666],

Cell[TextData[{
 Cell[TextData[ButtonBox["DiracDelta",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/DiracDelta"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " one- or multidimensional delta function"
}], "GuideText",
 CellID->7208],

Cell[TextData[{
 Cell[TextData[ButtonBox["HeavisideTheta",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/HeavisideTheta"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Heaviside step function, ",
 Cell[BoxData[
  StyleBox["0", "TR"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "<", 
   StyleBox["0", "TR"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["1", "TR"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ">", 
   StyleBox["0", "TR"]}]], "InlineFormula"]
}], "GuideText",
 CellID->3264],

Cell["\t", "GuideDelimiter",
 CellID->3497],

Cell[TextData[{
 Cell[TextData[ButtonBox["Integrate",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Integrate"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " integrals and derivatives of generalized functions"
}], "GuideText",
 CellID->23243],

Cell[TextData[{
 Cell[TextData[ButtonBox["LaplaceTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LaplaceTransform"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["FourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FourierTransform"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " integral transforms"
}], "GuideText",
 CellID->27649],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionExpand",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/FunctionExpand"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " expand out generalized functions"
}], "GuideText",
 CellID->22015]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->26841],

Cell[TextData[ButtonBox["Generalized Functions and Related Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]], "GuideTutorial",
 CellID->71648475],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "GuideTutorial",\

 CellID->283625722]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->19812],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "GuideMoreAbout",
 CellID->30648],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "GuideMoreAbout",
 CellID->9523]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1257773056],

Cell[TextData[{
 ButtonBox["Demonstrations related to Generalized Functions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
DiracDelta+OR+FourierTransform+OR+HeavisideTheta+OR+LaplaceTransform)"], 
    None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->235612773]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Generalized Functions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 31.7805426}", "context" -> "", 
    "keywords" -> {
     "delta function", "dirac delta", "Fourier transform", 
      "function transform", "generalized functions", "Green's functions", 
      "Heaviside theta", "improper functions", "impulse function", 
      "integral operator", "integral transform", "integral transformation", 
      "inverse Fourier transform", "inverse Laplace transform", 
      "Laplace transform", "Mellin transform", "power spectrum", "spectrum", 
      "spike", "unit step"}, "index" -> True, "label" -> "Mathematica Guide", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica's symbolic character allows it to handle generalized \
functions or \"distributions\" as a direct extension of classical \
mathematical functions, and to represent integrals and integral transforms \
that cannot be expressed in terms of continuous functions. ", 
    "synonyms" -> {}, "title" -> "Generalized Functions", "type" -> "Guide", 
    "uri" -> "guide/GeneralizedFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 58, 1, 70, "GuideTitle",
 CellID->6608],
Cell[680, 28, 369, 8, 70, "GuideAbstract",
 CellID->243266666],
Cell[1052, 38, 262, 8, 70, "GuideText",
 CellID->7208],
Cell[1317, 48, 747, 26, 70, "GuideText",
 CellID->3264],
Cell[2067, 76, 43, 1, 70, "GuideDelimiter",
 CellID->3497],
Cell[2113, 79, 385, 12, 70, "GuideText",
 CellID->23243],
Cell[2501, 93, 398, 12, 70, "GuideText",
 CellID->27649],
Cell[2902, 107, 264, 8, 70, "GuideText",
 CellID->22015]
}, Open  ]],
Cell[CellGroupData[{
Cell[3203, 120, 58, 1, 70, "GuideTutorialsSection",
 CellID->26841],
Cell[3264, 123, 199, 4, 70, "GuideTutorial",
 CellID->71648475],
Cell[3466, 129, 204, 5, 70, "GuideTutorial",
 CellID->283625722]
}, Open  ]],
Cell[CellGroupData[{
Cell[3707, 139, 59, 1, 70, "GuideMoreAboutSection",
 CellID->19812],
Cell[3769, 142, 150, 3, 70, "GuideMoreAbout",
 CellID->30648],
Cell[3922, 147, 155, 3, 70, "GuideMoreAbout",
 CellID->9523]
}, Open  ]],
Cell[CellGroupData[{
Cell[4114, 155, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1257773056],
Cell[4187, 158, 518, 16, 70, "GuideRelatedLinks",
 CellID->235612773]
}, Open  ]],
Cell[4720, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

