(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15966,        469]
NotebookOptionsPosition[     11727,        358]
NotebookOutlinePosition[     13961,        404]
CellTagsIndexPosition[     13918,        401]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Geometric Transforms", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s symbolic architecture and sophisticated mathematical capabilities allow \
it to take a uniquely high-level approach to geometric transformations\
\[LongDash]supporting complete geometric, matrix and functional \
representations in any number of dimensions, whether for mechanical systems, \
computer graphics or pure mathematics. "
}], "GuideAbstract",
 CellID->854539644],

Cell[CellGroupData[{

Cell["Geometric Object Transformations", "GuideFunctionsSubsection",
 CellID->538545725],

Cell[TextData[{
 Cell[TextData[ButtonBox["Rotate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Rotate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Translate",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Translate"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Scale",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/Scale"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->80799842],

Cell[TextData[{
 Cell[TextData[ButtonBox["GeometricTransformation",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "apply any transformation function to geometric objects"
}], "GuideText",
 CellID->35974961]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transformation Matrices", "GuideFunctionsSubsection",
 CellID->996468032],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "rotations in any number of dimensions"
}], "GuideText",
 CellID->101528075],

Cell[TextData[{
 Cell[TextData[ButtonBox["ScalingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ScalingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "stretch or shrink along any direction"
}], "GuideText",
 CellID->281226745],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShearingMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReflectionMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReflectionMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ProjectionMatrix",
  BaseStyle->{"Link", "BrightFlag"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["IdentityMatrix",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->58033752],

Cell[TextData[{
 Cell[TextData[ButtonBox["TransformationMatrix",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TransformationMatrix"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "the matrix representation of a transformation function"
}], "GuideText",
 CellID->583688850]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolic Transformation Functions", "GuideFunctionsSubsection",
 CellID->257716968],

Cell[TextData[{
 Cell[TextData[ButtonBox["RotationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RotationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["TranslationTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TranslationTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ScalingTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ScalingTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->290797115],

Cell[TextData[{
 Cell[TextData[ButtonBox["ShearingTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ShearingTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["ReflectionTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/ReflectionTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["RescalingTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/RescalingTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->211321552],

Cell[TextData[{
 Cell[TextData[ButtonBox["PerspectiveTransform",
  BaseStyle->{"Link", "BrightFlag"}]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["AffineTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/AffineTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["LinearFractionalTransform",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/LinearFractionalTransform"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]]
}], "InlineGuideFunctionListing",
 CellID->135211],

Cell[TextData[{
 Cell[TextData[ButtonBox["TransformationFunction",
  BaseStyle->"NewInVersionLink",
  ButtonData->"paclet:ref/TransformationFunction"]], "InlineFunctionSans",
  Background->Dynamic[
    If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
     RGBColor[0.92, 1, 0.59], None]]],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "general symbolic representation of transformations"
}], "GuideText",
 CellID->115746738],

Cell[TextData[{
 Cell[TextData[ButtonBox["Composition",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Composition"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "symbolic composition of transformation functions"
}], "GuideText",
 CellID->308443308],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseFunction",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/InverseFunction"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "inverse of transformation functions"
}], "GuideText",
 CellID->815446654]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "GuideTutorial",
 CellID->1885805579],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingMatrices"]], "GuideTutorial",
 CellID->133685174]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Matrices & Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Quaternions Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Quaternions/guide/QuaternionsPackage"]], "GuideMoreAbout",\

 CellID->202438413],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED LINKS", "GuideRelatedLinksSection",
 CellID->1658524749],

Cell[TextData[{
 ButtonBox["Demonstrations related to Geometric Transforms",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/search.html?query=symbols%3A(\
AffineTransform+OR+Composition+OR+FiniteGroupData+OR+GeometricTransformation+\
OR+IdentityMatrix+OR+InverseFunction+OR+LinearFractionalTransform+OR+\
PerspectiveTransform+OR+ProjectionMatrix+OR+ReflectionMatrix+OR+\
ReflectionTransform+OR+RescalingTransform+OR+Rotate+OR+RotationMatrix+OR+\
RotationTransform+OR+Scale+OR+ScalingMatrix+OR+ScalingTransform+OR+\
ShearingMatrix+OR+ShearingTransform+OR+TransformationFunction+OR+\
TransformationMatrix+OR+Translate+OR+TranslationTransform)"], None},
  ButtonNote->None],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->None],
 ")"
}], "GuideRelatedLinks",
 CellID->264800431]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Geometric Transforms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 31, 32.4680602}", "context" -> "", 
    "keywords" -> {
     "affine transform", "affine transformation", "composition of functions", 
      "conformal mapping", "finite group data", "FunctionInverse", 
      "functions", "geometric transform", "geometric transformation", 
      "geometric transforms", "graphics transformations", "identity", 
      "identity array", "identity matrix", "inverse function", "invert", 
      "linear fractional transform", "linear fractional transformation", 
      "nesting of functions", "reflection matrix", "reflection transform", 
      "rescaling transform", "resize", "rotate graphics", "rotation matrix", 
      "rotation transform", "scale", "scale graphics", "scaling matrix", 
      "scaling transform", "shearing matrix", "shearing transform", 
      "transformation function", "transformation matrix", 
      "translate graphics", "translation matrix", "translation transform", 
      "transvection", "unit array", "unit diagonal", "unit matrix", "zoom"}, 
    "index" -> True, "label" -> "Mathematica Guide", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica's symbolic architecture and sophisticated mathematical \
capabilities allow it to take a uniquely high-level approach to geometric \
transformations--supporting complete geometric, matrix and functional \
representations in any number of dimensions, whether for mechanical systems, \
computer graphics or pure mathematics. ", "synonyms" -> {}, "title" -> 
    "Geometric Transforms", "type" -> "Guide", "uri" -> 
    "guide/GeometricTransforms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 62, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[684, 28, 442, 9, 70, "GuideAbstract",
 CellID->854539644],
Cell[CellGroupData[{
Cell[1151, 41, 88, 1, 70, "GuideFunctionsSubsection",
 CellID->538545725],
Cell[1242, 44, 1030, 26, 70, "InlineGuideFunctionListing",
 CellID->80799842],
Cell[2275, 72, 457, 12, 70, "GuideText",
 CellID->35974961]
}, Open  ]],
Cell[CellGroupData[{
Cell[2769, 89, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->996468032],
Cell[2851, 92, 423, 12, 70, "GuideText",
 CellID->101528075],
Cell[3277, 106, 421, 12, 70, "GuideText",
 CellID->281226745],
Cell[3701, 120, 1128, 28, 70, "InlineGuideFunctionListing",
 CellID->58033752],
Cell[4832, 150, 452, 12, 70, "GuideText",
 CellID->583688850]
}, Open  ]],
Cell[CellGroupData[{
Cell[5321, 167, 89, 1, 70, "GuideFunctionsSubsection",
 CellID->257716968],
Cell[5413, 170, 1097, 26, 70, "InlineGuideFunctionListing",
 CellID->290797115],
Cell[6513, 198, 1099, 26, 70, "InlineGuideFunctionListing",
 CellID->211321552],
Cell[7615, 226, 930, 22, 70, "InlineGuideFunctionListing",
 CellID->135211],
Cell[8548, 250, 452, 12, 70, "GuideText",
 CellID->115746738],
Cell[9003, 264, 283, 9, 70, "GuideText",
 CellID->308443308],
Cell[9289, 275, 278, 9, 70, "GuideText",
 CellID->815446654]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9616, 290, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[9681, 293, 158, 3, 70, "GuideTutorial",
 CellID->1885805579],
Cell[9842, 298, 160, 3, 70, "GuideTutorial",
 CellID->133685174]
}, Open  ]],
Cell[CellGroupData[{
Cell[10039, 306, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[10104, 309, 166, 3, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[10273, 314, 168, 4, 70, "GuideMoreAbout",
 CellID->202438413],
Cell[10444, 320, 203, 4, 70, "GuideMoreAbout",
 CellID->221348293]
}, Open  ]],
Cell[CellGroupData[{
Cell[10684, 329, 70, 1, 70, "GuideRelatedLinksSection",
 CellID->1658524749],
Cell[10757, 332, 928, 21, 70, "GuideRelatedLinks",
 CellID->264800431]
}, Open  ]],
Cell[11700, 356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

